/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import io.meeds.notes.model.NoteFeaturedImage;
import io.meeds.notes.model.NotePageProperties;
import java.io.File;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.BaseTest;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.NoteToExport;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.PageVersion;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.NotesExportService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.storage.NoteDataStorage;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNoteService
extends BaseTest {
    private static final Identity USER_IDENTITY = new Identity("mary");
    private static final Identity ROOT_IDENTITY = new Identity("root");
    private static final String USERS_GROUP = "/platform/users";
    private static final String PORTAL_NAME = "classic";
    private WikiService wikiService;
    private NoteService noteService;
    private NotesExportService notesExportService;
    private IdentityManager identityManager;
    private FileService fileService;
    private SpaceService spaceService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.wikiService = (WikiService)this.getContainer().getComponentInstanceOfType(WikiService.class);
        this.noteService = (NoteService)this.getContainer().getComponentInstanceOfType(NoteService.class);
        this.notesExportService = (NotesExportService)this.getContainer().getComponentInstanceOfType(NotesExportService.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.fileService = (FileService)this.getContainer().getComponentInstanceOfType(FileService.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        this.removeWikiPages(this.noteService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetGroupPageById() throws WikiException, IllegalAccessException {
        Wiki wiki = this.getOrCreateWiki(this.wikiService, PortalConfig.GROUP_TYPE, USERS_GROUP);
        Identity root = ROOT_IDENTITY;
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, USERS_GROUP, "Home"));
        Page notePage = this.noteService.createNote(wiki, "Home", new Page("testGetGroupPageById-101", "testGetGroupPageById-101"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, USERS_GROUP, notePage.getName()));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, "unknown", "Home"));
    }

    public void testGetUserPageById() throws WikiException, IllegalAccessException {
        Wiki wiki = this.getOrCreateWiki(this.wikiService, PortalConfig.USER_TYPE, "john");
        Identity john = new Identity("john");
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "john", "Home"));
        Page notePage = this.noteService.createNote(wiki, "Home", new Page("testGetUserPageById-101", "testGetUserPageById-101"), john);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "john", notePage.getName()));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "unknown", "Home"));
    }

    public void testCreatePageAndSubNote() throws WikiException, IllegalAccessException {
        Wiki wiki = new Wiki(PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Identity root = ROOT_IDENTITY;
        Page parentNotePage = this.noteService.createNote(wiki, "Home", new Page("parentPage_", "parentPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, parentNotePage.getName(), root));
        Page childNotePage = this.noteService.createNote(wiki, parentNotePage.getName(), new Page("childPage_", "childPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, childNotePage.getName(), root));
    }

    public void testGetBreadcumb() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page breadcrumb1NotPage = this.noteService.createNote(portalWiki, "Home", new Page("Breadcrumb1_", "Breadcrumb1_"), root);
        Page breadcrumb2NotPage = this.noteService.createNote(portalWiki, breadcrumb1NotPage.getName(), new Page("Breadcrumb2_", "Breadcrumb2_"), root);
        Page breadcrumb3NotPage = this.noteService.createNote(portalWiki, breadcrumb2NotPage.getName(), new Page("Breadcrumb3_", "Breadcrumb3_"), root);
        List breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, PORTAL_NAME, breadcrumb3NotPage.getName(), false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)breadcrumb1NotPage.getName(), (String)((BreadcrumbData)breadCumbs.get(1)).getId());
        TestNoteService.assertEquals((String)breadcrumb2NotPage.getName(), (String)((BreadcrumbData)breadCumbs.get(2)).getId());
        TestNoteService.assertEquals((String)breadcrumb3NotPage.getName(), (String)((BreadcrumbData)breadCumbs.get(3)).getId());
    }

    public void testGetBreadcumbWithLanguage() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("Breadcumb1", "Breadcumb1"), root);
        Page note2 = this.noteService.createNote(portalWiki, note1.getName(), new Page("Breadcumb2", "Breadcumb2"), root);
        Page note3 = this.noteService.createNote(portalWiki, note2.getName(), new Page("Breadcumb3", "Breadcumb3"), root);
        note1.setLang("fr");
        note1.setTitle("Breadcumb1_fr");
        this.noteService.createVersionOfNote(note1, "root");
        note2.setLang("fr");
        note2.setTitle("Breadcumb2_fr");
        this.noteService.createVersionOfNote(note2, "root");
        note3.setLang("fr");
        note3.setTitle("Breadcumb3_fr");
        this.noteService.createVersionOfNote(note3, "root");
        List breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note3.getName(), false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)"Breadcumb1", (String)((BreadcrumbData)breadCumbs.get(1)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb2", (String)((BreadcrumbData)breadCumbs.get(2)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb3", (String)((BreadcrumbData)breadCumbs.get(3)).getTitle());
        breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note3.getName(), "fr", root, false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)"Breadcumb1_fr", (String)((BreadcrumbData)breadCumbs.get(1)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb2_fr", (String)((BreadcrumbData)breadCumbs.get(2)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb3_fr", (String)((BreadcrumbData)breadCumbs.get(3)).getTitle());
    }

    public void testMoveNote() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page oldParentNotePage = this.noteService.createNote(portalWiki, "Home", new Page("oldParent_", "oldParent_"), root);
        Page childNotePage = this.noteService.createNote(portalWiki, oldParentNotePage.getName(), new Page("child_", "child_"), root);
        Page newsParentNotPage = this.noteService.createNote(portalWiki, "Home", new Page("newParent_", "newParent_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, oldParentNotePage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, childNotePage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, newsParentNotPage.getName()));
        WikiPageParams currentLocationParams = new WikiPageParams();
        WikiPageParams newLocationParams = new WikiPageParams();
        currentLocationParams.setPageName(childNotePage.getName());
        currentLocationParams.setType(PortalConfig.PORTAL_TYPE);
        currentLocationParams.setOwner(PORTAL_NAME);
        newLocationParams.setPageName(newsParentNotPage.getName());
        newLocationParams.setType(PortalConfig.PORTAL_TYPE);
        newLocationParams.setOwner(PORTAL_NAME);
        TestNoteService.assertTrue((boolean)this.noteService.moveNote(currentLocationParams, newLocationParams, root));
        Wiki userWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.USER_TYPE, "root");
        Page acmeNotePage = this.noteService.createNote(userWiki, "Home", new Page("acmePage_", "acmePage_"), root);
        Page classicNotePage = this.noteService.createNote(portalWiki, "Home", new Page("classicPage_", "classicPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "root", acmeNotePage.getName(), root));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, classicNotePage.getName(), root));
        currentLocationParams.setPageName(acmeNotePage.getName());
        currentLocationParams.setType(PortalConfig.USER_TYPE);
        currentLocationParams.setOwner("root");
        newLocationParams.setPageName(classicNotePage.getName());
        newLocationParams.setType(PortalConfig.PORTAL_TYPE);
        newLocationParams.setOwner(PORTAL_NAME);
        TestNoteService.assertTrue((boolean)this.noteService.moveNote(currentLocationParams, newLocationParams, root));
        Wiki demoWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.USER_TYPE, "root");
        Page toMovedNotePage = this.noteService.createNote(demoWiki, "Home", new Page("toMovedPage_", "toMovedPage_"), root);
        Page privateNotePage = this.noteService.createNote(userWiki, "Home", new Page("privatePage_", "privatePage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "root", toMovedNotePage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "root", privateNotePage.getName()));
        currentLocationParams.setPageName(toMovedNotePage.getName());
        currentLocationParams.setType(PortalConfig.PORTAL_TYPE);
        currentLocationParams.setOwner("root");
        newLocationParams.setPageName(privateNotePage.getName());
        newLocationParams.setType(PortalConfig.USER_TYPE);
        newLocationParams.setOwner("root");
    }

    public void testDeleteNote() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page notePage1 = this.noteService.createNote(portalWiki, "Home", new Page("deletePage_", "deletePage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, PORTAL_NAME, notePage1.getName()));
        Page notePage2 = this.noteService.createNote(portalWiki, "Home", new Page("deletePage_", "deletePage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, PORTAL_NAME, notePage2.getName()));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, notePage2.getName()));
        TestNoteService.assertFalse((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, PORTAL_NAME, "Home"));
    }

    public void testRenameNote() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page currentNotePage = this.noteService.createNote(portalWiki, "Home", new Page("currentPage_", "currentPage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.renameNote(PortalConfig.PORTAL_TYPE, PORTAL_NAME, currentNotePage.getName(), "renamedPage_", "renamedPage_"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, "renamedPage_"));
    }

    public void testRenamePageToExistingNote() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page currentNotePage = this.noteService.createNote(portalWiki, "Home", new Page("currentPage_", "currentPage_"), root);
        Page currentNotePage2 = this.noteService.createNote(portalWiki, "Home", new Page("currentPage2_", "currentPage2_"), root);
        try {
            this.noteService.renameNote(PortalConfig.PORTAL_TYPE, PORTAL_NAME, currentNotePage.getName(), currentNotePage2.getName(), "renamedPage2_");
            TestNoteService.fail((String)("Renaming page currentPage to the existing page " + currentNotePage2.getName() + " should throw an exception"));
        }
        catch (WikiException e) {
            TestNoteService.assertEquals((String)("Note portal:classic:" + currentNotePage2.getName() + " already exists, cannot rename it."), (String)e.getMessage());
        }
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, currentNotePage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, currentNotePage2.getName()));
    }

    public void testHasPermisionOnSystemPage() throws WikiException, IllegalAccessException {
        NoteDataStorage storage = (NoteDataStorage)this.getContainer().getComponentInstanceOfType(NoteDataStorage.class);
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("testHasPermisionOnSystemPage");
        wiki = storage.createWiki(wiki);
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Identity adminAclIdentity = new Identity("admin", Arrays.asList(new MembershipEntry(USERS_GROUP, "*"), new MembershipEntry("/platform/administrators", "*")));
        identityRegistry.register(adminAclIdentity);
        Identity userAclIdentity = new Identity("user", Arrays.asList(new MembershipEntry(USERS_GROUP, "*")));
        identityRegistry.register(userAclIdentity);
        Page noPermissionPage = new Page();
        noPermissionPage.setWikiId(wiki.getId());
        noPermissionPage.setWikiType(wiki.getType());
        noPermissionPage.setWikiOwner(wiki.getOwner());
        noPermissionPage.setName("page1");
        noPermissionPage.setTitle("Page 1");
        noPermissionPage = storage.createPage(wiki, wiki.getWikiHome(), noPermissionPage);
        Page systemPermissionPage = new Page();
        systemPermissionPage.setWikiId(wiki.getId());
        systemPermissionPage.setWikiType(wiki.getType());
        systemPermissionPage.setWikiOwner(wiki.getOwner());
        systemPermissionPage.setName("page1");
        systemPermissionPage.setTitle("Page 1");
        systemPermissionPage.setOwner(IdentityConstants.SYSTEM);
        Page storedSystemPermissionPage = storage.createPage(wiki, wiki.getWikiHome(), systemPermissionPage);
        TestNoteService.assertTrue((boolean)this.noteService.hasPermissionOnPage(noPermissionPage, PermissionType.VIEWPAGE, adminAclIdentity));
        TestNoteService.assertFalse((boolean)this.noteService.hasPermissionOnPage(storedSystemPermissionPage, PermissionType.VIEWPAGE, adminAclIdentity));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteById(storedSystemPermissionPage.getId(), adminAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.noteService.getNoteById(storedSystemPermissionPage.getId(), userAclIdentity));
    }

    public void testUpdateNote() throws WikiException, IllegalAccessException, Exception {
        Identity root = ROOT_IDENTITY;
        this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME).getWikiHome();
        Page page = new Page("new page_", "new page_");
        page.setContent("Page content");
        page = this.noteService.createNote(new Wiki(PortalConfig.PORTAL_TYPE, PORTAL_NAME), "Home", page, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"Page content", (String)page.getContent());
        TestNoteService.assertEquals((String)"new page_", (String)page.getTitle());
        page.setContent("Page content updated_");
        DraftPage draftPage = new DraftPage();
        draftPage.setContent("test");
        draftPage.setTitle("test");
        this.noteService.createDraftForExistPage(draftPage, page, "", new Date().getTime(), "root");
        this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"Page content updated_", (String)page.getContent());
        page.setTitle("new page updated_");
        this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"new page updated_", (String)page.getTitle());
    }

    public void testDraftPage() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        DraftPage draftOfNewPage = new DraftPage();
        draftOfNewPage.setTitle("Draft page");
        draftOfNewPage.setContent("Draft page content");
        long now = new Date().getTime();
        draftOfNewPage = this.noteService.createDraftForNewPage(new DraftPage(), now, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)draftOfNewPage);
        String draftNameForNewPage = draftOfNewPage.getName();
        TestNoteService.assertTrue((boolean)draftOfNewPage.isNewPage());
        TestNoteService.assertTrue((boolean)draftOfNewPage.isDraftPage());
        TestNoteService.assertEquals((String)("Untitled_" + this.getDraftNameSuffix(now)), (String)draftNameForNewPage);
        String pageName = "new page 10";
        Page targetPage = new Page(pageName, pageName);
        targetPage.setContent("Page content");
        Wiki userWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.USER_TYPE, "root");
        targetPage = this.noteService.createNote(userWiki, "Home", new Page("TestPage", "TestPage"), root);
        DraftPage draftPageTosave = new DraftPage();
        String draftTitle = targetPage.getTitle() + "_draft";
        String draftContent = targetPage.getContent() + "_draft";
        draftPageTosave.setTitle(draftTitle);
        draftPageTosave.setContent(draftContent);
        String draftName = targetPage.getName() + "_" + this.getDraftNameSuffix(now);
        DraftPage draftOfExistingPage = this.noteService.createDraftForExistPage(draftPageTosave, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)draftOfExistingPage);
        TestNoteService.assertFalse((boolean)draftOfExistingPage.isNewPage());
        TestNoteService.assertEquals((String)draftOfExistingPage.getName(), (String)draftName);
        TestNoteService.assertEquals((String)targetPage.getId(), (String)draftOfExistingPage.getTargetPageId());
        TestNoteService.assertEquals((String)"1", (String)draftOfExistingPage.getTargetPageRevision());
        draftOfNewPage.setTitle("Draft page updated");
        draftOfNewPage.setContent("Draft page content updated");
        DraftPage updatedDraftOfNewPage = this.noteService.updateDraftForNewPage(draftOfNewPage, now, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)updatedDraftOfNewPage);
        TestNoteService.assertEquals((String)updatedDraftOfNewPage.getTitle(), (String)draftOfNewPage.getTitle());
        TestNoteService.assertEquals((String)updatedDraftOfNewPage.getContent(), (String)draftOfNewPage.getContent());
        TestNoteService.assertTrue((boolean)updatedDraftOfNewPage.isNewPage());
        TestNoteService.assertTrue((boolean)updatedDraftOfNewPage.isDraftPage());
        draftOfExistingPage.setTitle("Draft of page");
        draftOfExistingPage.setContent("Draft of page updated");
        DraftPage updatedDraftOfExistingPage = this.noteService.updateDraftForExistPage(draftOfExistingPage, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)updatedDraftOfExistingPage);
        TestNoteService.assertEquals((String)updatedDraftOfExistingPage.getTitle(), (String)draftOfExistingPage.getTitle());
        TestNoteService.assertEquals((String)updatedDraftOfExistingPage.getContent(), (String)draftOfExistingPage.getContent());
        TestNoteService.assertFalse((boolean)updatedDraftOfExistingPage.isNewPage());
        TestNoteService.assertTrue((boolean)updatedDraftOfExistingPage.isDraftPage());
    }

    private String getDraftNameSuffix(long clientTime) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(clientTime));
    }

    public void testGEtNoteById() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("exported1", "exported1"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note1.getName()));
        Page note = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getName(), (String)note1.getName());
        TestNoteService.assertFalse((boolean)note.isDeleted());
        this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), note.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetNoteByIdAndLang() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("testPage", "testPage"), root);
        note1.setLang("en");
        this.noteService.createVersionOfNote(note1, "root");
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note1.getName()));
        Page note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "en");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getName(), (String)note1.getName());
        TestNoteService.assertFalse((boolean)note.isDeleted());
        this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), note.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetPageAvailableTranslationLanguages() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testLang", "testLang"), root);
        note.setLang("ar");
        this.noteService.createVersionOfNote(note, "root");
        this.noteService.createVersionOfNote(note, "root");
        note.setLang("en");
        this.noteService.createVersionOfNote(note, "root");
        note.setLang("fr");
        this.noteService.createVersionOfNote(note, "root");
        List langs = this.noteService.getPageAvailableTranslationLanguages(Long.valueOf(note.getId()), false);
        TestNoteService.assertNotNull((Object)langs);
        TestNoteService.assertEquals((int)3, (int)langs.size());
    }

    public void testGetVersionsHistoryOfNoteByLang() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testVersionHistory", "testVersionHistory"), root);
        List pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", null);
        TestNoteService.assertEquals((int)1, (int)pageHistories.size());
        TestNoteService.assertNull((Object)((PageHistory)pageHistories.get(0)).getLang());
        note.setLang("ar");
        this.noteService.createVersionOfNote(note, "root");
        pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", "ar");
        TestNoteService.assertEquals((int)1, (int)pageHistories.size());
        TestNoteService.assertNotNull((Object)((PageHistory)pageHistories.get(0)).getLang());
        TestNoteService.assertEquals((String)"ar", (String)((PageHistory)pageHistories.get(0)).getLang());
        pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", "en");
        TestNoteService.assertEquals((int)0, (int)pageHistories.size());
    }

    public void testGetLatestDraftPageByUserAndTargetPageAndLang() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testLatestDraft", "testLatestDraft"), root);
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test draft");
        draftPage.setContent(note.getContent());
        draftPage.setName("test draft");
        draftPage.setTargetPageId(note.getId());
        this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        DraftPage latestDraft = this.noteService.getLatestDraftPageByTargetPageAndLang(Long.valueOf(note.getId()), null);
        TestNoteService.assertNotNull((Object)latestDraft);
    }

    public void testGetNoteOfNoteBookByName() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("test1", "test1"), root);
        TestNoteService.assertNotNull((Object)note1);
    }

    public void testExportNotes() throws Exception {
        Identity root = ROOT_IDENTITY;
        this.startSessionAs("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page page1 = new Page("exported1", "exported1");
        page1.setContent("<figure class=\"image\"><img src=\"/portal/rest/wiki/attachments/group/space//spaces/base_de_connaissances/page/4.01-_Profil_et_param\u00e8tres/Navigation param\u00e8tres.png\"></figure>");
        Page note1 = this.noteService.createNote(portalWiki, "Home", page1, root);
        Page page2 = new Page("exported2", "exported2");
        page2.setContent("<a class=\"noteLink\" href=\"exported1\" target=\"_blank\">R\u00e8gles de r\u00e9daction des tutoriels </a>");
        Page note2 = this.noteService.createNote(portalWiki, "Home", page2, root);
        Page page3 = new Page("exported3", "exported3");
        page3.setContent("<a class=\"noteLink\" href=\"" + note2.getId() + "\">Home</a>");
        Page note3 = this.noteService.createNote(portalWiki, "Home", page3, root);
        this.bindMockedUploadService();
        note3.setContent(note3.getContent().concat("<img cke_upload_id=\"123\" >"));
        note3 = this.noteService.updateNote(note3, PageUpdateType.EDIT_PAGE_CONTENT, ROOT_IDENTITY);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note1.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note2.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note3.getName()));
        TestNoteService.assertTrue((boolean)note3.getContent().contains("src=\"/portal/rest/v1/social/attachments/wikiPage/"));
        String[] notes = new String[]{note1.getId(), note2.getId(), note3.getId()};
        this.notesExportService.startExportNotes(200231, notes, true, root);
        boolean exportDone = false;
        while (!exportDone) {
            if (!this.notesExportService.getStatus(200231).getStatus().equals("ZIP_CREATED")) continue;
            exportDone = true;
        }
        byte[] exportedNotes = this.notesExportService.getExportedNotes(200231);
        TestNoteService.assertNotNull((Object)exportedNotes);
    }

    public void testImportNotes() throws Exception {
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Assert.assertThrows(IllegalAccessException.class, () -> this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported1", "to_be_imported1"), USER_IDENTITY));
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported1", "to_be_imported1"), ROOT_IDENTITY);
        Page note2 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported2", "to_be_imported2"), ROOT_IDENTITY);
        Page note3 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported3", "to_be_imported3"), ROOT_IDENTITY);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note1.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note2.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, note3.getName()));
        String[] notes = new String[]{note1.getId(), note2.getId(), note3.getId()};
        File zipFile = File.createTempFile("notesExport", ".zip");
        this.notesExportService.startExportNotes(200231, notes, true, ROOT_IDENTITY);
        boolean exportDone = false;
        while (!exportDone) {
            if (!this.notesExportService.getStatus(200231).getStatus().equals("ZIP_CREATED")) continue;
            exportDone = true;
        }
        byte[] exportedNotes = this.notesExportService.getExportedNotes(200231);
        TestNoteService.assertNotNull((Object)exportedNotes);
        FileUtils.writeByteArrayToFile((File)zipFile, (byte[])exportedNotes);
        Wiki userWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.USER_TYPE, "root");
        int childern = this.noteService.getChildrenNoteOf(userWiki.getWikiHome(), false, false).size();
        this.noteService.importNotes(zipFile.getPath(), userWiki.getWikiHome(), "update", ROOT_IDENTITY);
        TestNoteService.assertTrue((boolean)zipFile.delete());
        TestNoteService.assertEquals((int)this.noteService.getChildrenNoteOf(userWiki.getWikiHome(), false, false).size(), (int)(childern + 3));
    }

    public void testGetNotesOfWiki() throws WikiException, IllegalAccessException {
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page toBeImported1NotPage = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported1", "to_be_imported1"), ROOT_IDENTITY);
        Page toBeImported2NotPage = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported2", "to_be_imported2"), ROOT_IDENTITY);
        Page toBeImported3NotPage = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported3", "to_be_imported3"), ROOT_IDENTITY);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, toBeImported1NotPage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, toBeImported2NotPage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, toBeImported3NotPage.getName()));
        List pages = this.noteService.getNotesOfWiki(portalWiki.getType(), portalWiki.getOwner());
        TestNoteService.assertEquals((int)4, (int)pages.size());
    }

    public void testDeleteNote1() throws Exception {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page notePage = this.noteService.createNote(portalWiki, "Home", new Page("note1", "note1"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, notePage.getName()));
        this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, PORTAL_NAME, notePage.getName(), root);
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, PORTAL_NAME, notePage.getName()));
    }

    public void testDeleteVersionsByNoteIdAndLang() throws Exception {
        Identity root = ROOT_IDENTITY;
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateUserIdentity("root");
        Space space = new Space();
        space.setDisplayName("test2");
        space.setRegistration("open");
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, "root");
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.GROUP_TYPE, space.getGroupId());
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("testPage1", "testPage1"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, space.getGroupId(), note1.getName()));
        note1 = this.noteService.getNoteById(note1.getId());
        note1.setLang("en");
        note1.setTitle("englishTitle");
        this.noteService.createVersionOfNote(note1, "root");
        note1.setLang("fr");
        note1.setTitle("frenchTitle");
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(Long.parseLong(note1.getId()), "alt text", "summary test");
        note1.setProperties(notePageProperties);
        this.noteService.createVersionOfNote(note1, "root");
        NoteFeaturedImage featuredImage = this.noteService.getNoteFeaturedImageInfo(Long.valueOf(note1.getId()), "fr", false, null, Long.parseLong(identity.getId()));
        TestNoteService.assertNotNull((Object)featuredImage);
        this.noteService.deleteVersionsByNoteIdAndLang(Long.valueOf(note1.getId()), "en", true);
        Page note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "en");
        TestNoteService.assertEquals((String)note.getTitle(), (String)"testPage1");
        note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "fr");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getTitle(), (String)"frenchTitle");
        this.noteService.deleteVersionsByNoteIdAndLang(Long.valueOf(note.getId()), "fr", true);
        TestNoteService.assertNull((Object)this.fileService.getFile(featuredImage.getId().longValue()));
        note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "fr");
        TestNoteService.assertEquals((String)note.getTitle(), (String)"testPage1");
        this.noteService.deleteNote(note1.getWikiType(), note1.getWikiOwner(), note1.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetChildrenNoteOf() throws WikiException, IllegalAccessException {
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        this.noteService.createNote(portalWiki, "Home", new Page("imported1", "imported1"), ROOT_IDENTITY);
        this.noteService.createNote(portalWiki, "Home", new Page("imported2", "imported2"), ROOT_IDENTITY);
        Page home = portalWiki.getWikiHome();
        int childern = this.noteService.getChildrenNoteOf(home, false, false).size();
        NoteToExport note = new NoteToExport();
        note.setId(home.getId());
        note.setName(home.getName());
        note.setTitle(home.getTitle());
        note.setWikiId(home.getWikiId());
        note.setWikiOwner(home.getWikiOwner());
        note.setWikiType(home.getWikiType());
        int eXportCildren = this.noteService.getChildrenNoteOf(note).size();
        TestNoteService.assertEquals((int)eXportCildren, (int)childern);
    }

    public void testRemoveDraftOfNote() throws Exception {
        Identity root = ROOT_IDENTITY;
        this.startSessionAs("root");
        long now = new Date().getTime();
        String pageName = "new page 10";
        Page targetPage = new Page(pageName, pageName);
        targetPage.setContent("Page content");
        Wiki userWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.USER_TYPE, "root");
        targetPage = this.noteService.createNote(userWiki, "Home", new Page("TestPage1", "TestPage1"), root);
        DraftPage draftPageTosave = new DraftPage();
        String draftTitle = targetPage.getTitle() + "_draft";
        String draftContent = targetPage.getContent() + "_draft";
        draftPageTosave.setTitle(draftTitle);
        draftPageTosave.setContent(draftContent);
        draftPageTosave.setLang("fr");
        String draftName = targetPage.getName() + "_" + this.getDraftNameSuffix(now);
        DraftPage draftOfExistingPage = this.noteService.createDraftForExistPage(draftPageTosave, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)draftOfExistingPage);
        TestNoteService.assertFalse((boolean)draftOfExistingPage.isNewPage());
        TestNoteService.assertEquals((String)draftOfExistingPage.getName(), (String)draftName);
        TestNoteService.assertEquals((String)targetPage.getId(), (String)draftOfExistingPage.getTargetPageId());
        TestNoteService.assertEquals((String)"1", (String)draftOfExistingPage.getTargetPageRevision());
        DraftPage draft = this.noteService.getLatestDraftOfPage(targetPage);
        TestNoteService.assertEquals((String)draft.getId(), (String)draftOfExistingPage.getId());
        WikiPageParams noteParams = new WikiPageParams(targetPage.getWikiType(), targetPage.getWikiOwner(), targetPage.getName());
        this.noteService.removeDraftOfNote(noteParams, "en");
        draft = this.noteService.getLatestDraftOfPage(targetPage);
        TestNoteService.assertEquals((String)draft.getId(), (String)draftOfExistingPage.getId());
        this.noteService.removeDraftOfNote(noteParams, "fr");
        draft = this.noteService.getLatestDraftOfPage(targetPage);
        TestNoteService.assertNull((Object)draft);
    }

    public void testGetNoteOfNoteBookByNameWithLangMetadata() throws WikiException, IllegalAccessException {
        Identity user = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testNoteLangMetadata", "testNoteLangMetadata"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(note.getWikiType(), note.getWikiOwner(), note.getName(), "en", user));
    }

    public void testGetPublishedVersionByPageIdAndLang() throws WikiException, IllegalAccessException {
        Identity root = ROOT_IDENTITY;
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testNotee", "testNotee"), root);
        TestNoteService.assertNull((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(note.getId()), "en"));
        note.setLang("en");
        note.setTitle("english title");
        note.setContent("english content");
        this.noteService.createVersionOfNote(note, root.getUserId());
        TestNoteService.assertNotNull((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(note.getId()), "en"));
    }

    public void testRemoveOrphanDraftPagesByParentPage() throws Exception {
        this.startSessionAs("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.GROUP_TYPE, USERS_GROUP);
        Page homePage = this.noteService.getNoteById(portalWiki.getWikiHome().getId());
        DraftPage draft = new DraftPage();
        draft.setParentPageId(homePage.getId());
        draft.setTargetPageId(null);
        draft = this.noteService.createDraftForNewPage(draft, new Date().getTime(), this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)draft);
        this.noteService.removeOrphanDraftPagesByParentPage(Long.parseLong(homePage.getId()));
        this.restartTransaction();
        TestNoteService.assertNull((Object)this.noteService.getDraftNoteById(draft.getId(), "root"));
    }

    private Page createTestNoteWithVersionLang(String name, String lang, Identity user) {
        this.identityManager.getOrCreateUserIdentity("root");
        Space space = this.spaceService.getSpaceByGroupId("/spaces/test");
        if (space == null) {
            space = new Space();
            space.setDisplayName("test");
            space.setPrettyName("test");
            space.setRegistration("open");
            space.setVisibility("public");
            space = this.spaceService.createSpace(space, "root");
        }
        Wiki spaceWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.GROUP_TYPE, space.getGroupId());
        Page note = this.noteService.createNote(spaceWiki, "Home", new Page(name, name), ROOT_IDENTITY);
        note.setLang(lang);
        note.setTitle("language title");
        note.setContent("language content");
        this.noteService.createVersionOfNote(note, user.getUserId());
        return note;
    }

    private void bindMockedUploadService() throws Exception {
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        UploadResource uploadResource = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)uploadResource.getUploadedSize()).thenReturn((Object)12548.0);
        Mockito.when((Object)uploadService.getUploadResource(ArgumentMatchers.anyString())).thenReturn((Object)uploadResource);
        String location = ((Object)((Object)this)).getClass().getResource("/images/John.png").getPath();
        Mockito.when((Object)uploadResource.getStoreLocation()).thenReturn((Object)location);
        Field field = this.noteService.getClass().getDeclaredField("uploadService");
        field.setAccessible(true);
        field.set(this.noteService, uploadService);
    }

    private NotePageProperties createNotePageProperties(long noteId, String altText, String summary) {
        NotePageProperties notePageProperties = new NotePageProperties();
        NoteFeaturedImage featuredImage = new NoteFeaturedImage();
        featuredImage.setMimeType("image/png");
        featuredImage.setUploadId("123");
        featuredImage.setAltText(altText);
        notePageProperties.setFeaturedImage(featuredImage);
        notePageProperties.setNoteId(noteId);
        notePageProperties.setSummary(summary);
        return notePageProperties;
    }

    public void testSaveNoteFeaturedImage() throws Exception {
        Page note = this.createTestNoteWithVersionLang("testMetadata", "en", ROOT_IDENTITY);
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(Long.parseLong(note.getId()), "alt text", "summary test");
        NotePageProperties properties = this.noteService.saveNoteMetadata(notePageProperties, null, this.getIdentityId(ROOT_IDENTITY.getUserId()));
        TestNoteService.assertEquals((String)"summary test", (String)properties.getSummary());
        notePageProperties.setSummary("version language summary");
        properties = this.noteService.saveNoteMetadata(notePageProperties, "en", this.getIdentityId(ROOT_IDENTITY.getUserId()));
        TestNoteService.assertEquals((String)"version language summary", (String)properties.getSummary());
    }

    public void testRemoveNoteFeaturedImage() throws Exception {
        Page note = this.createTestNoteWithVersionLang("testMetadataRemove", "fr", ROOT_IDENTITY);
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(Long.parseLong(note.getId()), "alt text", "summary test");
        NotePageProperties properties = this.noteService.saveNoteMetadata(notePageProperties, null, this.getIdentityId(ROOT_IDENTITY.getUserId()));
        this.noteService.saveNoteMetadata(notePageProperties, "fr", this.getIdentityId(ROOT_IDENTITY.getUserId()));
        TestNoteService.assertNotNull((Object)properties.getFeaturedImage().getId());
        NoteFeaturedImage noteFeaturedImageInfo = this.noteService.getNoteFeaturedImageInfo(Long.valueOf(Long.parseLong(note.getId())), null, false, null, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        NoteFeaturedImage noteFeaturedImageInfoFr = this.noteService.getNoteFeaturedImageInfo(Long.valueOf(Long.parseLong(note.getId())), "fr", false, null, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)noteFeaturedImageInfo);
        TestNoteService.assertNotNull((Object)noteFeaturedImageInfoFr);
        TestNoteService.assertEquals((Object)noteFeaturedImageInfoFr.getId(), (Object)noteFeaturedImageInfo.getId());
        this.noteService.removeNoteFeaturedImage(Long.valueOf(Long.parseLong(note.getId())), properties.getFeaturedImage().getId(), null, false, this.getIdentityId(ROOT_IDENTITY.getUserId()));
        TestNoteService.assertNull((Object)this.noteService.getNoteFeaturedImageInfo(Long.valueOf(Long.parseLong(note.getId())), null, false, null, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue()));
        TestNoteService.assertNull((Object)this.noteService.getNoteFeaturedImageInfo(Long.valueOf(Long.parseLong(note.getId())), "fr", false, null, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue()));
    }

    public void testGetNoteFeaturedImageInfo() throws Exception {
        Page note = this.createTestNoteWithVersionLang("testGetMetadataInfo", "ar", ROOT_IDENTITY);
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(Long.parseLong(note.getId()), "alt text", "summary Test");
        this.noteService.saveNoteMetadata(notePageProperties, null, this.getIdentityId(ROOT_IDENTITY.getUserId()));
        notePageProperties = this.createNotePageProperties(Long.parseLong(note.getId()), "alt text", "summary Test");
        this.noteService.saveNoteMetadata(notePageProperties, "ar", this.getIdentityId(ROOT_IDENTITY.getUserId()));
        NoteFeaturedImage featuredImage = this.noteService.getNoteFeaturedImageInfo(Long.valueOf(Long.parseLong(note.getId())), null, false, "150x150", this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        NoteFeaturedImage versionLanguageFeaturedImage = this.noteService.getNoteFeaturedImageInfo(Long.valueOf(Long.parseLong(note.getId())), "ar", false, "150x150", this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)featuredImage);
        TestNoteService.assertTrue((featuredImage.getLastUpdated() > 0L ? 1 : 0) != 0);
        TestNoteService.assertNotSame((Object)featuredImage.getId(), (Object)versionLanguageFeaturedImage.getId());
    }

    public void testCreatePageWithProperties() throws Exception {
        this.startSessionAs("root");
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(0L, "alt text", "summary Test");
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test");
        draftPage.setContent("test");
        draftPage.setProperties(notePageProperties);
        draftPage = this.noteService.createDraftForNewPage(draftPage, new Date().getTime(), this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page page = new Page();
        page.setTitle("testSaveProperties1");
        page.setName("testSaveProperties1");
        page.setContent("test");
        page.setProperties(draftPage.getProperties());
        Assert.assertThrows(IllegalAccessException.class, () -> this.noteService.createNote(portalWiki, "Home", page, USER_IDENTITY));
        Page note = this.noteService.createNote(portalWiki, "Home", page, ROOT_IDENTITY);
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertNotNull((Object)note.getProperties());
        notePageProperties.setFeaturedImage(null);
        page.setTitle("testSaveProperties2");
        page.setName("testSaveProperties2");
        page.setProperties(notePageProperties);
        note = this.noteService.createNote(portalWiki, "Home", page, ROOT_IDENTITY);
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertNotNull((Object)note.getProperties());
    }

    public void testCreateDraftForNewPageWithProperties() throws Exception {
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(0L, "alt text", "summary Test");
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test");
        draftPage.setContent("test");
        draftPage.setProperties(notePageProperties);
        draftPage = this.noteService.createDraftForNewPage(draftPage, new Date().getTime(), this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)draftPage);
        TestNoteService.assertNotNull((Object)draftPage.getProperties());
    }

    public void testCreateDraftForExistPageWithProperties() throws Exception {
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(0L, "alt text", "summary Test");
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test");
        draftPage.setContent("test");
        draftPage.setProperties(notePageProperties);
        Page page = new Page();
        page.setTitle("testSaveProperties3");
        page.setName("testSaveProperties3");
        page.setContent("test");
        page.setProperties(draftPage.getProperties());
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note = this.noteService.createNote(portalWiki, "Home", page, ROOT_IDENTITY);
        draftPage = this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        TestNoteService.assertNotNull((Object)draftPage);
        TestNoteService.assertNotNull((Object)draftPage.getProperties());
        draftPage.setId("0");
        notePageProperties.getFeaturedImage().setId(Long.valueOf(0L));
        draftPage.setProperties(notePageProperties);
        draftPage = this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        TestNoteService.assertNotNull((Object)draftPage);
        TestNoteService.assertNotNull((Object)draftPage.getProperties());
    }

    public void testGetVersionById() throws Exception {
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testGetVersionById", "testGetVersionById"), ROOT_IDENTITY);
        note.setLang("en");
        note.setTitle("english title");
        note.setContent("english content");
        this.noteService.createVersionOfNote(note, USER_IDENTITY.getUserId());
        PageVersion pageVersion = this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(note.getId()), "en");
        TestNoteService.assertNotNull((Object)this.noteService.getPageVersionById(Long.valueOf(pageVersion.getId())));
    }

    public void testFeaturedImageWhenRemoveDraftById() throws Exception {
        this.startSessionAs("root");
        Space space = new Space();
        space.setDisplayName("test");
        space.setRegistration("open");
        space.setVisibility("public");
        space = this.spaceService.createSpace(space, "root");
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(0L, "alt text", "summary Test");
        notePageProperties.setDraft(true);
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test");
        draftPage.setContent("test");
        draftPage.setWikiOwner(space.getGroupId());
        draftPage.setProperties(notePageProperties);
        draftPage = this.noteService.createDraftForNewPage(draftPage, new Date().getTime(), this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        NoteFeaturedImage featuredImage = this.noteService.getNoteFeaturedImageInfo(Long.valueOf(draftPage.getId()), null, true, null, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)featuredImage);
        this.noteService.removeDraftById(draftPage.getId());
        TestNoteService.assertNull((Object)this.fileService.getFile(featuredImage.getId().longValue()));
        Page page = new Page();
        page.setTitle("testRemoveImageWhenDraftRemoved");
        page.setName("testRemoveImageWhenDraftRemoved");
        page.setContent("testRemoveImageWhenDraftRemoved");
        page.setWikiOwner(space.getGroupId());
        notePageProperties = this.createNotePageProperties(0L, "alt text", "summary Test");
        page.setProperties(notePageProperties);
        Wiki spaceWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.GROUP_TYPE, space.getGroupId());
        Page note = this.noteService.createNote(spaceWiki, "Home", page, ROOT_IDENTITY);
        draftPage.setTargetPageId(note.getId());
        draftPage.setId(null);
        notePageProperties = note.getProperties();
        notePageProperties.setDraft(true);
        draftPage.setProperties(notePageProperties);
        draftPage = this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        featuredImage = this.noteService.getNoteFeaturedImageInfo(Long.valueOf(draftPage.getId()), null, true, null, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)featuredImage);
        this.noteService.removeDraftById(draftPage.getId());
        TestNoteService.assertNotNull((Object)this.fileService.getFile(featuredImage.getId().longValue()));
        draftPage = this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        notePageProperties = this.createNotePageProperties(Long.parseLong(draftPage.getId()), "alt text", "summary Test");
        notePageProperties.setDraft(true);
        draftPage.setProperties(notePageProperties);
        draftPage = this.noteService.updateDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        featuredImage = this.noteService.getNoteFeaturedImageInfo(Long.valueOf(draftPage.getId()), null, true, null, this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)featuredImage);
        this.noteService.removeDraftById(draftPage.getId());
        TestNoteService.assertNull((Object)this.fileService.getFile(featuredImage.getId().longValue()));
    }

    public void testGetDraftsOfWiki() throws Exception {
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testGetDraftsOfWiki", "testGetDraftsOfWiki"), ROOT_IDENTITY);
        Page note2 = this.noteService.createNote(portalWiki, "Home", new Page("testGetDraftsOfWiki", "testGetDraftsOfWiki"), ROOT_IDENTITY);
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test");
        draftPage.setContent("test");
        draftPage.setWikiOwner(portalWiki.getId());
        draftPage.setParentPageId(note.getId());
        this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        draftPage.setParentPageId(note2.getId());
        this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        TestNoteService.assertEquals((int)2, (int)this.noteService.getDraftsOfWiki(portalWiki.getOwner(), portalWiki.getType(), portalWiki.getWikiHome().getName()).size());
    }

    public void testSaveHideAuthorAndHideReactionProperties() throws Exception {
        Page note = this.createTestNoteWithVersionLang("testMetadataHideAuthorAndHideReaction", null, ROOT_IDENTITY);
        this.bindMockedUploadService();
        NotePageProperties notePageProperties = this.createNotePageProperties(Long.parseLong(note.getId()), "alt text", "summary test");
        notePageProperties.setHideAuthor(true);
        notePageProperties.setHideReaction(true);
        NotePageProperties properties = this.noteService.saveNoteMetadata(notePageProperties, null, this.getIdentityId(ROOT_IDENTITY.getUserId()));
        TestNoteService.assertEquals((String)"summary test", (String)properties.getSummary());
        TestNoteService.assertTrue((boolean)properties.isHideAuthor());
        TestNoteService.assertTrue((boolean)properties.isHideReaction());
        note.setLang("en");
        note.setTitle("en title");
        note.setContent("en content");
        this.noteService.createVersionOfNote(note, ROOT_IDENTITY.getUserId());
        notePageProperties = this.createNotePageProperties(Long.parseLong(note.getId()), "alt text en", "summary test en");
        notePageProperties.setHideAuthor(false);
        this.noteService.saveNoteMetadata(notePageProperties, "en", this.getIdentityId(ROOT_IDENTITY.getUserId()));
        Page savedNote = this.noteService.getNoteByIdAndLang(Long.valueOf(note.getId()), "en");
        TestNoteService.assertTrue((boolean)savedNote.getProperties().isHideAuthor());
        TestNoteService.assertTrue((boolean)properties.isHideReaction());
    }

    public void testProcessingNoteContentImages() throws Exception {
        this.bindMockedUploadService();
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test");
        draftPage.setContent("content include image <img cke_upload_id=\"123\" >");
        draftPage.setAttachmentObjectType("wikiDraft");
        draftPage = this.noteService.createDraftForNewPage(draftPage, new Date().getTime(), this.getIdentityId(ROOT_IDENTITY.getUserId()).longValue());
        TestNoteService.assertNotNull((Object)draftPage);
        TestNoteService.assertNotNull((Object)draftPage.getContent());
        String imageSrcTagSuffix = "src=\"/portal/rest/v1/social/attachments/";
        TestNoteService.assertTrue((boolean)draftPage.getContent().contains(imageSrcTagSuffix.concat("wikiDraft").concat("/").concat(draftPage.getId())));
        Page note = new Page();
        note.setTitle(draftPage.getTitle());
        note.setContent(draftPage.getContent());
        note.setProperties(new NotePageProperties(Long.parseLong(draftPage.getId()), null, null, false, false, true));
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        note = this.noteService.createNote(portalWiki, "Home", note, ROOT_IDENTITY);
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertNotNull((Object)note.getId());
        TestNoteService.assertTrue((boolean)note.getContent().contains(imageSrcTagSuffix.concat("wikiPage").concat("/").concat(note.getId())));
        DraftPage draftForExistingPage = new DraftPage();
        draftForExistingPage.setTitle(note.getTitle());
        draftForExistingPage.setContent(note.getContent());
        draftForExistingPage.setParentPageId(note.getId());
        draftForExistingPage = this.noteService.createDraftForExistPage(draftForExistingPage, note, null, System.currentTimeMillis(), "root");
        TestNoteService.assertNotNull((Object)draftForExistingPage);
        TestNoteService.assertNotNull((Object)draftForExistingPage.getId());
        TestNoteService.assertTrue((boolean)draftForExistingPage.getContent().contains(imageSrcTagSuffix.concat("wikiPage").concat("/".concat(note.getId()))));
    }

    public void testProcessingNoteImportedContentImages() throws Exception {
        String fileName = "pexels-nout-gons-80280-378570(1).png";
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + fileName);
        file.createNewFile();
        this.bindMockedUploadService();
        String imageSrcTagSuffix = "src=\"/portal/rest/v1/social/attachments/";
        Page note = new Page();
        note.setTitle("imported note title");
        note.setContent("content include imported image matcher <img src=\"//-" + fileName + "-//\" >");
        Identity root = ROOT_IDENTITY;
        this.startSessionAs("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wikiService, PortalConfig.PORTAL_TYPE, PORTAL_NAME);
        note = this.noteService.createNote(portalWiki, "Home", note, root);
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertNotNull((Object)note.getId());
        TestNoteService.assertTrue((boolean)note.getContent().contains(imageSrcTagSuffix.concat("wikiPage").concat("/").concat(note.getId())));
        file.delete();
        String file1Name = "importedImage.png";
        File file1 = new File(System.getProperty("java.io.tmpdir") + File.separator + file1Name);
        file1.createNewFile();
        note.setContent(note.getContent().concat("<img src=\"//-" + file1Name + "-//\" >"));
        note = this.noteService.updateNote(note);
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertNotNull((Object)note.getId());
        TestNoteService.assertTrue((boolean)note.getContent().contains(imageSrcTagSuffix.concat("wikiPage").concat("/").concat(note.getId())));
        String content = note.getContent();
        content = content.substring(content.indexOf(imageSrcTagSuffix.concat("wikiPage").concat("/").concat(note.getId())));
        TestNoteService.assertTrue((boolean)content.contains(imageSrcTagSuffix.concat("wikiPage").concat("/").concat(note.getId())));
        file1.delete();
    }

    private Long getIdentityId(String username) {
        return Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId());
    }
}

