/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.rest;

import com.google.javascript.jscomp.jarjar.com.google.common.base.Objects;
import io.meeds.notes.service.NotePageViewService;
import io.meeds.social.html.model.HtmlTransformerContext;
import io.meeds.social.html.utils.HtmlUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.LocaleUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.wiki.model.Page;

@Path(value="/notes/view/")
@Tag(name="/notes/view/", description="Managing notes pages in for Note Page View Application")
public class NotePageViewRest
implements ResourceContainer {
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final int CACHE_IN_SECONDS = 31536000;
    private static final Log LOG = ExoLogger.getLogger(NotePageViewRest.class);
    private NotePageViewService notePageViewService;

    public NotePageViewRest(NotePageViewService notePageViewService) {
        this.notePageViewService = notePageViewService;
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves a note page switch Application setting name", description="Retrieves a note page switch Application setting name", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="304", description="Not modified"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="404", description="Resource not found")})
    public Response getNotePage(@Context Request request, @Parameter(description="Application setting name", required=true) @PathParam(value="name") String name, @Parameter(description="User language", required=false) @QueryParam(value="lang") String lang) {
        try {
            Page note = this.notePageViewService.getNotePage(name, lang, RestUtils.getCurrentUserAclIdentity());
            if (note == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String content = note.getContent();
            content = this.transformContent(content, lang);
            note.setContent(content);
            Date updatedDate = note.getUpdatedDate();
            EntityTag eTag = new EntityTag(String.valueOf(Objects.hashCode((Object[])new Object[]{name, lang, String.valueOf(updatedDate.getTime())})));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                builder = Response.ok((Object)note);
            }
            builder.lastModified(updatedDate);
            builder.tag(eTag);
            builder.cacheControl(CACHE_CONTROL);
            return builder.build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("Error accessing note page {} for user {}", new Object[]{name, RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving page content {} for user {}", new Object[]{name, RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="{name}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/x-www-form-urlencoded"})
    @Operation(summary="Saves a note page content to the associated application setting", description="Saves a note page content to the associated application setting", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public Response saveNotePage(@Context Request request, @Parameter(description="Application setting name", required=true) @PathParam(value="name") String name, @Parameter(description="Note Content", required=true) @FormParam(value="content") String content, @Parameter(description="User language", required=false) @FormParam(value="lang") String lang) {
        try {
            this.notePageViewService.saveNotePage(name, content, lang, RestUtils.getCurrentUserAclIdentity());
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("Error saving note page content '{}' by user '{}'", new Object[]{name, RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private String transformContent(String content, String lang) {
        try {
            content = HtmlUtils.transform((String)content, (HtmlTransformerContext)new HtmlTransformerContext(ConversationState.getCurrent().getIdentity(), LocaleUtils.toLocale((String)lang)));
            return HTMLSanitizer.sanitize((String)content);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error sanitizing terms and conditions content", (Throwable)e);
            return content;
        }
    }

    static {
        CACHE_CONTROL.setMaxAge(31536000);
        CACHE_CONTROL.setMustRevalidate(true);
    }
}

