/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.DraftPageEntity;
import org.exoplatform.wiki.jpa.entity.PageMoveEntity;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;

@Entity(name="WikiPageEntity")
@Table(name="WIKI_PAGES")
@NamedQueries(value={@NamedQuery(name="wikiPage.getAllIds", query="SELECT p.id FROM WikiPageEntity p  WHERE p.deleted = false ORDER BY p.id"), @NamedQuery(name="wikiPage.countAllIds", query="SELECT COUNT(*) FROM WikiPageEntity p  WHERE p.deleted = false"), @NamedQuery(name="wikiPage.getPageOfWikiByName", query="SELECT p FROM WikiPageEntity p JOIN p.wiki w WHERE p.name = :name AND w.type = :type AND w.owner = :owner AND p.deleted = false"), @NamedQuery(name="wikiPage.getAllPagesOfWiki", query="SELECT p FROM WikiPageEntity p JOIN p.wiki w WHERE w.type = :type AND w.owner = :owner"), @NamedQuery(name="wikiPage.getPagesOfWiki", query="SELECT p FROM WikiPageEntity p JOIN p.wiki w WHERE w.type = :type AND w.owner = :owner AND p.deleted = :deleted"), @NamedQuery(name="wikiPage.getChildrenPages", query="SELECT p FROM WikiPageEntity p WHERE p.parentPage.id = :id AND p.deleted = false ORDER BY p.name"), @NamedQuery(name="wikiPage.getAllChildrenPages", query="SELECT p FROM WikiPageEntity p WHERE p.parentPage.id = :id ORDER BY p.name"), @NamedQuery(name="wikiPage.getRelatedPages", query="SELECT p FROM WikiPageEntity p INNER JOIN p.relatedPages r where r.id = :pageId"), @NamedQuery(name="wikiPage.getAllPagesBySyntax", query="SELECT p FROM WikiPageEntity p WHERE p.syntax = :syntax OR p.syntax IS NULL ORDER BY p.updatedDate DESC"), @NamedQuery(name="wikiPage.countPageChildrenById", query="SELECT COUNT(*) FROM WikiPageEntity p WHERE p.parentPage.id = :id AND p.deleted = false")})
public class PageEntity
extends BasePageEntity {
    @Id
    @Column(name="PAGE_ID")
    @SequenceGenerator(name="SEQ_WIKI_PAGES_PAGE_ID", sequenceName="SEQ_WIKI_PAGES_PAGE_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_PAGES_PAGE_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="WIKI_ID")
    private WikiEntity wiki;
    @ManyToOne
    @JoinColumn(name="PARENT_PAGE_ID")
    private PageEntity parentPage;
    @OneToMany(mappedBy="parentPage")
    private List<PageEntity> children;
    @OneToMany(mappedBy="targetPage")
    private List<DraftPageEntity> drafts;
    @OneToMany(mappedBy="page")
    private List<PageVersionEntity> versions;
    @ManyToMany
    @JoinTable(name="WIKI_PAGES_RELATED_PAGES", joinColumns={@JoinColumn(name="PAGE_ID")}, inverseJoinColumns={@JoinColumn(name="RELATED_PAGE_ID")})
    private List<PageEntity> relatedPages;
    @Column(name="OWNER")
    private String owner;
    @Column(name="EDITION_COMMENT")
    private String comment;
    @Column(name="URL")
    private String url;
    @Column(name="MINOR_EDIT")
    private boolean minorEdit;
    @Column(name="ACTIVITY_ID")
    private String activityId;
    @ElementCollection
    @CollectionTable(name="WIKI_WATCHERS", joinColumns={@JoinColumn(name="PAGE_ID")})
    @Column(name="USERNAME")
    private Set<String> watchers = new HashSet<String>();
    @OneToMany(mappedBy="page", cascade={CascadeType.ALL})
    private List<PageMoveEntity> moves = new ArrayList<PageMoveEntity>();
    @Column(name="DELETED")
    private boolean deleted;

    @Generated
    public PageEntity() {
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public WikiEntity getWiki() {
        return this.wiki;
    }

    @Generated
    public PageEntity getParentPage() {
        return this.parentPage;
    }

    @Generated
    public List<PageEntity> getChildren() {
        return this.children;
    }

    @Generated
    public List<DraftPageEntity> getDrafts() {
        return this.drafts;
    }

    @Generated
    public List<PageVersionEntity> getVersions() {
        return this.versions;
    }

    @Generated
    public List<PageEntity> getRelatedPages() {
        return this.relatedPages;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    @Generated
    public String getActivityId() {
        return this.activityId;
    }

    @Generated
    public Set<String> getWatchers() {
        return this.watchers;
    }

    @Generated
    public List<PageMoveEntity> getMoves() {
        return this.moves;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setWiki(WikiEntity wiki) {
        this.wiki = wiki;
    }

    @Generated
    public void setParentPage(PageEntity parentPage) {
        this.parentPage = parentPage;
    }

    @Generated
    public void setChildren(List<PageEntity> children) {
        this.children = children;
    }

    @Generated
    public void setDrafts(List<DraftPageEntity> drafts) {
        this.drafts = drafts;
    }

    @Generated
    public void setVersions(List<PageVersionEntity> versions) {
        this.versions = versions;
    }

    @Generated
    public void setRelatedPages(List<PageEntity> relatedPages) {
        this.relatedPages = relatedPages;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setMinorEdit(boolean minorEdit) {
        this.minorEdit = minorEdit;
    }

    @Generated
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Generated
    public void setWatchers(Set<String> watchers) {
        this.watchers = watchers;
    }

    @Generated
    public void setMoves(List<PageMoveEntity> moves) {
        this.moves = moves;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public String toString() {
        return "PageEntity(id=" + this.getId() + ", wiki=" + String.valueOf(this.getWiki()) + ", parentPage=" + String.valueOf(this.getParentPage()) + ", children=" + String.valueOf(this.getChildren()) + ", drafts=" + String.valueOf(this.getDrafts()) + ", versions=" + String.valueOf(this.getVersions()) + ", relatedPages=" + String.valueOf(this.getRelatedPages()) + ", owner=" + this.getOwner() + ", comment=" + this.getComment() + ", url=" + this.getUrl() + ", minorEdit=" + this.isMinorEdit() + ", activityId=" + this.getActivityId() + ", watchers=" + String.valueOf(this.getWatchers()) + ", moves=" + String.valueOf(this.getMoves()) + ", deleted=" + this.isDeleted() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageEntity)) {
            return false;
        }
        PageEntity other = (PageEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isMinorEdit() != other.isMinorEdit()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$activityId = this.getActivityId();
        String other$activityId = other.getActivityId();
        return !(this$activityId == null ? other$activityId != null : !this$activityId.equals(other$activityId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isMinorEdit() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $activityId = this.getActivityId();
        result = result * 59 + ($activityId == null ? 43 : $activityId.hashCode());
        return result;
    }
}

