/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service.plugin;

import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.plugin.WikiDraftPageAttachmentPlugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class WikiDraftPageAttachmentPluginTest {
    @Mock
    private NoteService noteService;
    @Mock
    private SpaceService spaceService;
    private WikiDraftPageAttachmentPlugin plugin;

    @Before
    public void setUp() {
        this.plugin = new WikiDraftPageAttachmentPlugin(this.noteService, this.spaceService);
    }

    @Test
    public void testGetObjectType() {
        Assert.assertEquals((Object)"wikiDraft", (Object)this.plugin.getObjectType());
    }

    @Test
    public void testHasAccessPermission() throws Exception {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        DraftPage draftPage = (DraftPage)Mockito.mock(DraftPage.class);
        Mockito.when((Object)userIdentity.getUserId()).thenReturn((Object)"user123");
        Mockito.when((Object)this.noteService.getDraftNoteById("draft123", "user123")).thenReturn((Object)draftPage);
        Mockito.when((Object)draftPage.isCanView()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.plugin.hasAccessPermission(userIdentity, "draft123"));
    }

    @Test
    public void testHasEditPermission() throws Exception {
        Identity userIdentity = (Identity)Mockito.mock(Identity.class);
        DraftPage draftPage = (DraftPage)Mockito.mock(DraftPage.class);
        Mockito.when((Object)userIdentity.getUserId()).thenReturn((Object)"user123");
        Mockito.when((Object)this.noteService.getDraftNoteById("draft123", "user123")).thenReturn((Object)draftPage);
        Mockito.when((Object)draftPage.isCanManage()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.plugin.hasEditPermission(userIdentity, "draft123"));
    }

    @Test
    public void getSpaceId() throws Exception {
        DraftPage draftPage = (DraftPage)Mockito.mock(DraftPage.class);
        Mockito.when((Object)draftPage.getWikiOwner()).thenReturn((Object)"/spaces/test");
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)space.getId()).thenReturn((Object)"1");
        Mockito.when((Object)this.noteService.getDraftNoteById("draft123")).thenReturn((Object)draftPage);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(draftPage.getWikiOwner())).thenReturn((Object)space);
        Assert.assertEquals((long)1L, (long)this.plugin.getSpaceId("draft123"));
    }
}

