/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.service;

import io.meeds.notes.model.TermsAndConditionPage;
import io.meeds.notes.service.TermsAndConditionsService;
import java.util.Collections;
import java.util.HashMap;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.WikiService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={TermsAndConditionsService.class})
class TermsAndConditionsServiceTest {
    @MockBean
    private NoteService noteService;
    @MockBean
    private WikiService wikiService;
    @MockBean
    private SettingService settingService;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private MetadataService metadataService;
    @MockBean
    private UserACL userACL;
    @Autowired
    private TermsAndConditionsService termsAndConditionsService;

    TermsAndConditionsServiceTest() {
    }

    @Test
    void testSaveTermsAndConditionsAdminUser() throws Exception {
        Identity adminIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)adminIdentity.getUserId()).thenReturn((Object)"admin");
        Mockito.when((Object)this.userACL.isAdministrator(adminIdentity)).thenReturn((Object)true);
        Page page = new Page("termsAndConditions", "content");
        page.setId("1");
        Mockito.when((Object)this.noteService.createNote((Wiki)Mockito.any(), (Page)Mockito.any(), (Page)Mockito.any())).thenReturn((Object)new Page("termsAndConditions", "content"));
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)page);
        Mockito.when((Object)this.wikiService.getWikiByTypeAndOwner((String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)new Wiki("termsAndConditions", "__system"));
        TermsAndConditionPage result = this.termsAndConditionsService.saveTermsAndConditions("content", "en", adminIdentity);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void testSaveTermsAndConditionsSimpleUser() throws WikiException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        Mockito.when((Object)this.userACL.isAdministrator(identity)).thenReturn((Object)false);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.termsAndConditionsService.saveTermsAndConditions("content", "en", identity));
        ((NoteService)Mockito.verify((Object)this.noteService, (VerificationMode)Mockito.never())).createNote((Wiki)Mockito.any(), (Page)Mockito.any(), (Page)Mockito.any());
    }

    @Test
    void testIsTermsAcceptedForUserWhenAccepted() throws WikiException {
        Page page = new Page("termsAndConditions", "content");
        page.setId("1");
        page.setLatestVersionId("123");
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)page);
        HashMap<String, String> settingValues = new HashMap<String, String>();
        settingValues.put("userTERMS_AND_CONDITIONS", "123");
        Mockito.when((Object)this.settingService.get((Context)Mockito.any(Context.class), (Scope)Mockito.any(Scope.class), Mockito.anyString())).thenAnswer(invocation -> {
            String key = (String)invocation.getArgument(2, String.class);
            if ("TERMS_AND_CONDITIONS_ACCEPTED_VERSION".equals(key)) {
                return SettingValue.create((String)"123");
            }
            return null;
        });
        Assertions.assertTrue((boolean)this.termsAndConditionsService.isTermsAcceptedForUser("user", "en"));
    }

    @Test
    void testIsTermsAcceptedForUserWhenNotAccepted() throws WikiException {
        Page page = new Page("termsAndConditions", "content");
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getProperties()).thenReturn((Object)new HashMap<String, String>(){
            {
                this.put("published", "true");
            }
        });
        MetadataObject metadataObject = new MetadataObject("termsAndConditions", "1");
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(TermsAndConditionsService.TC_METADATA_KEY, metadataObject)).thenReturn(Collections.singletonList(metadataItem));
        page.setId("1");
        page.setLatestVersionId("123");
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)page);
        Mockito.when((Object)this.settingService.get((Context)Mockito.any(Context.class), (Scope)Mockito.any(Scope.class), Mockito.anyString())).thenAnswer(invocation -> {
            String key = (String)invocation.getArgument(2, String.class);
            if ("TERMS_AND_CONDITIONS_ACCEPTED_VERSION".equals(key)) {
                return SettingValue.create((String)"456");
            }
            return null;
        });
        Assertions.assertFalse((boolean)this.termsAndConditionsService.isTermsAcceptedForUser("user", "en"));
    }

    @Test
    void testMarkTermsAsAcceptedForUser() throws WikiException {
        Page page = new Page("termsAndConditions", "content");
        page.setId("1");
        page.setLatestVersionId("123");
        MetadataItem metadataItem = (MetadataItem)Mockito.mock(MetadataItem.class);
        Mockito.when((Object)metadataItem.getProperties()).thenReturn((Object)new HashMap<String, String>(){
            {
                this.put("published", "true");
                this.put("latestVersionId", "123");
                this.put("publishedDate", "112322341");
            }
        });
        MetadataObject metadataObject = new MetadataObject("termsAndConditions", "1");
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(TermsAndConditionsService.TC_METADATA_KEY, metadataObject)).thenReturn(Collections.singletonList(metadataItem));
        Mockito.when((Object)this.noteService.getNoteOfNoteBookByName((String)Mockito.any(), (String)Mockito.any(), (String)Mockito.any())).thenReturn((Object)page);
        this.termsAndConditionsService.markTermsAsAcceptedForUser("user", "en");
        ArgumentCaptor captor = ArgumentCaptor.forClass(SettingValue.class);
        ((SettingService)Mockito.verify((Object)this.settingService)).set((Context)Mockito.any(), (Scope)Mockito.any(), (String)Mockito.any(), (SettingValue)captor.capture());
        Assertions.assertEquals((Object)"123", (Object)((SettingValue)captor.getValue()).getValue());
    }
}

