/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.test.dao;

import java.util.Collections;
import java.util.List;
import org.exoplatform.perkstore.dao.PerkStoreOrderDAO;
import org.exoplatform.perkstore.entity.ProductEntity;
import org.exoplatform.perkstore.entity.ProductOrderEntity;
import org.exoplatform.perkstore.model.OrderFilter;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderType;
import org.exoplatform.perkstore.test.BasePerkStoreTest;
import org.junit.Test;

public class ProductOrderDAOTest
extends BasePerkStoreTest {
    @Test
    public void testServiceInstantiated() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        ProductOrderDAOTest.assertNotNull((Object)orderDAO);
    }

    @Test
    public void testDeleteAll() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        try {
            orderDAO.deleteAll();
            ProductOrderDAOTest.fail((String)"shouldn't be able to delete all entities");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteAllEntities() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        try {
            orderDAO.deleteAll(Collections.emptyList());
            ProductOrderDAOTest.fail((String)"shouldn't be able to delete all entities");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCountOrders() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        Long count = orderDAO.count();
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)count.longValue(), (float)0.0f);
    }

    @Test
    public void testCountOrderedQuantityByProductId() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        double count = orderDAO.countOrderedQuantityByProductId(1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countOrderedQuantityByProductId(productEntity.getId().longValue());
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrder(productEntity);
        count = orderDAO.countOrderedQuantityByProductId(productEntity.getId().longValue());
        ProductOrderDAOTest.assertEquals((double)orderEntity.getQuantity(), (double)count, (double)0.0);
    }

    @Test
    public void testCountOrderedQuantityByProductIdAndStatus() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        double count = orderDAO.countOrderedQuantityByProductIdAndStatus(1L, ProductOrderStatus.ORDERED);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countOrderedQuantityByProductIdAndStatus(1L, ProductOrderStatus.ORDERED);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrder(productEntity);
        count = orderDAO.countOrderedQuantityByProductIdAndStatus(productEntity.getId().longValue(), orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)orderEntity.getQuantity(), (double)count, (double)0.0);
    }

    @Test
    public void testCountRefundedQuantityByProductId() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        double count = orderDAO.countRefundedQuantityByProductId(1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countRefundedQuantityByProductId(1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrderInstance(productEntity);
        boolean refundedQuantity = true;
        orderEntity.setRefundedQuantity((double)refundedQuantity);
        orderEntity = (ProductOrderEntity)orderDAO.create((Object)orderEntity);
        this.entitiesToClean.add(0, orderEntity);
        count = orderDAO.countRefundedQuantityByProductId(productEntity.getId().longValue());
        ProductOrderDAOTest.assertEquals((double)((double)refundedQuantity), (double)count, (double)0.0);
    }

    @Test
    public void testCountRemainingOrdersToProcessByProductId() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        double count = orderDAO.countRemainingOrdersToProcessByProductId(1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countRemainingOrdersToProcessByProductId(1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrderInstance(productEntity);
        boolean remainingQuantity = true;
        orderEntity.setRemainingQuantity((double)remainingQuantity);
        orderEntity = (ProductOrderEntity)orderDAO.create((Object)orderEntity);
        this.entitiesToClean.add(0, orderEntity);
        count = orderDAO.countRemainingOrdersToProcessByProductId(productEntity.getId().longValue());
        ProductOrderDAOTest.assertEquals((double)((double)remainingQuantity), (double)count, (double)0.0);
    }

    @Test
    public void testCountRemainingOrdersByIdentityIdAndProductId() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        double count = orderDAO.countRemainingOrdersByIdentityIdAndProductId(1L, 1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countRemainingOrdersByIdentityIdAndProductId(1L, 1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrderInstance(productEntity);
        boolean remainingQuantity = true;
        orderEntity.setRemainingQuantity((double)remainingQuantity);
        orderEntity = (ProductOrderEntity)orderDAO.create((Object)orderEntity);
        this.entitiesToClean.add(0, orderEntity);
        count = orderDAO.countRemainingOrdersByIdentityIdAndProductId(orderEntity.getSenderId(), productEntity.getId().longValue());
        ProductOrderDAOTest.assertEquals((double)((double)remainingQuantity), (double)count, (double)0.0);
        count = orderDAO.countRemainingOrdersByIdentityIdAndProductId(20L, productEntity.getId().longValue());
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
    }

    @Test
    public void testCountUserTotalPurchasedQuantity() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        double count = orderDAO.countUserTotalPurchasedQuantity(1L, 1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countUserTotalPurchasedQuantity(1L, 1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrder(productEntity);
        count = orderDAO.countUserTotalPurchasedQuantity(productEntity.getId().longValue(), orderEntity.getSenderId());
        ProductOrderDAOTest.assertEquals((double)orderEntity.getQuantity(), (double)count, (double)0.0);
        count = orderDAO.countUserTotalPurchasedQuantity(productEntity.getId().longValue(), 20L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
    }

    @Test
    public void testFindOrderByTransactionHash() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        ProductOrderEntity orderToFind = orderDAO.findOrderByTransactionHash(this.generateRandomHash());
        ProductOrderDAOTest.assertNull((Object)orderToFind);
        ProductEntity productEntity = this.newProduct();
        ProductOrderEntity orderEntity = this.newOrder(productEntity);
        orderToFind = orderDAO.findOrderByTransactionHash(orderEntity.getTransactionHash());
        ProductOrderDAOTest.assertNotNull((Object)orderToFind);
        orderToFind = orderDAO.findOrderByTransactionHash(this.generateRandomHash());
        ProductOrderDAOTest.assertNull((Object)orderToFind);
    }

    @Test
    public void findOrderByRefundTransactionHash() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        ProductOrderEntity orderToFind = orderDAO.findOrderByRefundTransactionHash(this.generateRandomHash());
        ProductOrderDAOTest.assertNull((Object)orderToFind);
        ProductEntity productEntity = this.newProduct();
        ProductOrderEntity orderEntity = this.newOrderInstance(productEntity);
        orderEntity.setRefundTransactionHash(this.generateRandomHash());
        orderEntity = (ProductOrderEntity)orderDAO.create((Object)orderEntity);
        this.entitiesToClean.add(0, orderEntity);
        orderToFind = orderDAO.findOrderByRefundTransactionHash(orderEntity.getRefundTransactionHash());
        ProductOrderDAOTest.assertNotNull((Object)orderToFind);
        orderToFind = orderDAO.findOrderByRefundTransactionHash(this.generateRandomHash());
        ProductOrderDAOTest.assertNull((Object)orderToFind);
    }

    @Test
    public void testGetOrders() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        OrderFilter filter = new OrderFilter();
        filter.setLimit(10);
        List orders = orderDAO.getOrders(null, filter, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        ProductEntity productEntity = this.newProduct();
        orders = orderDAO.getOrders(null, filter, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        ProductOrderEntity orderEntity = this.newOrder(productEntity);
        orders = orderDAO.getOrders(null, filter, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        String username = "root" + orderEntity.getSenderId();
        filter.setOrdersType(ProductOrderType.ALL);
        orders = orderDAO.getOrders("test", filter, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = orderDAO.getOrders(username, filter, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.SENT);
        orders = orderDAO.getOrders(username, filter, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.RECEIVED);
        orders = orderDAO.getOrders("test", filter, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(null);
        orders = orderDAO.getOrders(null, filter, false, false);
        filter.setOrdered(true);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = orderDAO.getOrders(null, filter, false, false);
        filter.setNotProcessed(true);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = orderDAO.getOrders(null, filter, false, false);
        filter.setProductId(productEntity.getId().longValue());
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = orderDAO.getOrders(null, filter, false, false);
        filter.setSelectedOrderId(orderEntity.getId().longValue());
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = orderDAO.getOrders(null, filter, false, false);
        filter.setSearchInDates(true);
        filter.setSelectedDate(System.currentTimeMillis());
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = orderDAO.getOrders(username, filter, false, true);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = orderDAO.getOrders("test", filter, false, true);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = orderDAO.getOrders("root30", filter, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.ALL);
        orders = orderDAO.getOrders("root1", filter, true, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.RECEIVED);
        orders = orderDAO.getOrders("root1", filter, true, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.SENT);
        orders = orderDAO.getOrders("root1", filter, true, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filter.setProductId(0L);
        filter.setOrdersType(ProductOrderType.ALL);
        orders = orderDAO.getOrders("root1", filter, true, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.RECEIVED);
        orders = orderDAO.getOrders("root1", filter, true, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.SENT);
        orders = orderDAO.getOrders("root1", filter, true, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        OrderFilter filterTmp = filter.clone();
        filterTmp.setSelectedOrderId(200L);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setProductId(200L);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setDelivered(true);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setCanceled(true);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setPaid(true);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setPartial(true);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setError(true);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setRefunded(true);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setSearchInDates(true);
        filterTmp.setSelectedDate(System.currentTimeMillis() - 86400000L);
        orders = orderDAO.getOrders(null, filterTmp, false, false);
        ProductOrderDAOTest.assertNotNull((Object)orders);
        ProductOrderDAOTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
    }

    @Test
    public void testCountUserTotalRefundedQuantity() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        double count = orderDAO.countUserTotalRefundedQuantity(1L, 1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countUserTotalRefundedQuantity(1L, 1L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrderInstance(productEntity);
        boolean refundedQuantity = true;
        orderEntity.setRefundedQuantity((double)refundedQuantity);
        orderEntity = (ProductOrderEntity)orderDAO.create((Object)orderEntity);
        this.entitiesToClean.add(0, orderEntity);
        count = orderDAO.countUserTotalRefundedQuantity(productEntity.getId().longValue(), orderEntity.getSenderId());
        ProductOrderDAOTest.assertEquals((double)((double)refundedQuantity), (double)count, (double)0.0);
        count = orderDAO.countUserTotalRefundedQuantity(productEntity.getId().longValue(), 20L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
    }

    @Test
    public void testCountUserPurchasedQuantityInPeriod() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        long startTime = System.currentTimeMillis() - 1000L;
        double count = orderDAO.countUserPurchasedQuantityInPeriod(1L, 1L, startTime, startTime + 2000L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countUserPurchasedQuantityInPeriod(productEntity.getId().longValue(), 1L, startTime, startTime + 2000L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrder(productEntity);
        long endTime = System.currentTimeMillis() + 1000L;
        count = orderDAO.countUserPurchasedQuantityInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), startTime, endTime);
        ProductOrderDAOTest.assertEquals((double)orderEntity.getQuantity(), (double)count, (double)0.0);
        count = orderDAO.countUserPurchasedQuantityInPeriod(productEntity.getId().longValue(), 200L, startTime, endTime);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserPurchasedQuantityInPeriod(3000L, orderEntity.getSenderId(), startTime, endTime);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserPurchasedQuantityInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), endTime, endTime);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserPurchasedQuantityInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), startTime, startTime);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
    }

    @Test
    public void testCountUserOrderedQuantityByStatusInPeriod() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        long startTime = System.currentTimeMillis() - 1000L;
        double count = orderDAO.countUserOrderedQuantityByStatusInPeriod(1L, 1L, startTime, startTime + 2000L, ProductOrderStatus.ORDERED);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countUserOrderedQuantityByStatusInPeriod(productEntity.getId().longValue(), 1L, startTime, startTime + 2000L, ProductOrderStatus.ORDERED);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrder(productEntity);
        long endTime = System.currentTimeMillis() + 1000L;
        count = orderDAO.countUserOrderedQuantityByStatusInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), startTime, endTime, orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)orderEntity.getQuantity(), (double)count, (double)0.0);
        count = orderDAO.countUserOrderedQuantityByStatusInPeriod(productEntity.getId().longValue(), 200L, startTime, endTime, orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserOrderedQuantityByStatusInPeriod(3000L, orderEntity.getSenderId(), startTime, endTime, orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserOrderedQuantityByStatusInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), endTime, endTime, orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserOrderedQuantityByStatusInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), startTime, startTime, orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserOrderedQuantityByStatusInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), startTime, endTime, ProductOrderStatus.DELIVERED);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
    }

    @Test
    public void testCountUserRefundedQuantityInPeriod() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        long startTime = System.currentTimeMillis() - 1000L;
        double count = orderDAO.countUserRefundedQuantityInPeriod(1L, 1L, startTime, startTime + 2000L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countUserRefundedQuantityInPeriod(productEntity.getId().longValue(), 1L, startTime, startTime + 2000L);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrderInstance(productEntity);
        boolean refundedQuantity = true;
        orderEntity.setRefundedQuantity((double)refundedQuantity);
        orderEntity = (ProductOrderEntity)orderDAO.create((Object)orderEntity);
        this.entitiesToClean.add(0, orderEntity);
        long endTime = System.currentTimeMillis() + 1000L;
        count = orderDAO.countUserRefundedQuantityInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), startTime, endTime);
        ProductOrderDAOTest.assertEquals((double)orderEntity.getQuantity(), (double)count, (double)0.0);
        count = orderDAO.countUserRefundedQuantityInPeriod(productEntity.getId().longValue(), 200L, startTime, endTime);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserRefundedQuantityInPeriod(3000L, orderEntity.getSenderId(), startTime, endTime);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserRefundedQuantityInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), endTime, endTime);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserRefundedQuantityInPeriod(productEntity.getId().longValue(), orderEntity.getSenderId(), startTime, startTime);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
    }

    @Test
    public void testCountUserTotalOrderedQuantityByStatus() {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        double count = orderDAO.countUserTotalOrderedQuantityByStatus(1L, 1L, ProductOrderStatus.ORDERED);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductEntity productEntity = this.newProduct();
        count = orderDAO.countUserTotalOrderedQuantityByStatus(productEntity.getId().longValue(), 1L, ProductOrderStatus.ORDERED);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        ProductOrderEntity orderEntity = this.newOrderInstance(productEntity);
        boolean refundedQuantity = true;
        orderEntity.setRefundedQuantity((double)refundedQuantity);
        orderEntity = (ProductOrderEntity)orderDAO.create((Object)orderEntity);
        this.entitiesToClean.add(0, orderEntity);
        count = orderDAO.countUserTotalOrderedQuantityByStatus(productEntity.getId().longValue(), orderEntity.getSenderId(), orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)((double)refundedQuantity), (double)count, (double)0.0);
        count = orderDAO.countUserTotalOrderedQuantityByStatus(productEntity.getId().longValue(), orderEntity.getSenderId(), ProductOrderStatus.CANCELED);
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserTotalOrderedQuantityByStatus(productEntity.getId().longValue(), 20L, orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
        count = orderDAO.countUserTotalOrderedQuantityByStatus(3000L, orderEntity.getSenderId(), orderEntity.getStatus());
        ProductOrderDAOTest.assertEquals((double)0.0, (double)count, (double)0.0);
    }
}

