/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.test.mock;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.IdentityProviderPlugin;
import org.exoplatform.social.core.identity.SpaceMemberFilterListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.profile.ProfileListener;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class IdentityManagerMock
implements IdentityManager {
    List<Identity> identities = new ArrayList<Identity>();

    public IdentityManagerMock() {
        Profile profile;
        Identity identity;
        int i;
        for (i = 0; i < 100; ++i) {
            identity = new Identity(String.valueOf(i));
            identity.setDeleted(false);
            identity.setEnable(true);
            identity.setProviderId("organization");
            identity.setRemoteId("root" + i);
            profile = new Profile(identity);
            identity.setProfile(profile);
            this.identities.add(identity);
        }
        for (i = 0; i < 100; ++i) {
            identity = new Identity(String.valueOf(i));
            identity.setDeleted(false);
            identity.setEnable(true);
            identity.setProviderId("space");
            identity.setRemoteId("space" + i);
            profile = new Profile(identity);
            identity.setProfile(profile);
            this.identities.add(identity);
        }
    }

    public Identity getOrCreateIdentity(String providerId, String remoteId, boolean isProfileLoaded) {
        return this.identities.stream().filter(identity -> StringUtils.equals((CharSequence)identity.getProviderId(), (CharSequence)providerId) && StringUtils.equals((CharSequence)identity.getRemoteId(), (CharSequence)remoteId)).findFirst().orElse(null);
    }

    public Identity getIdentity(String identityId, boolean isProfileLoaded) {
        return this.identities.stream().filter(identity -> StringUtils.equals((CharSequence)identity.getId(), (CharSequence)identityId)).findFirst().orElse(null);
    }

    public void registerIdentityProviders(IdentityProviderPlugin plugin) {
    }

    public void addProfileListener(ProfileListenerPlugin plugin) {
    }

    public Identity getIdentity(String providerId, String remoteId, boolean loadProfile) {
        return this.getOrCreateIdentity(providerId, remoteId, loadProfile);
    }

    public boolean identityExisted(String providerId, String remoteId) {
        return this.getOrCreateIdentity(providerId, remoteId, true) != null;
    }

    public Identity getIdentity(String id) {
        return this.getIdentity(id, true);
    }

    public Identity getOrCreateIdentity(String providerId, String remoteId) {
        return this.getOrCreateIdentity(providerId, remoteId, true);
    }

    public Identity updateIdentity(Identity identity) {
        return identity;
    }

    public List<Identity> getLastIdentities(int limit) {
        throw new UnsupportedOperationException();
    }

    public void deleteIdentity(Identity identity) {
        throw new UnsupportedOperationException();
    }

    public void hardDeleteIdentity(Identity identity) {
        throw new UnsupportedOperationException();
    }

    public ListAccess<Identity> getConnectionsWithListAccess(Identity identity) {
        throw new UnsupportedOperationException();
    }

    public Profile getProfile(Identity identity) {
        return identity.getProfile();
    }

    public InputStream getAvatarInputStream(Identity identity) throws IOException {
        throw new UnsupportedOperationException();
    }

    public InputStream getBannerInputStream(Identity identity) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void updateProfile(Profile specificProfile) {
    }

    public ListAccess<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, boolean isProfileLoaded) {
        throw new UnsupportedOperationException();
    }

    public ListAccess<Identity> getIdentitiesForUnifiedSearch(String providerId, ProfileFilter profileFilter) {
        throw new UnsupportedOperationException();
    }

    public ListAccess<Identity> getSpaceIdentityByProfileFilter(Space space, ProfileFilter profileFilter, SpaceMemberFilterListAccess.Type type, boolean isProfileLoaded) {
        throw new UnsupportedOperationException();
    }

    public void addIdentityProvider(IdentityProvider<?> identityProvider) {
        throw new UnsupportedOperationException();
    }

    public void removeIdentityProvider(IdentityProvider<?> identityProvider) {
        throw new UnsupportedOperationException();
    }

    public void registerProfileListener(ProfileListenerPlugin profileListenerPlugin) {
        throw new UnsupportedOperationException();
    }

    public void processEnabledIdentity(String remoteId, boolean isEnable) {
        throw new UnsupportedOperationException();
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<Identity> getIdentitiesByProfileFilter(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<Identity> getIdentitiesByProfileFilter(ProfileFilter profileFilter, long offset, long limit) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(String providerId, ProfileFilter profileFilter, long offset, long limit) throws Exception {
        throw new UnsupportedOperationException();
    }

    public List<Identity> getIdentitiesFilterByAlphaBet(ProfileFilter profileFilter) throws Exception {
        throw new UnsupportedOperationException();
    }

    public long getIdentitiesCount(String providerId) {
        throw new UnsupportedOperationException();
    }

    public List<Identity> getConnections(Identity ownerIdentity) throws Exception {
        throw new UnsupportedOperationException();
    }

    public IdentityStorage getIdentityStorage() {
        throw new UnsupportedOperationException();
    }

    public IdentityStorage getStorage() {
        throw new UnsupportedOperationException();
    }

    public void registerProfileListener(ProfileListener listener) {
        throw new UnsupportedOperationException();
    }

    public void unregisterProfileListener(ProfileListener listener) {
        throw new UnsupportedOperationException();
    }
}

