/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.test.service;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.perkstore.exception.PerkStoreException;
import org.exoplatform.perkstore.model.FileDetail;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.model.OrderFilter;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.Profile;
import org.exoplatform.perkstore.model.constant.PerkStoreError;
import org.exoplatform.perkstore.model.constant.ProductOrderModificationType;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderTransactionStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderType;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.perkstore.storage.PerkStoreStorage;
import org.exoplatform.perkstore.test.BasePerkStoreTest;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PerkStoreServiceTest
extends BasePerkStoreTest {
    @Test
    public void testServiceInstantiated() {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        PerkStoreServiceTest.assertNotNull((Object)perkStoreService);
    }

    @Test
    public void testGetGlobalSettings() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        GlobalSettings globalSettings = perkStoreService.getGlobalSettings();
        PerkStoreServiceTest.assertNotNull((Object)globalSettings);
        this.checkBasicOperations(globalSettings);
        PerkStoreServiceTest.assertTrue((globalSettings.getAccessPermissions() == null || globalSettings.getAccessPermissions().isEmpty() ? 1 : 0) != 0);
        PerkStoreServiceTest.assertTrue((globalSettings.getManagers() == null || globalSettings.getManagers().isEmpty() ? 1 : 0) != 0);
        PerkStoreServiceTest.assertTrue((globalSettings.getProductCreationPermissions() == null || globalSettings.getProductCreationPermissions().isEmpty() ? 1 : 0) != 0);
        PerkStoreServiceTest.assertTrue((globalSettings.getAccessPermissionsProfiles() == null || globalSettings.getAccessPermissionsProfiles().isEmpty() ? 1 : 0) != 0);
        PerkStoreServiceTest.assertTrue((globalSettings.getManagersProfiles() == null || globalSettings.getManagersProfiles().isEmpty() ? 1 : 0) != 0);
        PerkStoreServiceTest.assertTrue((globalSettings.getProductCreationPermissionsProfiles() == null || globalSettings.getProductCreationPermissionsProfiles().isEmpty() ? 1 : 0) != 0);
        PerkStoreServiceTest.assertNull((Object)globalSettings.getSymbol());
        PerkStoreServiceTest.assertNull((Object)globalSettings.getUserSettings());
        GlobalSettings globalSettingsTmp = perkStoreService.getGlobalSettings();
        PerkStoreServiceTest.assertNotNull((Object)globalSettingsTmp);
        PerkStoreServiceTest.assertEquals((Object)globalSettingsTmp, (Object)globalSettings);
        PerkStoreServiceTest.assertEquals((String)globalSettingsTmp.toString(), (String)globalSettings.toString());
        PerkStoreServiceTest.assertFalse((globalSettingsTmp == globalSettings ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetGlobalSettingsForUser() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        try {
            perkStoreService.getGlobalSettings(null);
            PerkStoreServiceTest.fail((String)"Shouldn't be able to get global settings for a null user");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        GlobalSettings userGlobalSettings = perkStoreService.getGlobalSettings("root1");
        PerkStoreServiceTest.assertNotNull((Object)userGlobalSettings);
        PerkStoreServiceTest.assertNull((Object)userGlobalSettings.getAccessPermissions());
        PerkStoreServiceTest.assertNull((Object)userGlobalSettings.getManagers());
        PerkStoreServiceTest.assertNull((Object)userGlobalSettings.getAccessPermissionsProfiles());
        PerkStoreServiceTest.assertNull((Object)userGlobalSettings.getManagersProfiles());
        PerkStoreServiceTest.assertNull((Object)userGlobalSettings.getProductCreationPermissions());
        PerkStoreServiceTest.assertNull((Object)userGlobalSettings.getProductCreationPermissionsProfiles());
        PerkStoreServiceTest.assertNull((Object)userGlobalSettings.getSymbol());
        PerkStoreServiceTest.assertNotNull((Object)userGlobalSettings.getUserSettings());
        GlobalSettings userGlobalSettingsTmp = perkStoreService.getGlobalSettings("root1");
        PerkStoreServiceTest.assertNotNull((Object)userGlobalSettingsTmp);
        PerkStoreServiceTest.assertEquals((Object)userGlobalSettingsTmp, (Object)userGlobalSettings);
        PerkStoreServiceTest.assertEquals((String)userGlobalSettingsTmp.toString(), (String)userGlobalSettings.toString());
        PerkStoreServiceTest.assertFalse((userGlobalSettingsTmp == userGlobalSettings ? 1 : 0) != 0);
        this.checkBasicOperations(userGlobalSettingsTmp);
        PerkStoreServiceTest.assertNotNull((Object)userGlobalSettingsTmp.getUserSettings());
        PerkStoreServiceTest.assertEquals((Object)userGlobalSettingsTmp.getUserSettings(), (Object)userGlobalSettings.getUserSettings());
        PerkStoreServiceTest.assertEquals((int)userGlobalSettingsTmp.getUserSettings().hashCode(), (int)userGlobalSettings.getUserSettings().hashCode());
        PerkStoreServiceTest.assertFalse((userGlobalSettingsTmp.getUserSettings() == userGlobalSettings.getUserSettings() ? 1 : 0) != 0);
        PerkStoreServiceTest.assertNotNull((Object)userGlobalSettingsTmp.getUserSettings().getCometdChannel());
        PerkStoreServiceTest.assertNotNull((Object)userGlobalSettingsTmp.getUserSettings().getCometdContext());
        PerkStoreServiceTest.assertNotNull((Object)userGlobalSettingsTmp.getUserSettings().getCometdToken());
        PerkStoreServiceTest.assertFalse((boolean)userGlobalSettingsTmp.getUserSettings().isAdministrator());
        PerkStoreServiceTest.assertTrue((boolean)userGlobalSettingsTmp.getUserSettings().isCanAddProduct());
        GlobalSettings defaultSettings = perkStoreService.getGlobalSettings();
        GlobalSettings newSettings = new GlobalSettings();
        newSettings.setAccessPermissionsProfiles(Arrays.asList(Utils.toProfile((long)3L)));
        perkStoreService.saveGlobalSettings(newSettings, "root90");
        try {
            perkStoreService.getGlobalSettings("root1");
            PerkStoreServiceTest.fail((String)"User not allowed to access application");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.GLOBAL_SETTINGS_ACCESS_DENIED, (Object)e.getErrorType());
        }
        finally {
            perkStoreService.saveGlobalSettings(defaultSettings.clone(), "root90");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveGlobalSettings() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        try {
            perkStoreService.saveGlobalSettings(new GlobalSettings(), "root1");
            PerkStoreServiceTest.fail((String)"User not member of rewarding administrators group should,'t be able to modify settings");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.GLOBAL_SETTINGS_MODIFICATION_DENIED, (Object)e.getErrorType());
        }
        GlobalSettings defaultSettings = perkStoreService.getGlobalSettings();
        GlobalSettings newSettings = new GlobalSettings();
        perkStoreService.saveGlobalSettings(newSettings, "root90");
        GlobalSettings globalSettingsTmp = perkStoreService.getGlobalSettings();
        PerkStoreServiceTest.assertNotNull((Object)globalSettingsTmp);
        PerkStoreServiceTest.assertEquals((Object)newSettings, (Object)globalSettingsTmp);
        List<Profile> managers = Arrays.asList(new Profile(2L));
        List<Profile> accessPermission = Arrays.asList(new Profile(1L));
        List<Profile> creationPermission = Arrays.asList(new Profile(3L));
        String symbol = "symbol";
        newSettings.setAccessPermissionsProfiles(accessPermission);
        newSettings.setManagersProfiles(managers);
        newSettings.setProductCreationPermissionsProfiles(creationPermission);
        newSettings.setSymbol(symbol);
        perkStoreService.saveGlobalSettings(newSettings, "root90");
        try {
            globalSettingsTmp = perkStoreService.getGlobalSettings();
            PerkStoreServiceTest.assertNotNull((Object)globalSettingsTmp);
            PerkStoreServiceTest.assertEquals((Object)newSettings, (Object)globalSettingsTmp);
            PerkStoreServiceTest.assertNotNull((Object)globalSettingsTmp.getAccessPermissionsProfiles());
            PerkStoreServiceTest.assertEquals((int)1, (int)globalSettingsTmp.getAccessPermissionsProfiles().size());
            PerkStoreServiceTest.assertNotNull((Object)globalSettingsTmp.getManagersProfiles());
            PerkStoreServiceTest.assertEquals((int)1, (int)globalSettingsTmp.getManagersProfiles().size());
            PerkStoreServiceTest.assertNotNull((Object)globalSettingsTmp.getProductCreationPermissionsProfiles());
            PerkStoreServiceTest.assertEquals((int)1, (int)globalSettingsTmp.getProductCreationPermissionsProfiles().size());
            PerkStoreServiceTest.assertNotNull((Object)globalSettingsTmp.getSymbol());
            PerkStoreServiceTest.assertEquals((String)symbol, (String)globalSettingsTmp.getSymbol());
        }
        finally {
            perkStoreService.saveGlobalSettings(defaultSettings.clone(), "root90");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsPerkStoreManager() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        PerkStoreServiceTest.assertTrue((boolean)perkStoreService.isPerkStoreManager("root90"));
        PerkStoreServiceTest.assertFalse((boolean)perkStoreService.isPerkStoreManager("root1"));
        GlobalSettings defaultSettings = perkStoreService.getGlobalSettings();
        GlobalSettings newSettings = new GlobalSettings();
        newSettings.setManagersProfiles(Arrays.asList(Utils.toProfile((long)1L)));
        perkStoreService.saveGlobalSettings(newSettings, "root90");
        try {
            PerkStoreServiceTest.assertTrue((boolean)perkStoreService.isPerkStoreManager("root1"));
        }
        finally {
            perkStoreService.saveGlobalSettings(defaultSettings, "root90");
        }
    }

    @Test
    public void testSaveProduct() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        try {
            perkStoreService.saveProduct(null, "root90");
            PerkStoreServiceTest.fail((String)"product should be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            perkStoreService.saveProduct(new Product(), null);
            PerkStoreServiceTest.fail((String)"username should be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            perkStoreService.saveProduct(new Product(), "root90");
            PerkStoreServiceTest.fail((String)"Some product attributes are required when saving a new product");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Product product = new Product();
        Product savedProduct = this.newProduct(perkStoreService, product);
        PerkStoreServiceTest.assertNotNull((Object)savedProduct);
        PerkStoreServiceTest.assertTrue((savedProduct.getId() > 0L ? 1 : 0) != 0);
        product.setId(savedProduct.getId());
        PerkStoreServiceTest.assertTrue((savedProduct.getImageFiles() == null || savedProduct.getImageFiles().isEmpty() ? 1 : 0) != 0);
        PerkStoreServiceTest.assertEquals((Object)product, (Object)savedProduct);
        this.checkBasicOperations(savedProduct);
        PerkStoreServiceTest.assertEquals((String)product.getTitle(), (String)savedProduct.getTitle());
        PerkStoreServiceTest.assertEquals((String)product.getIllustrationURL(), (String)savedProduct.getIllustrationURL());
        PerkStoreServiceTest.assertEquals((String)product.getDescription(), (String)savedProduct.getDescription());
        PerkStoreServiceTest.assertEquals((Object)product.getAccessPermissions(), (Object)savedProduct.getAccessPermissions());
        PerkStoreServiceTest.assertEquals((Object)product.getMarchands(), (Object)savedProduct.getMarchands());
        PerkStoreServiceTest.assertEquals((boolean)product.isEnabled(), (boolean)savedProduct.isEnabled());
        PerkStoreServiceTest.assertEquals((boolean)product.isAllowFraction(), (boolean)savedProduct.isAllowFraction());
        PerkStoreServiceTest.assertEquals((double)product.getPrice(), (double)savedProduct.getPrice(), (double)0.0);
        PerkStoreServiceTest.assertEquals((double)product.getMaxOrdersPerUser(), (double)savedProduct.getMaxOrdersPerUser(), (double)0.0);
        PerkStoreServiceTest.assertNotNull((Object)savedProduct.getOrderPeriodicity());
        PerkStoreServiceTest.assertEquals((String)product.getOrderPeriodicity().toLowerCase(), (String)savedProduct.getOrderPeriodicity().toLowerCase());
        PerkStoreServiceTest.assertEquals((boolean)product.isUnlimited(), (boolean)savedProduct.isUnlimited());
        PerkStoreServiceTest.assertEquals((double)product.getTotalSupply(), (double)savedProduct.getTotalSupply(), (double)0.0);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)savedProduct.getNotProcessedOrders(), (float)0.0f);
        PerkStoreServiceTest.assertEquals((double)0.0, (double)savedProduct.getPurchased(), (double)0.0);
        savedProduct.setNotProcessedOrders(10L);
        savedProduct.setPurchased(10.0);
        savedProduct = perkStoreService.saveProduct(product, "root1");
        PerkStoreServiceTest.assertEquals((String)"NotProcessedOrders should be computed and not saved", (float)0.0f, (float)savedProduct.getNotProcessedOrders(), (float)0.0f);
        PerkStoreServiceTest.assertEquals((String)"Purchased should be computed and not saved", (double)0.0, (double)savedProduct.getPurchased(), (double)0.0);
        product.setImageFiles(new HashSet<FileDetail>(Arrays.asList(new FileDetail(100L))));
        savedProduct = perkStoreService.saveProduct(product, "root1");
        PerkStoreServiceTest.assertEquals((String)"Fake image detail id should have been deleted when saving", (int)0, (int)savedProduct.getImageFiles().size());
        long savedProductId = savedProduct.getId();
        savedProduct.setId(200L);
        try {
            perkStoreService.saveProduct(savedProduct, "root1");
            PerkStoreServiceTest.fail((String)"shouldn't be able to update non existing product");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.PRODUCT_NOT_EXISTS, (Object)e.getErrorType());
        }
        savedProduct.setId(savedProductId);
        try {
            perkStoreService.saveProduct(savedProduct, "root2");
            PerkStoreServiceTest.fail((String)"shouldn't be able to update product");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.PRODUCT_MODIFICATION_DENIED, (Object)e.getErrorType());
        }
        savedProduct.setDescription(null);
        savedProduct.setIllustrationURL(null);
        savedProduct.setOrderPeriodicity(null);
        savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
        PerkStoreServiceTest.assertNotNull((Object)savedProduct);
        PerkStoreServiceTest.assertNull((Object)savedProduct.getDescription());
        PerkStoreServiceTest.assertNull((Object)savedProduct.getIllustrationURL());
        PerkStoreServiceTest.assertNull((Object)savedProduct.getIllustrationURL());
        PerkStoreServiceTest.assertNull((Object)savedProduct.getOrderPeriodicity());
        PerkStoreServiceTest.assertNull((Object)savedProduct.getOrderPeriodicityLabel());
    }

    @Test
    public void testGetProducts() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        PerkStoreStorage perkStoreStorage = this.getService(PerkStoreStorage.class);
        List products = perkStoreService.getProducts(false, "root1");
        PerkStoreServiceTest.assertNotNull((Object)products);
        PerkStoreServiceTest.assertEquals((int)0, (int)products.size());
        this.newProduct(perkStoreService, new Product());
        products = perkStoreService.getProducts(false, "root1");
        PerkStoreServiceTest.assertNotNull((Object)products);
        PerkStoreServiceTest.assertEquals((int)1, (int)products.size());
        Product savedProduct = this.newProduct(perkStoreService, new Product());
        products = perkStoreService.getProducts(false, "root2");
        PerkStoreServiceTest.assertNotNull((Object)products);
        PerkStoreServiceTest.assertEquals((int)2, (int)products.size());
        savedProduct.setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
        perkStoreService.saveProduct(savedProduct, "root1");
        products = perkStoreService.getProducts(false, "root2");
        PerkStoreServiceTest.assertNotNull((Object)products);
        PerkStoreServiceTest.assertEquals((int)1, (int)products.size());
        products = perkStoreService.getProducts(false, "root90");
        PerkStoreServiceTest.assertNotNull((Object)products);
        PerkStoreServiceTest.assertEquals((int)2, (int)products.size());
        savedProduct.setDeleted(true);
        perkStoreStorage.saveProduct(savedProduct, "root1");
        products = perkStoreService.getProducts(false, "root90");
        PerkStoreServiceTest.assertNotNull((Object)products);
        PerkStoreServiceTest.assertEquals((int)1, (int)products.size());
    }

    @Test
    public void testGetAvailableProducts() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        this.newProduct(perkStoreService, new Product());
        this.newProduct(perkStoreService, new Product());
        Product savedProduct2 = this.newProduct(perkStoreService, new Product());
        Product savedProduct3 = this.newProduct(perkStoreService, new Product());
        List products = perkStoreService.getProducts(false, "root1");
        PerkStoreServiceTest.assertNotNull((Object)products);
        PerkStoreServiceTest.assertEquals((int)4, (int)products.size());
        savedProduct2.setEnabled(false);
        savedProduct3.setEnabled(false);
        perkStoreService.saveProduct(savedProduct2, "root1");
        perkStoreService.saveProduct(savedProduct3, "root1");
        products = perkStoreService.getProducts(true, "root1");
        PerkStoreServiceTest.assertNotNull((Object)products);
        PerkStoreServiceTest.assertEquals((int)2, (int)products.size());
    }

    @Test
    public void testGetProductById() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        PerkStoreStorage perkStoreStorage = this.getService(PerkStoreStorage.class);
        Product product = perkStoreService.getProductById(0L);
        PerkStoreServiceTest.assertNull((Object)product);
        Product savedProduct = this.newProduct(perkStoreService, new Product());
        PerkStoreServiceTest.assertNotNull((Object)savedProduct);
        Product productById = perkStoreService.getProductById(savedProduct.getId());
        PerkStoreServiceTest.assertNotNull((Object)productById);
        productById = perkStoreService.getProductById(savedProduct.getId());
        PerkStoreServiceTest.assertNotNull((Object)productById);
        savedProduct.setDeleted(true);
        perkStoreStorage.saveProduct(savedProduct, "root1");
        productById = perkStoreService.getProductById(savedProduct.getId());
        PerkStoreServiceTest.assertNull((Object)productById);
    }

    @Test
    public void testGetProductByIdAndUser() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product product = null;
        product = perkStoreService.getProductById(0L, "root1");
        PerkStoreServiceTest.assertNull((Object)product);
        Product savedProduct = this.newProduct(perkStoreService, new Product());
        PerkStoreServiceTest.assertNotNull((Object)savedProduct);
        Product productById = perkStoreService.getProductById(savedProduct.getId(), "root1");
        PerkStoreServiceTest.assertNotNull((Object)productById);
        productById = perkStoreService.getProductById(savedProduct.getId(), "root1");
        PerkStoreServiceTest.assertNotNull((Object)productById);
        PerkStoreServiceTest.assertNotNull((Object)productById.getUserData());
        this.checkBasicOperations(productById.getUserData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckCanCreateOrder() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        try {
            perkStoreService.checkCanCreateOrder(null, "root90");
            PerkStoreServiceTest.fail((String)"order should be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            perkStoreService.checkCanCreateOrder(new ProductOrder(), null);
            PerkStoreServiceTest.fail((String)"username should be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            perkStoreService.checkCanCreateOrder(new ProductOrder(), "root90");
            PerkStoreServiceTest.fail((String)"productId should be mandatory");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.PRODUCT_NOT_EXISTS, (Object)e.getErrorType());
        }
        try {
            ProductOrder order = new ProductOrder();
            order.setProductId(200L);
            perkStoreService.checkCanCreateOrder(new ProductOrder(), "root90");
            PerkStoreServiceTest.fail((String)"productId should exists");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.PRODUCT_NOT_EXISTS, (Object)e.getErrorType());
        }
        Product savedProduct = this.newProduct(perkStoreService, new Product());
        GlobalSettings defaultSettings = perkStoreService.getGlobalSettings();
        GlobalSettings newSettings = new GlobalSettings();
        newSettings.setAccessPermissionsProfiles(Arrays.asList(Utils.toProfile((long)2L)));
        perkStoreService.saveGlobalSettings(newSettings, "root90");
        try {
            ProductOrder newOrder;
            ProductOrder order;
            ProductOrder order2;
            try {
                order2 = this.newOrderInstance(savedProduct);
                perkStoreService.checkCanCreateOrder(order2, "root1");
                PerkStoreServiceTest.fail((String)"Shouldn't be able to create a new order when not member of access permission profiles for application");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_MODIFICATION_DENIED, (Object)e.getErrorType());
            }
            newSettings.setAccessPermissionsProfiles(Arrays.asList(Utils.toProfile((long)1L)));
            perkStoreService.saveGlobalSettings(newSettings, "root90");
            try {
                order2 = this.newOrderInstance(savedProduct);
                perkStoreService.checkCanCreateOrder(order2, "root1");
                PerkStoreServiceTest.fail((String)"Shouldn't be able to create a new order on inaccessible product");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_MODIFICATION_DENIED, (Object)e.getErrorType());
            }
            savedProduct.setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
            perkStoreService.saveProduct(savedProduct, "root1");
            ProductOrder savedOrder = this.newOrder(savedProduct);
            try {
                order = this.newOrderInstance(savedProduct);
                perkStoreService.checkCanCreateOrder(order, "root1");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_CREATION_QUANTITY_EXCEEDS_ALLOWED, (Object)e.getErrorType());
            }
            savedProduct.setTotalSupply(2.0);
            perkStoreService.saveProduct(savedProduct, "root1");
            try {
                order = this.newOrderInstance(savedProduct);
                perkStoreService.checkCanCreateOrder(order, "root1");
                PerkStoreServiceTest.fail((String)"shouldn't be able to order again");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_CREATION_QUANTITY_EXCEEDS_ALLOWED, (Object)e.getErrorType());
            }
            savedProduct.setMaxOrdersPerUser(2.0);
            perkStoreService.saveProduct(savedProduct, "root1");
            savedProduct = perkStoreService.getProductById(savedProduct.getId());
            try {
                order = this.newOrderInstance(savedProduct);
                order.setTransactionHash(savedOrder.getTransactionHash());
                perkStoreService.checkCanCreateOrder(order, "root1");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_CREATION_DENIED, (Object)e.getErrorType());
            }
            order = this.newOrderInstance(savedProduct);
            perkStoreService.checkCanCreateOrder(order, "root1");
            try {
                newOrder = this.newOrderInstance(savedProduct);
                newOrder.setId(500L);
                perkStoreService.checkCanCreateOrder(newOrder, "root90");
                PerkStoreServiceTest.fail((String)"productId should exists");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_MODIFICATION_DENIED, (Object)e.getErrorType());
            }
            savedProduct.setEnabled(false);
            savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
            try {
                newOrder = this.newOrderInstance(savedProduct);
                perkStoreService.checkCanCreateOrder(newOrder, "root90");
                PerkStoreServiceTest.fail((String)"productId should exists");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.PRODUCT_IS_DISABLED, (Object)e.getErrorType());
            }
        }
        finally {
            perkStoreService.saveGlobalSettings(defaultSettings, "root90");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateOrder() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product savedProduct = this.newProduct(perkStoreService, new Product());
        GlobalSettings defaultSettings = perkStoreService.getGlobalSettings();
        GlobalSettings newSettings = new GlobalSettings();
        newSettings.setAccessPermissionsProfiles(Arrays.asList(Utils.toProfile((long)2L)));
        perkStoreService.saveGlobalSettings(newSettings, "root90");
        try {
            ProductOrder savedOrder = null;
            try {
                savedOrder = this.newOrder(savedProduct);
                PerkStoreServiceTest.fail((String)"Shouldn't be able to create a new order when not member of access permission profiles for application");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_MODIFICATION_DENIED, (Object)e.getErrorType());
            }
            PerkStoreServiceTest.assertNull((Object)savedOrder);
            newSettings.setAccessPermissionsProfiles(Arrays.asList(Utils.toProfile((long)1L)));
            perkStoreService.saveGlobalSettings(newSettings, "root90");
            try {
                savedOrder = this.newOrder(savedProduct);
                PerkStoreServiceTest.fail((String)"Shouldn't be able to create a new order on inaccessible product");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_MODIFICATION_DENIED, (Object)e.getErrorType());
            }
            PerkStoreServiceTest.assertNull((Object)savedOrder);
            savedProduct.setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
            perkStoreService.saveProduct(savedProduct, "root1");
            savedOrder = this.newOrder(savedProduct);
            PerkStoreServiceTest.assertNotNull((Object)savedOrder);
            PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
            try {
                savedOrder = this.newOrder(savedProduct);
                PerkStoreServiceTest.fail((String)"shouldn't be able to order again");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_CREATION_QUANTITY_EXCEEDS_ALLOWED, (Object)e.getErrorType());
            }
            savedProduct.setTotalSupply(2.0);
            perkStoreService.saveProduct(savedProduct, "root1");
            try {
                savedOrder = this.newOrder(savedProduct);
                PerkStoreServiceTest.fail((String)"shouldn't be able to order again");
            }
            catch (PerkStoreException e) {
                PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
                PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
                PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_CREATION_QUANTITY_EXCEEDS_ALLOWED, (Object)e.getErrorType());
            }
            savedProduct.setMaxOrdersPerUser(2.0);
            perkStoreService.saveProduct(savedProduct, "root1");
            this.newOrder(savedProduct);
        }
        finally {
            perkStoreService.saveGlobalSettings(defaultSettings, "root90");
        }
    }

    @Test
    public void testReplaceOrderHash() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product product = this.newProduct(perkStoreService, new Product());
        product.setAccessPermissions(null);
        product = perkStoreService.saveProduct(product, "root1");
        ProductOrder order = this.newOrder(product);
        PerkStoreServiceTest.assertNotNull((Object)order);
        PerkStoreServiceTest.assertNull((Object)order.getError());
        String newHash = this.generateRandomHash();
        perkStoreService.replaceTransactions(order.getTransactionHash(), newHash);
        ProductOrder replacedOrder = perkStoreService.getOrderById(order.getId());
        PerkStoreServiceTest.assertEquals((String)newHash, (String)replacedOrder.getTransactionHash());
    }

    @Test
    public void testCreateOrderWithWrongReceiverFraud() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product product = this.newProductInstance(new Product());
        product.setAccessPermissions(null);
        Product savedProduct = perkStoreService.saveProduct(product, "root1");
        this.entitiesToClean.add(0, savedProduct);
        ProductOrder productOrder = this.newOrderInstance(savedProduct);
        productOrder.setReceiver(Utils.toProfile((long)3L));
        ProductOrder savedOrder = perkStoreService.createOrder(productOrder, "root1");
        this.entitiesToClean.add(0, savedOrder);
        PerkStoreServiceTest.assertNotNull((Object)savedOrder);
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.FRAUD.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_FRAUD_WRONG_RECEIVER, (Object)savedOrder.getError());
    }

    @Test
    public void testSaveOrder() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        try {
            perkStoreService.saveOrder(null, ProductOrderModificationType.NEW, "root1", true);
            PerkStoreServiceTest.fail((String)"Shouldn't be able to save a null order");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            perkStoreService.saveOrder(new ProductOrder(), null, "root1", true);
            PerkStoreServiceTest.fail((String)"Shouldn't be able to save a null modificationType");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            perkStoreService.saveOrder(new ProductOrder(), ProductOrderModificationType.NEW, "root1", true);
            PerkStoreServiceTest.fail((String)"Shouldn't be able to save an order without an associated product");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_CREATION_EMPTY_PRODUCT, (Object)e.getErrorType());
        }
        try {
            ProductOrder order = new ProductOrder();
            order.setProductId(1L);
            perkStoreService.saveOrder(order, ProductOrderModificationType.NEW, "root1", true);
            PerkStoreServiceTest.fail((String)"Shouldn't be able to save an order with non existing product");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_CREATION_EMPTY_PRODUCT, (Object)e.getErrorType());
        }
        Product savedProduct = this.newProductInstance(new Product());
        savedProduct.setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
        savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
        this.entitiesToClean.add(savedProduct);
        try {
            ProductOrder order = new ProductOrder();
            order.setProductId(savedProduct.getId());
            perkStoreService.saveOrder(order, ProductOrderModificationType.NEW, "root1", true);
            PerkStoreServiceTest.fail((String)"Shouldn't be able to save a non existing order");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_NOT_EXISTS, (Object)e.getErrorType());
        }
        ProductOrder savedOrder = this.newOrder(savedProduct);
        this.checkBasicOperations(savedOrder);
        try {
            perkStoreService.saveOrder(savedOrder, ProductOrderModificationType.NEW, "root3", true);
            PerkStoreServiceTest.fail((String)"Shouldn't be able to modify order when not manager of product neither on perk store");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_MODIFICATION_DENIED, (Object)e.getErrorType());
        }
    }

    @Test
    public void testGetOrderById() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        ProductOrder orderById = perkStoreService.getOrderById(0L);
        PerkStoreServiceTest.assertNull((Object)orderById);
        Product savedProduct = this.newProductInstance(new Product());
        savedProduct.setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
        savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
        this.entitiesToClean.add(savedProduct);
        ProductOrder savedOrder = this.newOrder(savedProduct);
        this.checkBasicOperations(savedOrder);
        orderById = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertNotNull((Object)orderById);
        this.checkBasicOperations(savedOrder);
        PerkStoreServiceTest.assertEquals((Object)savedOrder, (Object)orderById);
    }

    @Test
    public void testGetOrders() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        PerkStoreStorage perkStoreStorage = this.getService(PerkStoreStorage.class);
        OrderFilter filter = new OrderFilter();
        this.checkBasicOperations(filter);
        filter.setLimit(10);
        this.checkBasicOperations(filter);
        try {
            perkStoreService.getOrders(null, "root1");
            PerkStoreServiceTest.fail((String)"filter shouldn't be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            perkStoreService.getOrders(filter, null);
            PerkStoreServiceTest.fail((String)"username shouldn't be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        Product savedProduct = this.newProductInstance(new Product());
        savedProduct.setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
        savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
        this.entitiesToClean.add(savedProduct);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        ProductOrder savedOrder = this.newOrder(savedProduct);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.ALL);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.RECEIVED);
        orders = perkStoreService.getOrders(filter, "root10");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.SENT);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(null);
        orders = perkStoreService.getOrders(filter, "root1");
        filter.setOrdered(true);
        this.checkBasicOperations(filter);
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.ALL);
        orders = perkStoreService.getOrders(filter, "root1");
        filter.setNotProcessed(true);
        this.checkBasicOperations(filter);
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = perkStoreService.getOrders(filter, "root1");
        filter.setProductId(savedProduct.getId());
        this.checkBasicOperations(filter);
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        savedProduct.setDeleted(true);
        perkStoreStorage.saveProduct(savedProduct, "root1");
        OrderFilter finalFilter = filter;
        Assert.assertThrows(PerkStoreException.class, () -> perkStoreService.getOrders(finalFilter, "root1"));
        filter.setProductId(0L);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        savedProduct.setDeleted(false);
        perkStoreStorage.saveProduct(savedProduct, "root1");
        filter.setProductId(savedProduct.getId());
        try {
            filter.setSelectedOrderId(savedOrder.getId());
            this.checkBasicOperations(filter);
            perkStoreService.getOrders(filter, "root5");
            PerkStoreServiceTest.fail((String)"User 'root5' shouldn't be able to access product");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.PRODUCT_ACCESS_DENIED, (Object)e.getErrorType());
        }
        savedProduct.setAccessPermissions(null);
        perkStoreService.saveProduct(savedProduct, "root1");
        try {
            filter.setSelectedOrderId(savedOrder.getId());
            this.checkBasicOperations(filter);
            perkStoreService.getOrders(filter, "root5");
            PerkStoreServiceTest.fail((String)"User 'root5' shouldn't be able to access order of 'user1'");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_ACCESS_DENIED, (Object)e.getErrorType());
        }
        orders = perkStoreService.getOrders(filter, "root1");
        filter.setSearchInDates(true);
        filter.setSelectedDate(System.currentTimeMillis());
        this.checkBasicOperations(filter);
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setSelectedOrderId(0L);
        orders = perkStoreService.getOrders(filter, "root1");
        filter.setSearchInDates(true);
        filter.setSelectedDate(System.currentTimeMillis());
        this.checkBasicOperations(filter);
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        String username = savedOrder.getSender().getId();
        orders = perkStoreService.getOrders(filter, username);
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)this.container);
        savedProduct = perkStoreService.getProductById(savedProduct.getId(), username);
        this.checkBasicOperations(savedProduct.getUserData());
        PerkStoreServiceTest.assertEquals((double)1.0, (double)savedProduct.getPurchased(), (double)0.0);
        PerkStoreServiceTest.assertEquals((double)1.0, (double)savedProduct.getUserData().getPurchasedInCurrentPeriod(), (double)0.0);
        PerkStoreServiceTest.assertEquals((double)1.0, (double)savedProduct.getUserData().getTotalPurchased(), (double)0.0);
        PerkStoreServiceTest.assertEquals((String)username, (String)savedProduct.getUserData().getUsername());
        PerkStoreServiceTest.assertTrue((boolean)savedProduct.getUserData().isCanOrder());
        PerkStoreServiceTest.assertTrue((boolean)savedProduct.getUserData().isCanEdit());
        try {
            perkStoreService.getOrders(filter, "test-non-existing");
            PerkStoreServiceTest.fail((String)"Non existing user shouldn't be able to access application");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.GLOBAL_SETTINGS_ACCESS_DENIED, (Object)e.getErrorType());
        }
        orders = perkStoreService.getOrders(filter, "root30");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        OrderFilter filterTmp = filter.clone();
        filterTmp.setSelectedOrderId(200L);
        try {
            perkStoreService.getOrders(filterTmp, "root1");
            PerkStoreServiceTest.fail((String)"User 'root1' shouldn't be able to access not his order");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_ACCESS_DENIED, (Object)e.getErrorType());
        }
        filterTmp = filter.clone();
        filterTmp.setProductId(200L);
        try {
            perkStoreService.getOrders(filterTmp, "root1");
        }
        catch (PerkStoreException e) {
            PerkStoreServiceTest.assertNotNull((Object)e.getErrorType());
            PerkStoreServiceTest.assertNotNull((Object)e.getLocalizedMessage());
            PerkStoreServiceTest.assertEquals((Object)PerkStoreError.PRODUCT_NOT_EXISTS, (Object)e.getErrorType());
        }
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setDelivered(true);
        orders = perkStoreService.getOrders(filterTmp, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setCanceled(true);
        orders = perkStoreService.getOrders(filterTmp, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setPaid(true);
        orders = perkStoreService.getOrders(filterTmp, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setPartial(true);
        orders = perkStoreService.getOrders(filterTmp, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setError(true);
        orders = perkStoreService.getOrders(filterTmp, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setRefunded(true);
        orders = perkStoreService.getOrders(filterTmp, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setNotProcessed(false);
        filterTmp.setOrdered(false);
        filterTmp.setFraud(true);
        orders = perkStoreService.getOrders(filterTmp, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filterTmp = filter.clone();
        filterTmp.setSearchInDates(true);
        filterTmp.setSelectedDate(System.currentTimeMillis() - 86400000L);
        orders = perkStoreService.getOrders(filterTmp, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        savedProduct.setReceiverMarchand(Utils.toProfile((long)2L));
        savedProduct.setMaxOrdersPerUser(2.0);
        savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
        this.newOrder(savedProduct);
        filter = new OrderFilter();
        filter.setOrdersType(ProductOrderType.ALL);
        orders = perkStoreService.getOrders(filter, "root2");
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.RECEIVED);
        orders = perkStoreService.getOrders(filter, "root2");
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setOrdersType(ProductOrderType.SENT);
        orders = perkStoreService.getOrders(filter, "root2");
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
    }

    @Test
    public void testCountUserOrders() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        OrderFilter filter = new OrderFilter();
        this.checkBasicOperations(filter);
        filter.setLimit(10);
        filter.setNotProcessed(true);
        this.checkBasicOperations(filter);
        try {
            perkStoreService.countUserOrders(null, "root1");
            PerkStoreServiceTest.fail((String)"filter shouldn't be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            perkStoreService.countUserOrders(filter, null);
            PerkStoreServiceTest.fail((String)"username shouldn't be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        filter.setOrdersType(ProductOrderType.ALL);
        Long orders = perkStoreService.countUserOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.longValue(), (float)0.0f);
        Product[] products = new Product[5];
        for (int i = 0; i < 5; ++i) {
            products[i] = this.newProductInstance(new Product());
            products[i].setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
            products[i] = perkStoreService.saveProduct(products[i], "root90");
            this.entitiesToClean.add(products[i]);
            this.newOrder(products[i]);
        }
        orders = perkStoreService.countUserOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((int)5, (int)orders.intValue());
    }

    @Test
    public void testGetOrdersWithFraud() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        OrderFilter filter = new OrderFilter();
        filter.setLimit(10);
        Product savedProduct = this.newProductInstance(new Product());
        savedProduct.setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
        savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
        this.entitiesToClean.add(savedProduct);
        ProductOrder savedOrder = this.newOrder(savedProduct);
        filter.setFraud(true);
        filter.setOrdersType(ProductOrderType.ALL);
        List orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        savedOrder.setStatus(ProductOrderStatus.FRAUD.name());
        perkStoreService.saveOrder(savedOrder, ProductOrderModificationType.STATUS, "root1", false);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setFraud(true);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertNotNull((Object)orders);
        PerkStoreServiceTest.assertEquals((float)1.0f, (float)orders.size(), (float)0.0f);
        filter.setFraud(false);
        filter.setNotProcessed(true);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
        filter.setNotProcessed(false);
        filter.setOrdered(true);
        orders = perkStoreService.getOrders(filter, "root1");
        PerkStoreServiceTest.assertEquals((float)0.0f, (float)orders.size(), (float)0.0f);
    }

    @Test
    public void testSaveOrderTransactionStatus() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        try {
            perkStoreService.saveOrderTransactionStatus(null);
            PerkStoreServiceTest.fail((String)"transaction hash shoud be mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("hash", this.generateRandomHash());
            parameters.put("status", true);
            perkStoreService.saveOrderTransactionStatus(parameters);
        }
        catch (Exception e) {
            PerkStoreServiceTest.fail((String)"Shouldn't fail when no order corresponds to mined hash");
        }
        Product savedProduct = this.newProduct(perkStoreService, new Product());
        savedProduct.setAccessPermissions(Arrays.asList(Utils.toProfile((long)1L)));
        savedProduct.setMaxOrdersPerUser(2.0);
        savedProduct.setTotalSupply(2.0);
        perkStoreService.saveProduct(savedProduct, "root1");
        ProductOrder savedOrder = this.newOrder(savedProduct);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hash", savedOrder.getTransactionHash());
        parameters.put("from", savedOrder.getSender().getTechnicalId());
        parameters.put("to", savedOrder.getReceiver().getTechnicalId());
        parameters.put("contractAddress", "contractAddress");
        parameters.put("contractMethodName", "transfer");
        parameters.put("contractAmount", savedOrder.getAmount());
        parameters.put("issuerId", savedOrder.getSender().getTechnicalId());
        parameters.put("status", false);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.ERROR.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        parameters.put("status", true);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.PAID.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        savedOrder.setRefundTransactionHash(this.generateRandomHash());
        savedOrder.setRefundedQuantity(1.0);
        perkStoreService.saveOrder(savedOrder, ProductOrderModificationType.REFUNDED_QUANTITY, "root1", true);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertEquals((double)1.0, (double)savedOrder.getRefundedQuantity(), (double)0.0);
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.REFUNDED.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertEquals((String)ProductOrderTransactionStatus.PENDING.name(), (String)savedOrder.getRefundTransactionStatus());
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        parameters.put("hash", savedOrder.getRefundTransactionHash());
        parameters.put("to", savedOrder.getSender().getTechnicalId());
        parameters.put("from", savedOrder.getReceiver().getTechnicalId());
        parameters.put("contractAddress", "contractAddress");
        parameters.put("contractMethodName", "transfer");
        parameters.put("contractAmount", savedOrder.getAmount());
        parameters.put("issuerId", savedOrder.getReceiver().getTechnicalId());
        parameters.put("status", false);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertEquals((String)ProductOrderTransactionStatus.FAILED.name(), (String)savedOrder.getRefundTransactionStatus());
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        parameters.put("status", true);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertEquals((String)ProductOrderTransactionStatus.SUCCESS.name(), (String)savedOrder.getRefundTransactionStatus());
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
    }

    @Test
    public void testSaveOrderTransactionStatusWithEmptyTokenAddressFraud() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product product = this.newProductInstance(new Product());
        product.setAccessPermissions(null);
        Product savedProduct = perkStoreService.saveProduct(product, "root1");
        this.entitiesToClean.add(0, savedProduct);
        ProductOrder savedOrder = this.newOrder(savedProduct);
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hash", savedOrder.getTransactionHash());
        parameters.put("from", savedOrder.getSender().getTechnicalId());
        parameters.put("to", savedOrder.getReceiver().getTechnicalId());
        parameters.put("contractMethodName", "transfer");
        parameters.put("contractAmount", savedOrder.getAmount());
        parameters.put("issuerId", savedOrder.getSender().getTechnicalId());
        parameters.put("status", true);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertNotNull((Object)savedOrder);
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.FRAUD.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_FRAUD_NOT_TOKEN_TRANSACTION, (Object)savedOrder.getError());
    }

    @Test
    public void testSaveOrderTransactionStatusWithWrongContractMethodFraud() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product product = this.newProductInstance(new Product());
        product.setAccessPermissions(null);
        Product savedProduct = perkStoreService.saveProduct(product, "root1");
        this.entitiesToClean.add(0, savedProduct);
        ProductOrder savedOrder = this.newOrder(savedProduct);
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hash", savedOrder.getTransactionHash());
        parameters.put("from", savedOrder.getSender().getTechnicalId());
        parameters.put("to", savedOrder.getReceiver().getTechnicalId());
        parameters.put("contractAddress", "contractAddress");
        parameters.put("contractMethodName", "reward");
        parameters.put("contractAmount", savedOrder.getAmount());
        parameters.put("issuerId", savedOrder.getSender().getTechnicalId());
        parameters.put("status", true);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertNotNull((Object)savedOrder);
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.FRAUD.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_FRAUD_WRONG_TOKEN_TRANSFER_METHOD, (Object)savedOrder.getError());
    }

    @Test
    public void testSaveOrderTransactionStatusWithWrongSenderFraud() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product product = this.newProductInstance(new Product());
        product.setAccessPermissions(null);
        Product savedProduct = perkStoreService.saveProduct(product, "root1");
        this.entitiesToClean.add(0, savedProduct);
        ProductOrder savedOrder = this.newOrder(savedProduct);
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hash", savedOrder.getTransactionHash());
        parameters.put("from", 9L);
        parameters.put("to", savedOrder.getReceiver().getTechnicalId());
        parameters.put("contractAddress", "contractAddress");
        parameters.put("contractMethodName", "transfer");
        parameters.put("contractAmount", savedOrder.getAmount());
        parameters.put("issuerId", savedOrder.getSender().getTechnicalId());
        parameters.put("status", true);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertNotNull((Object)savedOrder);
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.FRAUD.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_FRAUD_WRONG_SENDER, (Object)savedOrder.getError());
    }

    @Test
    public void testSaveOrderTransactionStatusWithWrongReceiverFraud() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product product = this.newProductInstance(new Product());
        product.setAccessPermissions(null);
        Product savedProduct = perkStoreService.saveProduct(product, "root1");
        this.entitiesToClean.add(0, savedProduct);
        ProductOrder savedOrder = this.newOrder(savedProduct);
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hash", savedOrder.getTransactionHash());
        parameters.put("from", savedOrder.getSender().getTechnicalId());
        parameters.put("to", 8L);
        parameters.put("contractAddress", "contractAddress");
        parameters.put("contractMethodName", "transfer");
        parameters.put("contractAmount", savedOrder.getAmount());
        parameters.put("issuerId", savedOrder.getSender().getTechnicalId());
        parameters.put("status", true);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertNotNull((Object)savedOrder);
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.FRAUD.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_FRAUD_WRONG_RECEIVER, (Object)savedOrder.getError());
    }

    @Test
    public void testSaveOrderTransactionStatusWithWrongAmountFraud() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product product = this.newProductInstance(new Product());
        product.setAccessPermissions(null);
        Product savedProduct = perkStoreService.saveProduct(product, "root1");
        this.entitiesToClean.add(0, savedProduct);
        ProductOrder savedOrder = this.newOrder(savedProduct);
        PerkStoreServiceTest.assertNull((Object)savedOrder.getError());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("hash", savedOrder.getTransactionHash());
        parameters.put("from", savedOrder.getSender().getTechnicalId());
        parameters.put("to", savedOrder.getReceiver().getTechnicalId());
        parameters.put("contractAddress", "contractAddress");
        parameters.put("contractMethodName", "transfer");
        parameters.put("contractAmount", savedProduct.getPrice() * savedOrder.getQuantity() * 2.0);
        parameters.put("issuerId", savedOrder.getSender().getTechnicalId());
        parameters.put("status", true);
        perkStoreService.saveOrderTransactionStatus(parameters);
        savedOrder = perkStoreService.getOrderById(savedOrder.getId());
        PerkStoreServiceTest.assertNotNull((Object)savedOrder);
        PerkStoreServiceTest.assertEquals((String)ProductOrderStatus.FRAUD.name(), (String)savedOrder.getStatus());
        PerkStoreServiceTest.assertEquals((Object)PerkStoreError.ORDER_FRAUD_WRONG_AMOUNT, (Object)savedOrder.getError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFileDetail() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        ConfigurationManager configurationManager = this.getService(ConfigurationManager.class);
        final URL url = configurationManager.getResource("classpath:/conf/configuration.properties");
        PerkStoreServiceTest.assertNotNull((Object)url);
        UploadService uploadService = (UploadService)Mockito.mock(UploadService.class);
        Mockito.when((Object)uploadService.getUploadResource((String)Mockito.any())).thenAnswer((Answer)new Answer<UploadResource>(){

            public UploadResource answer(InvocationOnMock invocation) throws Throwable {
                String uploadId = (String)invocation.getArgument(0, String.class);
                UploadResource upResource = new UploadResource(uploadId);
                upResource.setFileName(uploadId);
                upResource.setMimeType("image/png");
                upResource.setStoreLocation(url.getFile());
                upResource.setEstimatedSize(0.0);
                return upResource;
            }
        });
        Product savedProduct = this.newProduct(perkStoreService, new Product());
        try (MockedStatic COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);){
            COMMONS_UTILS.when(() -> CommonsUtils.getService((Class)((Class)ArgumentMatchers.any()))).thenAnswer(invocation -> {
                Class clazz = (Class)invocation.getArgument(0);
                if (clazz.equals(UploadService.class)) {
                    return uploadService;
                }
                return this.container.getComponentInstanceOfType(clazz);
            });
            FileDetail fileDetail = perkStoreService.getFileDetail(savedProduct.getId(), 1L, true, "root1");
            PerkStoreServiceTest.assertNull((Object)fileDetail);
            fileDetail = new FileDetail();
            this.checkBasicOperations(fileDetail);
            fileDetail.setUploadId(this.generateRandomHash());
            HashSet<FileDetail> imageFiles = new HashSet<FileDetail>();
            imageFiles.add(fileDetail);
            savedProduct.setImageFiles(imageFiles);
            savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
            PerkStoreServiceTest.assertNotNull((Object)savedProduct);
            PerkStoreServiceTest.assertNotNull((Object)savedProduct.getImageFiles());
            PerkStoreServiceTest.assertEquals((int)1, (int)savedProduct.getImageFiles().size());
            this.checkBasicOperations(savedProduct.getImageFiles().iterator().next());
            savedProduct.setImageFiles(Collections.emptySet());
            savedProduct = perkStoreService.saveProduct(savedProduct, "root1");
            PerkStoreServiceTest.assertNotNull((Object)savedProduct);
            PerkStoreServiceTest.assertTrue((savedProduct.getImageFiles() == null || savedProduct.getImageFiles().isEmpty() ? 1 : 0) != 0);
        }
        finally {
            this.container.unregisterComponent(UploadService.class);
        }
    }

    @Test
    public void testDeleteProduct() throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        Product savedProduct = this.newProduct(perkStoreService, new Product());
        PerkStoreServiceTest.assertNotNull((Object)savedProduct);
        Product productById = perkStoreService.getProductById(savedProduct.getId());
        PerkStoreServiceTest.assertNotNull((Object)productById);
        Assert.assertThrows(IllegalAccessException.class, () -> perkStoreService.deleteProduct(savedProduct.getId(), "root2"));
        productById = perkStoreService.getProductById(savedProduct.getId());
        PerkStoreServiceTest.assertNotNull((Object)productById);
        perkStoreService.deleteProduct(savedProduct.getId(), "root1");
        productById = perkStoreService.getProductById(savedProduct.getId());
        PerkStoreServiceTest.assertNull((Object)productById);
    }
}

