/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.listener;

import java.util.HashSet;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.PerkStoreWebSocketService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class WebSocketSettingsListener
extends Listener<PerkStoreService, GlobalSettings> {
    private PerkStoreWebSocketService webSocketService;

    public void onEvent(Event<PerkStoreService, GlobalSettings> event) throws Exception {
        GlobalSettings globalSettings = (GlobalSettings)event.getData();
        HashSet<String> recipientUsers = new HashSet<String>();
        boolean sendToAll = Utils.getApplicationAccessUsersList(recipientUsers, globalSettings);
        this.getWebSocketService().sendMessage(event.getEventName(), recipientUsers, sendToAll, globalSettings);
    }

    private PerkStoreWebSocketService getWebSocketService() {
        if (this.webSocketService == null) {
            this.webSocketService = (PerkStoreWebSocketService)CommonsUtils.getService(PerkStoreWebSocketService.class);
        }
        return this.webSocketService;
    }
}

