/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.listener;

import java.util.HashSet;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.ProductOrderModification;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.PerkStoreWebSocketService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class WebSocketOrderListener
extends Listener<Product, ProductOrderModification> {
    private PerkStoreService perkStoreService;
    private PerkStoreWebSocketService webSocketService;

    public void onEvent(Event<Product, ProductOrderModification> event) throws Exception {
        Product product = (Product)event.getSource();
        ProductOrderModification orderModification = (ProductOrderModification)event.getData();
        GlobalSettings globalSettings = this.getPerkStoreService().getGlobalSettings();
        HashSet<String> readOnlyUsers = new HashSet<String>();
        boolean sendToAll = Utils.getProductAccessUsersList(readOnlyUsers, product, globalSettings);
        HashSet<String> orderDetailViewerUsers = new HashSet<String>();
        Utils.getProductManagersUsersList(orderDetailViewerUsers, product, globalSettings);
        ProductOrder updatedOrder = orderModification.getNewValue();
        orderDetailViewerUsers.add(updatedOrder.getSender().getId());
        readOnlyUsers.removeAll(orderDetailViewerUsers);
        this.getWebSocketService().sendMessage(event.getEventName(), readOnlyUsers, sendToAll, product);
        this.getWebSocketService().sendMessage(event.getEventName(), orderDetailViewerUsers, false, product, updatedOrder);
    }

    public PerkStoreService getPerkStoreService() {
        if (this.perkStoreService == null) {
            this.perkStoreService = (PerkStoreService)CommonsUtils.getService(PerkStoreService.class);
        }
        return this.perkStoreService;
    }

    private PerkStoreWebSocketService getWebSocketService() {
        if (this.webSocketService == null) {
            this.webSocketService = (PerkStoreWebSocketService)CommonsUtils.getService(PerkStoreWebSocketService.class);
        }
        return this.webSocketService;
    }
}

