/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.perkstore.dao.PerkStoreOrderDAO;
import org.exoplatform.perkstore.dao.PerkStoreProductDAO;
import org.exoplatform.perkstore.entity.ProductEntity;
import org.exoplatform.perkstore.entity.ProductOrderEntity;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.model.PerkStoreCloneable;
import org.exoplatform.perkstore.model.Product;
import org.exoplatform.perkstore.model.ProductOrder;
import org.exoplatform.perkstore.model.constant.ProductOrderPeriodType;
import org.exoplatform.perkstore.model.constant.ProductOrderStatus;
import org.exoplatform.perkstore.model.constant.ProductOrderTransactionStatus;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.perkstore.storage.PerkStoreStorage;
import org.exoplatform.perkstore.storage.cached.PerkStoreCachedStorage;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.GroupImpl;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.junit.After;
import org.junit.Before;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/perk-store-configuration.xml")})
public abstract class BasePerkStoreTest
extends AbstractKernelTest {
    protected static final String USERNAME_ADMIN = "root90";
    protected static final String USERNAME = "root1";
    protected PortalContainer container;
    protected List<Serializable> entitiesToClean = new ArrayList<Serializable>();
    private Random random = new Random(1L);

    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.container = this.getContainer();
        BasePerkStoreTest.assertNotNull((String)"Container shouldn't be null", (Object)this.container);
        BasePerkStoreTest.assertTrue((String)"Container should have been started", (boolean)this.container.isStarted());
        OrganizationService organizationService = this.getService(OrganizationService.class);
        UserImpl user = new UserImpl(USERNAME_ADMIN);
        GroupImpl group = new GroupImpl();
        group.setId("/platform/rewarding");
        MembershipTypeImpl role = new MembershipTypeImpl("*", null, null);
        try {
            organizationService.getMembershipHandler().linkMembership((User)user, (Group)group, (MembershipType)role, false);
        }
        catch (Exception e) {
            this.log.warn((Object)"Error adding root90 to rewarding group", (Throwable)e);
        }
        super.setUp();
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    @After
    protected void tearDown() throws Exception {
        super.tearDown();
        PerkStoreProductDAO productDAO = this.getService(PerkStoreProductDAO.class);
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        PerkStoreStorage perkStoreStorage = this.getService(PerkStoreStorage.class);
        this.assertDefaultSettingsAreSet();
        if (!this.entitiesToClean.isEmpty()) {
            for (Serializable entity : this.entitiesToClean) {
                if (entity instanceof ProductEntity) {
                    productDAO.delete((Object)((ProductEntity)entity));
                    continue;
                }
                if (entity instanceof Product) {
                    Product product = (Product)entity;
                    ProductEntity productEntity = (ProductEntity)productDAO.find((Serializable)Long.valueOf(product.getId()));
                    if (productEntity == null) continue;
                    productDAO.delete((Object)productEntity);
                    continue;
                }
                if (entity instanceof ProductOrderEntity) {
                    orderDAO.delete((Object)((ProductOrderEntity)entity));
                    continue;
                }
                if (entity instanceof ProductOrder) {
                    ProductOrder order = (ProductOrder)entity;
                    ProductOrderEntity orderEntity = (ProductOrderEntity)orderDAO.find((Serializable)Long.valueOf(order.getId()));
                    if (orderEntity == null) continue;
                    orderDAO.delete((Object)orderEntity);
                    continue;
                }
                throw new IllegalStateException("Entity not managed" + String.valueOf(entity));
            }
            if (perkStoreStorage instanceof PerkStoreCachedStorage) {
                ((PerkStoreCachedStorage)perkStoreStorage).clearCache();
            }
        }
        int productCount = productDAO.findAll().size();
        BasePerkStoreTest.assertEquals((String)"The previous test didn't cleaned product entities correctly, should add entities to clean into 'entitiesToClean' list.", (int)0, (int)productCount);
        int orderCount = orderDAO.findAll().size();
        BasePerkStoreTest.assertEquals((String)"The previous test didn't cleaned product order entities correctly, should add entities to clean into 'entitiesToClean' list.", (int)0, (int)orderCount);
        RequestLifeCycle.end();
    }

    protected <T> T getService(Class<T> componentType) {
        return (T)this.container.getComponentInstanceOfType(componentType);
    }

    private void assertDefaultSettingsAreSet() {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        GlobalSettings globalSettings = perkStoreService.getGlobalSettings();
        BasePerkStoreTest.assertNotNull((Object)globalSettings);
        BasePerkStoreTest.assertTrue((globalSettings.getAccessPermissions() == null || globalSettings.getAccessPermissions().isEmpty() ? 1 : 0) != 0);
        BasePerkStoreTest.assertTrue((globalSettings.getManagers() == null || globalSettings.getManagers().isEmpty() ? 1 : 0) != 0);
        BasePerkStoreTest.assertTrue((globalSettings.getProductCreationPermissions() == null || globalSettings.getProductCreationPermissions().isEmpty() ? 1 : 0) != 0);
        BasePerkStoreTest.assertNull((Object)globalSettings.getUserSettings());
        BasePerkStoreTest.assertTrue((boolean)StringUtils.isBlank((CharSequence)globalSettings.getSymbol()));
    }

    protected Product newProduct(PerkStoreService perkStoreService, Product product) throws Exception {
        this.newProductInstance(product);
        Product savedProduct = perkStoreService.saveProduct(product, USERNAME);
        this.entitiesToClean.add((Serializable)savedProduct);
        return savedProduct;
    }

    protected Product newProductInstance(Product product) {
        product.setTitle("title");
        product.setIllustrationURL("IllustrationURL");
        product.setDescription("description");
        product.setReceiverMarchand(Utils.toProfile((long)10L));
        product.setAccessPermissions(Arrays.asList(Utils.toProfile((long)2L)));
        product.setMarchands(Arrays.asList(Utils.toProfile((long)1L)));
        product.setEnabled(true);
        product.setAllowFraction(false);
        product.setPrice(0.002);
        product.setMaxOrdersPerUser(1.0);
        ProductOrderPeriodType[] values = ProductOrderPeriodType.values();
        product.setOrderPeriodicity(values[this.random.nextInt(values.length - 1)].getName());
        product.setUnlimited(false);
        product.setTotalSupply(10.0);
        return product;
    }

    protected ProductOrder newOrder(Product savedProduct) throws Exception {
        PerkStoreService perkStoreService = this.getService(PerkStoreService.class);
        ProductOrder productOrder = this.newOrderInstance(savedProduct);
        ProductOrder savedOrder = perkStoreService.createOrder(productOrder, USERNAME);
        this.entitiesToClean.add(0, (Serializable)savedOrder);
        return savedOrder;
    }

    protected ProductOrder newOrderInstance(Product savedProduct) {
        boolean quantity = true;
        ProductOrder productOrder = new ProductOrder();
        productOrder.setProductId(savedProduct.getId());
        productOrder.setAmount(savedProduct.getPrice() * (double)quantity);
        productOrder.setReceiver(savedProduct.getReceiverMarchand());
        productOrder.setSender(Utils.toProfile((long)1L));
        productOrder.setTransactionHash(this.generateRandomHash());
        productOrder.setTransactionStatus(ProductOrderTransactionStatus.PENDING.name());
        productOrder.setRefundTransactionStatus(ProductOrderTransactionStatus.NONE.name());
        productOrder.setQuantity((double)quantity);
        productOrder.setRemainingQuantityToProcess(5.0);
        return productOrder;
    }

    protected ProductEntity newProduct() {
        PerkStoreProductDAO productDAO = this.getService(PerkStoreProductDAO.class);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setAllowFraction(false);
        productEntity.setCreatedDate(System.currentTimeMillis());
        productEntity.setCreator(1L);
        productEntity.setDescription("description");
        productEntity.setEnabled(true);
        productEntity.setIllustrationURL("illustrationURL");
        productEntity.setImages(new HashSet<Long>(Arrays.asList(1L, 2L)));
        productEntity.setLastModifiedDate(System.currentTimeMillis());
        productEntity.setLastModifier(1L);
        productEntity.setMarchands(new ArrayList<Long>(Arrays.asList(1L, 2L)));
        productEntity.setMaxOrdersPerUser(1.0);
        productEntity.setOrderPeriodicity(ProductOrderPeriodType.WEEK);
        productEntity.setPrice(0.002);
        productEntity.setReceiverId(1L);
        productEntity.setTitle("title");
        productEntity.setTotalSupply(1.0);
        productEntity.setUnlimited(false);
        productEntity = (ProductEntity)productDAO.create((Object)productEntity);
        this.entitiesToClean.add((Serializable)productEntity);
        return productEntity;
    }

    protected ProductOrderEntity newOrder(ProductEntity productEntity) {
        PerkStoreOrderDAO orderDAO = this.getService(PerkStoreOrderDAO.class);
        ProductOrderEntity orderEntity = this.newOrderInstance(productEntity);
        orderEntity = (ProductOrderEntity)orderDAO.create((Object)orderEntity);
        this.entitiesToClean.add(0, (Serializable)orderEntity);
        return orderEntity;
    }

    protected ProductOrderEntity newOrderInstance(ProductEntity productEntity) {
        ProductOrderEntity orderEntity = new ProductOrderEntity();
        orderEntity.setCreatedDate(System.currentTimeMillis());
        orderEntity.setDeliveredDate(0L);
        orderEntity.setDeliveredQuantity(0.0);
        orderEntity.setProduct(productEntity);
        orderEntity.setQuantity(1.0);
        orderEntity.setReceiverId(productEntity.getReceiverId());
        orderEntity.setRefundedAmount(0.0);
        orderEntity.setRefundedDate(0L);
        orderEntity.setRefundedQuantity(0.0);
        orderEntity.setRefundTransactionHash(null);
        orderEntity.setRefundTransactionStatus(ProductOrderTransactionStatus.NONE);
        orderEntity.setRemainingQuantity(1.0);
        orderEntity.setSenderId(2L);
        orderEntity.setStatus(ProductOrderStatus.ORDERED);
        orderEntity.setTransactionHash(this.generateRandomHash());
        orderEntity.setTransactionStatus(ProductOrderTransactionStatus.PENDING);
        return orderEntity;
    }

    protected String generateRandomHash() {
        StringBuilder hashStringBuffer = new StringBuilder("0x");
        for (int i = 0; i < 64; ++i) {
            hashStringBuffer.append(Integer.toHexString(this.random.nextInt(16)));
        }
        return hashStringBuffer.toString();
    }

    protected void checkBasicOperations(Object object) {
        BasePerkStoreTest.assertNotNull((Object)object);
        try {
            BasePerkStoreTest.assertNotNull((Object)object.toString());
            BasePerkStoreTest.assertNotNull((Object)object.hashCode());
            BasePerkStoreTest.assertEquals((Object)object, (Object)object);
            if (object instanceof PerkStoreCloneable) {
                BasePerkStoreTest.assertEquals((Object)object, (Object)((PerkStoreCloneable)object).clone());
            }
        }
        catch (Exception e) {
            BasePerkStoreTest.fail((String)("To string, equals and hashcode of object " + object.getClass().getSimpleName() + " shouldn't throw an exception" + e.getMessage()));
        }
    }
}

