/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.test;

import java.time.LocalDate;
import java.time.ZoneOffset;
import org.exoplatform.perkstore.model.ProductOrderPeriod;
import org.exoplatform.perkstore.model.constant.ProductOrderPeriodType;
import org.exoplatform.perkstore.test.BasePerkStoreTest;
import org.junit.Test;

public class ProductOrderPeriodTypeTest
extends BasePerkStoreTest {
    @Test
    public void testGetWeekPeriod() {
        ProductOrderPeriod periodOfTime = ProductOrderPeriodType.WEEK.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        ProductOrderPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTime = LocalDate.of(2019, 7, 8).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        long endTime = LocalDate.of(2019, 7, 15).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        ProductOrderPeriod expectedPeriod = new ProductOrderPeriod(startTime, endTime);
        ProductOrderPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        ProductOrderPeriodTypeTest.assertEquals((long)startTime, (long)periodOfTime.getStartDate());
        ProductOrderPeriodTypeTest.assertEquals((long)endTime, (long)periodOfTime.getEndDate());
    }

    @Test
    public void testGetMonthPeriod() {
        ProductOrderPeriod periodOfTime = ProductOrderPeriodType.MONTH.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        ProductOrderPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTime = LocalDate.of(2019, 7, 1).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        long endTime = LocalDate.of(2019, 8, 1).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        ProductOrderPeriod expectedPeriod = new ProductOrderPeriod(startTime, endTime);
        ProductOrderPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        ProductOrderPeriodTypeTest.assertEquals((long)startTime, (long)periodOfTime.getStartDate());
        ProductOrderPeriodTypeTest.assertEquals((long)endTime, (long)periodOfTime.getEndDate());
    }

    @Test
    public void testGetQuarterPeriod() {
        ProductOrderPeriod periodOfTime = ProductOrderPeriodType.QUARTER.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        ProductOrderPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTime = LocalDate.of(2019, 7, 1).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        long endTime = LocalDate.of(2019, 10, 1).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        ProductOrderPeriod expectedPeriod = new ProductOrderPeriod(startTime, endTime);
        ProductOrderPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        ProductOrderPeriodTypeTest.assertEquals((long)startTime, (long)periodOfTime.getStartDate());
        ProductOrderPeriodTypeTest.assertEquals((long)endTime, (long)periodOfTime.getEndDate());
    }

    @Test
    public void testGetSemesterPeriod() {
        ProductOrderPeriod periodOfTime = ProductOrderPeriodType.SEMESTER.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        ProductOrderPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTime = LocalDate.of(2019, 7, 1).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        long endTime = LocalDate.of(2020, 1, 1).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        ProductOrderPeriod expectedPeriod = new ProductOrderPeriod(startTime, endTime);
        ProductOrderPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        ProductOrderPeriodTypeTest.assertEquals((long)startTime, (long)periodOfTime.getStartDate());
        ProductOrderPeriodTypeTest.assertEquals((long)endTime, (long)periodOfTime.getEndDate());
    }

    @Test
    public void testGetYearPeriod() {
        ProductOrderPeriod periodOfTime = ProductOrderPeriodType.YEAR.getPeriodOfTime(LocalDate.of(2019, 7, 12).atStartOfDay());
        ProductOrderPeriodTypeTest.assertNotNull((Object)periodOfTime);
        long startTime = LocalDate.of(2019, 1, 1).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        long endTime = LocalDate.of(2020, 1, 1).atStartOfDay().atZone(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
        ProductOrderPeriod expectedPeriod = new ProductOrderPeriod(startTime, endTime);
        ProductOrderPeriodTypeTest.assertEquals((Object)expectedPeriod, (Object)periodOfTime);
        ProductOrderPeriodTypeTest.assertEquals((int)expectedPeriod.hashCode(), (int)periodOfTime.hashCode());
        ProductOrderPeriodTypeTest.assertEquals((long)startTime, (long)periodOfTime.getStartDate());
        ProductOrderPeriodTypeTest.assertEquals((long)endTime, (long)periodOfTime.getEndDate());
    }
}

