/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.listener;

import io.meeds.poll.listener.GamificationPollListener;
import io.meeds.poll.model.Poll;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={GamificationPollListener.class})
public class GamificationPollListenerTest {
    private static final long CREATOR_ID = 555L;
    private static final String MODIFIER_ID = "556";
    private static final long ACTIVITY_ID = 2553L;
    private static final long SPACE_ID = 1L;
    private static final String MODIFIER = "modfier";
    private static final String EVENT_DETAILS = "{spaceId: 1, activityId: 2553}";
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private IdentityManager identityManager;
    @MockBean
    private Poll poll;
    @MockBean
    private Identity modifierIdentity;
    @MockBean
    private Event<String, Poll> event;
    @Autowired
    private GamificationPollListener gamificationListener;

    @Test
    public void createEvent() throws Exception {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"meeds.poll.createPoll");
        Mockito.when((Object)((Poll)this.event.getData())).thenReturn((Object)this.poll);
        Mockito.when((Object)this.poll.getCreatorId()).thenReturn((Object)555L);
        Mockito.when((Object)this.poll.getActivityId()).thenReturn((Object)2553L);
        Mockito.when((Object)this.poll.getSpaceId()).thenReturn((Object)1L);
        this.gamificationListener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("createPoll") && ((String)source.get("senderId")).equals(String.valueOf(555L)) && ((String)source.get("receiverId")).equals(String.valueOf(555L)) && ((String)source.get("objectType")).equals("activity") && ((String)source.get("objectId")).equals(String.valueOf(2553L)) && ((String)source.get("eventDetails")).equals(EVENT_DETAILS))), ArgumentMatchers.eq(null));
    }

    @Test
    public void voteEvent() throws Exception {
        Mockito.when((Object)this.event.getEventName()).thenReturn((Object)"meeds.poll.votePoll");
        Mockito.when((Object)((String)this.event.getSource())).thenReturn((Object)MODIFIER);
        Mockito.when((Object)((Poll)this.event.getData())).thenReturn((Object)this.poll);
        Mockito.when((Object)this.poll.getCreatorId()).thenReturn((Object)555L);
        Mockito.when((Object)this.poll.getActivityId()).thenReturn((Object)2553L);
        Mockito.when((Object)this.poll.getSpaceId()).thenReturn((Object)1L);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(MODIFIER)).thenReturn((Object)this.modifierIdentity);
        Mockito.when((Object)this.modifierIdentity.getId()).thenReturn((Object)MODIFIER_ID);
        this.gamificationListener.onEvent(this.event);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("votePoll") && ((String)source.get("senderId")).equals(MODIFIER_ID) && ((String)source.get("receiverId")).equals(String.valueOf(555L)) && ((String)source.get("objectType")).equals("activity") && ((String)source.get("objectId")).equals(String.valueOf(2553L)) && ((String)source.get("eventDetails")).equals(EVENT_DETAILS))), ArgumentMatchers.eq(null));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast((String)ArgumentMatchers.eq((Object)"exo.gamification.generic.action"), (Object)((Map)ArgumentMatchers.argThat(source -> ((String)source.get("eventId")).equals("receivePollVote") && ((String)source.get("senderId")).equals(String.valueOf(555L)) && ((String)source.get("receiverId")).equals(MODIFIER_ID) && ((String)source.get("objectType")).equals("activity") && ((String)source.get("objectId")).equals(String.valueOf(2553L)) && ((String)source.get("eventDetails")).equals(EVENT_DETAILS))), ArgumentMatchers.eq(null));
    }
}

