/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.util.List;
import lombok.Generated;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.page.PageData;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;

public class PageContext {
    final PageKey key;
    PageState state;
    PageData data;

    PageContext(PageData data) {
        this.key = data.key;
        this.state = null;
        this.data = data;
    }

    public PageContext(PageKey key, PageState state) {
        this.key = key;
        this.state = state;
        this.data = null;
    }

    public PageKey getKey() {
        return this.key;
    }

    public PageState getState() {
        if (this.state != null) {
            return this.state;
        }
        if (this.data != null) {
            return this.data.state;
        }
        return null;
    }

    public void setState(PageState state) throws IllegalStateException {
        if (this.data == null && state == null) {
            throw new IllegalStateException("Cannot clear state on a transient page");
        }
        this.state = state;
    }

    public void update(Page page) throws NullPointerException {
        if (page == null) {
            throw new NullPointerException();
        }
        PageState s = this.getState();
        page.setTitle(s.displayName);
        page.setDescription(s.description);
        page.setFactoryId(s.factoryId);
        page.setShowMaxWindow(s.showMaxWindow);
        page.setHideSharedLayout(s.hideSharedLayout);
        List<String> permisssions = s.accessPermissions;
        page.setAccessPermissions(permisssions != null ? permisssions.toArray(new String[permisssions.size()]) : null);
        page.setEditPermission(this.getState().editPermission);
    }

    @Generated
    public PageData getData() {
        return this.data;
    }

    @Generated
    public void setData(PageData data) {
        this.data = data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageContext)) {
            return false;
        }
        PageContext other = (PageContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PageKey this$key = this.getKey();
        PageKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        PageState this$state = this.getState();
        PageState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        PageData this$data = this.getData();
        PageData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PageKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        PageState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        PageData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageContext(key=" + String.valueOf(this.getKey()) + ", state=" + String.valueOf(this.getState()) + ", data=" + String.valueOf(this.getData()) + ")";
    }
}

