/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2024 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.portal.permlink.service;

import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;

import io.meeds.portal.permlink.model.PermanentLinkObject;

/**
 * A service to get permanent link to an object in order to reference it
 */
public interface PermanentLinkService {

  static final String PERMANENT_LINK_URL_PREFIX = "/portal/l/";

  /**
   * @param object {@link PermanentLinkObject} containing the object Type and Id
   * @return the permanent link with '/portal/' as prefix and domain name
   */
  String getPermanentLink(PermanentLinkObject object);

  /**
   * @param randomizedPermanentLink permanent link as generated by a randomizer
   * @return pretty link to access resource
   * @throws IllegalAccessException when current user doesn't have access to the
   *           given resource
   * @throws ObjectNotFoundException when the pretty link isn't recognized or
   *           the given resource doesn't exist anymore
   */
  String getDirectAccessUrl(String randomizedPermanentLink, Identity identity) throws IllegalAccessException,
                                                                               ObjectNotFoundException;

  /**
   * @param object {@link PermanentLinkObject} containing the object Type and Id
   * @return pretty link to access resource
   * @throws ObjectNotFoundException
   */
  String getLink(PermanentLinkObject object) throws ObjectNotFoundException;

}
