/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.kernel;

import io.meeds.spring.kernel.annotation.Exclude;
import io.meeds.spring.kernel.model.SpringBeanComponentAdapter;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.PropertyConfigurator;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.services.rest.impl.StartableApplication;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.picocontainer.Startable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

public class KernelContainerLifecyclePlugin
extends BaseContainerLifecyclePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(KernelContainerLifecyclePlugin.class);
    private static Map<String, BeanDefinitionRegistry> springBeanRegistries = new ConcurrentHashMap<String, BeanDefinitionRegistry>();
    private static Map<String, ApplicationContext> springContexts = new ConcurrentHashMap<String, ApplicationContext>();
    private static boolean kernelAlreadyBooted = false;

    public static void addSpringContext(String servletContextName, ApplicationContext applicationContext, BeanDefinitionRegistry beanDefinitionRegistry) {
        if (kernelAlreadyBooted) {
            LOG.warn("Adding Spring context '{}' happened too late in Server startup, spring beans will not be injected for this context", (Object)servletContextName);
            return;
        }
        LOG.info("Add Spring context '{}' to inject its Beans in Kernel as available components", (Object)servletContextName);
        springContexts.put(servletContextName, applicationContext);
        springBeanRegistries.put(servletContextName, beanDefinitionRegistry);
    }

    public void initContainer(ExoContainer container) throws Exception {
        PortalContainer portalContainer;
        block5: {
            block4: {
                if (!(container instanceof PortalContainer)) break block4;
                portalContainer = (PortalContainer)container;
                if (!springContexts.isEmpty()) break block5;
            }
            return;
        }
        kernelAlreadyBooted = true;
        if (LOG.isInfoEnabled()) {
            LOG.info("Start Spring Bean definitions of contexts [{}] integration with Kernel Container", (Object)StringUtils.join(springContexts.keySet(), (String)","));
        }
        long start = System.currentTimeMillis();
        Collection containerComponentAdapters = portalContainer.getComponentAdapters();
        List parentComponentAdapters = portalContainer.getParent() != null ? portalContainer.getParent().getComponentAdapters() : Collections.emptyList();
        Collection kernelComponentAdapters = CollectionUtils.union((Iterable)containerComponentAdapters, parentComponentAdapters);
        Map<String, Map<String, BeanDefinition>> springBeansByContext = KernelContainerLifecyclePlugin.getBeansByServletContext();
        LOG.info("1. Add Kernel Services in all Spring contexts");
        KernelContainerLifecyclePlugin.addKernelToSpring(portalContainer, kernelComponentAdapters);
        LOG.info("2. Add Spring Beans of all contexts into Kernel");
        KernelContainerLifecyclePlugin.addSpringToKernel(portalContainer, springBeansByContext);
        LOG.info("3. Add Spring Beans into each other context");
        KernelContainerLifecyclePlugin.addSpringToEachOther(springBeansByContext);
        LOG.info("End spring integration with Kernel Container within {}ms", (Object)(System.currentTimeMillis() - start));
    }

    public static void addKernelToSpring(PortalContainer portalContainer, Collection<ComponentAdapter<?>> kernelComponentAdapters) {
        kernelComponentAdapters.forEach(adapter -> {
            Class componentKey = KernelContainerLifecyclePlugin.componentToBeanName(adapter);
            if (!componentKey.isInterface() && KernelContainerLifecyclePlugin.isComponentDuplicated(portalContainer, componentKey)) {
                return;
            }
            springContexts.forEach((servletContextName, applicationContext) -> {
                String componentKeyName;
                BeanDefinitionRegistry beanRegistry = springBeanRegistries.get(servletContextName);
                if (beanRegistry.containsBeanDefinition(componentKeyName = componentKey.getName())) {
                    LOG.debug("Ignore Kernel Component '{}' as it's already injected in Spring context '{}'", (Object)componentKeyName, servletContextName);
                } else {
                    RootBeanDefinition beanDefinition = KernelContainerLifecyclePlugin.createBeanDefinition(componentKey, portalContainer);
                    LOG.debug("Add Kernel Component '{}' in Spring context '{}'", (Object)componentKeyName, servletContextName);
                    beanRegistry.registerBeanDefinition(componentKeyName, (BeanDefinition)beanDefinition);
                }
            });
        });
    }

    public static void addSpringToKernel(PortalContainer portalContainer, Map<String, Map<String, BeanDefinition>> springBeansByContext) {
        springContexts.forEach((servletContextName, applicationContext) -> {
            Map beansMap = (Map)springBeansByContext.get(servletContextName);
            beansMap.forEach((beanName, beanDefinition) -> {
                ComponentAdapter<Object> componentAdapter = KernelContainerLifecyclePlugin.createComponentAdapter(servletContextName, portalContainer, beanName, beanDefinition.getBeanClassName(), () -> KernelContainerLifecyclePlugin.getBeanInstance(applicationContext, beanName));
                if (componentAdapter != null) {
                    LOG.debug("Add Spring Bean '{}' from context '{}' as Kernel component '{}'", new Object[]{beanName, servletContextName, componentAdapter.getComponentKey()});
                    portalContainer.registerComponentAdapter(componentAdapter);
                } else {
                    LOG.debug("Ignore Spring bean '{}' injector to kernel, with class '{}'", beanName, (Object)beanDefinition.getBeanClassName());
                }
            });
        });
    }

    public static void addSpringToEachOther(Map<String, Map<String, BeanDefinition>> springBeansByContext) {
        springContexts.forEach((senderServletContextName, senderApplicationContext) -> {
            Map beansMap = (Map)springBeansByContext.get(senderServletContextName);
            springBeanRegistries.entrySet().stream().filter(e -> !StringUtils.equals((CharSequence)senderServletContextName, (CharSequence)((CharSequence)e.getKey()))).forEach(entry -> {
                String receiverServletContextName = (String)entry.getKey();
                BeanDefinitionRegistry receiverBeanRegistry = (BeanDefinitionRegistry)entry.getValue();
                beansMap.forEach((beanName, senderBeanDefinition) -> {
                    Class<Object> beanClassName = KernelContainerLifecyclePlugin.getClass(senderBeanDefinition.getBeanClassName());
                    if (beanClassName != null && !receiverBeanRegistry.containsBeanDefinition(beanName) && !receiverBeanRegistry.containsBeanDefinition(senderBeanDefinition.getBeanClassName())) {
                        RootBeanDefinition receiverBeanDefinition = KernelContainerLifecyclePlugin.createBeanDefinition(beanName, beanClassName, senderApplicationContext);
                        receiverBeanRegistry.registerBeanDefinition(beanName, (BeanDefinition)receiverBeanDefinition);
                        LOG.debug("Add Spring Bean '{}' from Spring Context '{}' to Spring context '{}'", new Object[]{beanName, senderServletContextName, receiverServletContextName});
                    }
                });
            });
        });
    }

    public static Map<String, Map<String, BeanDefinition>> getBeansByServletContext() {
        return springBeanRegistries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> KernelContainerLifecyclePlugin.getEligibleBeans((BeanDefinitionRegistry)e.getValue())));
    }

    private static ComponentAdapter<Object> createComponentAdapter(String servletContextName, PortalContainer portalContainer, String beanName, String beanClassName, Supplier<Object> getBeanFunction) {
        Class<Object> componentKey = KernelContainerLifecyclePlugin.beanNameToComponentKey(beanClassName, beanName);
        if (componentKey != null && portalContainer.getComponentAdapter(componentKey) == null) {
            return new SpringBeanComponentAdapter(servletContextName, beanName, componentKey, getBeanFunction);
        }
        return null;
    }

    private static <T> RootBeanDefinition createBeanDefinition(Class<T> keyClass, PortalContainer portalContainer) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(keyClass, () -> KernelContainerLifecyclePlugin.getComponentInstance(portalContainer, keyClass));
        beanDefinition.setLazyInit(true);
        beanDefinition.setDependencyCheck(0);
        return beanDefinition;
    }

    private static RootBeanDefinition createBeanDefinition(String beanName, Class<Object> beanClassName, ApplicationContext senderApplicationContext) {
        RootBeanDefinition receiverBeanDefinition = new RootBeanDefinition(beanClassName, () -> KernelContainerLifecyclePlugin.getBeanInstance(senderApplicationContext, beanName));
        receiverBeanDefinition.setLazyInit(true);
        receiverBeanDefinition.setDependencyCheck(0);
        return receiverBeanDefinition;
    }

    private static Map<String, BeanDefinition> getEligibleBeans(BeanDefinitionRegistry beanRegistry) {
        String[] beanNames = beanRegistry.getBeanDefinitionNames();
        return Stream.of(beanNames).map(beanName -> {
            BeanDefinition beanDefinition = beanRegistry.getBeanDefinition(beanName);
            if (KernelContainerLifecyclePlugin.isBeanEligible(beanName, beanDefinition.getBeanClassName())) {
                return new AbstractMap.SimpleEntry<String, BeanDefinition>((String)beanName, beanDefinition);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Class componentToBeanName(ComponentAdapter adapter) {
        Object key = adapter.getComponentKey();
        Class<?> componentKeyClass = KernelContainerLifecyclePlugin.getComponentKeyClass(key);
        if (componentKeyClass == null || !KernelContainerLifecyclePlugin.isComponentClassValid(componentKeyClass)) {
            Class componentImplementation = adapter.getComponentImplementation();
            LOG.debug("Kernel component with key '{}' class {}. Returning implementation class '{}'", new Object[]{key, componentKeyClass == null ? "wasn't found" : "isn't valid", componentImplementation == null ? null : componentImplementation.getName()});
            return componentImplementation;
        }
        return componentKeyClass;
    }

    private static Class<?> beanNameToComponentKey(String ... beanClassNames) {
        Stream<String> componentKeys = Stream.of(beanClassNames);
        List<Class> componentClasses = componentKeys.filter(Objects::nonNull).map(KernelContainerLifecyclePlugin::getClass).filter(Objects::nonNull).filter(className -> !Objects.equals(className, Object.class)).distinct().toList();
        if (componentClasses.isEmpty() || componentClasses.stream().anyMatch(KernelContainerLifecyclePlugin::isServiceBeanRejected)) {
            return null;
        }
        Class beanClassName = componentClasses.stream().filter(KernelContainerLifecyclePlugin::isServiceBean).findFirst().orElse(null);
        Class<?>[] componentKeyInterfaces = beanClassName == null ? null : beanClassName.getInterfaces();
        return componentKeyInterfaces == null ? beanClassName : Arrays.stream(componentKeyInterfaces).filter(KernelContainerLifecyclePlugin::isServiceBean).findFirst().orElse(beanClassName);
    }

    private static boolean isBeanEligible(String ... beanClassNames) {
        Stream<String> componentKeys = Stream.of(beanClassNames);
        List<Class> componentClasses = componentKeys.filter(Objects::nonNull).map(KernelContainerLifecyclePlugin::getClass).filter(Objects::nonNull).distinct().toList();
        return !componentClasses.isEmpty() && componentClasses.stream().noneMatch(KernelContainerLifecyclePlugin::isServiceBeanRejected) && componentClasses.stream().anyMatch(KernelContainerLifecyclePlugin::isServiceBean);
    }

    private static boolean isServiceBeanRejected(Class<?> beanClass) {
        return beanClass.isAnnotationPresent(Exclude.class) || beanClass.isAnnotationPresent(Configuration.class) || beanClass.isAnnotationPresent(SpringBootApplication.class);
    }

    private static boolean isServiceBean(Class<?> beanClass) {
        return beanClass.isAnnotationPresent(Service.class) && !StringUtils.contains((CharSequence)beanClass.getName(), (CharSequence)"org.springframework") && !StringUtils.startsWith((CharSequence)beanClass.getName(), (CharSequence)"java") && !StringUtils.startsWith((CharSequence)beanClass.getName(), (CharSequence)"jdk") && !StringUtils.contains((CharSequence)beanClass.getName(), (CharSequence)"$");
    }

    private static boolean isComponentClassValid(Class<?> componentClass) {
        return !componentClass.equals(Object.class) && !componentClass.isAssignableFrom(PropertyConfigurator.class) && !componentClass.equals(Startable.class) && !componentClass.equals(StartableApplication.class) && !componentClass.equals(ResourceContainer.class) && !StringUtils.startsWith((CharSequence)componentClass.getName(), (CharSequence)"jakarta") && !StringUtils.equals((CharSequence)componentClass.getName(), (CharSequence)"org.exoplatform.commons.cluster.StartableClusterAware");
    }

    private static Object getBeanInstance(ApplicationContext applicationContext, String beanName) {
        LOG.trace("Retrieve Bean with name '{}' from Spring to Kernel using Application context", (Object)beanName);
        return applicationContext.getBean(beanName);
    }

    private static <T> T getComponentInstance(PortalContainer portalContainer, Class<T> keyClass) {
        LOG.trace("Getting Kernel Service '{}' requested by a Spring Bean.", keyClass);
        try {
            Object instance = portalContainer.getComponentInstanceOfType(keyClass);
            if (instance == null) {
                LOG.trace("Kernel Service '{}' requested by a Spring Bean wasn't", keyClass);
            }
            return (T)instance;
        }
        catch (Exception e) {
            LOG.warn("Kernel Service '{}' requested by a Spring Bean wasn't found", keyClass, (Object)e);
            return null;
        }
    }

    private static Class<?> getComponentKeyClass(Object key) {
        if (key instanceof Class) {
            Class keyClass = (Class)key;
            return keyClass;
        }
        if (key instanceof String) {
            String keyString = (String)key;
            return KernelContainerLifecyclePlugin.getClass(keyString);
        }
        LOG.warn("Ignoring Kernel component with key '{}' which isn't of type *Class* neither *String*.", key);
        return null;
    }

    private static boolean isComponentDuplicated(PortalContainer portalContainer, Class<?> componentKey) {
        Object[] interfaces = componentKey.getInterfaces();
        return ArrayUtils.isNotEmpty((Object[])interfaces) && Arrays.stream(interfaces).anyMatch(interfaceClass -> {
            boolean componentIsDuplicated;
            boolean bl = componentIsDuplicated = portalContainer.getComponentAdapter(interfaceClass) != null;
            if (componentIsDuplicated) {
                LOG.debug("Ignore Kernel Component '{}' as it's already injected in Spring context with class '{}'", (Object)componentKey, interfaceClass);
            }
            return componentIsDuplicated;
        });
    }

    private static <T> Class<T> getClass(String beanClassName) {
        try {
            return KernelContainerLifecyclePlugin.class.getClassLoader().loadClass(beanClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

