/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.exoplatform.commons.utils.BufferingOutputStream;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestBufferingOutputStream
extends AbstractGateInTest {
    private ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private BufferingOutputStream out = new BufferingOutputStream((OutputStream)this.bytes, 5);

    protected void setUp() throws Exception {
        this.bytes = new ByteArrayOutputStream();
        this.out = new BufferingOutputStream((OutputStream)this.bytes, 5);
    }

    protected void tearDown() throws Exception {
        this.bytes = null;
        this.out = null;
    }

    public void testCtorIAE() {
        try {
            new BufferingOutputStream((OutputStream)this.bytes, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new BufferingOutputStream((OutputStream)this.bytes, -1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCtorNPE() {
        try {
            new BufferingOutputStream(null, 1);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testStreamClose() throws Exception {
        final AtomicBoolean closed = new AtomicBoolean(false);
        BufferingOutputStream out = new BufferingOutputStream((OutputStream)new ByteArrayOutputStream(this){

            @Override
            public void close() throws IOException {
                closed.set(true);
                super.close();
            }
        }, 1);
        out.close();
        TestBufferingOutputStream.assertTrue((boolean)closed.get());
        try {
            out.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.write(new byte[]{0});
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testFlush() throws Exception {
        this.out.write(0);
        this.assertBytes(new int[0]);
        this.out.flush();
        this.assertBytes(0);
        this.out.write(new byte[]{1, 2, 3, 4});
        this.assertBytes(new int[0]);
        this.out.close();
        this.assertBytes(1, 2, 3, 4);
    }

    public void testWriteByte() throws Exception {
        this.out.write(0);
        this.assertBytes(new int[0]);
        this.out.close();
        this.assertBytes(0);
    }

    public void testAlmostFill() throws Exception {
        this.out.write(new byte[]{0, 1, 2, 3});
        this.assertBytes(new int[0]);
        this.out.close();
        this.assertBytes(0, 1, 2, 3);
    }

    public void testFill() throws Exception {
        this.out.write(new byte[]{0, 1, 2, 3, 4});
        this.assertBytes(0, 1, 2, 3, 4);
        this.out.close();
        this.assertBytes(new int[0]);
    }

    public void testBufferOverflowWithByte() throws Exception {
        this.out.write(new byte[]{0, 1, 2, 3});
        this.assertBytes(new int[0]);
        this.out.write(4);
        this.assertBytes(new int[0]);
        this.out.write(5);
        this.assertBytes(0, 1, 2, 3, 4);
        this.out.close();
        this.assertBytes(5);
    }

    public void testBufferOverflowWithArray() throws Exception {
        this.out.write(new byte[]{0, 1, 2, 3});
        this.assertBytes(new int[0]);
        this.out.write(new byte[]{4});
        this.assertBytes(0, 1, 2, 3);
        this.out.close();
        this.assertBytes(4);
    }

    public void testBufferOverflowWithLongArray() throws Exception {
        this.out.write(new byte[]{0, 1, 2, 3});
        this.assertBytes(new int[0]);
        this.out.write(new byte[]{4, 5, 6, 7, 8, 9});
        this.assertBytes(0, 1, 2, 3, 4, 5, 6, 7, 8);
        this.out.close();
        this.assertBytes(9);
    }

    public void testBufferOverflowWithVeryLongArray() throws Exception {
        this.out.write(new byte[]{0, 1, 2, 3});
        this.assertBytes(new int[0]);
        this.out.write(new byte[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
        this.assertBytes(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13);
        this.out.close();
        this.assertBytes(14);
    }

    private void assertBytes(int ... expectedBytes) {
        int len = expectedBytes.length;
        TestBufferingOutputStream.assertEquals((int)len, (int)this.bytes.size());
        if (len > 0) {
            byte[] actualBytes = this.bytes.toByteArray();
            for (int i = 0; i < len; ++i) {
                int expectedByte = expectedBytes[i];
                byte actualByte = actualBytes[i];
                TestBufferingOutputStream.assertEquals((String)("Was expecting byte at index " + i + " to be equals to " + expectedByte + " instead of " + actualByte), (int)expectedByte, (int)actualByte);
            }
            this.bytes.reset();
        }
    }
}

