/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.spring.kernel;

import io.meeds.spring.kernel.KernelContainerLifecyclePlugin;
import jakarta.servlet.ServletContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.servlet.context.AnnotationConfigServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;

public class PortalApplicationContext
extends AnnotationConfigServletWebServerApplicationContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortalApplicationContext.class);
    private ServletContext servletContext;

    public PortalApplicationContext(ServletContext servletContext, DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
        this.servletContext = servletContext;
    }

    protected void finishBeanFactoryInitialization(final ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry beanRegistry = (BeanDefinitionRegistry)beanFactory;
        KernelContainerLifecyclePlugin.addSpringContext(this.servletContext.getServletContextName(), (ApplicationContext)this, beanRegistry);
        PortalContainer.addInitTask((ServletContext)this.servletContext, (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                PortalApplicationContext.this.finishSpringContextStartup(beanFactory);
            }
        }, (String)"portal");
    }

    protected void finishRefresh() {
    }

    private void finishSpringContextStartup(ConfigurableListableBeanFactory beanFactory) {
        long start = System.currentTimeMillis();
        LOG.info("Continue Spring context '{}' initialization", (Object)this.servletContext.getServletContextName());
        PortalApplicationContext.super.finishBeanFactoryInitialization(beanFactory);
        PortalApplicationContext.super.finishRefresh();
        LOG.info("Spring context '{}' initialized in {}ms", (Object)this.servletContext.getServletContextName(), (Object)(System.currentTimeMillis() - start));
    }
}

