/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.exoplatform.commons.xml.XMLDeclarationParser;
import org.xml.sax.SAXException;

public class TestXMLDeclarationParser
extends TestCase {
    private static Map<String, String> map(String ... keyVal) {
        HashMap<String, String> result = new HashMap<String, String>(4);
        int i = 0;
        while (i < keyVal.length) {
            result.put(keyVal[i++], keyVal[i++]);
        }
        return result;
    }

    public void testUnexpectedEndOfInput() throws SAXException, IOException {
        TestXMLDeclarationParser.assertFail("<?");
        TestXMLDeclarationParser.assertFail("<?xml");
        TestXMLDeclarationParser.assertFail("<?xml ");
        TestXMLDeclarationParser.assertFail("<?xml version");
        TestXMLDeclarationParser.assertFail("<?xml version=");
        TestXMLDeclarationParser.assertFail("<?xml version= ");
        TestXMLDeclarationParser.assertFail("<?xml version='");
        TestXMLDeclarationParser.assertFail("<?xml version='1.0'");
        TestXMLDeclarationParser.assertFail("<?xml version='1.0' ");
        TestXMLDeclarationParser.assertFail("<?xml version='1.0' encoding='UTF-8'?");
    }

    private static void assertFail(String xml) throws IOException {
        XMLDeclarationParser parser = new XMLDeclarationParser(xml);
        try {
            parser.parse();
            TestXMLDeclarationParser.fail((String)"XMLDeclarationParseException expected.");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void testParse() throws SAXException, IOException {
        XMLDeclarationParser parser = new XMLDeclarationParser("<?xml version='1.0' encoding='UTF-8'?>");
        Assert.assertEquals(TestXMLDeclarationParser.map("version", "1.0", "encoding", "UTF-8"), (Object)parser.parse());
        parser = new XMLDeclarationParser("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Assert.assertEquals(TestXMLDeclarationParser.map("version", "1.0", "encoding", "UTF-8"), (Object)parser.parse());
        parser = new XMLDeclarationParser("<?xml    version =\n\"1.0\" \t\t encoding=\r\"UTF-8\" ?>");
        Assert.assertEquals(TestXMLDeclarationParser.map("version", "1.0", "encoding", "UTF-8"), (Object)parser.parse());
    }
}

