/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import junit.framework.TestCase;
import org.exoplatform.commons.utils.HTMLEntityEncoder;

public class TestHTMLEntityEncoder
extends TestCase {
    private HTMLEntityEncoder htmlEncoder = HTMLEntityEncoder.getInstance();

    public void testHTMLEncoding() {
        TestHTMLEntityEncoder.assertEquals((String)"&lt;h1&gt;HELLO WORLD&lt;&#x2f;h1&gt;", (String)this.htmlEncoder.encode("<h1>HELLO WORLD</h1>"));
        TestHTMLEntityEncoder.assertEquals((String)"&lt;h1&gt;HELLO WORLD&lt;&#x2f;h1&gt;", (String)this.htmlEncoder.encodeHTML("<h1>HELLO WORLD</h1>"));
        TestHTMLEntityEncoder.assertEquals((String)"alert&#x28;&#x27;HELLO WORLD&#x27;&#x29;", (String)this.htmlEncoder.encode("alert('HELLO WORLD')"));
        TestHTMLEntityEncoder.assertEquals((String)"alert&#x28;&#x27;HELLO WORLD&#x27;&#x29;", (String)this.htmlEncoder.encodeHTML("alert('HELLO WORLD')"));
        TestHTMLEntityEncoder.assertEquals((String)"&lt;a href&#x3d;&quot;http&#x3a;&#x2f;&#x2f;example.com&#x2f;&#x3f;name1&#x3d;value1&amp;name2&#x3d;value2&amp;name3&#x3d;a&#x2b;b&quot;&gt;link&lt;&#x2f;a&gt;", (String)this.htmlEncoder.encode("<a href=\"http://example.com/?name1=value1&name2=value2&name3=a+b\">link</a>"));
        TestHTMLEntityEncoder.assertEquals((String)"&lt;a href&#x3d;&quot;http&#x3a;&#x2f;&#x2f;example.com&#x2f;&#x3f;name1&#x3d;value1&amp;name2&#x3d;value2&amp;name3&#x3d;a&#x2b;b&quot;&gt;link&lt;&#x2f;a&gt;", (String)this.htmlEncoder.encodeHTML("<a href=\"http://example.com/?name1=value1&name2=value2&name3=a+b\">link</a>"));
    }

    public void testHTMLAttributeEncoding() {
        TestHTMLEntityEncoder.assertEquals((String)"&lt;h1&gt;HELLO&#x20;WORLD&lt;&#x2f;h1&gt;", (String)this.htmlEncoder.encodeHTMLAttribute("<h1>HELLO WORLD</h1>"));
        TestHTMLEntityEncoder.assertEquals((String)"alert&#x28;&#x27;HELLO&#x20;WORLD&#x27;&#x29;", (String)this.htmlEncoder.encodeHTMLAttribute("alert('HELLO WORLD')"));
        TestHTMLEntityEncoder.assertEquals((String)"&lt;a&#x20;href&#x3d;&quot;http&#x3a;&#x2f;&#x2f;example.com&#x2f;&#x3f;name1&#x3d;value1&amp;name2&#x3d;value2&amp;name3&#x3d;a&#x2b;b&quot;&gt;link&lt;&#x2f;a&gt;", (String)this.htmlEncoder.encodeHTMLAttribute("<a href=\"http://example.com/?name1=value1&name2=value2&name3=a+b\">link</a>"));
    }

    public void testEmoticonsHTMLEncoding() {
        TestHTMLEntityEncoder.assertEquals((String)"&lt;h1&gt;HELLO WORLD &#x2714;&lt;&#x2f;h1&gt;", (String)this.htmlEncoder.encode("<h1>HELLO WORLD \u2714</h1>"));
        TestHTMLEntityEncoder.assertEquals((String)"&lt;h1&gt;HELLO WORLD &#x2714;&#xfe0f;&lt;&#x2f;h1&gt;", (String)this.htmlEncoder.encode("<h1>HELLO WORLD \u2714\ufe0f</h1>"));
        TestHTMLEntityEncoder.assertEquals((String)"&lt;h1&gt;HELLO WORLD &#x1f44d;&lt;&#x2f;h1&gt;", (String)this.htmlEncoder.encode("<h1>HELLO WORLD \ud83d\udc4d</h1>"));
    }
}

