/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.mock;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.commons.api.persistence.GenericDAO;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AbstractInMemoryDAO<E>
implements GenericDAO<E, Long> {
    private static final Log LOG = ExoLogger.getLogger(AbstractInMemoryDAO.class);
    protected static final AtomicLong ID_GENERATOR = new AtomicLong();
    protected Class<E> modelClass;
    protected static Map<String, Map<Long, ?>> allEntities = new HashMap();
    protected Map<Long, E> entities;

    public AbstractInMemoryDAO() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.modelClass = (Class)genericSuperclass.getActualTypeArguments()[0];
        this.entities = allEntities.computeIfAbsent(this.getClass().getName(), key -> new HashMap());
    }

    public Long count() {
        return this.entities.size();
    }

    public E find(Long id) {
        return this.entities.get(id);
    }

    public List<E> findAll() {
        return new ArrayList<E>(this.entities.values());
    }

    public List<E> findByIds(List<Long> ids) {
        return this.entities.values().stream().filter(entity -> ids.contains(this.getId(entity))).toList();
    }

    public void deleteById(Long id) {
        E entity = this.entities.get(id);
        this.delete(entity);
    }

    public E create(E entity) {
        long id = ID_GENERATOR.incrementAndGet();
        this.setId(entity, id);
        this.entities.put(id, entity);
        return entity;
    }

    public void createAll(List<E> entities) {
        entities.forEach(this::create);
    }

    public E update(E entity) {
        Long id = this.getId(entity);
        this.entities.put(id, entity);
        return entity;
    }

    public void updateAll(List<E> entities) {
        entities.forEach(this::update);
    }

    public void delete(E entity) {
        if (entity == null) {
            return;
        }
        this.entities.remove(this.getId(entity));
    }

    public void deleteAll(List<E> entities) {
        this.remove(entities);
    }

    public void deleteAll() {
        this.remove(this.entities.values());
    }

    private Long getId(E entity) {
        try {
            return (Long)this.modelClass.getDeclaredMethod("getId", new Class[0]).invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Can't get id of entity {}", new Object[]{this.modelClass, e});
            return null;
        }
    }

    private void setId(E entity, long id) {
        try {
            this.modelClass.getDeclaredMethod("setId", Long.class).invoke(entity, id);
        }
        catch (Exception e) {
            LOG.warn("Can't set id of entity {}", new Object[]{this.modelClass, e});
        }
    }

    private void remove(Collection<E> items) {
        Object[] array;
        for (Object item : array = items.toArray()) {
            this.delete(item);
        }
    }
}

