/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.exoplatform.commons.utils.BinaryOutput;
import org.exoplatform.commons.utils.BufferingOutputStream;
import org.exoplatform.commons.utils.GrowingOutputStream;
import org.exoplatform.commons.utils.IOFailureFlow;
import org.exoplatform.commons.utils.Printer;
import org.exoplatform.commons.utils.TextEncoder;
import org.gatein.common.io.UndeclaredIOException;

public class OutputStreamPrinter
extends Printer
implements BinaryOutput {
    private final IOFailureFlow failureFlow;
    private final boolean ignoreOnFailure;
    private final OutputStream out;
    private final TextEncoder encoder;
    private boolean failed;
    private final boolean flushOnClose;

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out, boolean flushOnClose) throws IllegalArgumentException {
        this(encoder, out, IOFailureFlow.RETHROW, false, flushOnClose, 0, false);
    }

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out, boolean flushOnClose, int bufferSize) throws IllegalArgumentException {
        this(encoder, out, IOFailureFlow.RETHROW, false, flushOnClose, bufferSize, false);
    }

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out, boolean flushOnClose, int bufferSize, boolean growing) throws IllegalArgumentException {
        this(encoder, out, IOFailureFlow.RETHROW, false, flushOnClose, bufferSize, growing);
    }

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out) throws IllegalArgumentException {
        this(encoder, out, IOFailureFlow.RETHROW, false, false, 0, false);
    }

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out, IOFailureFlow failureFlow, boolean ignoreOnFailure, boolean flushOnClose, int bufferSize) throws IllegalArgumentException {
        this(encoder, out, failureFlow, ignoreOnFailure, flushOnClose, bufferSize, false);
    }

    public OutputStreamPrinter(TextEncoder encoder, OutputStream out, IOFailureFlow failureFlow, boolean ignoreOnFailure, boolean flushOnClose, int bufferSize, boolean growing) throws IllegalArgumentException {
        if (encoder == null) {
            throw new IllegalArgumentException("No null encoder accepted");
        }
        if (out == null) {
            throw new IllegalArgumentException("No null output stream accepted");
        }
        if (failureFlow == null) {
            throw new IllegalArgumentException("No null control flow mode accepted");
        }
        if (bufferSize < 0) {
            throw new IllegalArgumentException("Invalid negative max buffer size: " + bufferSize);
        }
        if (bufferSize > 0 && !growing) {
            out = new BufferingOutputStream(out, bufferSize);
        } else if (growing) {
            out = new GrowingOutputStream(out, bufferSize);
        }
        this.encoder = encoder;
        this.out = out;
        this.failureFlow = failureFlow;
        this.failed = false;
        this.ignoreOnFailure = ignoreOnFailure;
        this.flushOnClose = flushOnClose;
    }

    @Override
    public final Charset getCharset() {
        return this.encoder.getCharset();
    }

    public final IOFailureFlow getFailureFlow() {
        return this.failureFlow;
    }

    public final boolean getIgnoreOnFailure() {
        return this.ignoreOnFailure;
    }

    public final boolean isFailed() {
        return this.failed;
    }

    @Override
    public final void write(byte b) throws IOException {
        if (!this.failed) {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void write(byte[] bytes) throws IOException {
        if (!this.failed) {
            try {
                this.out.write(bytes);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void write(byte[] bytes, int off, int len) throws IOException {
        if (!this.failed) {
            try {
                this.out.write(bytes, off, len);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void write(int c) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode((char)c, this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void write(char[] cbuf) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode(cbuf, 0, cbuf.length, this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void write(String str) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode(str, 0, str.length(), this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void write(String str, int off, int len) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode(str, off, len, this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.failed) {
            try {
                this.encoder.encode(cbuf, off, len, this.out);
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void flush() throws IOException {
        if (!this.failed && !this.flushOnClose) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }

    @Override
    public final void close() throws IOException {
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.handle(e);
        }
    }

    private void handle(IOException e) throws IOException {
        if (this.ignoreOnFailure) {
            this.failed = true;
        }
        switch (this.failureFlow) {
            case IGNORE: {
                break;
            }
            case THROW_UNDECLARED: {
                throw new UndeclaredIOException(e);
            }
            case RETHROW: {
                throw e;
            }
        }
    }

    public void flushOutputStream() throws IOException {
        if (!this.failed) {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                this.handle(e);
            }
        }
    }
}

