/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upload;

import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MimeTypeUploadPlugin
extends BaseComponentPlugin {
    private static final Log log = ExoLogger.getLogger(MimeTypeUploadPlugin.class);
    private static final String MIMETYPE_PATH = "mimetype-path";
    private static final String DEFAULT_MIMETYPE = "mimetype-default";
    private Properties mimeTypes = new Properties();
    private String mimetypeDefault;

    public MimeTypeUploadPlugin(InitParams initParams, ConfigurationManager configurationService) throws Exception {
        ValueParam param = initParams.getValueParam(MIMETYPE_PATH);
        URL filePath = configurationService.getURL(param.getValue());
        URLConnection connection = filePath.openConnection();
        this.mimeTypes.load(connection.getInputStream());
        param = initParams.getValueParam(DEFAULT_MIMETYPE);
        if (param != null) {
            this.mimetypeDefault = param.getValue();
        }
    }

    public String getMimeType(String fileName) {
        if (fileName.indexOf(46) == -1) {
            return this.mimetypeDefault;
        }
        String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
        String mimeType = this.mimeTypes.getProperty(ext.toLowerCase(), this.mimetypeDefault);
        if (mimeType == null || mimeType.length() == 0) {
            return null;
        }
        return mimeType;
    }
}

