/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.jpa.dao.mock;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.jpa.mock.AbstractInMemoryDAO;
import org.exoplatform.settings.jpa.SettingsDAO;
import org.exoplatform.settings.jpa.entity.SettingsEntity;

public class InMemorySettingsDAO
extends AbstractInMemoryDAO<SettingsEntity>
implements SettingsDAO {
    public List<SettingsEntity> getSettingsByContextTypeAndName(String contextType, String contextName) {
        return this.entities.values().stream().filter(entity -> this.isSameContextName((SettingsEntity)entity, contextName) && this.isSameContextType((SettingsEntity)entity, contextType)).toList();
    }

    public List<SettingsEntity> getSettingsByContextAndScope(String contextType, String contextName, String scopeType, String scopeName) {
        return this.entities.values().stream().filter(entity -> this.isSameScopeName((SettingsEntity)entity, scopeName) && this.isSameScopeType((SettingsEntity)entity, scopeType) && this.isSameContextName((SettingsEntity)entity, contextName) && this.isSameContextType((SettingsEntity)entity, contextType)).toList();
    }

    public SettingsEntity getSettingByContextAndScopeAndKey(String contextType, String contextName, String scopeType, String scopeName, String key) {
        return this.entities.values().stream().filter(entity -> this.isSameScopeName((SettingsEntity)entity, scopeName) && this.isSameScopeType((SettingsEntity)entity, scopeType) && this.isSameContextName((SettingsEntity)entity, contextName) && this.isSameContextType((SettingsEntity)entity, contextType) && StringUtils.equals((CharSequence)key, (CharSequence)entity.getName())).findFirst().orElse(null);
    }

    public long countSettingsByNameAndValueAndScope(String scopeType, String scopeName, String key, String value) {
        return this.entities.values().stream().filter(entity -> this.isSameScopeName((SettingsEntity)entity, scopeName) && this.isSameScopeType((SettingsEntity)entity, scopeType) && StringUtils.equals((CharSequence)key, (CharSequence)entity.getName()) && StringUtils.equals((CharSequence)value, (CharSequence)entity.getValue())).count();
    }

    private boolean isSameContextType(SettingsEntity entity, String contextType) {
        return StringUtils.isBlank((CharSequence)contextType) || StringUtils.equals((CharSequence)contextType, (CharSequence)this.getContextType(entity));
    }

    private boolean isSameContextName(SettingsEntity entity, String contextName) {
        return StringUtils.isBlank((CharSequence)contextName) || StringUtils.equals((CharSequence)contextName, (CharSequence)this.getContextName(entity));
    }

    private boolean isSameScopeType(SettingsEntity entity, String scopeType) {
        return StringUtils.isBlank((CharSequence)scopeType) || StringUtils.equals((CharSequence)scopeType, (CharSequence)this.getScopeType(entity));
    }

    private boolean isSameScopeName(SettingsEntity entity, String scopeName) {
        return StringUtils.isBlank((CharSequence)scopeName) || StringUtils.equals((CharSequence)scopeName, (CharSequence)this.getScopeName(entity));
    }

    private String getContextType(SettingsEntity entity) {
        return entity == null || entity.getContext() == null ? null : entity.getContext().getType();
    }

    private String getContextName(SettingsEntity entity) {
        return entity == null || entity.getContext() == null ? null : entity.getContext().getName();
    }

    private String getScopeType(SettingsEntity entity) {
        return entity == null || entity.getScope() == null ? null : entity.getScope().getType();
    }

    private String getScopeName(SettingsEntity entity) {
        return entity == null || entity.getScope() == null ? null : entity.getScope().getName();
    }
}

