/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.cache.future;

import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.exoplatform.commons.cache.future.FutureMap;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.cache.future.StringLoader;
import org.junit.Assert;

public class GetTestCase
extends TestCase {
    public void testGet() {
        FutureMap futureCache = new FutureMap((Loader)new StringLoader());
        GetTestCase.assertEquals((String)"foo_value_", (String)((String)futureCache.get((Object)new Callable<String>(this){

            @Override
            public String call() throws Exception {
                return "foo_value_";
            }
        }, (Object)"foo")));
        GetTestCase.assertEquals((String)"foo_value_", (String)((String)futureCache.data.get("foo")));
    }

    public void testNullValue() {
        FutureMap futureCache = new FutureMap((Loader)new StringLoader());
        GetTestCase.assertEquals(null, (String)((String)futureCache.get((Object)new Callable<String>(this){

            @Override
            public String call() throws Exception {
                return null;
            }
        }, (Object)"foo")));
        GetTestCase.assertFalse((boolean)futureCache.data.containsKey("foo"));
    }

    public void testThrowException() {
        FutureMap futureCache = new FutureMap((Loader)new StringLoader());
        Assert.assertThrows(IllegalStateException.class, () -> futureCache.get((Object)new Callable<String>(this){

            @Override
            public String call() throws Exception {
                throw new Exception("DON'T FREAK OUT");
            }
        }, (Object)"foo"));
        GetTestCase.assertFalse((boolean)futureCache.data.containsKey("foo"));
    }

    public void testReentrancy() {
        final FutureMap futureCache = new FutureMap((Loader)new StringLoader());
        String res = (String)futureCache.get((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    futureCache.get((Object)new Callable<String>(this){

                        @Override
                        public String call() throws Exception {
                            throw new AssertionError();
                        }
                    }, (Object)"foo");
                    return "fail";
                }
                catch (IllegalStateException expected) {
                    return "pass";
                }
            }
        }, (Object)"foo");
        GetTestCase.assertEquals((String)"pass", (String)res);
    }
}

