/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.exoplatform.commons.utils.TimeZoneUtils;
import org.junit.Assert;
import org.junit.Test;

public class TimeZoneUtilsTest {
    @Test
    public void testGetTimezones() {
        List timezones = TimeZoneUtils.getTimeZones();
        Assert.assertNotNull((Object)timezones);
        Assert.assertTrue((String)"List timezones must cover at least 24 timezones", (timezones.size() > 24 ? 1 : 0) != 0);
        int oldOffset = -46800000;
        for (TimeZone timeZone : timezones) {
            Assert.assertTrue((timeZone.getRawOffset() > oldOffset ? 1 : 0) != 0);
            oldOffset = timeZone.getRawOffset();
        }
    }

    @Test
    public void testGetTimezoneDisplayName() {
        List timezones = TimeZoneUtils.getTimeZones();
        for (TimeZone timeZone : timezones) {
            String timeZoneDisplay = TimeZoneUtils.getTimeZoneDisplay((TimeZone)timeZone, (Locale)Locale.ENGLISH);
            Assert.assertNotNull((Object)timeZoneDisplay);
            Assert.assertTrue((boolean)timeZoneDisplay.startsWith("(GMT"));
        }
    }
}

