/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.upload;

import java.util.HashMap;
import java.util.Map;

class ParameterParser {
    private char[] chars_ = null;
    private int pos = 0;
    private int len = 0;
    private int i1 = 0;
    private int i2 = 0;
    private boolean lowerCaseNames = false;

    ParameterParser() {
    }

    private boolean hasChar() {
        return this.pos < this.len;
    }

    private String getToken(boolean quoted) {
        while (this.i1 < this.i2 && Character.isWhitespace(this.chars_[this.i1])) {
            ++this.i1;
        }
        while (this.i2 > this.i1 && Character.isWhitespace(this.chars_[this.i2 - 1])) {
            --this.i2;
        }
        if (quoted && this.i2 - this.i1 >= 2 && this.chars_[this.i1] == '\"' && this.chars_[this.i2 - 1] == '\"') {
            ++this.i1;
            --this.i2;
        }
        if (this.i2 > this.i1) {
            return new String(this.chars_, this.i1, this.i2 - this.i1);
        }
        return null;
    }

    private boolean isOneOf(char ch, char[] charray) {
        for (int i = 0; i < charray.length; ++i) {
            if (ch != charray[i]) continue;
            return true;
        }
        return false;
    }

    private String parseToken(char[] terminators) {
        char ch;
        this.i1 = this.pos;
        this.i2 = this.pos;
        while (this.hasChar() && !this.isOneOf(ch = this.chars_[this.pos], terminators)) {
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(false);
    }

    private String parseQuotedToken(char[] terminators) {
        this.i1 = this.pos;
        this.i2 = this.pos;
        boolean quoted = false;
        boolean charEscaped = false;
        while (this.hasChar()) {
            char ch = this.chars_[this.pos];
            if (!quoted && this.isOneOf(ch, terminators)) break;
            if (!charEscaped && ch == '\"') {
                quoted = !quoted;
            }
            charEscaped = !charEscaped && ch == '\\';
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(true);
    }

    public void setLowerCaseNames(boolean b) {
        this.lowerCaseNames = b;
    }

    public Map<String, String> parse(String str, char separator) {
        if (str == null) {
            return new HashMap<String, String>();
        }
        this.chars_ = str.toCharArray();
        int offset = 0;
        int length = this.chars_.length;
        HashMap<String, String> params = new HashMap<String, String>();
        this.pos = offset;
        this.len = length;
        String paramName = null;
        String paramValue = null;
        while (this.hasChar()) {
            paramName = this.parseToken(new char[]{'=', separator});
            paramValue = null;
            if (this.hasChar() && this.chars_[this.pos] == '=') {
                ++this.pos;
                paramValue = this.parseQuotedToken(new char[]{separator});
            }
            if (this.hasChar() && this.chars_[this.pos] == separator) {
                ++this.pos;
            }
            if (paramName == null || paramName.length() <= 0) continue;
            if (this.lowerCaseNames) {
                paramName = paramName.toLowerCase();
            }
            params.put(paramName, paramValue);
        }
        return params;
    }
}

