/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jpa.settings.dao;

import java.util.List;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.jpa.CommonsDAOJPAImplTest;
import org.exoplatform.settings.jpa.entity.ContextEntity;
import org.exoplatform.settings.jpa.entity.ScopeEntity;
import org.exoplatform.settings.jpa.entity.SettingsEntity;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SettingsDAOTest
extends CommonsDAOJPAImplTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        this.settingsDAO.deleteAll();
        this.settingScopeDAO.deleteAll();
        this.settingContextDAO.deleteAll();
    }

    @Test
    public void testGetSetting() {
        String scopeGlobalName = Scope.GLOBAL.getName();
        String contextGlobalName = Context.GLOBAL.getName();
        ScopeEntity scopeEntity = new ScopeEntity();
        scopeEntity.setType(scopeGlobalName);
        scopeEntity.setName(scopeGlobalName);
        scopeEntity = (ScopeEntity)this.settingScopeDAO.create((Object)scopeEntity);
        ContextEntity contextEntity = new ContextEntity();
        contextEntity.setType(contextGlobalName);
        contextEntity.setName(contextGlobalName);
        contextEntity = (ContextEntity)this.settingContextDAO.create((Object)contextEntity);
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #1").setValue("My value #1").setScope(scopeEntity).setContext(contextEntity));
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #2").setValue("My value #2").setScope(scopeEntity).setContext(contextEntity));
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #3").setValue("My value #3").setScope(scopeEntity).setContext(contextEntity));
        SettingsEntity setting1 = this.settingsDAO.getSettingByContextAndScopeAndKey(contextGlobalName, contextGlobalName, scopeGlobalName, scopeGlobalName, "My setting #1");
        SettingsEntity setting2 = this.settingsDAO.getSettingByContextAndScopeAndKey(contextGlobalName, contextGlobalName, scopeGlobalName, scopeGlobalName, "My setting #2");
        SettingsEntity setting3 = this.settingsDAO.getSettingByContextAndScopeAndKey(contextGlobalName, contextGlobalName, scopeGlobalName, scopeGlobalName, "My setting #3");
        SettingsDAOTest.assertNotNull((Object)setting1);
        SettingsDAOTest.assertEquals((String)setting1.getName(), (String)"My setting #1");
        SettingsDAOTest.assertNotNull((Object)setting2);
        SettingsDAOTest.assertEquals((String)setting2.getName(), (String)"My setting #2");
        SettingsDAOTest.assertNotNull((Object)setting3);
        SettingsDAOTest.assertEquals((String)setting3.getName(), (String)"My setting #3");
    }

    @Test
    public void testGetByUser() {
        String scopeGlobalName = Scope.GLOBAL.getName();
        ScopeEntity scopeEntity = new ScopeEntity();
        scopeEntity.setType(scopeGlobalName);
        scopeEntity.setName(scopeGlobalName);
        scopeEntity = (ScopeEntity)this.settingScopeDAO.create((Object)scopeEntity);
        ContextEntity contextEntity = new ContextEntity();
        contextEntity.setType(Context.USER.getName());
        contextEntity.setName("foo");
        contextEntity = (ContextEntity)this.settingContextDAO.create((Object)contextEntity);
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #1").setValue("My value #1").setScope(scopeEntity).setContext(contextEntity));
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #2").setValue("My value #2").setScope(scopeEntity).setContext(contextEntity));
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #3").setValue("My value #3").setScope(scopeEntity).setContext(contextEntity));
        List settings = this.settingsDAO.getSettingsByContextTypeAndName(Context.USER.getName(), "foo");
        SettingsDAOTest.assertEquals((int)settings.size(), (int)3);
    }

    @Test
    public void testGetByContext() {
        String scopeGlobalName = Scope.GLOBAL.getName();
        String contextGlobalName = Context.GLOBAL.getName();
        ScopeEntity scopeEntity = new ScopeEntity();
        scopeEntity.setType(scopeGlobalName);
        scopeEntity.setName(scopeGlobalName);
        scopeEntity = (ScopeEntity)this.settingScopeDAO.create((Object)scopeEntity);
        ContextEntity contextEntity = new ContextEntity();
        contextEntity.setType(contextGlobalName);
        contextEntity.setName(contextGlobalName);
        contextEntity = (ContextEntity)this.settingContextDAO.create((Object)contextEntity);
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #1").setValue("My value #1").setScope(scopeEntity).setContext(contextEntity));
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #2").setValue("My value #2").setScope(scopeEntity).setContext(contextEntity));
        this.settingsDAO.create((Object)new SettingsEntity().setName("My setting #3").setValue("My value #3").setScope(scopeEntity).setContext(contextEntity));
        List settings = this.settingsDAO.getSettingsByContextTypeAndName(contextGlobalName, contextGlobalName);
        SettingsDAOTest.assertEquals((int)settings.size(), (int)3);
    }
}

