/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.impl;

import java.io.Serializable;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.api.settings.data.SettingKey;
import org.exoplatform.commons.testing.BaseTestCase;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.settings.cache.CacheSettingServiceImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.settings-configuration-local.xml")})
public class CacheSettingTest
extends BaseTestCase {
    protected static SettingService settingService;
    private ExoCache<SettingKey, SettingValue<?>> settingCache;
    private static final String SETTING_CACHING_NAME = "commons.SettingService";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.settingCache = this.getService(CacheService.class).getCacheInstance(SETTING_CACHING_NAME);
        settingService = this.getService(SettingService.class);
        CacheSettingTest.assertNotNull((String)"Cannot find Setting Service", (Object)settingService);
        CacheSettingTest.assertTrue((String)("settingService should be of type CacheSettingServiceImpl instead of " + settingService.getClass().getName()), (boolean)(settingService instanceof CacheSettingServiceImpl));
        ConversationState c = new ConversationState(new Identity("test"));
        ConversationState.setCurrent((ConversationState)c);
        this.settingCache.clearCache();
    }

    public void testSetAndSimpleRemove() {
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
        settingService.set(Context.USER, Scope.SPACE, "a", SettingValue.create((String)"b"));
        CacheSettingTest.assertEquals((int)1, (int)this.settingCache.getCacheSize());
        CacheSettingTest.assertEquals((Object)"b", (Object)((SettingValue)this.settingCache.get((Serializable)new SettingKey(Context.USER, Scope.SPACE, "a"))).getValue());
        settingService.remove(Context.USER, Scope.SPACE, "a");
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
        settingService.set(Context.USER, Scope.SPACE, "b", SettingValue.create((Long)new Long(987L)));
        CacheSettingTest.assertEquals((int)1, (int)this.settingCache.getCacheSize());
        CacheSettingTest.assertEquals((Object)new Long(987L), (Object)((SettingValue)this.settingCache.get((Serializable)new SettingKey(Context.USER, Scope.SPACE, "b"))).getValue());
        settingService.remove(Context.USER, Scope.SPACE, "b");
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
        settingService.set(Context.USER, Scope.SPACE, "b", SettingValue.create((Double)new Double(1.5)));
        CacheSettingTest.assertEquals((int)1, (int)this.settingCache.getCacheSize());
        CacheSettingTest.assertEquals((Object)((SettingValue)this.settingCache.get((Serializable)new SettingKey(Context.USER, Scope.SPACE, "b"))).getValue(), (Object)1.5);
        CacheSettingTest.assertEquals((Object)((SettingValue)this.settingCache.get((Serializable)new SettingKey(Context.USER, Scope.SPACE, "b"))).getValue(), (Object)new Double(1.5));
        this.settingCache.clearCache();
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
        settingService.set(Context.USER, Scope.SPACE, "b", SettingValue.create((Boolean)true));
        CacheSettingTest.assertEquals((int)1, (int)this.settingCache.getCacheSize());
        CacheSettingTest.assertEquals((Object)((SettingValue)this.settingCache.get((Serializable)new SettingKey(Context.USER, Scope.SPACE, "b"))).getValue(), (Object)true);
        CacheSettingTest.assertEquals((Object)((SettingValue)this.settingCache.get((Serializable)new SettingKey(Context.USER, Scope.SPACE, "b"))).getValue(), (Object)new Boolean(true));
        this.settingCache.clearCache();
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
    }

    public void testSetAndRemovePage() {
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
        settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x1", SettingValue.create((String)"y1"));
        settingService.set(Context.GLOBAL, Scope.PAGE.id("name1"), "x2", SettingValue.create((String)"y2"));
        CacheSettingTest.assertEquals((int)2, (int)this.settingCache.getCacheSize());
        settingService.remove(Context.GLOBAL, Scope.PAGE.id("name1"));
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
    }

    public void testSetAndRemoveUser() {
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
        settingService.set(Context.USER, Scope.PORTAL.id("name1"), "x1", SettingValue.create((String)"y1"));
        settingService.set(Context.USER, Scope.PORTAL.id("name2"), "x2", SettingValue.create((String)"y2"));
        settingService.set(Context.USER, Scope.PAGE.id("name3"), "x3", SettingValue.create((String)"y3"));
        settingService.set(Context.USER, Scope.PAGE.id("name4"), "x4", SettingValue.create((String)"y4"));
        CacheSettingTest.assertEquals((int)4, (int)this.settingCache.getCacheSize());
        settingService.remove(Context.USER);
        CacheSettingTest.assertEquals((int)0, (int)this.settingCache.getCacheSize());
    }
}

