/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.component.test.AbstractGateInTest;

public class TestSafe
extends AbstractGateInTest {
    public TestSafe() {
    }

    public TestSafe(String s) {
        super(s);
    }

    public void testClose() {
        TestSafe.assertFalse((boolean)Safe.close(null));
        TestSafe.assertTrue((boolean)Safe.close((Closeable)new ByteArrayOutputStream()));
        TestSafe.assertFalse((boolean)Safe.close((Closeable)new Closeable(this){

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        }));
        TestSafe.assertFalse((boolean)Safe.close((Closeable)new Closeable(this){

            @Override
            public void close() throws IOException {
                throw new RuntimeException();
            }
        }));
        final Error expectedError = new Error();
        try {
            Safe.close((Closeable)new Closeable(){

                @Override
                public void close() throws IOException {
                    throw expectedError;
                }
            });
            TestSafe.fail();
        }
        catch (Error error) {
            TestSafe.assertSame((Object)expectedError, (Object)error);
        }
    }

    public void testEquals() {
        Object o = new Object();
        TestSafe.assertTrue((boolean)Safe.equals((Object)o, (Object)o));
        TestSafe.assertTrue((boolean)Safe.equals(null, null));
        TestSafe.assertFalse((boolean)Safe.equals((Object)new Object(), null));
        TestSafe.assertFalse((boolean)Safe.equals(null, (Object)new Object()));
        TestSafe.assertFalse((boolean)Safe.equals((Object)new Object(), (Object)new Object()));
        TestSafe.assertFalse((boolean)Safe.equals((Object)new Thrower(new RuntimeException()), null));
        TestSafe.assertFalse((boolean)Safe.equals(null, (Object)new Thrower(new RuntimeException())));
        TestSafe.assertFalse((boolean)Safe.equals((Object)new Object(), (Object)new Thrower(new RuntimeException())));
        TestSafe.assertFalse((boolean)Safe.equals((Object)new Thrower(new Error()), null));
        TestSafe.assertFalse((boolean)Safe.equals(null, (Object)new Thrower(new Error())));
        TestSafe.assertFalse((boolean)Safe.equals((Object)new Object(), (Object)new Thrower(new Error())));
        RuntimeException re = new RuntimeException();
        Error er = new Error();
        try {
            Safe.equals((Object)new Thrower(er), (Object)new Object());
            TestSafe.fail();
        }
        catch (Error e) {
            TestSafe.assertSame((Object)er, (Object)e);
        }
        try {
            Safe.equals((Object)new Thrower(re), (Object)new Object());
            TestSafe.fail();
        }
        catch (RuntimeException e) {
            TestSafe.assertSame((Object)re, (Object)e);
        }
    }

    public void testSetUnmodifiable() {
        TestSafe.assertNull((Object)Safe.unmodifiableSet(null));
        Set<String> strings = new HashSet<String>();
        strings.add("a");
        strings = Safe.unmodifiableSet(strings);
        try {
            strings.add("b");
            TestSafe.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestSafe.assertEquals(Collections.singleton("a"), strings);
    }

    private static class Thrower {
        private final Throwable t;

        private Thrower(Throwable t) {
            this.t = t;
        }

        public boolean equals(Object obj) {
            if (this.t instanceof Error) {
                throw (Error)this.t;
            }
            if (this.t instanceof RuntimeException) {
                throw (RuntimeException)this.t;
            }
            throw new AssertionFailedError();
        }
    }
}

