/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.serialization.model;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.exoplatform.commons.serialization.api.TypeConverter;
import org.exoplatform.commons.serialization.api.annotations.Converted;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.serialization.model.ClassTypeModel;
import org.exoplatform.commons.serialization.model.ConvertedTypeModel;
import org.exoplatform.commons.serialization.model.FieldModel;
import org.exoplatform.commons.serialization.model.SerializationMode;
import org.exoplatform.commons.serialization.model.TypeException;
import org.exoplatform.commons.serialization.model.TypeModel;
import org.exoplatform.commons.serialization.model.metadata.ClassTypeMetaData;
import org.exoplatform.commons.serialization.model.metadata.ConvertedTypeMetaData;
import org.exoplatform.commons.serialization.model.metadata.DomainMetaData;
import org.exoplatform.commons.serialization.model.metadata.TypeMetaData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class TypeModelBuilder {
    private static final Log log = ExoLogger.getLogger(TypeModelBuilder.class);
    private static final Map<Class<?>, Class<?>> primitiveToWrapperMap = new HashMap();
    private final Map<String, TypeModel<?>> addedTypeModels = new HashMap();
    private final DomainMetaData metaData;
    private final Map<String, TypeModel<?>> existingTypeModels;

    public TypeModelBuilder(DomainMetaData metaData, Map<String, TypeModel<?>> existingTypeModels) {
        this.metaData = metaData;
        this.existingTypeModels = existingTypeModels;
    }

    Map<String, TypeModel<?>> getAddedTypeModels() {
        return this.addedTypeModels;
    }

    <O> TypeModel<O> build(Class<O> javaType) {
        if (javaType.isPrimitive()) {
            throw new IllegalArgumentException("No primitive type accepted");
        }
        TypeModel<O> typeModel = this.get(javaType);
        if (typeModel != null) {
            log.debug((Object)("Found type model " + String.valueOf(typeModel) + "  for java type " + String.valueOf(javaType)));
            return typeModel;
        }
        log.debug((Object)("About to build type model for java type " + String.valueOf(javaType)));
        TypeMetaData typeMetaData = this.metaData.getTypeMetaData(javaType);
        if (typeMetaData == null) {
            log.debug((Object)("No meta data found for java type " + String.valueOf(javaType) + " about to build it"));
            boolean serialized = javaType.getAnnotation(Serialized.class) != null;
            Converted converted = javaType.getAnnotation(Converted.class);
            if (serialized) {
                if (converted != null) {
                    throw new TypeException();
                }
                typeMetaData = new ClassTypeMetaData(javaType.getName(), true);
            } else {
                typeMetaData = converted != null ? new ConvertedTypeMetaData(javaType.getName(), converted.value()) : new ClassTypeMetaData(javaType.getName(), false);
            }
        }
        log.debug((Object)("Built type meta data " + String.valueOf(typeMetaData) + " for java type " + String.valueOf(javaType)));
        return this.build(javaType, typeMetaData);
    }

    private <O> TypeModel<O> build(Class<O> javaType, TypeMetaData typeMetaData) {
        if (typeMetaData instanceof ClassTypeMetaData) {
            return this.buildClassType(javaType, (ClassTypeMetaData)typeMetaData);
        }
        return this.buildConvertedType(javaType, (ConvertedTypeMetaData)typeMetaData);
    }

    private <O> ConvertedTypeModel<O, ?> buildConvertedType(Class<O> javaType, ConvertedTypeMetaData typeMetaData) {
        log.debug((Object)("About to build type model from type type metadata " + String.valueOf(typeMetaData)));
        Class<TypeConverter<?, ?>> converterClass = typeMetaData.getConverterClass();
        ParameterizedType converterParameterizedType = (ParameterizedType)converterClass.getGenericSuperclass();
        if (!converterParameterizedType.getActualTypeArguments()[0].equals(javaType)) {
            throw new TypeException("The declared type parameter in the converter " + converterClass.getName() + " does not match the type it is related to " + javaType.getName());
        }
        Class<TypeConverter<?, ?>> converterJavaType = converterClass;
        return this.buildConvertedType(javaType, converterJavaType);
    }

    private <O, T> ConvertedTypeModel<O, T> buildConvertedType(Class<O> javaType, Class<? extends TypeConverter<O, ?>> converterJavaType) {
        Class outputClass = (Class)((ParameterizedType)converterJavaType.getGenericSuperclass()).getActualTypeArguments()[1];
        ClassTypeModel targetType = (ClassTypeModel)this.build(outputClass);
        TypeModel<O> superType = null;
        Class<O> superJavaType = javaType.getSuperclass();
        if (superJavaType != null) {
            superType = this.build(superJavaType);
        }
        ConvertedTypeModel typeModel = new ConvertedTypeModel(javaType, superType, targetType, converterJavaType);
        this.addedTypeModels.put(typeModel.getName(), typeModel);
        return typeModel;
    }

    private <O> ClassTypeModel<O> buildClassType(Class<O> javaType, ClassTypeMetaData typeMetaData) {
        ClassTypeModel superTypeModel = null;
        if (javaType.getSuperclass() != null) {
            TypeModel<O> builtType = this.build(javaType.getSuperclass());
            if (builtType instanceof ClassTypeModel) {
                superTypeModel = (ClassTypeModel)builtType;
            } else {
                throw new TypeException();
            }
        }
        TreeMap fieldModels = new TreeMap();
        SerializationMode serializationMode = typeMetaData.isSerialized() ? SerializationMode.SERIALIZED : (Serializable.class.isAssignableFrom(javaType) ? SerializationMode.SERIALIZABLE : SerializationMode.NONE);
        ClassTypeModel<O> typeModel = new ClassTypeModel<O>(javaType, superTypeModel, fieldModels, serializationMode);
        this.addedTypeModels.put(javaType.getName(), typeModel);
        for (Field field : javaType.getDeclaredFields()) {
            TypeModel<?> fieldTypeModel;
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Class<?> fieldJavaType = field.getType();
            if (fieldJavaType.isPrimitive()) {
                fieldJavaType = primitiveToWrapperMap.get(fieldJavaType);
            }
            if ((fieldTypeModel = this.build(fieldJavaType)) == null) continue;
            fieldModels.put(field.getName(), this.createField(typeModel, field, fieldTypeModel));
        }
        return typeModel;
    }

    private <O, V> FieldModel<O, V> createField(TypeModel<O> owner, Field field, TypeModel<V> fieldTypeModel) {
        return new FieldModel<O, V>(owner, field, fieldTypeModel);
    }

    private <O> TypeModel<O> get(Class<O> javaType) {
        TypeModel<?> typeModel = this.existingTypeModels.get(javaType.getName());
        if (typeModel == null) {
            typeModel = this.addedTypeModels.get(javaType.getName());
        }
        return typeModel;
    }

    static {
        primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveToWrapperMap.put(Short.TYPE, Short.class);
        primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveToWrapperMap.put(Long.TYPE, Long.class);
        primitiveToWrapperMap.put(Float.TYPE, Float.class);
        primitiveToWrapperMap.put(Double.TYPE, Double.class);
        primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperMap.put(Character.TYPE, Character.class);
    }
}

