/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax.navigator.builder;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.gatein.common.xml.stax.navigator.builder.StaxNavBuilder;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.StaxNavigatorFactory;

public class StaxNavBuilderImpl
implements StaxNavBuilder {
    private Object input;
    private String inputEncoding;
    private XMLStreamReader reader;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, Object> supportedProperties = new HashMap<String, Object>();

    @Override
    public StaxNavBuilder withProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.properties.put(name, value);
        return this;
    }

    @Override
    public StaxNavBuilder withPropertyIfSupported(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        this.supportedProperties.put(name, value);
        return this;
    }

    @Override
    public StaxNavBuilder withInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        this.input = inputStream;
        return this;
    }

    @Override
    public StaxNavBuilder withInputStream(InputStream inputStream, String encoding) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        this.input = inputStream;
        this.inputEncoding = encoding;
        return this;
    }

    @Override
    public StaxNavBuilder withReader(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.input = reader;
        return this;
    }

    @Override
    public StaxNavBuilder withSource(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        this.input = source;
        return this;
    }

    @Override
    public StaxNavBuilder withXmlStreamReader(XMLStreamReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        this.reader = reader;
        return this;
    }

    @Override
    public <N> StaxNavigator<N> build(Naming<N> naming) throws StaxNavException, IllegalStateException {
        if (naming == null) {
            throw new IllegalArgumentException("naming is null");
        }
        if (this.reader == null && this.input == null) {
            throw new IllegalStateException("Cannot build stax reader. Try calling withInputStream/withReader or pass in own XMLStreamReader.");
        }
        if (this.reader == null) {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                factory.setProperty(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.supportedProperties.entrySet()) {
                String name = entry.getKey();
                if (!factory.isPropertySupported(name)) continue;
                factory.setProperty(name, entry.getValue());
            }
            if (this.input instanceof InputStream) {
                if (this.inputEncoding == null) {
                    try {
                        this.reader = factory.createXMLStreamReader((InputStream)this.input, this.inputEncoding);
                    }
                    catch (XMLStreamException e) {
                        throw new StaxNavException(e);
                    }
                } else {
                    try {
                        this.reader = factory.createXMLStreamReader((InputStream)this.input);
                    }
                    catch (XMLStreamException e) {
                        throw new StaxNavException(e);
                    }
                }
            } else if (this.input instanceof Reader) {
                try {
                    this.reader = factory.createXMLStreamReader((Reader)this.input);
                }
                catch (XMLStreamException e) {
                    throw new StaxNavException(e);
                }
            } else if (this.input instanceof Source) {
                try {
                    this.reader = factory.createXMLStreamReader((Source)this.input);
                }
                catch (XMLStreamException e) {
                    throw new StaxNavException(e);
                }
            } else {
                throw new IllegalStateException("Unknown input: " + String.valueOf(this.input));
            }
        }
        return StaxNavigatorFactory.create(naming, (XMLStreamReader)this.reader);
    }
}

