/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.LogLevel;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.idm.AbstractDAOImpl;
import org.exoplatform.services.organization.idm.ExtGroup;
import org.exoplatform.services.organization.idm.IDMGroupListAccess;
import org.exoplatform.services.organization.idm.IDMGroupTreeListAccess;
import org.exoplatform.services.organization.idm.MembershipDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.Tools;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.SimpleAttribute;

public class GroupDAOImpl
extends AbstractDAOImpl
implements GroupHandler {
    public static final String GROUP_LABEL = "label";
    public static final String GROUP_DESCRIPTION = "description";
    private List<GroupEventListener> listeners_ = new ArrayList<GroupEventListener>();
    private static final String CYCLIC_ID = "org.gatein.portal.identity.LOOPED_GROUP_ID";
    org.picketlink.idm.api.Group rootGroup = null;

    public GroupDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        super(orgService, service);
    }

    public void addGroupEventListener(GroupEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.add(listener);
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listeners_.remove(listener);
    }

    public final Group createGroupInstance() {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "createGroupInstance", null);
        }
        return new ExtGroup();
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "createGroup", new Object[]{"broadcast", broadcast});
        }
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        Group g;
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "addChild", new Object[]{"parent", parent, "child", child, "broadcast", broadcast});
        }
        org.picketlink.idm.api.Group parentGroup = null;
        if (parent != null) {
            String parentPLGroupName = this.getPLIDMGroupName(parent.getGroupName());
            try {
                parentGroup = this.getIdentitySession().getPersistenceManager().findGroup(parentPLGroupName, this.orgService.getConfiguration().getGroupType(parent.getParentId()));
            }
            catch (Exception e) {
                this.handleException("Cannot obtain group: " + parentPLGroupName, e);
            }
            if (parentGroup == null) {
                throw new Exception("Parent group does not exist");
            }
            child.setId(parent.getId() + "/" + child.getGroupName());
        } else {
            child.setId("/" + child.getGroupName());
        }
        if (broadcast) {
            this.preSave(child, true);
        }
        if (parentGroup != null) {
            child.setParentId(parent.getId());
        }
        if ((g = this.findGroupById(child.getId())) != null) {
            throw new Exception("Group " + child.getGroupName() + " is already exist");
        }
        org.picketlink.idm.api.Group childGroup = this.persistGroup(child);
        try {
            if (parentGroup != null) {
                this.getIdentitySession().getRelationshipManager().associateGroups(parentGroup, childGroup);
            } else {
                this.getIdentitySession().getRelationshipManager().associateGroups(this.getRootGroup(), childGroup);
            }
        }
        catch (Exception e) {
            try {
                if (parentGroup != null) {
                    if (this.getIdentitySession().getRelationshipManager().isAssociatedByKeys(parentGroup.getKey(), childGroup.getKey())) {
                        this.getIdentitySession().getRelationshipManager().disassociateGroups(parentGroup, new ArrayList<org.picketlink.idm.api.Group>(Arrays.asList(childGroup)));
                    }
                } else {
                    org.picketlink.idm.api.Group rootGroup = this.getRootGroup();
                    if (this.getIdentitySession().getRelationshipManager().isAssociatedByKeys(rootGroup.getKey(), childGroup.getKey())) {
                        this.getIdentitySession().getRelationshipManager().disassociateGroups(rootGroup, new ArrayList<org.picketlink.idm.api.Group>(Arrays.asList(childGroup)));
                    }
                }
            }
            catch (IdentityException e1) {
                this.handleException("Cannot deassociate groups: ", (Exception)((Object)e1));
            }
            throw e;
        }
        if (broadcast) {
            this.postSave(child, true);
        }
    }

    public void moveGroup(Group parentOriginGroup, Group parentTargetGroup, Group groupToMove) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "moveGroup", new Object[]{"parentOriginGroup", parentOriginGroup, "parentTargetGroup", parentTargetGroup, "groupToMove", groupToMove});
        }
        org.picketlink.idm.api.Group jbidParentOriginGroup = null;
        String plParentOriginGroupName = this.getPLIDMGroupName(parentOriginGroup.getGroupName());
        try {
            jbidParentOriginGroup = this.getIdentitySession().getPersistenceManager().findGroup(plParentOriginGroupName, this.orgService.getConfiguration().getGroupType(parentOriginGroup.getParentId()));
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        org.picketlink.idm.api.Group jbidParentTargetGroup = null;
        String plParentTargetGroupName = this.getPLIDMGroupName(parentTargetGroup.getGroupName());
        try {
            jbidParentTargetGroup = this.getIdentitySession().getPersistenceManager().findGroup(plParentTargetGroupName, this.orgService.getConfiguration().getGroupType(parentTargetGroup.getParentId()));
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        org.picketlink.idm.api.Group jbidGroupToMove = null;
        String plGroupToMoveName = this.getPLIDMGroupName(groupToMove.getGroupName());
        try {
            jbidGroupToMove = this.getIdentitySession().getPersistenceManager().findGroup(plGroupToMoveName, this.orgService.getConfiguration().getGroupType(groupToMove.getParentId()));
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (jbidParentOriginGroup == null) {
            throw new Exception("Group " + String.valueOf(jbidParentOriginGroup) + " does not exist");
        }
        if (jbidParentTargetGroup == null) {
            throw new Exception("Group " + String.valueOf(jbidParentOriginGroup) + " does not exist");
        }
        if (jbidGroupToMove == null) {
            throw new Exception("Group " + String.valueOf(jbidGroupToMove) + " does not exist");
        }
        try {
            this.getIdentitySession().getRelationshipManager().disassociateGroups(jbidParentOriginGroup, List.of(jbidGroupToMove));
        }
        catch (Exception e) {
            this.handleException("Cannot dissociate: " + plGroupToMoveName + " to " + plParentOriginGroupName + "; ", e);
        }
        try {
            this.getIdentitySession().getRelationshipManager().associateGroups(jbidParentTargetGroup, jbidGroupToMove);
        }
        catch (Exception e) {
            this.handleException("Cannot associate: " + plGroupToMoveName + " to " + plParentTargetGroupName + "; ", e);
        }
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "saveGroup", new Object[]{"group", group, "broadcast", broadcast});
        }
        if (broadcast) {
            this.preSave(group, false);
        }
        this.persistGroup(group);
        if (broadcast) {
            this.postSave(group, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        String plGroupName;
        org.picketlink.idm.api.Group jbidGroup;
        block16: {
            if (this.log.isTraceEnabled()) {
                Tools.logMethodIn(this.log, LogLevel.TRACE, "removeGroup", new Object[]{"group", group, "broadcast", broadcast});
            }
            jbidGroup = null;
            plGroupName = this.getPLIDMGroupName(group.getGroupName());
            try {
                this.orgService.flush();
                jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(plGroupName, this.orgService.getConfiguration().getGroupType(group.getParentId()));
            }
            catch (Exception e) {
                this.handleException("Cannot obtain group: " + plGroupName + "; ", e);
            }
            if (jbidGroup == null) {
                throw new Exception("Group " + String.valueOf(group) + " does not exists");
            }
            Collection oneLevelChilds = null;
            this.orgService.flush();
            try {
                oneLevelChilds = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, false);
            }
            catch (Exception e) {
                this.handleException("Cannot clear group relationships: " + plGroupName + "; ", e);
            }
            finally {
                if (oneLevelChilds == null || oneLevelChilds.size() <= 0) break block16;
                throw new IllegalStateException("Group " + group.getGroupName() + " has at least one child group");
            }
        }
        if (broadcast) {
            this.preDelete(group);
        }
        try {
            Collection parents = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, false, false);
            HashSet<org.picketlink.idm.api.Group> dummySet = new HashSet<org.picketlink.idm.api.Group>();
            dummySet.add(jbidGroup);
            for (org.picketlink.idm.api.Group parent : parents) {
                this.getIdentitySession().getRelationshipManager().disassociateGroups(parent, dummySet);
            }
        }
        catch (Exception e) {
            this.handleException("Cannot clear group relationships: " + plGroupName + "; ", e);
        }
        try {
            this.getIdentitySession().getPersistenceManager().removeGroup(jbidGroup, true);
        }
        catch (Exception e) {
            this.handleException("Cannot remove group: " + plGroupName + "; ", e);
        }
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    public Collection<Group> findGroupByMembership(String userName, String membershipType) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroupsByMembership", new Object[]{"userName", membershipType});
        }
        Collection allRoles = new HashSet();
        try {
            this.orgService.flush();
            allRoles = this.getIdentitySession().getRoleManager().findRoles(userName, membershipType);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        MembershipDAOImpl mmm = (MembershipDAOImpl)this.orgService.getMembershipHandler();
        for (Role role : allRoles) {
            Group exoGroup = this.convertGroup(role.getGroup());
            if (!mmm.isCreateMembership(role.getRoleType().getName(), exoGroup.getId())) continue;
            exoGroups.add(exoGroup);
        }
        if (mmm.isAssociationMapped() && mmm.getAssociationMapping().equals(membershipType)) {
            Collection groups = new HashSet();
            try {
                this.orgService.flush();
                groups = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(userName, null);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
            for (org.picketlink.idm.api.Group group : groups) {
                exoGroups.add(this.convertGroup(group));
            }
        }
        LinkedList<Group> result = new LinkedList<Group>(exoGroups);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupByMembership", result);
        }
        return result;
    }

    public Collection<Group> resolveGroupByMembership(String userName, String membershipType) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroupsByMembership", new Object[]{"userName", membershipType});
        }
        HashSet roles = new HashSet();
        try {
            this.orgService.flush();
            roles.addAll(this.getIdentitySession().getRoleManager().findRoles(userName, membershipType));
            roles.addAll(this.getIdentitySession().getRoleManager().findRoles(userName, "*"));
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        MembershipDAOImpl mmm = (MembershipDAOImpl)this.orgService.getMembershipHandler();
        for (Role role : roles) {
            Group exoGroup = this.convertGroup(role.getGroup());
            if (!mmm.isCreateMembership(role.getRoleType().getName(), exoGroup.getId())) continue;
            exoGroups.add(exoGroup);
        }
        if (mmm.isAssociationMapped() && mmm.getAssociationMapping().equals(membershipType)) {
            Collection groups = new HashSet();
            try {
                this.orgService.flush();
                groups = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(userName, null);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
            for (org.picketlink.idm.api.Group group : groups) {
                exoGroups.add(this.convertGroup(group));
            }
        }
        LinkedList<Group> result = new LinkedList<Group>(exoGroups);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupByMembership", result);
        }
        return result;
    }

    public Group findGroupById(String groupId) throws Exception {
        org.picketlink.idm.api.Group jbidGroup;
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroupById", new Object[]{"groupId", groupId});
        }
        if ((jbidGroup = this.orgService.getJBIDMGroup(groupId)) == null) {
            if (this.log.isTraceEnabled()) {
                Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupById", null);
            }
            return null;
        }
        Group result = this.convertGroup(jbidGroup);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupById", result);
        }
        return result;
    }

    public ListAccess<Group> findGroupChildren(Group parent, String keyword) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroupChildren", null);
        }
        IdentitySearchCriteriaImpl identitySearchCriteria = new IdentitySearchCriteriaImpl();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            identitySearchCriteria.nameFilter("*" + keyword + "*");
        }
        return new IDMGroupTreeListAccess(this, parent, this.service_, (IdentitySearchCriteria)identitySearchCriteria);
    }

    public Collection<Group> findGroups(Group parent) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroups", new Object[]{"parent", parent});
        }
        return this.getChildrenGroups(parent, null);
    }

    public Collection<Group> findGroupsOfUser(String user) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroupsOfUser", new Object[]{"user", user});
        }
        if (user == null) {
            if (this.log.isTraceEnabled()) {
                Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupsOfUser", Collections.emptyList());
            }
            return Collections.emptyList();
        }
        Collection allGroups = new HashSet();
        try {
            this.orgService.flush();
            allGroups = this.getIdentitySession().getRelationshipManager().findRelatedGroups(user, null, null);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.picketlink.idm.api.Group group : allGroups) {
            exoGroups.add(this.convertGroup(group));
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupsOfUser", exoGroups);
        }
        return exoGroups;
    }

    public Collection<Group> findGroupsOfUserByKeyword(String user, String keyword, String groupType) throws IOException {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroupsOfUser", new Object[]{"user", user});
        }
        IdentitySearchCriteriaImpl identitySearchCriteria = new IdentitySearchCriteriaImpl();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            try {
                identitySearchCriteria.nameFilter("*" + keyword + "*");
            }
            catch (Exception e) {
                this.handleException("unsupported Criteria error: ", e);
            }
        }
        if (user == null) {
            if (this.log.isTraceEnabled()) {
                Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupsOfUser", Collections.emptyList());
            }
            return null;
        }
        Collection allGroups = new HashSet();
        try {
            this.orgService.flush();
            allGroups = this.getIdentitySession().getRelationshipManager().findRelatedGroups(user, groupType, (IdentitySearchCriteria)identitySearchCriteria);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.picketlink.idm.api.Group group : allGroups) {
            try {
                if (!groupType.isEmpty() && !group.getGroupType().equals(groupType)) continue;
                exoGroups.add(this.convertGroup(group));
            }
            catch (Exception e) {
                this.handleException("convert Group error: ", e);
            }
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupsOfUser", exoGroups);
        }
        return exoGroups;
    }

    public Collection<Group> getAllGroups() throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "getAllGroups", null);
        }
        HashSet plGroups = new HashSet();
        try {
            this.orgService.flush();
            plGroups.addAll(this.getIdentitySession().getRelationshipManager().findAssociatedGroups(this.getRootGroup(), null, true, true));
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            for (String type : this.orgService.getConfiguration().getAllTypes()) {
                try {
                    plGroups.addAll(this.getIdentitySession().getPersistenceManager().findGroup(type));
                }
                catch (Exception e) {
                    this.handleException("Identity operation error: ", e);
                }
            }
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        org.picketlink.idm.api.Group root = this.getRootGroup();
        for (org.picketlink.idm.api.Group group : plGroups) {
            if (group.equals((Object)root)) continue;
            exoGroups.add(this.convertGroup(group));
        }
        LinkedList<Group> result = new LinkedList<Group>(exoGroups);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "getAllGroups", result);
        }
        return result;
    }

    public ListAccess<Group> findGroupsByKeyword(String keyword) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroupsByKeyword", null);
        }
        IdentitySearchCriteria identitySearchCriteria = new IdentitySearchCriteriaImpl().nameFilter("*" + keyword + "*");
        return new IDMGroupListAccess(this, this.service_, identitySearchCriteria);
    }

    public Collection<Group> findAllGroupsByKeyword(String keyword, List<String> excludedGroupsParent) throws Exception {
        IdentitySearchCriteriaImpl identitySearchCriteria = new IdentitySearchCriteriaImpl();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            identitySearchCriteria.nameFilter("*" + keyword + "*");
        }
        Collection allGroups = new HashSet();
        allGroups = this.getIdentitySession().getPersistenceManager().findGroup("@@ALL_GROUPS@@", (IdentitySearchCriteria)identitySearchCriteria);
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        List excludedGroupsTypes = excludedGroupsParent.stream().map(parent -> this.orgService.getConfiguration().getGroupType((String)parent)).collect(Collectors.toList());
        for (org.picketlink.idm.api.Group group : allGroups) {
            if (excludedGroupsTypes.contains(group.getGroupType())) continue;
            exoGroups.add(this.convertGroup(group));
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findAllGroups", exoGroups);
        }
        return exoGroups;
    }

    public Collection<Group> findGroupsOfUserByKeyword(String user, String keyword, List<String> excludedGroupsParent) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "findGroupsOfUserByKeyword", new Object[]{user, keyword, excludedGroupsParent});
        }
        IdentitySearchCriteriaImpl identitySearchCriteria = new IdentitySearchCriteriaImpl();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            identitySearchCriteria.nameFilter("*" + keyword + "*");
        }
        if (user == null) {
            if (this.log.isTraceEnabled()) {
                Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupsOfUserByKeyword", Collections.emptyList());
            }
            return Collections.emptyList();
        }
        Collection allGroups = new HashSet();
        this.orgService.flush();
        List excludedGroupsTypes = excludedGroupsParent.stream().map(parent -> this.orgService.getConfiguration().getGroupType((String)parent)).collect(Collectors.toList());
        allGroups = this.getIdentitySession().getRelationshipManager().findRelatedGroups(user, "@@ALL_GROUPS@@", (IdentitySearchCriteria)identitySearchCriteria);
        LinkedList<Group> exoGroups = new LinkedList<Group>();
        for (org.picketlink.idm.api.Group group : allGroups) {
            if (excludedGroupsTypes.contains(group.getGroupType())) continue;
            exoGroups.add(this.convertGroup(group));
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroupsOfUserByKeyword", exoGroups);
        }
        return exoGroups;
    }

    private void preSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preSave(group, isNew);
        }
    }

    private void postSave(Group group, boolean isNew) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postSave(group, isNew);
        }
    }

    private void preDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.preDelete(group);
        }
    }

    private void postDelete(Group group) throws Exception {
        for (GroupEventListener listener : this.listeners_) {
            listener.postDelete(group);
        }
    }

    public List<Group> getChildrenGroups(Group parent, IdentitySearchCriteria identitySearchCriteria) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = this.getPLIDMGroup(parent);
        if (jbidGroup == null) {
            return Collections.emptyList();
        }
        HashSet plGroups = new HashSet();
        try {
            this.orgService.flush();
            plGroups.addAll(this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, true, false, identitySearchCriteria));
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            String id = parent != null ? parent.getId() : "/";
            for (String string : this.orgService.getConfiguration().getTypes(id)) {
                try {
                    plGroups.addAll(this.getIdentitySession().getPersistenceManager().findGroup(string, identitySearchCriteria));
                }
                catch (Exception e) {
                    this.handleException("Identity operation error: ", e);
                }
            }
        }
        HashSet<Group> exoGroups = new HashSet<Group>();
        org.picketlink.idm.api.Group root = this.getRootGroup();
        for (org.picketlink.idm.api.Group group : plGroups) {
            if (group.equals((Object)root)) continue;
            Group g = this.convertGroup(group);
            if (this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
                String id = g.getParentId();
                if (!(parent == null && id == null || parent != null && id != null && id.equals(parent.getId())) && (parent != null || id == null || !id.equals("/"))) continue;
                exoGroups.add(g);
                continue;
            }
            exoGroups.add(g);
        }
        LinkedList<Group> linkedList = new LinkedList<Group>(exoGroups);
        if (this.orgService.getConfiguration().isSortGroups()) {
            Collections.sort(linkedList);
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "findGroups", linkedList);
        }
        return linkedList;
    }

    public org.picketlink.idm.api.Group getPLIDMGroup(Group group) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = null;
        if (group == null) {
            jbidGroup = this.getRootGroup();
        } else {
            try {
                String plGroupName = this.getPLIDMGroupName(group.getGroupName());
                jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(plGroupName, this.orgService.getConfiguration().getGroupType(group.getParentId()));
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
        }
        return jbidGroup;
    }

    public Group convertGroup(org.picketlink.idm.api.Group jbidGroup) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "convertGroup", new Object[]{"jbidGroup", jbidGroup});
        }
        Map attrs = new HashMap();
        try {
            this.orgService.flush();
            attrs = this.getIdentitySession().getAttributesManager().getAttributes((IdentityType)jbidGroup);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        String gtnGroupName = this.getGtnGroupName(jbidGroup.getName());
        ExtGroup exoGroup = new ExtGroup(gtnGroupName);
        if (attrs.containsKey(GROUP_DESCRIPTION) && ((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue() != null) {
            exoGroup.setDescription(((Attribute)attrs.get(GROUP_DESCRIPTION)).getValue().toString());
        }
        if (attrs.containsKey("store") && ((Attribute)attrs.get("store")).getValue() != null) {
            exoGroup.setOriginatingStore(((Attribute)attrs.get("store")).getValue().toString());
        }
        if (attrs.containsKey(GROUP_LABEL) && ((Attribute)attrs.get(GROUP_LABEL)).getValue() != null) {
            exoGroup.setLabel(((Attribute)attrs.get(GROUP_LABEL)).getValue().toString());
        } else {
            exoGroup.setLabel(gtnGroupName);
        }
        String id = this.getGroupId(jbidGroup, null);
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "getGroupId", id);
        }
        exoGroup.setId(id);
        if (id.length() == gtnGroupName.length() + 1) {
            exoGroup.setParentId(null);
        } else if (!id.equals("") && !id.equals("/")) {
            exoGroup.setParentId(id.substring(0, id.lastIndexOf("/")));
        }
        if (this.log.isTraceEnabled()) {
            Tools.logMethodOut(this.log, LogLevel.TRACE, "convertGroup", exoGroup);
        }
        return exoGroup;
    }

    public String getGroupId(org.picketlink.idm.api.Group jbidGroup, List<org.picketlink.idm.api.Group> processed) throws Exception {
        if (this.log.isTraceEnabled()) {
            Tools.logMethodIn(this.log, LogLevel.TRACE, "getGroupId", new Object[]{"jbidGroup", jbidGroup, "processed", processed});
        }
        if (jbidGroup.equals((Object)this.getRootGroup())) {
            return "";
        }
        if (processed == null) {
            processed = new LinkedList<org.picketlink.idm.api.Group>();
        }
        Collection parents = new HashSet();
        String gtnGroupName = this.getGtnGroupName(jbidGroup.getName());
        try {
            this.orgService.flush();
            parents = this.getIdentitySession().getRelationshipManager().findAssociatedGroups(jbidGroup, null, false, false);
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (parents.size() > 0 && processed.contains(parents.iterator().next())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Detected looped relationship between groups!!!");
            }
            processed.remove(processed.size() - 1);
            return CYCLIC_ID;
        }
        if (parents.size() == 0 || parents.size() > 1) {
            if (parents.size() > 1) {
                this.log.info((Object)("PLIDM Group has more than one parent: " + jbidGroup.getName() + "; Will try to use parent path defined by type mappings or just place it under root /"));
            }
            return this.obtainMappedId(jbidGroup, gtnGroupName);
        }
        processed.add(jbidGroup);
        String parentGroupId = this.getGroupId((org.picketlink.idm.api.Group)parents.iterator().next(), processed);
        if (parentGroupId.equals(CYCLIC_ID)) {
            if (processed.size() > 0) {
                processed.remove(processed.size() - 1);
                return parentGroupId;
            }
            return this.obtainMappedId(jbidGroup, gtnGroupName);
        }
        return parentGroupId + "/" + gtnGroupName;
    }

    private String obtainMappedId(org.picketlink.idm.api.Group jbidGroup, String gtnGroupName) {
        String id = this.orgService.getConfiguration().getParentId(jbidGroup.getGroupType());
        if (id != null && this.orgService.getConfiguration().isForceMembershipOfMappedTypes()) {
            if (id.endsWith("/*")) {
                id = id.substring(0, id.length() - 2);
            }
            return id + "/" + gtnGroupName;
        }
        return "/" + gtnGroupName;
    }

    private org.picketlink.idm.api.Group persistGroup(Group exoGroup) throws Exception {
        org.picketlink.idm.api.Group jbidGroup = null;
        String plGroupName = this.getPLIDMGroupName(exoGroup.getGroupName());
        try {
            jbidGroup = this.getIdentitySession().getPersistenceManager().findGroup(plGroupName, this.orgService.getConfiguration().getGroupType(exoGroup.getParentId()));
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (jbidGroup == null) {
            try {
                jbidGroup = this.getIdentitySession().getPersistenceManager().createGroup(plGroupName, this.orgService.getConfiguration().getGroupType(exoGroup.getParentId()));
            }
            catch (Exception e) {
                try {
                    this.getIdentitySession().getPersistenceManager().removeGroup(plGroupName, true);
                }
                catch (IdentityException e1) {
                    this.handleException("Cannot remove group", (Exception)((Object)e1));
                }
                throw e;
            }
        }
        String description = exoGroup.getDescription();
        String label = exoGroup.getLabel();
        String originatingStore = exoGroup.getOriginatingStore();
        ArrayList<SimpleAttribute> attrsList = new ArrayList<SimpleAttribute>();
        if (description != null) {
            attrsList.add(new SimpleAttribute(GROUP_DESCRIPTION, (Object)description));
        }
        if (label != null) {
            attrsList.add(new SimpleAttribute(GROUP_LABEL, (Object)label));
        }
        if (originatingStore != null) {
            attrsList.add(new SimpleAttribute("store", (Object)originatingStore));
        }
        if (attrsList.size() > 0) {
            Attribute[] attrs = new Attribute[attrsList.size()];
            attrs = attrsList.toArray(attrs);
            try {
                this.getIdentitySession().getAttributesManager().updateAttributes((IdentityType)jbidGroup, attrs);
            }
            catch (Exception e) {
                this.handleException("Identity operation error: ", e);
            }
        }
        return jbidGroup;
    }

    private String getCacheNS() {
        return ((PicketLinkIDMServiceImpl)this.service_).getRealmName();
    }

    protected org.picketlink.idm.api.Group getRootGroup() throws Exception {
        return this.obtainRootGroup();
    }

    public org.picketlink.idm.api.Group obtainRootGroup() throws Exception {
        if (this.rootGroup != null) {
            return this.rootGroup;
        }
        try {
            this.rootGroup = this.getIdentitySession().getPersistenceManager().findGroup(this.orgService.getConfiguration().getRootGroupName(), this.orgService.getConfiguration().getGroupType("/"));
        }
        catch (Exception e) {
            this.handleException("Identity operation error: ", e);
        }
        if (this.rootGroup == null) {
            try {
                this.rootGroup = this.getIdentitySession().getPersistenceManager().createGroup(this.orgService.getConfiguration().getRootGroupName(), this.orgService.getConfiguration().getGroupType("/"));
            }
            catch (Exception e) {
                try {
                    this.getIdentitySession().getPersistenceManager().removeGroup(this.orgService.getConfiguration().getRootGroupName(), true);
                }
                catch (IdentityException e1) {
                    this.handleException("Cannot remove group", (Exception)((Object)e1));
                }
                throw e;
            }
        }
        return this.rootGroup;
    }

    public String getPLIDMGroupName(String gtnGroupName) {
        return this.orgService.getConfiguration().getPLIDMGroupName(gtnGroupName);
    }

    public String getGtnGroupName(String plidmGroupName) {
        return this.orgService.getConfiguration().getGtnGroupName(plidmGroupName);
    }
}

