/*
 * Decompiled with CFR 0.152.
 */
package exo.portal.component.identiy.opendsconfig.opends;

import exo.portal.component.identiy.opendsconfig.DSConfig;
import java.io.File;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.opends.server.tools.LDAPModify;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.InitializationException;
import org.opends.server.util.EmbeddedUtils;

public class OpenDSService {
    private static Log log = ExoLogger.getLogger((String)OpenDSService.class.getName());
    private String serverRoot = "";
    public static final String LDAP_HOST = "localhost";
    public static final String LDAP_PORT = "10389";
    public static final String LDAP_PROVIDER_URL = "ldap://localhost:10389";
    public static final String LDAP_PRINCIPAL = "cn=Directory Manager";
    public static final String LDAP_CREDENTIALS = "password";
    public String EMBEDDED_OPEN_DS_DIRECTORY_NAME = "EmbeddedOpenDS";
    protected DSConfig directoryConfig;
    public String directories = "ldap/datasources/directories.xml";
    private String directoryName = this.EMBEDDED_OPEN_DS_DIRECTORY_NAME;
    public static Hashtable<String, String> env = new Hashtable();
    String identityConfig;

    public OpenDSService(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public DirectoryEnvironmentConfig getConfig() {
        DirectoryEnvironmentConfig config = new DirectoryEnvironmentConfig();
        try {
            File root;
            if (this.getServerRoot() != null) {
                root = new File(this.getServerRoot());
            } else {
                URL rootURL = Thread.currentThread().getContextClassLoader().getResource("ldap/opends/config/config.ldif");
                if (rootURL == null) {
                    throw new IllegalStateException("opends root doesn't exist");
                }
                try {
                    root = new File(rootURL.toURI());
                }
                catch (URISyntaxException e) {
                    root = new File(rootURL.getPath());
                }
                if (root != null) {
                    root = root.getParentFile().getParentFile();
                }
            }
            if (root == null || !root.exists()) {
                throw new IllegalStateException("opends root doesn't exist: " + this.getServerRoot());
            }
            if (!root.isDirectory()) {
                throw new IllegalStateException("opends root is not a directory: " + this.getServerRoot());
            }
            config.setServerRoot(root);
            config.setForceDaemonThreads(true);
        }
        catch (InitializationException e) {
            log.error((Object)"An unexpected error occurs ", (Throwable)e);
        }
        return config;
    }

    public void start() {
        if (!EmbeddedUtils.isRunning()) {
            try {
                EmbeddedUtils.startServer((DirectoryEnvironmentConfig)this.getConfig());
            }
            catch (Exception e) {
                log.error((Object)"An unexpected error occurs ", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (EmbeddedUtils.isRunning()) {
            EmbeddedUtils.stopServer((String)this.getClass().getName(), null);
        }
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
    }

    public void initLDAPServer() throws Exception {
        this.loadConfig();
        this.populateLDIF();
        this.populate();
    }

    public void populate() throws Exception {
        this.populateLDIFFile("ldap/ldap/initial-opends.ldif");
    }

    public void populateLDIF() throws Exception {
        String ldif = this.directoryConfig.getPopulateLdif();
        URL ldifURL = Thread.currentThread().getContextClassLoader().getResource(ldif);
        log.info((Object)("LDIF: " + ldifURL.toURI().getPath()));
        String[] cmd = new String[]{"-h", this.directoryConfig.getHost(), "-p", this.directoryConfig.getPort(), "-D", this.directoryConfig.getAdminDN(), "-w", this.directoryConfig.getAdminPassword(), "-a", "-f", ldifURL.toURI().getPath()};
        if (this.directoryName.equals(this.EMBEDDED_OPEN_DS_DIRECTORY_NAME)) {
            log.info((Object)("Populate success: " + (LDAPModify.mainModify((String[])cmd, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0)));
        } else {
            log.info((Object)("Populate success: " + (LDAPModify.mainModify((String[])cmd) == 0)));
        }
    }

    public void loadConfig() throws Exception {
        this.directoryConfig = DSConfig.obtainConfig(this.directories, this.directoryName);
        this.identityConfig = this.directoryConfig.getConfigFile();
        env.put("java.naming.factory.initial", this.directoryConfig.getContextFactory());
        env.put("java.naming.provider.url", this.directoryConfig.getDescription());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.directoryConfig.getAdminDN());
        env.put("java.naming.security.credentials", this.directoryConfig.getAdminPassword());
    }

    public LdapContext getLdapContext() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", LDAP_PROVIDER_URL);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", LDAP_PRINCIPAL);
        env.put("java.naming.security.credentials", LDAP_CREDENTIALS);
        return new InitialLdapContext(env, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpDN(String dn) throws Exception {
        try (LdapContext ldapCtx = this.getLdapContext();){
            log.info((Object)("Removing: " + dn));
            this.removeContext(ldapCtx, dn);
        }
    }

    public void populateLDIFFile(String ldif) throws Exception {
        URL ldifURL = Thread.currentThread().getContextClassLoader().getResource(ldif);
        log.info((Object)("LDIF: " + ldifURL.toURI().getPath()));
        String[] cmd = new String[]{"-h", this.directoryConfig.getHost(), "-p", this.directoryConfig.getPort(), "-D", this.directoryConfig.getAdminDN(), "-w", this.directoryConfig.getAdminPassword(), "-a", "-c", "-f", ldifURL.toURI().getPath()};
        if (this.directoryName.equals(this.EMBEDDED_OPEN_DS_DIRECTORY_NAME)) {
            log.info((Object)("Populate success: " + (LDAPModify.mainModify((String[])cmd, (boolean)false, (OutputStream)System.out, (OutputStream)System.err) == 0)));
        } else {
            log.info((Object)("Populate success: " + (LDAPModify.mainModify((String[])cmd) == 0)));
        }
    }

    public void removeContext(Context mainCtx, String name) throws Exception {
        Context deleteCtx = (Context)mainCtx.lookup(name);
        NamingEnumeration<Binding> subDirs = mainCtx.listBindings(name);
        while (subDirs.hasMoreElements()) {
            Binding binding = (Binding)subDirs.nextElement();
            String subName = binding.getName();
            this.removeContext(deleteCtx, subName);
        }
        mainCtx.unbind(name);
    }
}

