/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.Arrays;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.search.UserSearchService;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="org/exoplatform/services/organization/TestOrganization-configuration.xml")})
public class TestUserSearchService
extends AbstractKernelTest {
    private UserSearchService userSearchService;
    private OrganizationService organizationService;

    protected void setUp() throws Exception {
        super.setUp();
        this.userSearchService = (UserSearchService)this.getContainer().getComponentInstanceOfType(UserSearchService.class);
        this.organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        RequestLifeCycle.begin((ExoContainer)this.getContainer());
    }

    public void testUserSearch() throws Exception {
        UserHandler userHandler = this.organizationService.getUserHandler();
        ListAccess users = userHandler.findAllUsers();
        TestUserSearchService.assertNotNull((Object)users);
        ListAccess searchedUsers = this.userSearchService.searchUsers(null);
        TestUserSearchService.assertNotNull((Object)searchedUsers);
        TestUserSearchService.assertEquals((int)users.getSize(), (int)searchedUsers.getSize());
        TestUserSearchService.assertTrue((users.getSize() > 1 ? 1 : 0) != 0);
        Query query = new Query();
        query.setUserName("*roo*");
        users = userHandler.findUsersByQuery(query);
        TestUserSearchService.assertNotNull((Object)users);
        TestUserSearchService.assertEquals((int)1, (int)users.getSize());
        searchedUsers = this.userSearchService.searchUsers("roo");
        TestUserSearchService.assertNotNull((Object)searchedUsers);
        TestUserSearchService.assertEquals((int)users.getSize(), (int)searchedUsers.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserSearchSwitchStatus() throws Exception {
        UserHandler userHandler = this.organizationService.getUserHandler();
        ListAccess users = userHandler.findAllUsers();
        TestUserSearchService.assertNotNull((Object)users);
        ListAccess searchedUsers = this.userSearchService.searchUsers(null, UserStatus.ANY);
        TestUserSearchService.assertNotNull((Object)searchedUsers);
        TestUserSearchService.assertEquals((int)users.getSize(), (int)searchedUsers.getSize());
        TestUserSearchService.assertTrue((users.getSize() > 1 ? 1 : 0) != 0);
        User[] usersArray = (User[])users.load(0, users.getSize());
        User johnUser = Arrays.stream(usersArray).filter(user -> user.getUserName().equals("john")).findFirst().orElse(null);
        TestUserSearchService.assertNotNull((Object)johnUser);
        this.organizationService.getUserHandler().setEnabled(johnUser.getUserName(), false, true);
        try {
            searchedUsers = this.userSearchService.searchUsers(null, UserStatus.ENABLED);
            TestUserSearchService.assertNotNull((Object)searchedUsers);
            TestUserSearchService.assertEquals((int)(users.getSize() - 1), (int)searchedUsers.getSize());
            TestUserSearchService.assertEquals((int)(usersArray.length - 1), (int)searchedUsers.getSize());
            searchedUsers = this.userSearchService.searchUsers(null, UserStatus.DISABLED);
            TestUserSearchService.assertEquals((int)1, (int)searchedUsers.getSize());
            searchedUsers = this.userSearchService.searchUsers(null, UserStatus.ANY);
            TestUserSearchService.assertNotNull((Object)searchedUsers);
            TestUserSearchService.assertEquals((int)users.getSize(), (int)searchedUsers.getSize());
            TestUserSearchService.assertEquals((int)usersArray.length, (int)searchedUsers.getSize());
        }
        finally {
            this.organizationService.getUserHandler().setEnabled(johnUser.getUserName(), true, true);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        RequestLifeCycle.end();
    }
}

