/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.tck.organization;

import java.util.Calendar;
import java.util.List;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserEventListenerHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.impl.NewUserConfig;
import org.exoplatform.services.organization.impl.NewUserEventListener;
import org.exoplatform.services.tck.organization.AbstractOrganizationServiceTest;

public class TestUserHandler
extends AbstractOrganizationServiceTest {
    private MyUserEventListener listener;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.listener = new MyUserEventListener();
        this.uHandler.addUserEventListener((UserEventListener)this.listener);
    }

    @Override
    public void tearDown() throws Exception {
        this.uHandler.removeUserEventListener((UserEventListener)this.listener);
        super.tearDown();
    }

    public void testAuthenticate() throws Exception {
        this.createUser("testAuthenticate");
        TestUserHandler.assertTrue((boolean)this.uHandler.authenticate("testAuthenticate", "pwdADDSomeSaltToBeCompliantWithSomeIS00"));
        TestUserHandler.assertFalse((boolean)this.uHandler.authenticate("testAuthenticate_", "pwdADDSomeSaltToBeCompliantWithSomeIS00"));
        TestUserHandler.assertFalse((boolean)this.uHandler.authenticate("testAuthenticate", "pwdADDSomeSaltToBeCompliantWithSomeIS00_"));
        boolean unsupportedOperation = false;
        try {
            this.uHandler.setEnabled("testAuthenticate", false, true);
            try {
                this.uHandler.authenticate("testAuthenticate", "pwdADDSomeSaltToBeCompliantWithSomeIS00");
                TestUserHandler.fail((String)"A DisabledUserException was expected");
            }
            catch (DisabledUserException disabledUserException) {
                // empty catch block
            }
            this.uHandler.setEnabled("testAuthenticate", true, true);
            TestUserHandler.assertTrue((boolean)this.uHandler.authenticate("testAuthenticate", "pwdADDSomeSaltToBeCompliantWithSomeIS00"));
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        this.uHandler.removeUser("testAuthenticate", true);
        TestUserHandler.assertFalse((boolean)this.uHandler.authenticate("testAuthenticate", "pwdADDSomeSaltToBeCompliantWithSomeIS00"));
        TestUserHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testFindUserByName() throws Exception {
        this.createUser("testFindUserByName");
        User u = this.uHandler.findUserByName("demo");
        TestUserHandler.assertNotNull((Object)u);
        TestUserHandler.assertEquals((String)"demo@localhost", (String)u.getEmail());
        TestUserHandler.assertEquals((String)"Demo", (String)u.getFirstName());
        TestUserHandler.assertEquals((String)"exo", (String)u.getLastName());
        TestUserHandler.assertEquals((String)"demo", (String)u.getUserName());
        TestUserHandler.assertTrue((boolean)u.isEnabled());
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("not-existed-user"));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("not-existed-user", UserStatus.ENABLED));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("not-existed-user", UserStatus.DISABLED));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("not-existed-user", UserStatus.ANY));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName("testFindUserByName"));
        TestUserHandler.assertTrue((boolean)this.uHandler.findUserByName("testFindUserByName").isEnabled());
        TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.ENABLED));
        TestUserHandler.assertTrue((boolean)this.uHandler.findUserByName("testFindUserByName", UserStatus.ENABLED).isEnabled());
        TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.ANY));
        TestUserHandler.assertTrue((boolean)this.uHandler.findUserByName("testFindUserByName", UserStatus.ANY).isEnabled());
        boolean unsupportedOperation = false;
        try {
            this.uHandler.setEnabled("testFindUserByName", false, true);
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("testFindUserByName"));
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.ENABLED));
            TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.ANY));
            TestUserHandler.assertFalse((boolean)this.uHandler.findUserByName("testFindUserByName", UserStatus.ANY).isEnabled());
            TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.DISABLED));
            TestUserHandler.assertFalse((boolean)this.uHandler.findUserByName("testFindUserByName", UserStatus.DISABLED).isEnabled());
            this.uHandler.setEnabled("testFindUserByName", true, true);
            TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName("testFindUserByName"));
            TestUserHandler.assertTrue((boolean)this.uHandler.findUserByName("testFindUserByName").isEnabled());
            TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.ENABLED));
            TestUserHandler.assertTrue((boolean)this.uHandler.findUserByName("testFindUserByName", UserStatus.ENABLED).isEnabled());
            TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.ANY));
            TestUserHandler.assertTrue((boolean)this.uHandler.findUserByName("testFindUserByName", UserStatus.ANY).isEnabled());
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.DISABLED));
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        this.uHandler.removeUser("testFindUserByName", true);
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("testFindUserByName"));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.ENABLED));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.DISABLED));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName("testFindUserByName", UserStatus.ANY));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        TestUserHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testFindUsersByQuery() throws Exception {
        String skipDateTests;
        this.createUser("tolik");
        this.uHandler.authenticate("tolik", "pwdADDSomeSaltToBeCompliantWithSomeIS00");
        Query query = new Query();
        query.setEmail("email@test");
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByQuery(query), UserStatus.ENABLED);
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
        query = new Query();
        query.setUserName("*tolik*");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("tol*");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("*lik");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("tolik");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setUserName("tol");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        query = new Query();
        query.setFirstName("first");
        query.setLastName("last");
        this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        String skipCISearchTests = System.getProperty("orgservice.test.configuration.skipCISearchTests");
        if (!"true".equals(skipCISearchTests)) {
            query = new Query();
            query.setUserName("Tolik");
            this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
            query = new Query();
            query.setFirstName("fiRst");
            query.setLastName("lasT");
            this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        }
        if (!"true".equals(skipDateTests = System.getProperty("orgservice.test.configuration.skipDateTests"))) {
            Calendar calc = Calendar.getInstance();
            calc.set(1, calc.get(1) - 1);
            query = new Query();
            query.setFromLoginDate(calc.getTime());
            query.setUserName("tolik");
            this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
            calc = Calendar.getInstance();
            calc.set(1, calc.get(1) + 1);
            query = new Query();
            query.setFromLoginDate(calc.getTime());
            this.assertSizeEquals(0, this.uHandler.findUsersByQuery(query));
            calc = Calendar.getInstance();
            calc.set(1, calc.get(1) - 1);
            query = new Query();
            query.setToLoginDate(calc.getTime());
            this.assertSizeEquals(0, this.uHandler.findUsersByQuery(query));
            calc = Calendar.getInstance();
            calc.set(1, calc.get(1) + 1);
            query = new Query();
            query.setToLoginDate(calc.getTime());
            query.setUserName("tolik");
            this.assertSizeEquals(1, this.uHandler.findUsersByQuery(query));
        }
        this.createUser("rolik");
        this.createUser("bolik");
        this.createUser("volik");
        query = new Query();
        query.setUserName("olik");
        ListAccess users = this.uHandler.findUsersByQuery(query);
        this.assertSizeEquals(4, (ListAccess<User>)users, UserStatus.ENABLED);
        this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
        User[] allPage = (User[])users.load(0, 4);
        User[] page1 = (User[])users.load(0, 2);
        User[] page2 = (User[])users.load(2, 2);
        TestUserHandler.assertEquals((String)allPage[0].getUserName(), (String)page1[0].getUserName());
        TestUserHandler.assertEquals((String)allPage[1].getUserName(), (String)page1[1].getUserName());
        TestUserHandler.assertEquals((String)allPage[2].getUserName(), (String)page2[0].getUserName());
        TestUserHandler.assertEquals((String)allPage[3].getUserName(), (String)page2[1].getUserName());
        try {
            users.load(0, 0);
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception is not expected");
        }
        try {
            users.load(0, 5);
            TestUserHandler.fail((String)"Exception is expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            users.load(1, 4);
            TestUserHandler.fail((String)"Exception is expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean unsupportedOperation = false;
        try {
            this.uHandler.setEnabled("tolik", false, true);
            this.assertSizeEquals(3, (ListAccess<User>)this.uHandler.findUsersByQuery(query), UserStatus.ENABLED);
            this.assertSizeEquals(3, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
            this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.DISABLED), UserStatus.DISABLED);
            this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
            this.uHandler.setEnabled("tolik", true, true);
            this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query), UserStatus.ENABLED);
            this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
            this.assertSizeEquals(0, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.DISABLED), UserStatus.DISABLED);
            this.assertSizeEquals(4, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        this.uHandler.removeUser("tolik", true);
        this.assertSizeEquals(3, (ListAccess<User>)this.uHandler.findUsersByQuery(query), UserStatus.ENABLED);
        this.assertSizeEquals(3, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(3, (ListAccess<User>)this.uHandler.findUsersByQuery(query, UserStatus.ANY), UserStatus.ANY);
        TestUserHandler.assertEquals((int)4, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)4, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testFindUsers() throws Exception {
        String skipDateTests;
        this.createUser("tolik");
        this.uHandler.authenticate("tolik", "pwdADDSomeSaltToBeCompliantWithSomeIS00");
        Query query = new Query();
        query.setEmail("email@test");
        this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        query = new Query();
        query.setUserName("*tolik*");
        this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        query = new Query();
        query.setUserName("tol*");
        this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        query = new Query();
        query.setUserName("*lik");
        this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        query = new Query();
        query.setUserName("tolik");
        this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        query = new Query();
        query.setUserName("tol");
        this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        query = new Query();
        query.setFirstName("first");
        query.setLastName("last");
        this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        String skipCISearchTests = System.getProperty("orgservice.test.configuration.skipCISearchTests");
        if (!"true".equals(skipCISearchTests)) {
            query = new Query();
            query.setUserName("Tolik");
            this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
            query = new Query();
            query.setFirstName("fiRst");
            query.setLastName("lasT");
            this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        }
        if (!"true".equals(skipDateTests = System.getProperty("orgservice.test.configuration.skipDateTests"))) {
            Calendar calc = Calendar.getInstance();
            calc.set(1, calc.get(1) - 1);
            query = new Query();
            query.setFromLoginDate(calc.getTime());
            query.setUserName("tolik");
            this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
            calc = Calendar.getInstance();
            calc.set(1, calc.get(1) + 1);
            query = new Query();
            query.setFromLoginDate(calc.getTime());
            this.assertSizeEquals(0, this.uHandler.findUsers(query).getAll());
            calc = Calendar.getInstance();
            calc.set(1, calc.get(1) - 1);
            query = new Query();
            query.setToLoginDate(calc.getTime());
            this.assertSizeEquals(0, this.uHandler.findUsers(query).getAll());
            calc = Calendar.getInstance();
            calc.set(1, calc.get(1) + 1);
            query = new Query();
            query.setToLoginDate(calc.getTime());
            query.setUserName("tolik");
            this.assertSizeEquals(1, this.uHandler.findUsers(query).getAll());
        }
    }

    public void testGetUserPageList() throws Exception {
        TestUserHandler.assertTrue((this.uHandler.getUserPageList(10).getAll().size() >= 4 ? 1 : 0) != 0);
    }

    public void testFindAllUsers() throws Exception {
        String userName = "testFindAllUsers";
        this.createUser(userName);
        int initSize = this.uHandler.findAllUsers().getSize();
        TestUserHandler.assertTrue((initSize >= 5 ? 1 : 0) != 0);
        this.assertSizeEquals(initSize, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(initSize, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.ANY), UserStatus.ANY);
        ListAccess users = this.uHandler.findAllUsers();
        User[] allPage = (User[])users.load(0, 4);
        User[] page1 = (User[])users.load(0, 2);
        User[] page2 = (User[])users.load(2, 2);
        TestUserHandler.assertEquals((String)allPage[0].getUserName(), (String)page1[0].getUserName());
        TestUserHandler.assertEquals((String)allPage[1].getUserName(), (String)page1[1].getUserName());
        TestUserHandler.assertEquals((String)allPage[2].getUserName(), (String)page2[0].getUserName());
        TestUserHandler.assertEquals((String)allPage[3].getUserName(), (String)page2[1].getUserName());
        try {
            users.load(0, 0);
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception is not expected");
        }
        users.load(0, 6);
        boolean unsupportedOperation = false;
        int initialEnabledSize = this.uHandler.findAllUsers(UserStatus.ENABLED).getSize();
        int initialDisabledSize = this.uHandler.findAllUsers(UserStatus.DISABLED).getSize();
        try {
            this.uHandler.setEnabled(userName, false, true);
            this.assertSizeEquals(initialEnabledSize - 1, (ListAccess<User>)this.uHandler.findAllUsers(), UserStatus.ENABLED);
            this.assertSizeEquals(initialEnabledSize - 1, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.ENABLED), UserStatus.ENABLED);
            this.assertSizeEquals(initialDisabledSize + 1, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.DISABLED), UserStatus.DISABLED);
            this.assertSizeEquals(initialDisabledSize + initialEnabledSize, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.ANY), UserStatus.ANY);
            this.uHandler.setEnabled(userName, true, true);
            this.assertSizeEquals(initialEnabledSize, (ListAccess<User>)this.uHandler.findAllUsers(), UserStatus.ENABLED);
            this.assertSizeEquals(initialEnabledSize, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.ENABLED), UserStatus.ENABLED);
            this.assertSizeEquals(initialDisabledSize, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.DISABLED), UserStatus.DISABLED);
            this.assertSizeEquals(initialDisabledSize + initialEnabledSize, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.ANY), UserStatus.ANY);
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        this.uHandler.removeUser(userName, true);
        initialEnabledSize = this.uHandler.findAllUsers(UserStatus.ENABLED).getSize();
        this.assertSizeEquals(initialEnabledSize, (ListAccess<User>)this.uHandler.findAllUsers(), UserStatus.ENABLED);
        this.assertSizeEquals(initialEnabledSize, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(initialEnabledSize, (ListAccess<User>)this.uHandler.findAllUsers(UserStatus.ANY), UserStatus.ANY);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testRemoveUser() throws Exception {
        this.createMembership(this.userName, this.groupName2, this.membershipType);
        TestUserHandler.assertEquals((String)("We expect to find single membership for user " + this.userName), (int)1, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        TestUserHandler.assertNotNull((Object)this.uHandler.removeUser(this.userName, true));
        TestUserHandler.assertNull((Object)this.upHandler.findUserProfileByName(this.userName));
        TestUserHandler.assertEquals((String)("We expect to find no membership for user " + this.userName), (int)0, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        try {
            TestUserHandler.assertNull((Object)this.uHandler.findUserByName(this.userName + "_"));
        }
        catch (Exception e) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
    }

    public void testSaveUser() throws Exception {
        String userName = "testSaveUser";
        this.createUser(userName);
        String newEmail = "new@Email";
        String displayName = "name";
        User u = this.uHandler.findUserByName(userName);
        u.setEmail(newEmail);
        this.uHandler.saveUser(u, true);
        u = this.uHandler.findUserByName(userName);
        TestUserHandler.assertEquals((String)newEmail, (String)u.getEmail());
        TestUserHandler.assertEquals((String)u.getDisplayName(), (String)(u.getFirstName() + " " + u.getLastName()));
        u.setDisplayName(displayName);
        this.uHandler.saveUser(u, true);
        u = this.uHandler.findUserByName(userName);
        TestUserHandler.assertEquals((String)displayName, (String)u.getDisplayName());
        boolean unsupportedOperation = false;
        try {
            u = this.uHandler.setEnabled(userName, false, true);
            u.setDisplayName(displayName + "new-value");
            try {
                this.uHandler.saveUser(u, true);
                TestUserHandler.fail((String)"A DisabledUserException was expected");
            }
            catch (DisabledUserException disabledUserException) {
                // empty catch block
            }
            u = this.uHandler.setEnabled(userName, true, true);
            u.setDisplayName(displayName + "new-value");
            this.uHandler.saveUser(u, true);
            u = this.uHandler.findUserByName(userName);
            TestUserHandler.assertEquals((String)(displayName + "new-value"), (String)u.getDisplayName());
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        this.uHandler.removeUser(userName, true);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 2 : 3), (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 2 : 3), (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testChangePassword() throws Exception {
        this.createUser("testChangePassword");
        TestUserHandler.assertTrue((boolean)this.uHandler.authenticate("testChangePassword", "pwdADDSomeSaltToBeCompliantWithSomeIS00"));
        TestUserHandler.assertFalse((boolean)this.uHandler.authenticate("testChangePassword", "pwdADDSomeSaltToBeCompliantWithSomeIS00_"));
        User u = this.uHandler.findUserByName("testChangePassword");
        u.setPassword("pwdADDSomeSaltToBeCompliantWithSomeIS00_");
        this.uHandler.saveUser(u, true);
        TestUserHandler.assertTrue((boolean)this.uHandler.authenticate("testChangePassword", "pwdADDSomeSaltToBeCompliantWithSomeIS00_"));
        TestUserHandler.assertFalse((boolean)this.uHandler.authenticate("testChangePassword", "pwdADDSomeSaltToBeCompliantWithSomeIS00"));
        boolean unsupportedOperation = false;
        try {
            u = this.uHandler.setEnabled("testChangePassword", false, true);
            u.setPassword("pwdADDSomeSaltToBeCompliantWithSomeIS00");
            try {
                this.uHandler.saveUser(u, true);
                TestUserHandler.fail((String)"A DisabledUserException was expected");
            }
            catch (DisabledUserException disabledUserException) {
                // empty catch block
            }
            try {
                this.uHandler.authenticate("testChangePassword", "pwdADDSomeSaltToBeCompliantWithSomeIS00_");
                TestUserHandler.fail((String)"A DisabledUserException was expected");
            }
            catch (DisabledUserException disabledUserException) {
                // empty catch block
            }
            try {
                this.uHandler.authenticate("testChangePassword", "pwdADDSomeSaltToBeCompliantWithSomeIS00");
                TestUserHandler.fail((String)"A DisabledUserException was expected");
            }
            catch (DisabledUserException disabledUserException) {
                // empty catch block
            }
            u = this.uHandler.setEnabled("testChangePassword", true, true);
            u.setPassword("pwdADDSomeSaltToBeCompliantWithSomeIS00");
            this.uHandler.saveUser(u, true);
            TestUserHandler.assertTrue((boolean)this.uHandler.authenticate("testChangePassword", "pwdADDSomeSaltToBeCompliantWithSomeIS00"));
            TestUserHandler.assertFalse((boolean)this.uHandler.authenticate("testChangePassword", "pwdADDSomeSaltToBeCompliantWithSomeIS00_"));
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        this.uHandler.removeUser("testChangePassword", true);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 1 : 2), (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 1 : 2), (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testCreateUser() throws Exception {
        User u = this.uHandler.createUserInstance(this.userName);
        u.setEmail("email@test");
        u.setFirstName("first");
        u.setLastName("last");
        u.setPassword("pwdADDSomeSaltToBeCompliantWithSomeIS00");
        this.uHandler.createUser(u, true);
        TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName(this.userName));
        TestUserHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testFindUsersByGroupId() throws Exception {
        this.createMembership(this.userName, this.groupName2, this.membershipType);
        String groupId = "/" + this.groupName2;
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId), UserStatus.ENABLED);
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.ANY), UserStatus.ANY);
        boolean unsupportedOperation = false;
        try {
            this.uHandler.setEnabled(this.userName, false, true);
            this.assertSizeEquals(0, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId), UserStatus.ENABLED);
            this.assertSizeEquals(0, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.ENABLED), UserStatus.ENABLED);
            this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.DISABLED), UserStatus.DISABLED);
            this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.ANY), UserStatus.ANY);
            this.uHandler.setEnabled(this.userName, true, true);
            this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId), UserStatus.ENABLED);
            this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.ENABLED), UserStatus.ENABLED);
            this.assertSizeEquals(0, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.DISABLED), UserStatus.DISABLED);
            this.assertSizeEquals(1, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.ANY), UserStatus.ANY);
        }
        catch (UnsupportedOperationException e) {
            unsupportedOperation = true;
        }
        this.uHandler.removeUser(this.userName, true);
        this.assertSizeEquals(0, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId), UserStatus.ENABLED);
        this.assertSizeEquals(0, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.ENABLED), UserStatus.ENABLED);
        this.assertSizeEquals(0, (ListAccess<User>)this.uHandler.findUsersByGroupId(groupId, UserStatus.ANY), UserStatus.ANY);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)(unsupportedOperation ? 0 : 2), (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testGetListeners() throws Exception {
        if (this.uHandler instanceof UserEventListenerHandler) {
            List list = ((UserEventListenerHandler)this.uHandler).getUserListeners();
            try {
                list.clear();
                TestUserHandler.fail((String)"Exception should not be thrown");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testSetEnabled() throws Exception {
        try {
            TestUserHandler.assertNull((Object)this.uHandler.setEnabled("foo", false, true));
        }
        catch (UnsupportedOperationException e) {
            return;
        }
        this.createUser("testSetEnabled");
        User user = this.uHandler.setEnabled("testSetEnabled", false, true);
        TestUserHandler.assertNotNull((Object)user);
        TestUserHandler.assertEquals((String)"testSetEnabled", (String)user.getUserName());
        TestUserHandler.assertFalse((boolean)user.isEnabled());
        user = this.uHandler.setEnabled("testSetEnabled", false, true);
        TestUserHandler.assertNotNull((Object)user);
        TestUserHandler.assertEquals((String)"testSetEnabled", (String)user.getUserName());
        TestUserHandler.assertFalse((boolean)user.isEnabled());
        user = this.uHandler.setEnabled("testSetEnabled", true, true);
        TestUserHandler.assertNotNull((Object)user);
        TestUserHandler.assertEquals((String)"testSetEnabled", (String)user.getUserName());
        TestUserHandler.assertTrue((boolean)user.isEnabled());
        user = this.uHandler.setEnabled("testSetEnabled", true, true);
        TestUserHandler.assertNotNull((Object)user);
        TestUserHandler.assertEquals((String)"testSetEnabled", (String)user.getUserName());
        TestUserHandler.assertTrue((boolean)user.isEnabled());
        this.uHandler.removeUser("testSetEnabled", true);
        TestUserHandler.assertNull((Object)this.uHandler.setEnabled("testSetEnabled", false, true));
        TestUserHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserHandler.assertEquals((int)2, (int)this.listener.preSetEnabled);
        TestUserHandler.assertEquals((int)2, (int)this.listener.postSetEnabled);
        TestUserHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreDeleteUserEventListenerPreventRemoveUser() throws Exception {
        this.createMembership(this.userName, this.groupName2, this.membershipType);
        this.createUserProfile(this.userName);
        TestUserHandler.assertEquals((String)("Only one membership is expected for the user " + this.userName), (int)1, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        UserProfile up = this.upHandler.findUserProfileByName(this.userName);
        TestUserHandler.assertNotNull((Object)up);
        TestUserHandler.assertEquals((String)this.userName, (String)up.getUserName());
        TestUserHandler.assertEquals((String)"value1", (String)up.getAttribute("key1"));
        TestUserHandler.assertEquals((String)"value2", (String)up.getAttribute("key2"));
        PreventDeleteUserListener preventDeleteUserListener = new PreventDeleteUserListener();
        this.uHandler.addUserEventListener((UserEventListener)preventDeleteUserListener);
        try {
            this.uHandler.removeUser(this.userName, true);
            TestUserHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
        }
        finally {
            this.uHandler.removeUserEventListener((UserEventListener)preventDeleteUserListener);
        }
        TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName(this.userName));
        TestUserHandler.assertEquals((String)("Only one membership is expected for the user " + this.userName), (int)1, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        up = this.upHandler.findUserProfileByName(this.userName);
        TestUserHandler.assertNotNull((Object)up);
        TestUserHandler.assertEquals((String)this.userName, (String)up.getUserName());
        TestUserHandler.assertEquals((String)"value1", (String)up.getAttribute("key1"));
        TestUserHandler.assertEquals((String)"value2", (String)up.getAttribute("key2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreDeleteNewUserEventListener() throws Exception {
        this.createMembership(this.userName, this.groupName2, this.membershipType);
        this.createUserProfile(this.userName);
        TestUserHandler.assertEquals((String)("Only one membership is expected for the user " + this.userName), (int)1, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        UserProfile up = this.upHandler.findUserProfileByName(this.userName);
        TestUserHandler.assertNotNull((Object)up);
        TestUserHandler.assertEquals((String)this.userName, (String)up.getUserName());
        TestUserHandler.assertEquals((String)"value1", (String)up.getAttribute("key1"));
        TestUserHandler.assertEquals((String)"value2", (String)up.getAttribute("key2"));
        ObjectParameter param = new ObjectParameter();
        param.setObject((Object)new NewUserConfig());
        InitParams params = new InitParams();
        params.addParam((Object)param);
        NewUserEventListener newUserEventListener = new NewUserEventListener(params);
        this.uHandler.addUserEventListener((UserEventListener)newUserEventListener);
        try {
            this.uHandler.removeUser(this.userName, true);
        }
        catch (Exception ex) {
            TestUserHandler.fail((String)"Exception should not be thrown");
        }
        finally {
            this.uHandler.removeUserEventListener((UserEventListener)newUserEventListener);
        }
        TestUserHandler.assertNull((Object)this.uHandler.findUserByName(this.userName));
        TestUserHandler.assertEquals((String)("the membership should be removed for the user " + this.userName), (int)0, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        up = this.upHandler.findUserProfileByName(this.userName);
        TestUserHandler.assertNull((Object)up);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPreventRemoveUser() throws Exception {
        this.createMembership(this.userName, this.groupName2, this.membershipType);
        this.createUserProfile(this.userName);
        TestUserHandler.assertEquals((String)("Only one membership is expected for the user " + this.userName), (int)1, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        UserProfile up = this.upHandler.findUserProfileByName(this.userName);
        TestUserHandler.assertNotNull((Object)up);
        TestUserHandler.assertEquals((String)this.userName, (String)up.getUserName());
        TestUserHandler.assertEquals((String)"value1", (String)up.getAttribute("key1"));
        TestUserHandler.assertEquals((String)"value2", (String)up.getAttribute("key2"));
        ObjectParameter param = new ObjectParameter();
        param.setObject((Object)new NewUserConfig());
        InitParams params = new InitParams();
        params.addParam((Object)param);
        NewUserEventListener newUserEventListener = new NewUserEventListener(params);
        PreventDeleteUserListener preventDeleteUserListener = new PreventDeleteUserListener();
        this.uHandler.addUserEventListener((UserEventListener)newUserEventListener);
        this.uHandler.addUserEventListener((UserEventListener)preventDeleteUserListener);
        try {
            this.uHandler.removeUser(this.userName, true);
            TestUserHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
        }
        finally {
            this.uHandler.removeUserEventListener((UserEventListener)preventDeleteUserListener);
            this.uHandler.removeUserEventListener((UserEventListener)newUserEventListener);
        }
        TestUserHandler.assertNotNull((Object)this.uHandler.findUserByName(this.userName));
        TestUserHandler.assertEquals((String)("Only one membership is expected for the user " + this.userName), (int)1, (int)this.mHandler.findMembershipsByUser(this.userName).size());
        up = this.upHandler.findUserProfileByName(this.userName);
        TestUserHandler.assertNotNull((Object)up);
        TestUserHandler.assertEquals((String)this.userName, (String)up.getUserName());
        TestUserHandler.assertEquals((String)"value1", (String)up.getAttribute("key1"));
        TestUserHandler.assertEquals((String)"value2", (String)up.getAttribute("key2"));
    }

    private static class MyUserEventListener
    extends UserEventListener {
        public int preSaveNew;
        public int postSaveNew;
        public int preSave;
        public int postSave;
        public int preDelete;
        public int postDelete;
        public int preSetEnabled;
        public int postSetEnabled;

        private MyUserEventListener() {
        }

        public void preSave(User user, boolean isNew) throws Exception {
            if (user == null) {
                return;
            }
            if (isNew) {
                ++this.preSaveNew;
            } else {
                ++this.preSave;
            }
        }

        public void postSave(User user, boolean isNew) throws Exception {
            if (user == null) {
                return;
            }
            if (isNew) {
                ++this.postSaveNew;
            } else {
                ++this.postSave;
            }
        }

        public void preDelete(User user) throws Exception {
            if (user == null) {
                return;
            }
            ++this.preDelete;
        }

        public void postDelete(User user) throws Exception {
            if (user == null) {
                return;
            }
            ++this.postDelete;
        }

        public void preSetEnabled(User user) throws Exception {
            if (user == null) {
                return;
            }
            ++this.preSetEnabled;
        }

        public void postSetEnabled(User user) throws Exception {
            if (user == null) {
                return;
            }
            ++this.postSetEnabled;
        }
    }

    private static class PreventDeleteUserListener
    extends UserEventListener {
        private PreventDeleteUserListener() {
        }

        public void preDelete(User user) throws Exception {
            throw new Exception("You cannot to delete user");
        }

        public void postDelete(User user) throws Exception {
            TestCase.fail((String)"This method should not be execute because preDelete Event prevent remove user");
        }
    }
}

