/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.tck.organization;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupEventListenerHandler;
import org.exoplatform.services.tck.organization.AbstractOrganizationServiceTest;

public class TestGroupHandler
extends AbstractOrganizationServiceTest {
    private MyGroupEventListener listener;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.listener = new MyGroupEventListener();
        this.gHandler.addGroupEventListener((GroupEventListener)this.listener);
    }

    @Override
    public void tearDown() throws Exception {
        this.gHandler.removeGroupEventListener((GroupEventListener)this.listener);
        super.tearDown();
    }

    public void testFindGroupById() throws Exception {
        Group g = this.gHandler.findGroupById("/platform/administrators");
        TestGroupHandler.assertNotNull((Object)g);
        TestGroupHandler.assertEquals((String)g.getDescription(), (String)"the /platform/administrators group");
        TestGroupHandler.assertEquals((String)g.getGroupName(), (String)"administrators");
        TestGroupHandler.assertEquals((String)g.getId(), (String)"/platform/administrators");
        TestGroupHandler.assertEquals((String)g.getLabel(), (String)"Administrators");
        TestGroupHandler.assertEquals((String)g.getParentId(), (String)"/platform");
        try {
            TestGroupHandler.assertNull((Object)this.gHandler.findGroupById("/not-existed-group"));
        }
        catch (Exception e) {
            TestGroupHandler.fail((String)"Exception should be thrown");
        }
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testFindGroupsByUser() throws Exception {
        this.assertSizeEquals(3, this.gHandler.findGroupsOfUser("john"));
        this.assertSizeEquals(0, this.gHandler.findGroupsOfUser("fake-user"));
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        this.createGroup(null, this.groupName2, "label", "desc");
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName2), this.mtHandler.findMembershipType("*"), true);
        Collection groups = this.gHandler.findGroupsOfUser(this.userName);
        this.assertSizeEquals(2, groups);
        HashSet<String> groupNames = new HashSet<String>();
        for (Group g : groups) {
            groupNames.add(g.getGroupName());
        }
        TestGroupHandler.assertTrue((boolean)groupNames.contains(this.groupName1));
        TestGroupHandler.assertTrue((boolean)groupNames.contains(this.groupName2));
        Iterator it = groups.iterator();
        this.gHandler.removeGroup((Group)it.next(), true);
        this.assertSizeEquals(1, this.gHandler.findGroupsOfUser(this.userName));
        this.gHandler.removeGroup((Group)it.next(), true);
        this.assertSizeEquals(0, this.gHandler.findGroupsOfUser(this.userName));
        this.createMembership(this.userName + "2", this.groupName2, this.membershipType + "2");
        this.assertSizeEquals(1, this.gHandler.findGroupsOfUser(this.userName + "2"));
        this.mHandler.removeMembershipByUser(this.userName + "2", false);
        this.assertSizeEquals(0, this.gHandler.findGroupsOfUser(this.userName + "2"));
        this.createMembership(this.userName + "3", this.groupName2 + "3", this.membershipType + "3");
        this.assertSizeEquals(1, this.gHandler.findGroupsOfUser(this.userName + "3"));
        this.uHandler.removeUser(this.userName + "3", false);
        this.assertSizeEquals(0, this.gHandler.findGroupsOfUser(this.userName + "3"));
        TestGroupHandler.assertEquals((int)4, (int)this.listener.preSaveNew);
        TestGroupHandler.assertEquals((int)4, (int)this.listener.postSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestGroupHandler.assertEquals((int)2, (int)this.listener.preDelete);
        TestGroupHandler.assertEquals((int)2, (int)this.listener.postDelete);
    }

    public void testFindGroups() throws Exception {
        TestGroupHandler.assertTrue((this.gHandler.findGroups(null).size() >= 4 ? 1 : 0) != 0);
        this.assertSizeEquals(2, this.gHandler.findGroups(this.gHandler.findGroupById("/organization/operations")));
        this.assertSizeEquals(0, this.gHandler.findGroups(this.gHandler.findGroupById("/organization/management/executive-board")));
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testGetAllGroups() throws Exception {
        TestGroupHandler.assertTrue((this.gHandler.getAllGroups().size() >= 16 ? 1 : 0) != 0);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testGetGroupsByKeyword() throws Exception {
        try {
            this.assertSizeEquals(2, this.gHandler.findGroupsByKeyword("us"));
            this.assertSizeEquals(1, this.gHandler.findGroupsByKeyword("ad"));
            TestGroupHandler.assertEquals((int)0, (int)this.listener.preSaveNew);
            TestGroupHandler.assertEquals((int)0, (int)this.listener.postSaveNew);
            TestGroupHandler.assertEquals((int)0, (int)this.listener.preSave);
            TestGroupHandler.assertEquals((int)0, (int)this.listener.postSave);
            TestGroupHandler.assertEquals((int)0, (int)this.listener.preDelete);
            TestGroupHandler.assertEquals((int)0, (int)this.listener.postDelete);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemoveGroup() throws Exception {
        this.createUser(this.userName);
        this.createGroup("/organization", this.groupName1, "label", "desc");
        this.createGroup("/organization/" + this.groupName1, this.groupName2, "label", "desc");
        this.createMembership(this.newUserName, this.groupName2, this.membershipType);
        TestGroupHandler.assertEquals((String)("We expect to find single membership for user " + this.newUserName), (int)1, (int)this.mHandler.findMembershipsByUser(this.newUserName).size());
        try {
            this.gHandler.removeGroup(this.gHandler.findGroupById("/organization/group1"), true);
            TestGroupHandler.fail((String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gHandler.removeGroup(this.gHandler.findGroupById("/organization/group1/group2"), true);
        Group group = this.gHandler.removeGroup(this.gHandler.findGroupById("/organization/group1"), true);
        TestGroupHandler.assertNull((Object)this.gHandler.findGroupById("/organization/group1"));
        TestGroupHandler.assertNull((Object)this.gHandler.findGroupById("/organization/group1/group2"));
        this.gHandler.removeGroup(this.gHandler.findGroupById("/" + this.groupName2), true);
        TestGroupHandler.assertEquals((String)("We expect to find no membership for user " + this.newUserName), (int)0, (int)this.mHandler.findMembershipsByUser(this.newUserName).size());
        try {
            this.gHandler.removeGroup(group, true);
            TestGroupHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createGroup(null, this.groupName1, "label", "desc");
        this.createGroup("/" + this.groupName1, this.groupName2, "label", "desc");
        this.gHandler.removeGroup(this.gHandler.findGroupById("/" + this.groupName1 + "/" + this.groupName2), true);
        this.gHandler.removeGroup(this.gHandler.findGroupById("/" + this.groupName1), true);
        TestGroupHandler.assertNull((Object)this.gHandler.findGroupById("/" + this.groupName1));
        TestGroupHandler.assertNull((Object)this.gHandler.findGroupById("/" + this.groupName1 + "/" + this.groupName2));
        TestGroupHandler.assertEquals((int)5, (int)this.listener.preSaveNew);
        TestGroupHandler.assertEquals((int)5, (int)this.listener.postSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestGroupHandler.assertEquals((int)5, (int)this.listener.preDelete);
        TestGroupHandler.assertEquals((int)5, (int)this.listener.postDelete);
    }

    public void testAddChild() throws Exception {
        Group parent = this.createGroupInstance(this.groupName1);
        Group child = this.createGroupInstance(this.groupName2);
        try {
            this.gHandler.addChild(parent, child, false);
            TestGroupHandler.fail((String)"Exception should be thrown.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gHandler.addChild(null, parent, false);
        TestGroupHandler.assertNotNull((Object)this.gHandler.findGroupById("/" + this.groupName1));
        this.gHandler.addChild(parent, child, false);
        TestGroupHandler.assertNotNull((Object)this.gHandler.findGroupById("/" + this.groupName1 + "/" + this.groupName2));
        TestGroupHandler.assertEquals((int)2, (int)this.listener.preSaveNew);
        TestGroupHandler.assertEquals((int)2, (int)this.listener.postSaveNew);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestGroupHandler.assertEquals((int)2, (int)this.listener.preDelete);
        TestGroupHandler.assertEquals((int)2, (int)this.listener.postDelete);
    }

    public void testAddDuplicateChild() throws Exception {
        String parentName = "testAddDuplicateChild_GroupParent";
        Group groupParent = this.gHandler.createGroupInstance();
        groupParent.setGroupName(parentName);
        groupParent.setLabel("GroupParent Label");
        groupParent.setDescription("This is description");
        this.gHandler.addChild(null, groupParent, true);
        TestGroupHandler.assertEquals((String)this.gHandler.findGroupById(groupParent.getId()).getLabel(), (String)"GroupParent Label");
        Group groupChild1 = this.gHandler.createGroupInstance();
        groupChild1.setGroupName("testAddDuplicateChild");
        groupChild1.setLabel("Group1 Label");
        this.gHandler.addChild(groupParent, groupChild1, true);
        TestGroupHandler.assertEquals((String)this.gHandler.findGroupById(groupChild1.getId()).getLabel(), (String)"Group1 Label");
        try {
            Group groupChild2 = this.gHandler.createGroupInstance();
            groupChild2.setGroupName("testAddDuplicateChild");
            groupChild2.setLabel("Group2 Label");
            this.gHandler.addChild(groupParent, groupChild2, true);
            TestGroupHandler.fail((String)"Exception should be thrown because group child is existing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestGroupHandler.assertEquals((String)this.gHandler.findGroupById(groupChild1.getId()).getLabel(), (String)"Group1 Label");
        this.gHandler.removeGroup(this.gHandler.findGroupById(groupChild1.getId()), true);
        this.gHandler.removeGroup(this.gHandler.findGroupById(groupParent.getId()), true);
    }

    public void testCreateGroup() throws Exception {
        Group group = this.gHandler.createGroupInstance();
        group.setGroupName(this.groupName1);
        group.setLabel("label");
        this.gHandler.createGroup(group, true);
        TestGroupHandler.assertNotNull((Object)this.gHandler.findGroupById("/" + this.groupName1));
    }

    public void testSaveGroup() throws Exception {
        this.createGroup(null, this.groupName1, "label", "desc");
        Group g = this.gHandler.findGroupById("/" + this.groupName1);
        g.setDescription("newDesc");
        this.gHandler.saveGroup(g, true);
        g = this.gHandler.findGroupById("/" + this.groupName1);
        TestGroupHandler.assertEquals((String)g.getDescription(), (String)"newDesc");
        TestGroupHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestGroupHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestGroupHandler.assertEquals((int)1, (int)this.listener.preSave);
        TestGroupHandler.assertEquals((int)1, (int)this.listener.postSave);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestGroupHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testGetListeners() throws Exception {
        if (this.gHandler instanceof GroupEventListenerHandler) {
            List list = ((GroupEventListenerHandler)this.gHandler).getGroupListeners();
            try {
                list.clear();
                TestGroupHandler.fail((String)"We are not supposed to be able to change list of listeners.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void testFindGroupByMembership() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        this.createGroup(null, this.groupName2, "label", "desc");
        this.mtHandler.findMembershipType("*");
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName2), this.mtHandler.findMembershipType("*"), false);
        Collection groups = this.gHandler.findGroupByMembership(this.userName, this.membershipType);
        TestGroupHandler.assertNotNull((Object)groups);
        TestGroupHandler.assertEquals((int)1, (int)groups.size());
        TestGroupHandler.assertEquals((String)this.groupName1, (String)((Group)groups.iterator().next()).getGroupName());
        groups = this.gHandler.findGroupByMembership(this.userName, "*");
        TestGroupHandler.assertNotNull((Object)groups);
        TestGroupHandler.assertEquals((int)1, (int)groups.size());
        TestGroupHandler.assertEquals((String)this.groupName2, (String)((Group)groups.iterator().next()).getGroupName());
    }

    public void testResolveGroupByMembership() throws Exception {
        this.createMembership(this.userName, this.groupName1, this.membershipType);
        this.createGroup(null, this.groupName2, "label", "desc");
        this.mHandler.linkMembership(this.uHandler.findUserByName(this.userName), this.gHandler.findGroupById("/" + this.groupName2), this.mtHandler.findMembershipType("*"), false);
        Collection groups = this.gHandler.resolveGroupByMembership(this.userName, this.membershipType);
        TestGroupHandler.assertNotNull((Object)groups);
        TestGroupHandler.assertEquals((int)2, (int)groups.size());
        HashSet<String> groupNames = new HashSet<String>();
        for (Group g : groups) {
            groupNames.add(g.getGroupName());
        }
        TestGroupHandler.assertTrue((boolean)groupNames.contains(this.groupName1));
        TestGroupHandler.assertTrue((boolean)groupNames.contains(this.groupName2));
        groups = this.gHandler.resolveGroupByMembership(this.userName, "*");
        TestGroupHandler.assertNotNull((Object)groups);
        TestGroupHandler.assertEquals((int)1, (int)groups.size());
        TestGroupHandler.assertEquals((String)this.groupName2, (String)((Group)groups.iterator().next()).getGroupName());
    }

    private static class MyGroupEventListener
    extends GroupEventListener {
        public int preSaveNew;
        public int postSaveNew;
        public int preSave;
        public int postSave;
        public int preDelete;
        public int postDelete;

        private MyGroupEventListener() {
        }

        public void preSave(Group group, boolean isNew) throws Exception {
            if (group == null) {
                return;
            }
            if (isNew) {
                ++this.preSaveNew;
            } else {
                ++this.preSave;
            }
        }

        public void postSave(Group group, boolean isNew) throws Exception {
            if (group == null) {
                return;
            }
            if (isNew) {
                ++this.postSaveNew;
            } else {
                ++this.postSave;
            }
        }

        public void preDelete(Group group) throws Exception {
            if (group == null) {
                return;
            }
            ++this.preDelete;
        }

        public void postDelete(Group group) throws Exception {
            if (group == null) {
                return;
            }
            ++this.postDelete;
        }
    }
}

