/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.tck.organization;

import java.util.List;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileEventListenerHandler;
import org.exoplatform.services.tck.organization.AbstractOrganizationServiceTest;

public class TestUserProfileHandler
extends AbstractOrganizationServiceTest {
    private MyUserProfileEventListener listener;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.listener = new MyUserProfileEventListener();
        this.upHandler.addUserProfileEventListener((UserProfileEventListener)this.listener);
    }

    @Override
    public void tearDown() throws Exception {
        this.upHandler.removeUserProfileEventListener((UserProfileEventListener)this.listener);
        super.tearDown();
    }

    public void testFindUserProfileByName() throws Exception {
        this.createUser(this.userName);
        this.createUserProfile(this.userName);
        UserProfile up = this.upHandler.findUserProfileByName(this.userName);
        TestUserProfileHandler.assertNotNull((Object)up);
        TestUserProfileHandler.assertEquals((String)this.userName, (String)up.getUserName());
        TestUserProfileHandler.assertEquals((String)"value1", (String)up.getAttribute("key1"));
        TestUserProfileHandler.assertEquals((String)"value2", (String)up.getAttribute("key2"));
        try {
            TestUserProfileHandler.assertNull((Object)this.upHandler.findUserProfileByName(this.newUserName));
        }
        catch (Exception e) {
            TestUserProfileHandler.fail((String)"Exception should not be thrown");
        }
        this.createUser(this.newUserName);
        try {
            TestUserProfileHandler.assertNull((Object)this.upHandler.findUserProfileByName(this.newUserName));
        }
        catch (Exception e) {
            TestUserProfileHandler.fail((String)"Exception should not be thrown");
        }
        this.createUserProfile(this.newUserName);
        TestUserProfileHandler.assertNotNull((Object)this.upHandler.findUserProfileByName(this.newUserName));
        this.upHandler.removeUserProfile(this.newUserName, true);
        TestUserProfileHandler.assertNull((Object)this.upHandler.findUserProfileByName(this.newUserName));
        this.createUserProfile(this.newUserName);
        TestUserProfileHandler.assertNotNull((Object)this.upHandler.findUserProfileByName(this.newUserName));
        this.uHandler.removeUser(this.newUserName, false);
        TestUserProfileHandler.assertNull((Object)this.upHandler.findUserProfileByName(this.newUserName));
        TestUserProfileHandler.assertEquals((int)3, (int)this.listener.preSaveNew);
        TestUserProfileHandler.assertEquals((int)3, (int)this.listener.postSaveNew);
        TestUserProfileHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserProfileHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testFindUserProfiles() throws Exception {
        this.createUser(this.userName);
        this.createUserProfile(this.userName);
        this.createUser(this.newUserName);
        this.createUserProfile(this.newUserName);
        this.assertSizeEquals(2, this.upHandler.findUserProfiles());
        this.upHandler.removeUserProfile(this.newUserName, true);
        this.assertSizeEquals(1, this.upHandler.findUserProfiles());
        this.createUserProfile(this.newUserName);
        this.assertSizeEquals(2, this.upHandler.findUserProfiles());
        this.uHandler.removeUser(this.newUserName, false);
        this.assertSizeEquals(1, this.upHandler.findUserProfiles());
        TestUserProfileHandler.assertEquals((int)3, (int)this.listener.preSaveNew);
        TestUserProfileHandler.assertEquals((int)3, (int)this.listener.postSaveNew);
        TestUserProfileHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserProfileHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testRemoveUserProfile() throws Exception {
        this.createUser(this.userName);
        this.createUserProfile(this.userName);
        UserProfile up = this.upHandler.removeUserProfile(this.userName, true);
        TestUserProfileHandler.assertNotNull((Object)up);
        TestUserProfileHandler.assertEquals((String)up.getAttribute("key1"), (String)"value1");
        TestUserProfileHandler.assertEquals((String)up.getAttribute("key2"), (String)"value2");
        TestUserProfileHandler.assertNull((Object)this.upHandler.findUserProfileByName("userP1"));
        try {
            TestUserProfileHandler.assertNull((Object)this.upHandler.removeUserProfile(this.newUserName, true));
        }
        catch (Exception e) {
            TestUserProfileHandler.fail((String)"Exception should not be thrown");
        }
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserProfileHandler.assertEquals((int)0, (int)this.listener.preSave);
        TestUserProfileHandler.assertEquals((int)0, (int)this.listener.postSave);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.preDelete);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.postDelete);
    }

    public void testSaveUserProfile() throws Exception {
        this.createUser(this.userName);
        this.createUserProfile(this.userName);
        UserProfile up = this.upHandler.findUserProfileByName(this.userName);
        up.setAttribute("key1", "value11");
        up.setAttribute("key2", null);
        this.upHandler.saveUserProfile(up, true);
        up = this.upHandler.findUserProfileByName(this.userName);
        TestUserProfileHandler.assertEquals((String)up.getAttribute("key1"), (String)"value11");
        TestUserProfileHandler.assertNull((Object)up.getAttribute("key2"));
        try {
            up = this.upHandler.createUserProfileInstance(this.newUserName);
            this.upHandler.saveUserProfile(up, true);
            TestUserProfileHandler.fail((String)"Exception should be thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.preSaveNew);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.postSaveNew);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.preSave);
        TestUserProfileHandler.assertEquals((int)1, (int)this.listener.postSave);
        TestUserProfileHandler.assertEquals((int)0, (int)this.listener.preDelete);
        TestUserProfileHandler.assertEquals((int)0, (int)this.listener.postDelete);
    }

    public void testGetListeners() throws Exception {
        if (this.upHandler instanceof UserProfileEventListenerHandler) {
            List list = ((UserProfileEventListenerHandler)this.upHandler).getUserProfileListeners();
            try {
                list.clear();
                TestUserProfileHandler.fail((String)"We should not able to modife list of listeners");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class MyUserProfileEventListener
    extends UserProfileEventListener {
        public int preSaveNew;
        public int postSaveNew;
        public int preSave;
        public int postSave;
        public int preDelete;
        public int postDelete;

        private MyUserProfileEventListener() {
        }

        public void preSave(UserProfile up, boolean isNew) throws Exception {
            if (up == null) {
                return;
            }
            if (isNew) {
                ++this.preSaveNew;
            } else {
                ++this.preSave;
            }
        }

        public void postSave(UserProfile up, boolean isNew) throws Exception {
            if (up == null) {
                return;
            }
            if (isNew) {
                ++this.postSaveNew;
            } else {
                ++this.postSave;
            }
        }

        public void preDelete(UserProfile up) throws Exception {
            if (up == null) {
                return;
            }
            ++this.preDelete;
        }

        public void postDelete(UserProfile up) throws Exception {
            if (up == null) {
                return;
            }
            ++this.postDelete;
        }
    }
}

