/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.mock;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.DisabledUserException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.organization.mock.InMemoryListAccess;
import org.exoplatform.services.organization.mock.InMemoryMembershipHandler;
import org.exoplatform.services.organization.mock.InMemoryUserProfileHandler;

public class InMemoryUserHandler
implements UserHandler {
    private static final String ERROR_BROADCASTING_EVENT_MESSAGE = "Error broadcasting event : {}";
    public static final String USER_PASSWORD = "password";
    public static final String USER_PASSWORD_SALT = "passwordSalt";
    public static final String USER_FIRST_NAME = "firstName";
    public static final String USER_LAST_NAME = "lastName";
    public static final String USER_DISPLAY_NAME = "displayName";
    public static final String USER_EMAIL = "email";
    public static final String USER_CREATED_DATE = "createdDate";
    public static final String USER_LAST_LOGIN_TIME = "lastLoginTime";
    public static final String USER_ORGANIZATION_ID = "organizationId";
    public static final String USER_ENABLED = "enabled";
    public static final DateFormat dateFormat = DateFormat.getInstance();
    private OrganizationService organizationService;
    private List<UserEventListener> userListeners = new ArrayList<UserEventListener>();
    private static Map<String, User> usersById = new ConcurrentHashMap<String, User>();

    public InMemoryUserHandler(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public final List<UserEventListener> getUserEventListeners() {
        return this.userListeners.stream().toList();
    }

    public void addUserEventListener(UserEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.userListeners.add(listener);
    }

    public void removeUserEventListener(UserEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.userListeners.remove(listener);
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    public void createUser(User user, boolean broadcast) {
        if (usersById.containsKey(user.getUserName())) {
            return;
        }
        this.saveUser(user, broadcast, true);
    }

    public void saveUser(User user, boolean broadcast) throws DisabledUserException {
        if (user != null && !user.isEnabled()) {
            throw new DisabledUserException(user.getUserName());
        }
        this.saveUser(user, broadcast, false);
    }

    public User setEnabled(String userName, boolean enabled, boolean broadcast) {
        if (!usersById.containsKey(userName)) {
            return null;
        }
        User user = usersById.get(userName);
        if (user.isEnabled() == enabled) {
            return this.getClonedUser(userName);
        }
        if (broadcast) {
            this.preSetEnabled(user);
        }
        ((UserImpl)user).setEnabled(Boolean.valueOf(enabled));
        if (broadcast) {
            this.postSetEnabled(user);
        }
        return this.getClonedUser(userName);
    }

    public User removeUser(String userName, boolean broadcast) {
        User user = usersById.get(userName);
        if (broadcast) {
            this.preDelete(user);
        }
        this.getMembershipHandler().removeMembershipByUser(userName, false);
        this.getUserProfileHandler().removeUserProfile(userName, false);
        usersById.remove(userName);
        if (broadcast) {
            this.postDelete(user);
        }
        return user;
    }

    public User findUserByName(String userName) {
        return this.findUserByName(userName, UserStatus.ENABLED);
    }

    public User findUserByName(String userName, UserStatus userStatus) {
        if (!usersById.containsKey(userName)) {
            return null;
        }
        User user = this.getClonedUser(userName);
        return this.filterUserStatus(user, userStatus);
    }

    public LazyPageList<User> getUserPageList(int pageSize) {
        return new LazyPageList(new InMemoryListAccess<User>(usersById.values().stream().toList(), new User[0]), pageSize);
    }

    public ListAccess<User> findAllUsers() {
        return this.findAllUsers(UserStatus.ENABLED);
    }

    public ListAccess<User> findAllUsers(UserStatus userStatus) {
        List<User> users = usersById.values().stream().map(user -> this.filterUserStatus((User)user, userStatus)).filter(Objects::nonNull).toList();
        return new InMemoryListAccess<User>(users, new User[0]);
    }

    public boolean authenticate(String username, String password) throws DisabledUserException {
        if (!usersById.containsKey(username)) {
            return false;
        }
        User user = usersById.get(username);
        if (!user.isEnabled()) {
            throw new DisabledUserException(username);
        }
        return StringUtils.equals((CharSequence)user.getPassword(), (CharSequence)password);
    }

    public LazyPageList<User> findUsers(Query q) {
        return new LazyPageList(this.findUsersByQuery(q), 20);
    }

    public InMemoryListAccess<User> findUsersByQuery(Query q) {
        return this.findUsersByQuery(q, UserStatus.ENABLED);
    }

    public InMemoryListAccess<User> findUsersByQuery(Query query, UserStatus userStatus) {
        List<User> users = usersById.values().stream().map(user -> this.filterUserStatus((User)user, userStatus)).filter(Objects::nonNull).filter(user -> this.contains(user.getEmail(), query.getEmail()) && this.contains(user.getFirstName(), query.getFirstName()) && this.contains(user.getLastName(), query.getLastName()) && this.contains(user.getUserName(), query.getUserName())).filter(Objects::nonNull).toList();
        return new InMemoryListAccess<User>(users, new User[0]);
    }

    public LazyPageList<User> findUsersByGroup(String groupId) {
        ListAccess users = this.findUsersByGroupId(groupId);
        return new LazyPageList(users, users.getSize());
    }

    public InMemoryListAccess<User> findUsersByGroupId(String groupId) {
        return this.findUsersByGroupId(groupId, UserStatus.ENABLED);
    }

    public InMemoryListAccess<User> findUsersByGroupId(String groupId, UserStatus userStatus) {
        List<User> users = this.getMembershipHandler().findMembershipsByGroupId(groupId).stream().map(membership -> usersById.get(membership.getUserName())).map(user -> this.filterUserStatus((User)user, userStatus)).filter(Objects::nonNull).toList();
        return new InMemoryListAccess<User>(users, new User[0]);
    }

    public InMemoryListAccess<User> findUsersByQuery(Query query, List<String> groupIds, UserStatus userStatus) {
        List<User> users = usersById.values().stream().map(user -> this.filterUserStatus((User)user, userStatus)).filter(user -> CollectionUtils.isEmpty((Collection)groupIds) || groupIds.stream().anyMatch(groupId -> !this.getMembershipHandler().findMembershipsByUserAndGroup(user.getUserName(), (String)groupId).isEmpty())).filter(Objects::nonNull).toList();
        return new InMemoryListAccess<User>(users, new User[0]);
    }

    public User findUserByUniqueAttribute(String attributeName, String attributeValue, UserStatus userStatus) {
        InMemoryUserProfileHandler userProfileHandler = (InMemoryUserProfileHandler)this.organizationService.getUserProfileHandler();
        List<UserProfile> profiles = userProfileHandler.findUserProfiles().stream().filter(Objects::nonNull).filter(profile -> profile.getUserInfoMap() != null && profile.getUserInfoMap().containsKey(attributeName) && StringUtils.equals((CharSequence)((CharSequence)profile.getUserInfoMap().get(attributeName)), (CharSequence)attributeValue)).distinct().toList();
        User user = null;
        if (profiles.isEmpty()) {
            if (StringUtils.equals((CharSequence)"userName", (CharSequence)attributeName)) {
                user = usersById.values().stream().filter(existingUser -> StringUtils.equals((CharSequence)existingUser.getUserName(), (CharSequence)attributeValue)).findFirst().orElse(null);
            } else if (StringUtils.equals((CharSequence)USER_EMAIL, (CharSequence)attributeName)) {
                user = usersById.values().stream().filter(existingUser -> StringUtils.equalsIgnoreCase((CharSequence)existingUser.getEmail(), (CharSequence)attributeValue)).findFirst().orElse(null);
            }
        } else if (profiles.size() == 1) {
            user = usersById.get(profiles.get(0).getUserName());
        }
        return this.filterUserStatus(user, userStatus);
    }

    public boolean isUpdateLastLoginTime() {
        return true;
    }

    private User filterUserStatus(User user, UserStatus userStatus) {
        if (user == null || userStatus == null) {
            return user;
        }
        switch (userStatus) {
            case ANY: {
                return user;
            }
            case ENABLED: {
                return user.isEnabled() ? user : null;
            }
            case DISABLED: {
                return user.isEnabled() ? null : user;
            }
        }
        return null;
    }

    private void saveUser(User user, boolean broadcast, boolean isNew) {
        if (broadcast) {
            this.preSave(user, isNew);
        }
        String userName = user.getUserName();
        if (StringUtils.isBlank((CharSequence)user.getPassword()) && usersById.containsKey(userName)) {
            user.setPassword(usersById.get(userName).getPassword());
        }
        usersById.put(userName, user);
        if (broadcast) {
            this.postSave(user, isNew);
        }
    }

    private void preSave(User user, boolean isNew) {
        this.getUserEventListeners().forEach(listener -> {
            try {
                listener.preSave(user, isNew);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        });
    }

    private void postSave(User user, boolean isNew) {
        this.getUserEventListeners().forEach(listener -> {
            try {
                listener.postSave(user, isNew);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        });
    }

    private void preDelete(User user) {
        this.getUserEventListeners().forEach(listener -> {
            try {
                listener.preDelete(user);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        });
    }

    private void postDelete(User user) {
        this.getUserEventListeners().forEach(listener -> {
            try {
                listener.postDelete(user);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        });
    }

    private void preSetEnabled(User user) {
        this.getUserEventListeners().forEach(listener -> {
            try {
                listener.preSetEnabled(user);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        });
    }

    private void postSetEnabled(User user) {
        this.getUserEventListeners().forEach(listener -> {
            try {
                listener.postSetEnabled(user);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        });
    }

    private InMemoryUserProfileHandler getUserProfileHandler() {
        return (InMemoryUserProfileHandler)this.organizationService.getUserProfileHandler();
    }

    private InMemoryMembershipHandler getMembershipHandler() {
        return (InMemoryMembershipHandler)this.organizationService.getMembershipHandler();
    }

    private boolean contains(String value, String queryString) {
        return StringUtils.isBlank((CharSequence)queryString) || StringUtils.contains((CharSequence)value, (CharSequence)queryString.replace("*", ""));
    }

    private User getClonedUser(String userName) {
        return (User)ObjectUtils.clone((Object)usersById.get(userName));
    }
}

