/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.externalstore.jpa;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.externalstore.IDMQueueService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.externalstore.model.IDMQueueEntry;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueDAO;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueEntity;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl$AjcClosure1;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl$AjcClosure11;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl$AjcClosure3;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl$AjcClosure5;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl$AjcClosure7;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl$AjcClosure9;

public class IDMQueueServiceImpl
implements IDMQueueService {
    private static final Scope IDM_SCOPE;
    private static final Log LOG;
    private static final String IDM_QUEUE_PROCESSING_MAX_RETRIES = "exo.idm.queue.processing.error.retries.max";
    private static final int DEFAULT_MAX_RETRIES = 5;
    private int maxRetries = 5;
    private IDMQueueDAO queueDAO;
    private SettingService settingService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public IDMQueueServiceImpl(IDMQueueDAO queueDAO, SettingService settingService, InitParams params) {
        this.settingService = settingService;
        this.queueDAO = queueDAO;
        if (params != null && params.containsKey((Object)IDM_QUEUE_PROCESSING_MAX_RETRIES)) {
            String maxRetriesString = params.getValueParam(IDM_QUEUE_PROCESSING_MAX_RETRIES).getValue();
            try {
                this.maxRetries = Integer.parseInt(maxRetriesString);
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)("Unable to parse max retries " + maxRetriesString + ". Default value 5 will be used"), (Throwable)e);
            }
        }
    }

    public LocalDateTime getLastCheckedTime(IDMEntityType<?> entityType) {
        long timestamp;
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is null");
        }
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, IDM_SCOPE, "DATE-" + entityType.getClassType().getSimpleName());
        if (settingValue == null) {
            return null;
        }
        Object value = settingValue.getValue();
        if (value instanceof Long) {
            timestamp = (Long)value;
        } else if (value instanceof String) {
            timestamp = Long.parseLong(String.valueOf(value));
        } else {
            LOG.warn((Object)("value of type" + value.getClass().getSimpleName() + " is not recognized"));
            return null;
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC.normalized());
        return dateTime;
    }

    public void setLastCheckedTime(IDMEntityType<?> entityType, LocalDateTime dateTime) {
        if (entityType == null) {
            throw new IllegalArgumentException("entityType is null");
        }
        if (dateTime == null) {
            this.settingService.remove(Context.GLOBAL, IDM_SCOPE, "DATE-" + entityType.getClassType().getSimpleName());
        } else {
            SettingValue value = SettingValue.create((Long)dateTime.toInstant(ZoneOffset.UTC).toEpochMilli());
            this.settingService.set(Context.GLOBAL, IDM_SCOPE, "DATE-" + entityType.getClassType().getSimpleName(), value);
        }
    }

    public int countAll() throws Exception {
        return this.queueDAO.countAllNotProcessedAndMaxNbRetries(this.getMaxRetries());
    }

    public int count(int nbRetries) throws Exception {
        return this.queueDAO.countAllNotProcessedAndNbRetries(nbRetries);
    }

    @ExoTransactional
    public void push(IDMQueueEntry queueEntry) throws Exception {
        IDMQueueEntry iDMQueueEntry = queueEntry;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)iDMQueueEntry);
        Object[] objectArray = new Object[]{this, iDMQueueEntry, joinPoint};
        IDMQueueServiceImpl$AjcClosure1 iDMQueueServiceImpl$AjcClosure1 = new IDMQueueServiceImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(iDMQueueServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<IDMQueueEntry> pop(int limit, int nbRetries, boolean keepInQueue) throws Exception {
        int n = limit;
        int n2 = nbRetries;
        boolean bl = keepInQueue;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.booleanObject((boolean)bl), joinPoint};
        IDMQueueServiceImpl$AjcClosure3 iDMQueueServiceImpl$AjcClosure3 = new IDMQueueServiceImpl$AjcClosure3(objectArray2);
        return (List)ExoTransactionalAspect.aspectOf().around(iDMQueueServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void storeAsProcessed(List<IDMQueueEntry> queueEntries) {
        List<IDMQueueEntry> list = queueEntries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, list);
        Object[] objectArray = new Object[]{this, list, joinPoint};
        IDMQueueServiceImpl$AjcClosure5 iDMQueueServiceImpl$AjcClosure5 = new IDMQueueServiceImpl$AjcClosure5(objectArray);
        ExoTransactionalAspect.aspectOf().around(iDMQueueServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void incrementRetry(List<IDMQueueEntry> queueEntries) {
        List<IDMQueueEntry> list = queueEntries;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, list);
        Object[] objectArray = new Object[]{this, list, joinPoint};
        IDMQueueServiceImpl$AjcClosure7 iDMQueueServiceImpl$AjcClosure7 = new IDMQueueServiceImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(iDMQueueServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deleteProcessedEntries() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        IDMQueueServiceImpl$AjcClosure9 iDMQueueServiceImpl$AjcClosure9 = new IDMQueueServiceImpl$AjcClosure9(objectArray);
        ExoTransactionalAspect.aspectOf().around(iDMQueueServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deleteExceededRetriesEntries() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        IDMQueueServiceImpl$AjcClosure11 iDMQueueServiceImpl$AjcClosure11 = new IDMQueueServiceImpl$AjcClosure11(objectArray);
        ExoTransactionalAspect.aspectOf().around(iDMQueueServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    private IDMQueueEntity convertToEntity(IDMQueueEntry queueEntry) {
        IDMQueueEntity idmQueueEntity = new IDMQueueEntity();
        idmQueueEntity.setCreationDate(queueEntry.getCreationDate() == null ? Calendar.getInstance() : queueEntry.getCreationDate()).setId(queueEntry.getId()).setEntityType(queueEntry.getEntityType().getTypeIndex()).setEntityId(queueEntry.getEntityId()).setNbRetries(queueEntry.getRetryCount()).setType(queueEntry.getOperationType()).setProcessed(queueEntry.isProcessed());
        return idmQueueEntity;
    }

    private IDMQueueEntry convertToDTO(IDMQueueEntity idmQueueEntity) {
        IDMQueueEntry queueEntry = new IDMQueueEntry();
        queueEntry.setId(idmQueueEntity.getId()).setCreationDate(idmQueueEntity.getCreationDate()).setEntityType(IDMEntityType.getEntityType((int)idmQueueEntity.getEntityType())).setEntityId(idmQueueEntity.getEntityId()).setRetryCount(idmQueueEntity.getNbRetries()).setOperationType(idmQueueEntity.getType()).setProcessed(idmQueueEntity.isProcessed());
        return queueEntry;
    }

    static {
        IDMQueueServiceImpl.ajc$preClinit();
        IDM_SCOPE = Scope.APPLICATION.id("IDM");
        LOG = ExoLogger.getLogger(IDMQueueServiceImpl.class);
    }

    static final /* synthetic */ void push_aroundBody0(IDMQueueServiceImpl ajc$this, IDMQueueEntry queueEntry, JoinPoint joinPoint) {
        IDMQueueEntity idmQueueEntity = ajc$this.convertToEntity(queueEntry);
        ajc$this.queueDAO.create(idmQueueEntity);
    }

    static final /* synthetic */ List pop_aroundBody2(IDMQueueServiceImpl ajc$this, int limit, int nbRetries, boolean keepInQueue, JoinPoint joinPoint) {
        List<IDMQueueEntity> queueEntries = ajc$this.queueDAO.getEntriesNotProcessedWithNBRetries(nbRetries, limit);
        if (queueEntries == null || queueEntries.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<IDMQueueEntry> entries = new ArrayList<IDMQueueEntry>();
        for (IDMQueueEntity idmQueueEntity : queueEntries) {
            entries.add(ajc$this.convertToDTO(idmQueueEntity));
        }
        if (!keepInQueue) {
            ajc$this.queueDAO.deleteAll(queueEntries);
        }
        return entries;
    }

    static final /* synthetic */ void storeAsProcessed_aroundBody4(IDMQueueServiceImpl ajc$this, List queueEntries, JoinPoint joinPoint) {
        if (queueEntries == null || queueEntries.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (IDMQueueEntry queueEntry : queueEntries) {
            queueEntry.setProcessed(true);
            if (queueEntry.getId() <= 0L) {
                LOG.warn("ID of entry {} couldn't be 0", new Object[]{queueEntry});
            }
            ids.add(queueEntry.getId());
        }
        ajc$this.queueDAO.setProcessed(ids);
    }

    static final /* synthetic */ void incrementRetry_aroundBody6(IDMQueueServiceImpl ajc$this, List queueEntries, JoinPoint joinPoint) {
        if (queueEntries == null || queueEntries.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (IDMQueueEntry queueEntry : queueEntries) {
            queueEntry.setRetryCount(queueEntry.getRetryCount() + 1);
            if (queueEntry.getId() <= 0L) {
                LOG.warn("ID of entry {} couldn't be 0", new Object[]{queueEntry});
            }
            ids.add(queueEntry.getId());
        }
        ajc$this.queueDAO.incrementRetry(ids);
    }

    static final /* synthetic */ void deleteProcessedEntries_aroundBody8(IDMQueueServiceImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.queueDAO.deleteProcessedEntries();
    }

    static final /* synthetic */ void deleteExceededRetriesEntries_aroundBody10(IDMQueueServiceImpl ajc$this, JoinPoint joinPoint) {
        ajc$this.queueDAO.deleteExceededRetriesEntries(ajc$this.getMaxRetries());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("IDMQueueServiceImpl.java", IDMQueueServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "push", "org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl", "org.exoplatform.services.organization.externalstore.model.IDMQueueEntry", "queueEntry", "java.lang.Exception", "void"), 122);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "pop", "org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl", "int:int:boolean", "limit:nbRetries:keepInQueue", "java.lang.Exception", "java.util.List"), 129);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "storeAsProcessed", "org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl", "java.util.List", "queueEntries", "", "void"), 146);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "incrementRetry", "org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl", "java.util.List", "queueEntries", "", "void"), 163);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteProcessedEntries", "org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl", "", "", "", "void"), 180);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteExceededRetriesEntries", "org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueServiceImpl", "", "", "", "void"), 186);
    }
}

