/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore;

import exo.portal.component.identiy.opendsconfig.opends.OpenDSService;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.externalstore.PicketLinkIDMExternalStoreService;
import org.gatein.portal.idm.impl.repository.ExoFallbackIdentityStoreRepository;
import org.gatein.portal.idm.impl.store.hibernate.ExoHibernateIdentityStoreImpl;
import org.picketlink.idm.impl.store.ldap.ExoLDAPIdentityStoreImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-external-ldap-store-configuration.xml")})
public class TestPLIDMExternalStoreService
extends AbstractKernelTest {
    private static final String NICKNAME_PARAM = "user.name.nickName";
    private OpenDSService openDSService = new OpenDSService(null);
    private PicketLinkIDMExternalStoreService externalStoreService;
    private ListenerService listenerService;
    private PicketLinkIDMOrganizationServiceImpl organizationService;
    private AtomicInteger listenerDeleteUser = new AtomicInteger(0);
    private AtomicInteger listenerModifyUser = new AtomicInteger(0);
    private AtomicInteger listenerAddUser = new AtomicInteger(0);
    private Listener<IDMExternalStoreService, User> userAddedListener = new Listener<IDMExternalStoreService, User>(){

        public void onEvent(Event<IDMExternalStoreService, User> event) throws Exception {
            TestCase.assertNotNull(event);
            TestCase.assertNotNull((Object)event.getSource());
            User user = (User)event.getData();
            TestCase.assertNotNull((Object)user);
            TestCase.assertNotNull((Object)TestPLIDMExternalStoreService.this.organizationService.getUserHandler().findUserByName(user.getUserName()));
            TestPLIDMExternalStoreService.this.listenerAddUser.incrementAndGet();
        }
    };
    private Listener<IDMExternalStoreService, User> userDeleteListener = new Listener<IDMExternalStoreService, User>(){

        public void onEvent(Event<IDMExternalStoreService, User> event) throws Exception {
            TestCase.assertNotNull(event);
            TestCase.assertNotNull((Object)event.getSource());
            User user = (User)event.getData();
            TestCase.assertNotNull((Object)user);
            TestCase.assertNull((Object)TestPLIDMExternalStoreService.this.organizationService.getUserHandler().findUserByName(user.getUserName()));
            TestPLIDMExternalStoreService.this.listenerDeleteUser.incrementAndGet();
        }
    };
    private Listener<IDMExternalStoreService, User> userModifiedListener = new Listener<IDMExternalStoreService, User>(){

        public void onEvent(Event<IDMExternalStoreService, User> event) throws Exception {
            TestCase.assertNotNull(event);
            TestCase.assertNotNull((Object)event.getSource());
            User user = (User)event.getData();
            TestCase.assertNotNull((Object)user);
            TestCase.assertNotNull((Object)TestPLIDMExternalStoreService.this.organizationService.getUserHandler().findUserByName(user.getUserName()));
            TestPLIDMExternalStoreService.this.listenerModifyUser.incrementAndGet();
        }
    };
    private UserEventListener errorOnUserEventListener = new UserEventListener(this){

        public void preSave(User user, boolean isNew) throws Exception {
            throw new Exception("Fake exception !"){

                @Override
                public void printStackTrace(PrintStream s) {
                }

                @Override
                public void printStackTrace(PrintWriter s) {
                }

                @Override
                public void printStackTrace() {
                }
            };
        }
    };

    public void setUp() throws Exception {
        this.setForceContainerReload(true);
        this.externalStoreService = (PicketLinkIDMExternalStoreService)this.getContainer().getComponentInstanceOfType(IDMExternalStoreService.class);
        this.listenerService = (ListenerService)this.getContainer().getComponentInstanceOfType(ListenerService.class);
        this.organizationService = (PicketLinkIDMOrganizationServiceImpl)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.listenerAddUser.set(0);
        this.listenerModifyUser.set(0);
        this.listenerService.addListener("exo.idm.externalStore.user.deleted", this.userDeleteListener);
        this.listenerService.addListener("exo.idm.externalStore.user.new", this.userAddedListener);
        this.listenerService.addListener("exo.idm.externalStore.user.modified", this.userModifiedListener);
        this.begin();
        this.removeAllUsers();
        this.removeGroupTree(null);
        this.externalStoreService.initializeGroupTree(this.externalStoreService.getReversedGroupTypeMappings());
    }

    public void tearDown() throws Exception {
        this.removeAllUsers();
        this.organizationService.getUserHandler().removeUserEventListener(this.errorOnUserEventListener);
        this.removeGroupTree(null);
        this.end();
        super.tearDown();
    }

    private void removeAllUsers() throws Exception {
        User[] users;
        ListAccess allusers = this.organizationService.getUserHandler().findAllUsers();
        for (User user : users = (User[])allusers.load(0, allusers.getSize())) {
            this.organizationService.getUserHandler().removeUser(user.getUserName(), true);
        }
    }

    public void beforeRunBare() {
        try {
            this.openDSService.start();
            this.openDSService.initLDAPServer();
            this.openDSService.populateLDIFFile("ldap/ldap/initial-opends-external.ldif");
        }
        catch (Exception e) {
            this.log.error((Object)"Error in starting up OPENDS", (Throwable)e);
            e.printStackTrace();
        }
        super.beforeRunBare();
    }

    public void testConfiguration() throws Exception {
        TestPLIDMExternalStoreService.assertTrue((String)"External Store is not enabled", (boolean)this.externalStoreService.isEnabled());
        TestPLIDMExternalStoreService.assertTrue((String)"External Store doesn't update user on login", (boolean)this.externalStoreService.isUpdateInformationOnLogin());
        TestPLIDMExternalStoreService.assertNotNull((String)"External Store doesn't have a managed entity types", (Object)this.externalStoreService.getManagedEntityTypes());
        TestPLIDMExternalStoreService.assertEquals((String)"Incoherent managed types size", (int)7, (int)this.externalStoreService.getManagedEntityTypes().size());
        TestPLIDMExternalStoreService.assertTrue((String)"'USER' entity is not managed", (boolean)this.externalStoreService.getManagedEntityTypes().contains(IDMEntityType.USER));
        TestPLIDMExternalStoreService.assertTrue((String)"'IDMUSER' entity is not managed", (boolean)this.externalStoreService.getManagedEntityTypes().contains(PicketLinkIDMExternalStoreService.IDMUSER));
        TestPLIDMExternalStoreService.assertTrue((String)"'USER_MEMBERSHIPS' entity is not managed", (boolean)this.externalStoreService.getManagedEntityTypes().contains(IDMEntityType.USER_MEMBERSHIPS));
        TestPLIDMExternalStoreService.assertTrue((String)"'USER_PROFILE' entity is not managed", (boolean)this.externalStoreService.getManagedEntityTypes().contains(IDMEntityType.USER_PROFILE));
        TestPLIDMExternalStoreService.assertTrue((String)"'GROUP' entity is not managed", (boolean)this.externalStoreService.getManagedEntityTypes().contains(IDMEntityType.GROUP));
        TestPLIDMExternalStoreService.assertTrue((String)"'GROUP_MEMBERSHIPS' entity is not managed", (boolean)this.externalStoreService.getManagedEntityTypes().contains(IDMEntityType.GROUP_MEMBERSHIPS));
        TestPLIDMExternalStoreService.assertTrue((String)"'MEMBERSHIP' entity is not managed", (boolean)this.externalStoreService.getManagedEntityTypes().contains(IDMEntityType.MEMBERSHIP));
        ExoFallbackIdentityStoreRepository exoFallbackIdentityStoreRepository = this.externalStoreService.getFallbackStoreRepository();
        TestPLIDMExternalStoreService.assertTrue((String)"External Store Repository doesn't exist", (boolean)exoFallbackIdentityStoreRepository.hasExternalStore());
        TestPLIDMExternalStoreService.assertEquals((String)"External Store Repository name is incoherent", (String)"PortalLDAPStore", (String)exoFallbackIdentityStoreRepository.getExternalStoreId());
        TestPLIDMExternalStoreService.assertFalse((String)"External Store is not active", (boolean)exoFallbackIdentityStoreRepository.isUseExternalStore());
        TestPLIDMExternalStoreService.assertTrue((String)"External Identity Store implementation is not recognized", (boolean)(exoFallbackIdentityStoreRepository.getExternalIdentityStore() instanceof ExoLDAPIdentityStoreImpl));
        TestPLIDMExternalStoreService.assertTrue((String)"Internal Identity Store implementation is not recognized", (boolean)(exoFallbackIdentityStoreRepository.getDefaultIdentityStore() instanceof ExoHibernateIdentityStoreImpl));
    }

    public void testAuthenticateNewUser() throws Exception {
        String username = "jduke1";
        String password = "theduke";
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
        this.createLDAPGroup("User");
        this.createLDAPGroup("Echo");
        User user = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertNull((String)("User '" + username + "' shouldn't exist in internal store"), (Object)user);
        UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
        TestPLIDMExternalStoreService.assertTrue((String)("User Profile '" + username + "' shouldn't exist in internal store"), (userProfile == null || userProfile.getUserInfoMap() == null || userProfile.getUserInfoMap().isEmpty() ? 1 : 0) != 0);
        ListAccess allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"Initial users count in internal store should be 0", (int)0, (int)allusers.getSize());
        boolean authenticated = this.organizationService.getUserHandler().authenticate(username, "fakePassword");
        TestPLIDMExternalStoreService.assertFalse((String)("User '" + username + "' shouldn't be able to authenticate with wrong password"), (boolean)authenticated);
        user = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertNull((String)("User '" + username + "' shouldn't be added on internal store if not authenticated"), (Object)user);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"No user should be added on internal store when no successful auhentication is made", (int)0, (int)allusers.getSize());
        TestPLIDMExternalStoreService.assertEquals((String)"User add listener shouldn't be triggered when the no user is added on internal store", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"User modify listener shouldn't be triggered when the no user is modified on internal store", (int)0, (int)this.listenerModifyUser.get());
        authenticated = this.organizationService.getUserHandler().authenticate(username, password);
        TestPLIDMExternalStoreService.assertTrue((String)("The user '" + username + "' should be authenticated on external store"), (boolean)authenticated);
        user = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertNotNull((String)"The user should be added on internal store", (Object)user);
        TestPLIDMExternalStoreService.assertEquals((String)"The user first name attribute should be the same in internal and external stores", (String)"Java Duke1", (String)user.getFirstName());
        TestPLIDMExternalStoreService.assertEquals((String)"The user last name attribute should be the same in internal and external stores", (String)"Duke1", (String)user.getLastName());
        TestPLIDMExternalStoreService.assertEquals((String)"The user email attribute should be the same in internal and external stores", (String)"email@email.com", (String)user.getEmail());
        TestPLIDMExternalStoreService.assertFalse((String)"The user should be recognized as coming from external store", (boolean)user.isInternalStore());
        TestPLIDMExternalStoreService.assertEquals((String)("The listener 'user creation' should be triggered once the user '" + username + "' is successfully authenticated"), (int)1, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)("The listener 'user modification' shouldn't be triggered once the user '" + username + "' is successfully authenticated and created on internal store"), (int)0, (int)this.listenerModifyUser.get());
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)("Exactly one user should exist in internal store once user '" + username + "' successfully authenticated"), (int)1, (int)allusers.getSize());
        userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
        TestPLIDMExternalStoreService.assertNotNull((String)("User Profile of '" + username + "' should exist in internal store once authenticated"), (Object)userProfile);
        TestPLIDMExternalStoreService.assertNotNull((String)("User Profile of '" + username + "' should have at least one attribute switch PLIDM LDAP configuration mapping"), (Object)userProfile.getUserInfoMap());
        TestPLIDMExternalStoreService.assertEquals((String)("User Profile of '" + username + "' should have at the attribute 'user.name.nickName' stored in internal store switch PLIDM LDAP configuration mapping"), (String)"Duke1", (String)userProfile.getAttribute(NICKNAME_PARAM));
        Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUser(username);
        TestPLIDMExternalStoreService.assertNotNull((String)("Memberships of user '" + username + "' should be imported from external store once successfully authenticated"), (Object)memberships);
        TestPLIDMExternalStoreService.assertTrue((String)("Memberships of user '" + username + "' should be imported from external store once successfully authenticated, thus it has to be greater than 0"), (memberships.size() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (Membership membership : memberships) {
            found |= membership.getGroupId().equals("/role_hierarchy/Echo");
        }
        TestPLIDMExternalStoreService.assertTrue((String)"Membership 'member:/role_hierarchy/Echo' should be found on internal store once the user successfully authenticated", (boolean)found);
    }

    public void testAuthenticateNewUserWithExceptionOnListener() throws Exception {
        Listener<IDMExternalStoreService, User> exceptionListener = new Listener<IDMExternalStoreService, User>(this){

            public void onEvent(Event<IDMExternalStoreService, User> event) throws Exception {
                throw new Exception("Fake exception !"){

                    @Override
                    public void printStackTrace(PrintStream s) {
                    }

                    @Override
                    public void printStackTrace(PrintWriter s) {
                    }

                    @Override
                    public void printStackTrace() {
                    }
                };
            }
        };
        this.listenerService.addListener("exo.idm.externalStore.user.new", (ListenerBase)exceptionListener);
        this.testAuthenticateNewUser();
    }

    public void testAuthenticateNewUserWithExceptionOnCreate() throws Exception {
        this.organizationService.getUserHandler().addUserEventListener(this.errorOnUserEventListener);
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
        User user = this.organizationService.getUserHandler().findUserByName("jduke1");
        TestPLIDMExternalStoreService.assertNull((String)"User 'jduke1' shouldn't exist in internal store", (Object)user);
        ListAccess allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"No user should be added on internal store when no successful auhentication is made", (int)0, (int)allusers.getSize());
        try {
            this.externalStoreService.authenticate("jduke1", "theduke");
            TestPLIDMExternalStoreService.fail((String)"The authentication should fail when the user creation fails");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered once the user 'jduke1' authentication fails", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' shouldn't be triggered once the user 'jduke1' authentication fails", (int)0, (int)this.listenerModifyUser.get());
        user = this.organizationService.getUserHandler().findUserByName("jduke1");
        TestPLIDMExternalStoreService.assertNull((String)"The user 'jduke1' shouldn't be imported on internal store given the authentication has failed", (Object)user);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"No uer should exist on internal store given the authentication has failed", (int)0, (int)allusers.getSize());
    }

    public void testAuthenticateExistingUserInInternalStore() throws Exception {
        String username = "jduke1";
        String internalStorePassword = "password";
        String externalStorePassword = "theduke";
        this.createUser(username, externalStorePassword);
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
        User user = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertNotNull((String)("The user '" + username + "' has been created on internal store, thus it should exist"), (Object)user);
        ListAccess allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"Only one user should exist on internal store", (int)1, (int)allusers.getSize());
        boolean authenticated = this.organizationService.getUserHandler().authenticate(username, "fakePassword");
        TestPLIDMExternalStoreService.assertFalse((String)("The user '" + username + "' shouldn't be able to authenticated using a wrong password"), (boolean)authenticated);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"Only one user should exist on internal store", (int)1, (int)allusers.getSize());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered when the user authentication fails", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' shouldn't be triggered when the user authentication fails", (int)0, (int)this.listenerModifyUser.get());
        authenticated = this.organizationService.getUserHandler().authenticate(username, internalStorePassword);
        TestPLIDMExternalStoreService.assertTrue((String)"The user should be able to authenticate using internal store password", (boolean)authenticated);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)("Only one user should exist on internal store once user '" + username + "' successfully authenticates using internal store password"), (int)1, (int)allusers.getSize());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered when the user authentication succeeds using internal store", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' shouldn't be triggered when the user authentication succeeds using internal store", (int)0, (int)this.listenerModifyUser.get());
        authenticated = this.organizationService.getUserHandler().authenticate(username, externalStorePassword);
        TestPLIDMExternalStoreService.assertTrue((String)("The user '" + username + "' should be able to authenticate using external store password"), (boolean)authenticated);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"Only one user should exist on internal store even after authentication succeeds on external store", (int)1, (int)allusers.getSize());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered when the user authentication succeeds using external store since it already exists", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' should be triggered when the user authentication succeeds using external store since its attributes are different on external store", (int)1, (int)this.listenerModifyUser.get());
    }

    public void testUserSwitchFromInternalStoreToExternalStore() throws Exception {
        String username = "jduke1";
        String internalStorePassword = "password";
        String externalStorePassword = "theduke";
        User user = (User)this.externalStoreService.getEntity(IDMEntityType.USER, (Object)username);
        user.setOriginatingStore(null);
        user.setPassword(internalStorePassword);
        this.organizationService.getUserHandler().createUser(user, true);
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
        user = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertNotNull((String)("The user '" + username + "' has been created on internal store, thus it should exist"), (Object)user);
        TestPLIDMExternalStoreService.assertTrue((String)("The user '" + username + "' has been created on internal store, thus it should be recognized as internal user"), (boolean)user.isInternalStore());
        ListAccess allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"Only one user should exist on internal store", (int)1, (int)allusers.getSize());
        boolean authenticated = this.organizationService.getUserHandler().authenticate(username, internalStorePassword);
        TestPLIDMExternalStoreService.assertTrue((String)("User '" + username + "' should be able to authenticate using internal store password since it's not yet recognized as external user"), (boolean)authenticated);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"Only one user should exist on internal store after successfully authenticated on internal store", (int)1, (int)allusers.getSize());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered when the user authentication succeeds using internal store", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' shouldn't be triggered when the user authentication succeeds using internal store", (int)0, (int)this.listenerModifyUser.get());
        authenticated = this.organizationService.getUserHandler().authenticate(username, externalStorePassword);
        TestPLIDMExternalStoreService.assertTrue((String)"User should be able to authenticate using external store password", (boolean)authenticated);
        allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"Only one user should exist on internal store after successfully authenticated on external store", (int)1, (int)allusers.getSize());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered when the user authentication succeeds using internal store", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' shouldn't be triggered when the user authentication succeeds using external store since the user attributes are still the same as on LDAP", (int)0, (int)this.listenerModifyUser.get());
        user = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertFalse((String)"The user should be recognized now as coming from external store", (boolean)user.isInternalStore());
        TestPLIDMExternalStoreService.assertEquals((String)"The user should be recognized now as coming from external store", (String)"external", (String)user.getOriginatingStore());
        authenticated = this.organizationService.getUserHandler().authenticate(username, internalStorePassword);
        TestPLIDMExternalStoreService.assertFalse((String)"The user shouldn't be able to authenticate using internal store password anymore once he's recognized as coming from external store to not have two valid passwords", (boolean)authenticated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPopulateUserInformationOnLogin() throws Exception {
        boolean updateInformationOnLogin = this.externalStoreService.isUpdateInformationOnLogin();
        this.externalStoreService.setUpdateInformationOnLogin(false);
        try {
            String username = "jduke1";
            String password = "theduke";
            User user = (User)this.externalStoreService.getEntity(IDMEntityType.USER, (Object)username);
            user.setOriginatingStore(null);
            user.setPassword(null);
            user.setFirstName(null);
            this.organizationService.getUserHandler().createUser(user, true);
            TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
            TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
            user = this.organizationService.getUserHandler().findUserByName(username);
            TestPLIDMExternalStoreService.assertNotNull((String)("The user '" + username + "' has been created on internal store, thus it should exist"), (Object)user);
            TestPLIDMExternalStoreService.assertNull((String)("The user '" + username + "' has been created on internal store and should have null firstName field"), (Object)user.getFirstName());
            TestPLIDMExternalStoreService.assertTrue((String)("The user '" + username + "' has been created on internal store, thus it should be recognized as internal user"), (boolean)user.isInternalStore());
            boolean authenticated = this.organizationService.getUserHandler().authenticate(username, password);
            TestPLIDMExternalStoreService.assertTrue((String)"User should be able to authenticate using external store password", (boolean)authenticated);
            TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered when the user authentication succeeds using internal store", (int)0, (int)this.listenerAddUser.get());
            TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' should be triggered once when the user authentication succeeds using external store since the user attributes are modified from LDAP", (int)1, (int)this.listenerModifyUser.get());
            user = this.organizationService.getUserHandler().findUserByName(username);
            TestPLIDMExternalStoreService.assertNotNull((String)"The user should be recognized now as coming from external store", (Object)user.getFirstName());
            TestPLIDMExternalStoreService.assertEquals((String)"The user should be recognized now as coming from external store", (String)"external", (String)user.getOriginatingStore());
        }
        finally {
            this.externalStoreService.setUpdateInformationOnLogin(updateInformationOnLogin);
        }
    }

    public void testExternalUserChangePassword() throws Exception {
        String username = "jduke1";
        String password = "theduke";
        boolean authenticated = this.organizationService.getUserHandler().authenticate(username, password);
        TestPLIDMExternalStoreService.assertTrue((String)"The user should be able to authenticate using external store password", (boolean)authenticated);
        User user = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertNotNull((String)"Once the user authenticated, it should be created on internal store", (Object)user);
        TestPLIDMExternalStoreService.assertFalse((String)"The user should be recognized as coming from external store", (boolean)user.isInternalStore());
        user.setPassword("newPassword");
        try {
            this.organizationService.getUserHandler().saveUser(user, true);
            TestPLIDMExternalStoreService.fail((String)"External user shouldn't be able to change password");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAuthenticateExistingUserWithExceptionOnListener() throws Exception {
        Listener<IDMExternalStoreService, User> exceptionListener = new Listener<IDMExternalStoreService, User>(this){

            public void onEvent(Event<IDMExternalStoreService, User> event) throws Exception {
                throw new Exception("Fake exception !"){

                    @Override
                    public void printStackTrace(PrintStream s) {
                    }

                    @Override
                    public void printStackTrace(PrintWriter s) {
                    }

                    @Override
                    public void printStackTrace() {
                    }
                };
            }
        };
        this.listenerService.addListener("exo.idm.externalStore.user.modified", (ListenerBase)exceptionListener);
        String username = "jduke1";
        String password = "theduke";
        this.createUser(username, null);
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
        User user = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertNotNull((String)"The user should exists o internal store once created", (Object)user);
        boolean authenticated = this.organizationService.getUserHandler().authenticate(username, "fakePassword");
        TestPLIDMExternalStoreService.assertFalse((String)"The user shouldn't be able to authenticate using wrong password", (boolean)authenticated);
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' shouldn't be triggered", (int)0, (int)this.listenerModifyUser.get());
        User foundUser = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertEquals((String)"The user email shouldn't be changed from external store since the authentication fails", (String)user.getEmail(), (String)foundUser.getEmail());
        authenticated = this.organizationService.getUserHandler().authenticate(username, password);
        TestPLIDMExternalStoreService.assertTrue((String)"The user should be able to authenticate using external store password", (boolean)authenticated);
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' should be triggered once the LDAP attributes are different from internal store attributes", (int)1, (int)this.listenerModifyUser.get());
        foundUser = this.organizationService.getUserHandler().findUserByName(username);
        TestPLIDMExternalStoreService.assertFalse((String)"The uer email should be changed using LDAP attribute value", (boolean)user.getEmail().equals(foundUser.getEmail()));
    }

    public void testAuthenticateExistingUserWithExceptionOnModify() throws Exception {
        this.organizationService.getUserHandler().addUserEventListener(this.errorOnUserEventListener);
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerAddUser invocation count must be 0", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"Initial listenerModifyUser invocation count must be 0", (int)0, (int)this.listenerModifyUser.get());
        ListAccess allusers = this.organizationService.getUserHandler().findAllUsers();
        TestPLIDMExternalStoreService.assertEquals((String)"No user should exists in internal store", (int)0, (int)allusers.getSize());
        try {
            this.externalStoreService.authenticate("jduke1", "theduke");
            TestPLIDMExternalStoreService.fail((String)"The authentication should fail when the user creation fails");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user creation' shouldn't be triggered when authentication fails", (int)0, (int)this.listenerAddUser.get());
        TestPLIDMExternalStoreService.assertEquals((String)"The listener 'user modification' shouldn't be triggered when authentication fails", (int)0, (int)this.listenerModifyUser.get());
    }

    public void testGetUserFromExternalStore() throws Exception {
        User user = (User)this.externalStoreService.getEntity(IDMEntityType.USER, (Object)"jduke1");
        TestPLIDMExternalStoreService.assertNotNull((String)"The user 'jduke1' should exist in external store", (Object)user);
        TestPLIDMExternalStoreService.assertEquals((String)"The user 'jduke1' first name should equals to external store attribute", (String)"Java Duke1", (String)user.getFirstName());
        TestPLIDMExternalStoreService.assertEquals((String)"The user 'jduke1' last name should equals to external store attribute", (String)"Duke1", (String)user.getLastName());
        TestPLIDMExternalStoreService.assertEquals((String)"The user 'jduke1' email should equals to external store attribute", (String)"email@email.com", (String)user.getEmail());
        this.createUser("testuser", "testuser");
        user = (User)this.externalStoreService.getEntity(IDMEntityType.USER, (Object)"testuser");
        TestPLIDMExternalStoreService.assertNull((String)"The created user 'testuser' on internal store shouldn't exist on external store", (Object)user);
    }

    public void testGetGroupFromExternalStore() throws Exception {
        Group group = this.organizationService.getGroupHandler().findGroupById("/organization_hierarchy/OrganizationC");
        TestPLIDMExternalStoreService.assertNull((String)"The Group '/organization_hierarchy/OrganizationC' shouldn't exist on internal store", (Object)group);
        group = (Group)this.externalStoreService.getEntity(IDMEntityType.GROUP, (Object)"/organization_hierarchy/OrganizationC");
        TestPLIDMExternalStoreService.assertNotNull((String)"The Group '/organization_hierarchy/OrganizationC' should exist on external store", (Object)group);
        TestPLIDMExternalStoreService.assertEquals((String)"OrganizationC", (String)group.getGroupName());
        TestPLIDMExternalStoreService.assertEquals((String)"OrganizationC", (String)group.getLabel());
        TestPLIDMExternalStoreService.assertEquals((String)"Some organization", (String)group.getDescription());
        TestPLIDMExternalStoreService.assertEquals((String)"/organization_hierarchy/OrganizationC", (String)group.getId());
        TestPLIDMExternalStoreService.assertEquals((String)"/organization_hierarchy", (String)group.getParentId());
        group = this.organizationService.getGroupHandler().findGroupById("/organization_hierarchy/OrganizationC");
        TestPLIDMExternalStoreService.assertNull((String)"The Group '/organization_hierarchy/OrganizationC' shouldn't exist on internal store once retrived from external store without explicit import operation", (Object)group);
        try {
            group = (Group)this.externalStoreService.getEntity(IDMEntityType.GROUP, (Object)"/organization_hierarchy");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestPLIDMExternalStoreService.assertNull((String)"Internal parent group '/organization_hierarchy' shouldn't exist on external store", (Object)group);
    }

    public void testGetMembershipFromExternalStore() throws Exception {
        String membershipId = "member:jduke1:/organization_hierarchy/OrganizationD";
        Membership membership = this.organizationService.getMembershipHandler().findMembership(membershipId);
        TestPLIDMExternalStoreService.assertNull((String)("Membership '" + membershipId + "' shouldn't exist on internal store"), (Object)membership);
        membership = (Membership)this.externalStoreService.getEntity(IDMEntityType.MEMBERSHIP, (Object)membershipId);
        TestPLIDMExternalStoreService.assertNotNull((String)("Membership '" + membershipId + "' should exist on external store"), (Object)membership);
        TestPLIDMExternalStoreService.assertEquals((String)"/organization_hierarchy/OrganizationD", (String)membership.getGroupId());
        TestPLIDMExternalStoreService.assertEquals((String)"jduke1", (String)membership.getUserName());
        TestPLIDMExternalStoreService.assertEquals((String)"member", (String)membership.getMembershipType());
        membership = this.organizationService.getMembershipHandler().findMembership(membershipId);
        TestPLIDMExternalStoreService.assertNull((String)("Membership '" + membershipId + "' shouldn't exist on internal store once retrieved from external store without explicit data import operation"), (Object)membership);
    }

    public void testGetUserMembershipsFromExternalStore() throws Exception {
        Collection memberships = (Collection)this.externalStoreService.getEntity(IDMEntityType.USER_MEMBERSHIPS, (Object)"jduke1");
        TestPLIDMExternalStoreService.assertEquals((String)"User 'jduke1' should have 3 memberships on external store", (int)3, (int)memberships.size());
        for (Object object : memberships) {
            Membership membership = (Membership)object;
            TestPLIDMExternalStoreService.assertEquals((String)"Mapped memberships from external store should have membership type = member", (String)"member", (String)membership.getMembershipType());
            TestPLIDMExternalStoreService.assertEquals((String)"User 'jduke1' memberships should have username = 'jduke1'", (String)"jduke1", (String)membership.getUserName());
            if (membership.getGroupId().equals("/organization_hierarchy/OrganizationD") || membership.getGroupId().equals("/role_hierarchy/Echo") || membership.getGroupId().equals("/role_hierarchy/User")) continue;
            TestPLIDMExternalStoreService.fail((String)("Group id '" + membership.getGroupId() + "' is not expected"));
        }
    }

    public void testGetGroupMembershipsFromExternalStore() throws Exception {
        List membershipsList = (List)this.externalStoreService.getEntity(IDMEntityType.GROUP_MEMBERSHIPS, (Object)"/organization_hierarchy/OrganizationD");
        TestPLIDMExternalStoreService.assertNotNull((String)"Group '/organization_hierarchy/OrganizationD' should have memberships on external store", (Object)membershipsList);
        TestPLIDMExternalStoreService.assertEquals((String)"Group '/organization_hierarchy/OrganizationD' should have 3 memberships on external store", (int)3, (int)membershipsList.size());
        for (Object object : membershipsList) {
            Membership membership = (Membership)object;
            TestPLIDMExternalStoreService.assertEquals((String)"Mapped memberships from external store should have membership type = member", (String)"member", (String)membership.getMembershipType());
            TestPLIDMExternalStoreService.assertEquals((String)"Group '/organization_hierarchy/OrganizationD' memberships should have groupId = '/organization_hierarchy/OrganizationD'", (String)"/organization_hierarchy/OrganizationD", (String)membership.getGroupId());
            if (membership.getUserName().equals("jduke") || membership.getUserName().equals("jduke1") || membership.getUserName().equals("jduke2")) continue;
            TestPLIDMExternalStoreService.fail((String)("Username '" + membership.getUserName() + "' is not expected"));
        }
    }

    public void testGetAllUsers() throws Exception {
        String rdbmsuser = "rdbmsuser";
        this.createUser(rdbmsuser, "password");
        ListAccess allUsersListAccess = this.externalStoreService.getAllOfType(IDMEntityType.USER, null);
        String[] usernames = (String[])allUsersListAccess.load(0, Integer.MAX_VALUE);
        TestPLIDMExternalStoreService.assertNotNull((String)"No user was found on external store", (Object)usernames);
        TestPLIDMExternalStoreService.assertTrue((String)"No user was found on external store", (usernames.length > 0 ? 1 : 0) != 0);
        for (String username : usernames) {
            TestPLIDMExternalStoreService.assertFalse((String)"Internal user 'rdbmsuser' shouldn't be retrieved from external store query", (boolean)rdbmsuser.equals(username));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetModifiedUsers() throws Exception {
        LocalDateTime searchDate = this.getLocalDateTime().minusSeconds(1L);
        this.openDSService.populateLDIFFile("ldap/ldap/test-user-modification-opends.ldif");
        Thread.sleep(1000L);
        try {
            ListAccess modifiedUsersListAccess = this.externalStoreService.getAllOfType(IDMEntityType.USER, searchDate);
            String[] usernames = (String[])modifiedUsersListAccess.load(0, Integer.MAX_VALUE);
            TestPLIDMExternalStoreService.assertNotNull((String)"No user was detected as modified", (Object)usernames);
            TestPLIDMExternalStoreService.assertEquals((String)"Detected modified users count should equal to 2", (int)2, (int)usernames.length);
            for (String username : usernames) {
                TestPLIDMExternalStoreService.assertTrue((String)("Detected modified user '" + username + "' isn't expected"), ("jduke11".equals(username) || "jduke10".equals(username) ? 1 : 0) != 0);
            }
        }
        finally {
            this.openDSService.cleanUpDN("uid=jduke10,ou=People,o=test,dc=portal,dc=example,dc=com");
            this.openDSService.cleanUpDN("uid=jduke11,ou=People,o=test,dc=portal,dc=example,dc=com");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetModifiedGroups() throws Exception {
        LocalDateTime searchDate = this.getLocalDateTime().minusSeconds(1L);
        ListAccess modifiedGroupsListAccess = this.externalStoreService.getAllOfType(IDMEntityType.GROUP, null);
        String[] groupIds = (String[])modifiedGroupsListAccess.load(0, Integer.MAX_VALUE);
        TestPLIDMExternalStoreService.assertNotNull((Object)groupIds);
        TestPLIDMExternalStoreService.assertEquals((String)"LDAP Groups count is incoherent", (int)8, (int)groupIds.length);
        this.openDSService.populateLDIFFile("ldap/ldap/test-group-modification-opends.ldif");
        Thread.sleep(1000L);
        try {
            modifiedGroupsListAccess = this.externalStoreService.getAllOfType(IDMEntityType.GROUP, null);
            groupIds = (String[])modifiedGroupsListAccess.load(0, Integer.MAX_VALUE);
            TestPLIDMExternalStoreService.assertNotNull((Object)groupIds);
            TestPLIDMExternalStoreService.assertEquals((String)"LDAP Groups count is incoherent after single group import", (int)9, (int)groupIds.length);
            modifiedGroupsListAccess = this.externalStoreService.getAllOfType(IDMEntityType.GROUP, searchDate);
            groupIds = (String[])modifiedGroupsListAccess.load(0, Integer.MAX_VALUE);
            TestPLIDMExternalStoreService.assertNotNull((String)"No modified group is detected", (Object)groupIds);
            TestPLIDMExternalStoreService.assertTrue((String)("Detected modified group count is incoherent, it should be greater or equal to 1, got " + groupIds.length), (groupIds.length >= 1 ? 1 : 0) != 0);
            boolean found = false;
            for (String groupId : groupIds) {
                if (!groupId.equals("/role_hierarchy/Delta")) continue;
                found = true;
            }
            TestPLIDMExternalStoreService.assertTrue((String)"Added group '/role_hierarchy/Delta' on external store should have been detected.", (boolean)found);
        }
        finally {
            this.openDSService.cleanUpDN("cn=Delta,ou=Roles,o=test,dc=portal,dc=example,dc=com");
        }
    }

    private User createUser(String username, String password) throws Exception {
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.createUserInstance(username);
        if (StringUtils.isNotBlank((CharSequence)password)) {
            user.setPassword("password");
        }
        user.setFirstName("default");
        user.setLastName("default");
        user.setEmail(username + "@exoportal.org");
        try {
            userHandler.createUser(user, true);
            return user;
        }
        catch (Exception e) {
            TestPLIDMExternalStoreService.fail((String)("Error on create user " + user.getUserName()), (Throwable)e);
            throw e;
        }
    }

    private void removeGroupTree(Group group) throws Exception {
        Collection groups = this.organizationService.getGroupHandler().findGroups(group);
        if (groups != null && groups.size() > 0) {
            for (Group childgroup : groups) {
                this.removeGroupTree(childgroup);
            }
        }
        if (group != null) {
            this.organizationService.getGroupHandler().removeGroup(group, true);
        }
    }

    private LocalDateTime getLocalDateTime() {
        return ZonedDateTime.now(ZoneId.of("UTC")).toLocalDateTime();
    }

    private void createLDAPGroup(String groupName) throws Exception {
        Group parentLDAPGroup = this.organizationService.getGroupHandler().findGroupById("/role_hierarchy");
        if (parentLDAPGroup == null) {
            TestPLIDMExternalStoreService.fail((String)"Parent LDAP Group /role_hierarchy wasn't created");
        }
        Group ldapGroup = this.organizationService.getGroupHandler().createGroupInstance();
        ldapGroup.setId("/role_hierarchy/" + groupName);
        ldapGroup.setGroupName(groupName);
        this.organizationService.getGroupHandler().addChild(parentLDAPGroup, ldapGroup, true);
    }
}

