/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore;

import exo.portal.component.identiy.opendsconfig.opends.OpenDSService;
import java.util.List;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.externalstore.PicketLinkIDMExternalStoreService;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/exo.portal.component.identity-ldap-parameterized-configuration.xml")})
public class TestLDAPAsExternalStoreParameterized
extends AbstractKernelTest {
    OpenDSService openDSService = new OpenDSService(null);
    PicketLinkIDMOrganizationServiceImpl organizationService;
    PicketLinkIDMServiceImpl idmService;
    PicketLinkIDMExternalStoreService externalStoreService;

    protected void beforeRunBare() {
        try {
            this.openDSService.start();
            this.openDSService.initLDAPServer();
        }
        catch (Exception e) {
            this.log.error((Object)"Error in starting up OPENDS", (Throwable)e);
            e.printStackTrace();
        }
        super.beforeRunBare();
    }

    protected void tearDown() throws Exception {
        this.end();
        super.tearDown();
    }

    public void testParameterizedConfigurationWithDefaultValues() {
        this.setForceContainerReload(true);
        this.beforeClass();
        this.idmService = (PicketLinkIDMServiceImpl)this.getContainer().getComponentInstanceOfType(PicketLinkIDMService.class);
        this.begin();
        IdentityConfigurationMetaData configMD = this.idmService.getConfigMD();
        IdentityStoreConfigurationMetaData portalLDAPStore = configMD.getIdentityStores().stream().filter(store -> store.getId().equals("PortalLDAPStore")).findFirst().get();
        TestLDAPAsExternalStoreParameterized.assertEquals((String)"ldap://localhost:1389", (String)((String)((List)portalLDAPStore.getOptions().get("providerURL")).get(0)));
        TestLDAPAsExternalStoreParameterized.assertEquals((String)"cn=admin", (String)((String)((List)portalLDAPStore.getOptions().get("adminDN")).get(0)));
        TestLDAPAsExternalStoreParameterized.assertEquals((String)"", (String)((String)((List)portalLDAPStore.getOptions().get("adminPassword")).get(0)));
        IdentityObjectTypeMetaData userIdentityObjectTypeMD = portalLDAPStore.getSupportedIdentityTypes().stream().filter(identityType -> identityType.getName().equals("USER")).findFirst().get();
        List usersCtxDNs = (List)userIdentityObjectTypeMD.getOptions().get("ctxDNs");
        TestLDAPAsExternalStoreParameterized.assertNotNull((Object)usersCtxDNs);
        TestLDAPAsExternalStoreParameterized.assertEquals((int)1, (int)usersCtxDNs.size());
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)usersCtxDNs.contains("ou=users,dc=company,dc=org"));
        List userAttributes = userIdentityObjectTypeMD.getAttributes();
        TestLDAPAsExternalStoreParameterized.assertNotNull((Object)userAttributes);
        TestLDAPAsExternalStoreParameterized.assertEquals((int)3, (int)userAttributes.size());
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)userAttributes.stream().anyMatch(attribute -> attribute.getName().equals("firstName") && attribute.getStoreMapping().equals("cn")));
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)userAttributes.stream().anyMatch(attribute -> attribute.getName().equals("lastName") && attribute.getStoreMapping().equals("sn")));
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)userAttributes.stream().anyMatch(attribute -> attribute.getName().equals("email") && attribute.getStoreMapping().equals("mail")));
        IdentityObjectTypeMetaData groupIdentityObjectTypeMD = portalLDAPStore.getSupportedIdentityTypes().stream().filter(identityType -> identityType.getName().equals("GROUP")).findFirst().get();
        List groupsCtxDNs = (List)groupIdentityObjectTypeMD.getOptions().get("ctxDNs");
        TestLDAPAsExternalStoreParameterized.assertNotNull((Object)groupsCtxDNs);
        TestLDAPAsExternalStoreParameterized.assertEquals((int)1, (int)groupsCtxDNs.size());
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)groupsCtxDNs.contains("ou=groups,dc=company,dc=org"));
    }

    public void testParameterizedConfigurationWithCustomizedValues() {
        System.setProperty("exo.ldap.url", "ldap://localhost:10389");
        System.setProperty("exo.ldap.admin.dn", "cn=Directory Manager");
        System.setProperty("exo.ldap.admin.password", "password");
        System.setProperty("exo.ldap.users.base.dn", "ou=users1,dc=company,dc=org;ou=users2,dc=company,dc=org;ou=users3,dc=company,dc=org");
        System.setProperty("exo.ldap.groups.base.dn", "ou=group1,dc=company,dc=org");
        System.setProperty("exo.ldap.users.attributes.custom.names", "customAttribute1,customAttribute2");
        System.setProperty("exo.ldap.users.attributes.customAttribute1.mapping", "ldapAttribute1");
        System.setProperty("exo.ldap.users.attributes.customAttribute1.type", "text");
        System.setProperty("exo.ldap.users.attributes.customAttribute1.isRequired", "true");
        System.setProperty("exo.ldap.users.attributes.customAttribute1.isMultivalued", "true");
        System.setProperty("exo.ldap.users.attributes.customAttribute2.mapping", "ldapAttribute2");
        System.setProperty("exo.ldap.users.attributes.customAttribute2.type", "text");
        System.setProperty("exo.ldap.users.attributes.customAttribute2.isRequired", "false");
        System.setProperty("exo.ldap.users.attributes.customAttribute2.isMultivalued", "true");
        this.setForceContainerReload(true);
        this.beforeClass();
        this.idmService = (PicketLinkIDMServiceImpl)this.getContainer().getComponentInstanceOfType(PicketLinkIDMService.class);
        this.begin();
        IdentityConfigurationMetaData configMD = this.idmService.getConfigMD();
        IdentityStoreConfigurationMetaData portalLDAPStore = configMD.getIdentityStores().stream().filter(store -> store.getId().equals("PortalLDAPStore")).findFirst().get();
        TestLDAPAsExternalStoreParameterized.assertEquals((String)"ldap://localhost:10389", (String)((String)((List)portalLDAPStore.getOptions().get("providerURL")).get(0)));
        TestLDAPAsExternalStoreParameterized.assertEquals((String)"cn=Directory Manager", (String)((String)((List)portalLDAPStore.getOptions().get("adminDN")).get(0)));
        TestLDAPAsExternalStoreParameterized.assertEquals((String)"password", (String)((String)((List)portalLDAPStore.getOptions().get("adminPassword")).get(0)));
        IdentityObjectTypeMetaData userIdentityObjectTypeMD = portalLDAPStore.getSupportedIdentityTypes().stream().filter(identityType -> identityType.getName().equals("USER")).findFirst().get();
        List ctxDNs = (List)userIdentityObjectTypeMD.getOptions().get("ctxDNs");
        TestLDAPAsExternalStoreParameterized.assertNotNull((Object)ctxDNs);
        TestLDAPAsExternalStoreParameterized.assertEquals((int)3, (int)ctxDNs.size());
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)ctxDNs.contains("ou=users1,dc=company,dc=org"));
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)ctxDNs.contains("ou=users2,dc=company,dc=org"));
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)ctxDNs.contains("ou=users3,dc=company,dc=org"));
        List userAttributes = userIdentityObjectTypeMD.getAttributes();
        TestLDAPAsExternalStoreParameterized.assertNotNull((Object)userAttributes);
        TestLDAPAsExternalStoreParameterized.assertEquals((int)5, (int)userAttributes.size());
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)userAttributes.stream().anyMatch(attribute -> attribute.getName().equals("firstName") && attribute.getStoreMapping().equals("cn")));
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)userAttributes.stream().anyMatch(attribute -> attribute.getName().equals("lastName") && attribute.getStoreMapping().equals("sn")));
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)userAttributes.stream().anyMatch(attribute -> attribute.getName().equals("email") && attribute.getStoreMapping().equals("mail")));
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)userAttributes.stream().anyMatch(attribute -> attribute.getName().equals("customAttribute1") && attribute.getStoreMapping().equals("ldapAttribute1")));
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)userAttributes.stream().anyMatch(attribute -> attribute.getName().equals("customAttribute2") && attribute.getStoreMapping().equals("ldapAttribute2")));
        IdentityObjectTypeMetaData groupIdentityObjectTypeMD = portalLDAPStore.getSupportedIdentityTypes().stream().filter(identityType -> identityType.getName().equals("GROUP")).findFirst().get();
        List groupsCtxDNs = (List)groupIdentityObjectTypeMD.getOptions().get("ctxDNs");
        TestLDAPAsExternalStoreParameterized.assertNotNull((Object)groupsCtxDNs);
        TestLDAPAsExternalStoreParameterized.assertEquals((int)1, (int)groupsCtxDNs.size());
        TestLDAPAsExternalStoreParameterized.assertTrue((boolean)groupsCtxDNs.contains("ou=group1,dc=company,dc=org"));
        System.clearProperty("exo.ldap.url");
        System.clearProperty("exo.ldap.admin.dn");
        System.clearProperty("exo.ldap.admin.password");
        System.clearProperty("exo.ldap.users.base.dn");
        System.clearProperty("exo.ldap.groups.base.dn");
        System.clearProperty("exo.ldap.users.attributes.custom.names");
        System.clearProperty("exo.ldap.users.attributes.customAttribute1.mapping");
        System.clearProperty("exo.ldap.users.attributes.customAttribute1.type");
        System.clearProperty("exo.ldap.users.attributes.customAttribute1.isRequired");
        System.clearProperty("exo.ldap.users.attributes.customAttribute1.isMultivalued");
        System.clearProperty("exo.ldap.users.attributes.customAttribute2.mapping");
        System.clearProperty("exo.ldap.users.attributes.customAttribute2.type");
        System.clearProperty("exo.ldap.users.attributes.customAttribute2.isRequired");
        System.clearProperty("exo.ldap.users.attributes.customAttribute2.isMultivalued");
        PropertyManager.refresh();
    }
}

