/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore.jpa;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.externalstore.IDMQueueService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.services.organization.externalstore.model.IDMOperationType;
import org.exoplatform.services.organization.externalstore.model.IDMQueueEntry;
import org.exoplatform.services.organization.idm.externalstore.jpa.IDMQueueDAO;
import org.junit.Test;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/idm-queue-configuration.xml")})
public class TestIDMQueueService
extends AbstractKernelTest {
    PortalContainer container;
    IDMQueueService queueService = null;
    IDMQueueDAO queueDAO = null;

    protected void beforeRunBare() {
        try {
            super.beforeRunBare();
            this.container = PortalContainer.getInstance();
            this.queueService = (IDMQueueService)this.container.getComponentInstanceOfType(IDMQueueService.class);
            this.queueDAO = (IDMQueueDAO)this.container.getComponentInstanceOfType(IDMQueueDAO.class);
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
        }
        catch (Exception e) {
            TestIDMQueueService.fail((Throwable)e);
        }
    }

    protected void afterRunBare() {
        try {
            this.queueDAO.deleteAll();
            TestIDMQueueService.assertEquals((String)"Number of entries must be 0 before any test runs.", (int)0, (int)this.queueService.countAll());
        }
        catch (Exception e) {
            TestIDMQueueService.fail((Throwable)e);
        }
        super.afterRunBare();
        RequestLifeCycle.end();
    }

    @Test
    public void testPush() throws Exception {
        TestIDMQueueService.assertEquals((String)"Queue must be initially empty", (int)0, (int)this.queueService.countAll());
        this.queueService.push(new IDMQueueEntry(IDMEntityType.USER, "testuser", IDMOperationType.ADD_OR_UPDATE));
        this.queueService.push(new IDMQueueEntry(IDMEntityType.USER, "testuser2", IDMOperationType.DELETE));
        TestIDMQueueService.assertEquals((String)"Two new pushed elements must be detected", (int)2, (int)this.queueService.countAll());
    }

    @Test
    public void testPop() throws Exception {
        TestIDMQueueService.assertEquals((String)"Queue must be initially empty", (int)0, (int)this.queueService.countAll());
        this.queueService.push(new IDMQueueEntry(IDMEntityType.USER, "testuser", IDMOperationType.ADD_OR_UPDATE));
        this.queueService.push(new IDMQueueEntry(IDMEntityType.USER, "testuser2", IDMOperationType.DELETE));
        IDMQueueEntry entryInError = new IDMQueueEntry(IDMEntityType.USER, "testuser3", IDMOperationType.ADD_OR_UPDATE);
        entryInError.setRetryCount(1);
        this.queueService.push(entryInError);
        IDMQueueEntry entryProcessed = new IDMQueueEntry(IDMEntityType.USER, "testuser4", IDMOperationType.ADD_OR_UPDATE);
        entryProcessed.setProcessed(true);
        this.queueService.push(entryProcessed);
        TestIDMQueueService.assertEquals((String)"Only not processed and retry < maxRetries should be recognized.", (int)3, (int)this.queueService.countAll());
        TestIDMQueueService.assertEquals((String)"Only two entries are not processed and have nbRetries == 0.", (int)2, (int)this.queueService.count(0));
        TestIDMQueueService.assertEquals((String)"Only one entry is not processed and have nbRetries == 1.", (int)1, (int)this.queueService.count(1));
        TestIDMQueueService.assertEquals((String)"Only one entry is requested which has't been processed and have nbRetries == 0.", (int)1, (int)this.queueService.pop(1, 0, true).size());
        TestIDMQueueService.assertEquals((String)"Only two entries are requested which have't been processed and have nbRetries == 0.", (int)2, (int)this.queueService.pop(2, 0, true).size());
        TestIDMQueueService.assertEquals((String)"Only two entries are existing in queue which have't been processed and have nbRetries == 0.", (int)2, (int)this.queueService.pop(100, 0, true).size());
        TestIDMQueueService.assertEquals((String)"Only one entry is existing in queue which has't been processed and have nbRetries == 1.", (int)1, (int)this.queueService.pop(100, 1, true).size());
        TestIDMQueueService.assertEquals((String)"No entry is existing in queue which has't been processed and have nbRetries == 2.", (int)0, (int)this.queueService.pop(100, 2, true).size());
        List entities = this.queueService.pop(1, 1, false);
        TestIDMQueueService.assertEquals((String)"Only one entry is existing in queue which has't been processed and have nbRetries == 1.", (int)1, (int)entities.size());
        TestIDMQueueService.assertEquals((String)"Queue entry should has nbRetries == 1.", (int)1, (int)((IDMQueueEntry)entities.get(0)).getRetryCount());
        TestIDMQueueService.assertEquals((String)"Queue entry should has id = 'testuser3'.", (String)"testuser3", (String)((IDMQueueEntry)entities.get(0)).getEntityId());
        TestIDMQueueService.assertEquals((String)"No entry should exists in queue which has't been processed and have nbRetries == 1.", (int)0, (int)this.queueService.count(1));
        entities = this.queueService.pop(1, 0, false);
        TestIDMQueueService.assertEquals((String)"Only one entry is requested which has't been processed and have nbRetries == 0.", (int)1, (int)entities.size());
        TestIDMQueueService.assertEquals((String)"One entry is requested which has't been processed and have nbRetries == 0. Thus nbRetries should equals to 0.", (int)0, (int)((IDMQueueEntry)entities.get(0)).getRetryCount());
        TestIDMQueueService.assertEquals((String)"Last added entry should be retrieved", (String)"testuser2", (String)((IDMQueueEntry)entities.get(0)).getEntityId());
        TestIDMQueueService.assertEquals((String)"The last request 'pop' operation should delete the requested entry. Thus, only one entry should remaining that has't been processed and have nbRetries == 0.", (int)1, (int)this.queueService.count(0));
    }

    @Test
    public void testLastCheckedTime() throws Exception {
        TestIDMQueueService.assertNotNull((Object)this.getLocalDateTime());
        TestIDMQueueService.assertNull((Object)this.queueService.getLastCheckedTime(IDMEntityType.USER));
        TestIDMQueueService.assertNull((Object)this.queueService.getLastCheckedTime(IDMEntityType.ROLE));
        TestIDMQueueService.assertNull((Object)this.queueService.getLastCheckedTime(IDMEntityType.GROUP));
        LocalDateTime userCheckedTime = this.getLocalDateTime();
        this.queueService.setLastCheckedTime(IDMEntityType.USER, userCheckedTime);
        TestIDMQueueService.assertEquals((Object)userCheckedTime, (Object)this.queueService.getLastCheckedTime(IDMEntityType.USER));
        TestIDMQueueService.assertNull((Object)this.queueService.getLastCheckedTime(IDMEntityType.ROLE));
        TestIDMQueueService.assertNull((Object)this.queueService.getLastCheckedTime(IDMEntityType.GROUP));
        userCheckedTime = this.getLocalDateTime();
        this.queueService.setLastCheckedTime(IDMEntityType.USER, userCheckedTime);
        TestIDMQueueService.assertEquals((Object)userCheckedTime, (Object)this.queueService.getLastCheckedTime(IDMEntityType.USER));
        TestIDMQueueService.assertNull((Object)this.queueService.getLastCheckedTime(IDMEntityType.ROLE));
        TestIDMQueueService.assertNull((Object)this.queueService.getLastCheckedTime(IDMEntityType.GROUP));
        LocalDateTime groupCheckedTime = this.getLocalDateTime();
        this.queueService.setLastCheckedTime(IDMEntityType.GROUP, groupCheckedTime);
        TestIDMQueueService.assertEquals((Object)userCheckedTime, (Object)this.queueService.getLastCheckedTime(IDMEntityType.USER));
        TestIDMQueueService.assertEquals((Object)groupCheckedTime, (Object)this.queueService.getLastCheckedTime(IDMEntityType.GROUP));
        TestIDMQueueService.assertNull((Object)this.queueService.getLastCheckedTime(IDMEntityType.ROLE));
        LocalDateTime roleCheckedTime = this.getLocalDateTime();
        this.queueService.setLastCheckedTime(IDMEntityType.ROLE, roleCheckedTime);
        TestIDMQueueService.assertEquals((Object)userCheckedTime, (Object)this.queueService.getLastCheckedTime(IDMEntityType.USER));
        TestIDMQueueService.assertEquals((Object)groupCheckedTime, (Object)this.queueService.getLastCheckedTime(IDMEntityType.GROUP));
        TestIDMQueueService.assertEquals((Object)roleCheckedTime, (Object)this.queueService.getLastCheckedTime(IDMEntityType.ROLE));
    }

    @Test
    public void testProcessed() throws Exception {
        TestIDMQueueService.assertEquals((String)"Queue must be initially empty", (int)0, (int)this.queueService.countAll());
        this.queueService.push(new IDMQueueEntry(IDMEntityType.USER, "testuser", IDMOperationType.ADD_OR_UPDATE));
        this.queueService.push(new IDMQueueEntry(IDMEntityType.USER, "testuser2", IDMOperationType.DELETE));
        IDMQueueEntry entryInError = new IDMQueueEntry(IDMEntityType.USER, "testuser3", IDMOperationType.ADD_OR_UPDATE);
        entryInError.setRetryCount(1);
        this.queueService.push(entryInError);
        IDMQueueEntry entryProcessed = new IDMQueueEntry(IDMEntityType.USER, "testuser4", IDMOperationType.ADD_OR_UPDATE);
        entryProcessed.setProcessed(true);
        this.queueService.push(entryProcessed);
        TestIDMQueueService.assertEquals((int)3, (int)this.queueService.countAll());
        TestIDMQueueService.assertEquals((int)2, (int)this.queueService.count(0));
        TestIDMQueueService.assertEquals((int)1, (int)this.queueService.count(1));
        List entities = this.queueService.pop(1, 0, true);
        TestIDMQueueService.assertEquals((int)1, (int)entities.size());
        TestIDMQueueService.assertFalse((boolean)((IDMQueueEntry)entities.get(0)).isProcessed());
        TestIDMQueueService.assertEquals((int)0, (int)((IDMQueueEntry)entities.get(0)).getRetryCount());
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ExoContainer)this.container);
        this.queueService.storeAsProcessed(entities);
        TestIDMQueueService.assertEquals((int)2, (int)this.queueService.countAll());
        TestIDMQueueService.assertEquals((int)1, (int)this.queueService.count(0));
        TestIDMQueueService.assertEquals((int)1, (int)this.queueService.count(1));
        entities = this.queueService.pop(1, 0, true);
        TestIDMQueueService.assertEquals((int)1, (int)entities.size());
        TestIDMQueueService.assertFalse((boolean)((IDMQueueEntry)entities.get(0)).isProcessed());
        TestIDMQueueService.assertEquals((int)0, (int)((IDMQueueEntry)entities.get(0)).getRetryCount());
        this.queueService.deleteProcessedEntries();
        TestIDMQueueService.assertEquals((int)2, (int)this.queueService.countAll());
        TestIDMQueueService.assertEquals((int)1, (int)this.queueService.count(0));
        TestIDMQueueService.assertEquals((int)1, (int)this.queueService.count(1));
        entities = this.queueService.pop(1, 0, true);
        TestIDMQueueService.assertEquals((int)1, (int)entities.size());
        TestIDMQueueService.assertFalse((boolean)((IDMQueueEntry)entities.get(0)).isProcessed());
        TestIDMQueueService.assertEquals((int)0, (int)((IDMQueueEntry)entities.get(0)).getRetryCount());
    }

    @Test
    public void testIncrementRetry() throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        TestIDMQueueService.assertEquals((String)"Queue must be initially empty", (int)0, (int)this.queueService.countAll());
        this.queueService.push(new IDMQueueEntry(IDMEntityType.USER, "testuser", IDMOperationType.ADD_OR_UPDATE));
        this.queueService.push(new IDMQueueEntry(IDMEntityType.USER, "testuser2", IDMOperationType.DELETE));
        IDMQueueEntry entryInError = new IDMQueueEntry(IDMEntityType.USER, "testuser3", IDMOperationType.ADD_OR_UPDATE);
        entryInError.setRetryCount(1);
        this.queueService.push(entryInError);
        IDMQueueEntry entryProcessed = new IDMQueueEntry(IDMEntityType.USER, "testuser4", IDMOperationType.ADD_OR_UPDATE);
        entryProcessed.setProcessed(true);
        this.queueService.push(entryProcessed);
        List entities = this.queueService.pop(100, 1, true);
        TestIDMQueueService.assertEquals((int)1, (int)entities.size());
        this.queueService.incrementRetry(entities);
        TestIDMQueueService.assertEquals((int)0, (int)this.queueService.pop(100, 1, true).size());
        TestIDMQueueService.assertEquals((int)1, (int)this.queueService.pop(100, 2, true).size());
        entities = this.queueService.pop(100, 0, true);
        TestIDMQueueService.assertEquals((int)2, (int)entities.size());
        this.queueService.incrementRetry(entities);
        TestIDMQueueService.assertEquals((int)2, (int)this.queueService.pop(100, 1, true).size());
        TestIDMQueueService.assertEquals((int)1, (int)this.queueService.pop(100, 2, true).size());
        TestIDMQueueService.assertEquals((int)0, (int)this.queueService.pop(100, 0, true).size());
        TestIDMQueueService.assertEquals((int)0, (int)this.queueService.pop(100, 3, true).size());
    }

    private LocalDateTime getLocalDateTime() {
        LocalDateTime localDateTime = ZonedDateTime.now(ZoneId.of("UTC")).toLocalDateTime();
        localDateTime = localDateTime.minusNanos(localDateTime.getNano());
        return localDateTime;
    }
}

