/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.idm.ExtGroup;
import org.exoplatform.services.organization.mock.InMemoryListAccess;
import org.exoplatform.services.organization.mock.InMemoryMembershipHandler;

public class InMemoryGroupHandler
implements GroupHandler {
    private static final String ERROR_BROADCASTING_EVENT_MESSAGE = "Error broadcasting event : {}";
    private static final String ROOT_PARENT_ID = "";
    private static final String DOESN_T_EXISTS_MESSAGE = " doesn't exists";
    private OrganizationService organizationService;
    private List<GroupEventListener> groupListeners = new ArrayList<GroupEventListener>();
    private static Map<String, Group> groupsById = new HashMap<String, Group>();
    private static Map<String, Map<String, Group>> groupChildsById = new HashMap<String, Map<String, Group>>();

    public InMemoryGroupHandler(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public void addGroupEventListener(GroupEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.groupListeners.add(listener);
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.groupListeners.remove(listener);
    }

    public final Group createGroupInstance() {
        return new ExtGroup();
    }

    public void createGroup(Group group, boolean broadcast) {
        this.addChild(null, group, broadcast);
    }

    public void addChild(Group parent, Group childGroup, boolean broadcast) {
        String parentId = parent == null ? ROOT_PARENT_ID : parent.getId();
        childGroup.setId(parentId + "/" + childGroup.getGroupName());
        childGroup.setParentId(parent == null ? ROOT_PARENT_ID : parentId);
        this.saveGroup(childGroup, broadcast);
    }

    public void moveGroup(Group parentOriginGroup, Group parentTargetGroup, Group groupToMove) {
        if (!groupsById.containsKey(parentOriginGroup.getId())) {
            throw new IllegalArgumentException(parentOriginGroup.getId() + DOESN_T_EXISTS_MESSAGE);
        }
        if (!groupsById.containsKey(parentTargetGroup.getId())) {
            throw new IllegalArgumentException(parentTargetGroup.getId() + DOESN_T_EXISTS_MESSAGE);
        }
        if (!groupsById.containsKey(groupToMove.getId())) {
            throw new IllegalArgumentException(groupToMove.getId() + DOESN_T_EXISTS_MESSAGE);
        }
        if (!groupChildsById.containsKey(parentOriginGroup.getId())) {
            throw new IllegalArgumentException(parentOriginGroup.getId() + " doesn't have child groups");
        }
        if (!groupChildsById.get(parentOriginGroup.getId()).containsKey(groupToMove.getId())) {
            throw new IllegalArgumentException(groupToMove.getId() + "isn't a child group of " + parentOriginGroup.getId());
        }
        groupChildsById.get(parentOriginGroup.getId()).remove(groupToMove.getId());
        this.addChild(parentTargetGroup, groupToMove, false);
    }

    public void saveGroup(Group group, boolean broadcast) {
        if (broadcast) {
            this.preSave(group, broadcast);
        }
        groupsById.put(group.getId(), (Group)ObjectUtils.clone((Object)group));
        if (group.getId().lastIndexOf("/") > 0) {
            String[] parts = group.getId().split("/");
            String parentId = StringUtils.join((Object[])Arrays.copyOfRange(parts, 0, parts.length - 1), (String)"/");
            group.setParentId(parentId);
        } else {
            group.setParentId(ROOT_PARENT_ID);
        }
        groupChildsById.computeIfAbsent(group.getParentId(), key -> new HashMap()).put(group.getId(), (Group)ObjectUtils.clone((Object)group));
        if (broadcast) {
            this.postSave(group, broadcast);
        }
    }

    public Group removeGroup(Group group, boolean broadcast) {
        String groupId = group.getId();
        if (!groupsById.containsKey(groupId)) {
            throw new IllegalArgumentException(groupId + DOESN_T_EXISTS_MESSAGE);
        }
        if (broadcast) {
            this.preDelete(group);
        }
        this.removeGroup(groupId, broadcast);
        if (broadcast) {
            this.postDelete(group);
        }
        return group;
    }

    public Collection<Group> findGroupByMembership(String userName, String membershipType) {
        Collection memberships = this.getMembershipHandler().findMembershipsByUserAndGroup(userName, membershipType);
        return memberships.stream().map(membership -> groupsById.get(membership.getGroupId())).filter(Objects::nonNull).map(ObjectUtils::clone).toList();
    }

    public Collection<Group> resolveGroupByMembership(String userName, String membershipType) {
        Collection memberships = this.getMembershipHandler().findMembershipsByUser(userName);
        boolean allMembershipTypes = StringUtils.equals((CharSequence)"*", (CharSequence)membershipType);
        return memberships.stream().map(membership -> allMembershipTypes || StringUtils.equals((CharSequence)membership.getMembershipType(), (CharSequence)membershipType) ? groupsById.get(membership.getGroupId()) : null).filter(Objects::nonNull).map(ObjectUtils::clone).toList();
    }

    public Group findGroupById(String groupId) {
        return (Group)ObjectUtils.clone((Object)groupsById.get(groupId));
    }

    public ListAccess<Group> findGroupChildren(Group parent, String keyword) {
        List<Group> childGroups = groupChildsById.computeIfAbsent(parent.getId(), key -> new HashMap()).values().stream().filter(group -> StringUtils.contains((CharSequence)group.getLabel(), (CharSequence)keyword) || StringUtils.contains((CharSequence)group.getGroupName(), (CharSequence)keyword)).toList();
        return new InMemoryListAccess<Group>(childGroups, new Group[0]);
    }

    public Collection<Group> findGroups(Group parent) {
        return groupChildsById.computeIfAbsent(parent.getId(), key -> new HashMap()).values().stream().map(ObjectUtils::clone).toList();
    }

    public Collection<Group> findGroupsOfUser(String userName) {
        Collection memberships = this.getMembershipHandler().findMembershipsByUser(userName);
        return memberships.stream().map(membership -> groupsById.get(membership.getGroupId())).filter(Objects::nonNull).map(ObjectUtils::clone).toList();
    }

    public Collection<Group> findGroupsOfUserByKeyword(String userName, String keyword, String excludeParentGroup) {
        return this.findGroupsOfUserByKeyword(userName, keyword, Collections.singletonList(excludeParentGroup));
    }

    public Collection<Group> getAllGroups() {
        return groupsById.values().stream().map(ObjectUtils::clone).toList();
    }

    public ListAccess<Group> findGroupsByKeyword(String keyword) {
        List<Group> childGroups = this.getAllGroups().stream().filter(group -> StringUtils.contains((CharSequence)group.getLabel(), (CharSequence)keyword) || StringUtils.contains((CharSequence)group.getGroupName(), (CharSequence)keyword)).toList();
        return new InMemoryListAccess<Group>(childGroups, new Group[0]);
    }

    public Collection<Group> findAllGroupsByKeyword(String keyword, List<String> excludedGroupsParent) {
        return this.getAllGroups().stream().filter(group -> excludedGroupsParent.stream().noneMatch(groupId -> StringUtils.contains((CharSequence)group.getId(), (CharSequence)groupId))).filter(group -> StringUtils.contains((CharSequence)group.getLabel(), (CharSequence)keyword) || StringUtils.contains((CharSequence)group.getGroupName(), (CharSequence)keyword)).toList();
    }

    public Collection<Group> findGroupsOfUserByKeyword(String userName, String keyword, List<String> excludedGroupsParent) {
        return this.findGroupsOfUser(userName).stream().filter(group -> excludedGroupsParent.stream().noneMatch(groupId -> StringUtils.contains((CharSequence)group.getId(), (CharSequence)groupId))).filter(group -> StringUtils.contains((CharSequence)group.getLabel(), (CharSequence)keyword) || StringUtils.contains((CharSequence)group.getGroupName(), (CharSequence)keyword)).toList();
    }

    private void preSave(Group group, boolean isNew) {
        for (GroupEventListener listener : this.groupListeners) {
            try {
                listener.preSave(group, isNew);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void postSave(Group group, boolean isNew) {
        for (GroupEventListener listener : this.groupListeners) {
            try {
                listener.postSave(group, isNew);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void preDelete(Group group) {
        for (GroupEventListener listener : this.groupListeners) {
            try {
                listener.preDelete(group);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private void postDelete(Group group) {
        for (GroupEventListener listener : this.groupListeners) {
            try {
                listener.postDelete(group);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(ERROR_BROADCASTING_EVENT_MESSAGE.replace("{}", listener.getClass().getName()), e);
            }
        }
    }

    private InMemoryMembershipHandler getMembershipHandler() {
        return (InMemoryMembershipHandler)this.organizationService.getMembershipHandler();
    }

    private void removeGroup(String groupId, boolean broadcast) {
        this.removeSubGroups(groupId, broadcast);
        groupsById.remove(groupId);
        this.getMembershipHandler().removeMembershipByGroup(groupId, broadcast);
    }

    private void removeSubGroups(String groupId, boolean broadcast) {
        Map<String, Group> childGroupsById = groupChildsById.get(groupId);
        if (childGroupsById != null) {
            Group[] childGroupsArray;
            for (Group childGroup : childGroupsArray = childGroupsById.values().toArray(new Group[0])) {
                this.removeGroup(childGroup.getId(), broadcast);
            }
            childGroupsById.remove(groupId);
        }
    }
}

