/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.hibernate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.query.Query;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.helper.Tools;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObject;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectAttributeBinaryValue;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredential;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialBinaryValue;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectCredentialType;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationship;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipName;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.picketlink.idm.impl.model.hibernate.HibernateIdentityObjectType;
import org.picketlink.idm.impl.model.hibernate.HibernateRealm;
import org.picketlink.idm.impl.store.FeaturesMetaDataImpl;
import org.picketlink.idm.impl.store.hibernate.HibernateIdentityStoreSessionImpl;
import org.picketlink.idm.impl.types.SimpleIdentityObject;
import org.picketlink.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.RealmConfigurationMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectAttribute;
import org.picketlink.idm.spi.model.IdentityObjectCredential;
import org.picketlink.idm.spi.model.IdentityObjectCredentialType;
import org.picketlink.idm.spi.model.IdentityObjectRelationship;
import org.picketlink.idm.spi.model.IdentityObjectRelationshipType;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;
import org.picketlink.idm.spi.store.FeaturesMetaData;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.picketlink.idm.spi.store.IdentityStore;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.store.IdentityStoreSession;

public class HibernateIdentityStoreImpl
implements IdentityStore {
    private static final String NOT_PRESENT_IN_THE_STORE = "] not present in the store.";
    private static final String ATTRIBUTE_NAME = ". Attribute name: ";
    private static final String OPTION_IF_NEEDED_ATTRIBUTE_NAME = "' option if needed. Attribute name: ";
    private static final String CANNOT_OBTAIN_RELATIONSHIP_PROPERTIES = "Cannot obtain relationship properties: ";
    private static final String IDENTITY_PARAM = "identity";
    public static final String HIBERNATE_SESSION_FACTORY_REGISTRY_NAME = "hibernateSessionFactoryRegistryName";
    public static final String HIBERNATE_CONFIGURATION = "hibernateConfiguration";
    public static final String HIBERNATE_SESSION_FACTORY_JNDI_NAME = "hibernateSessionFactoryJNDIName";
    public static final String POPULATE_MEMBERSHIP_TYPES = "populateRelationshipTypes";
    public static final String POPULATE_IDENTITY_OBJECT_TYPES = "populateIdentityObjectTypes";
    public static final String IS_REALM_AWARE = "isRealmAware";
    public static final String MANAGE_TRANSACTION_DURING_BOOTSTRAP = "manageTransactionDuringBootstrap";
    public static final String ALLOW_NOT_DEFINED_ATTRIBUTES = "allowNotDefinedAttributes";
    public static final String ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION = "allowNotDefinedIdentityObjectTypes";
    public static final String ALLOW_NOT_CASE_SENSITIVE_SEARCH = "allowNotCaseSensitiveSearch";
    public static final String LAZY_START_OF_HIBERNATE_TRANSACTION = "lazyStartOfHibernateTransaction";
    public static final String DEFAULT_REALM_NAME = HibernateIdentityStoreImpl.class.getName() + ".DEFAULT_REALM";
    public static final String CREDENTIAL_TYPE_PASSWORD = "PASSWORD";
    public static final String CREDENTIAL_TYPE_BINARY = "BINARY";
    public static final String NAME_PARAM = "name";
    public static final String REALM_PARAM = "realm";
    private static final String TYPE_NAME_PARAM = "typeName";
    public static final String IDENTITY_TYPE_NAME = "typeName";
    public static final String REALM_NAME_PARAM = "realmName";
    private String id;
    private FeaturesMetaData supportedFeatures;
    private SessionFactory sessionFactory;
    private boolean isRealmAware = false;
    private boolean isAllowNotDefinedAttributes = false;
    private boolean isAllowNotDefinedIdentityObjectTypes = false;
    private boolean isAllowNotCaseSensitiveSearch = false;
    private boolean lazyStartOfHibernateTransaction = false;
    private boolean isManageTransactionDuringBootstrap = true;
    private IdentityStoreConfigurationMetaData configurationMD;
    private static Set<IdentityObjectSearchCriteriaType> supportedIdentityObjectSearchCriteria = new HashSet<IdentityObjectSearchCriteriaType>();
    private static Set<String> supportedCredentialTypes = new HashSet<String>();
    private Map<String, Set<String>> attributeMappings = new HashMap<String, Set<String>>();
    private Map<String, Map<String, IdentityObjectAttributeMetaData>> attributesMetaData = new HashMap<String, Map<String, IdentityObjectAttributeMetaData>>();
    private Map<String, Map<String, String>> reverseAttributeMappings = new HashMap<String, Map<String, String>>();
    private static final long serialVersionUID = -130355852189832805L;

    public HibernateIdentityStoreImpl(String id) {
        this.id = id;
    }

    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        HibernateRealm realm;
        String lazyStartOfHibernateTransactionValue;
        String allowNotCaseSensitiveSearch;
        String allowNotDefinedIOT;
        String allowNotDefineAttributes;
        String realmAware;
        this.configurationMD = configurationContext.getStoreConfigurationMetaData();
        this.id = this.configurationMD.getId();
        this.supportedFeatures = new FeaturesMetaDataImpl(this.configurationMD, supportedIdentityObjectSearchCriteria, true, true, new HashSet());
        String populateMembershipTypes = this.configurationMD.getOptionSingleValue(POPULATE_MEMBERSHIP_TYPES);
        String populateIdentityObjectTypes = this.configurationMD.getOptionSingleValue(POPULATE_IDENTITY_OBJECT_TYPES);
        String manageTransactionDuringBootstrap = this.configurationMD.getOptionSingleValue(MANAGE_TRANSACTION_DURING_BOOTSTRAP);
        if (manageTransactionDuringBootstrap != null && manageTransactionDuringBootstrap.equalsIgnoreCase("false")) {
            this.isAllowNotDefinedAttributes = false;
        }
        this.sessionFactory = this.bootstrapHibernateSessionFactory(configurationContext);
        Session hibernateSession = this.sessionFactory.openSession();
        for (Object identityObjectTypeMetaData : this.configurationMD.getSupportedIdentityTypes()) {
            HashSet<String> names = new HashSet<String>();
            HashMap<String, IdentityObjectAttributeMetaData> metadataMap = new HashMap<String, IdentityObjectAttributeMetaData>();
            HashMap<String, String> reverseMap = new HashMap<String, String>();
            for (IdentityObjectAttributeMetaData attributeMetaData : identityObjectTypeMetaData.getAttributes()) {
                names.add(attributeMetaData.getName());
                metadataMap.put(attributeMetaData.getName(), attributeMetaData);
                if (attributeMetaData.getStoreMapping() == null) continue;
                reverseMap.put(attributeMetaData.getStoreMapping(), attributeMetaData.getName());
            }
            this.attributeMappings.put(identityObjectTypeMetaData.getName(), Collections.unmodifiableSet(names));
            this.attributesMetaData.put(identityObjectTypeMetaData.getName(), metadataMap);
            this.reverseAttributeMappings.put(identityObjectTypeMetaData.getName(), reverseMap);
        }
        this.attributeMappings = Collections.unmodifiableMap(this.attributeMappings);
        if (this.isManageTransactionDuringBootstrap()) {
            hibernateSession.getTransaction().begin();
        }
        if (populateMembershipTypes != null && populateMembershipTypes.equalsIgnoreCase("true")) {
            LinkedList<String> memberships = new LinkedList<String>();
            for (String membership : this.configurationMD.getSupportedRelationshipTypes()) {
                memberships.add(membership);
            }
            try {
                this.populateRelationshipTypes(hibernateSession, memberships.toArray(new String[memberships.size()]));
            }
            catch (Exception e) {
                throw new IdentityException("Failed to populate relationship types", (Throwable)e);
            }
        }
        if (populateIdentityObjectTypes != null && populateIdentityObjectTypes.equalsIgnoreCase("true")) {
            LinkedList<String> types = new LinkedList<String>();
            for (IdentityObjectTypeMetaData metaData : this.configurationMD.getSupportedIdentityTypes()) {
                types.add(metaData.getName());
            }
            try {
                this.populateObjectTypes(hibernateSession, types.toArray(new String[types.size()]));
            }
            catch (Exception e) {
                throw new IdentityException("Failed to populate identity object types", (Throwable)e);
            }
        }
        if (supportedCredentialTypes != null && !supportedCredentialTypes.isEmpty()) {
            try {
                this.populateCredentialTypes(hibernateSession, supportedCredentialTypes.toArray(new String[supportedCredentialTypes.size()]));
            }
            catch (Exception e) {
                throw new IdentityException("Failed to populated credential types");
            }
        }
        if ((realmAware = this.configurationMD.getOptionSingleValue(IS_REALM_AWARE)) != null && realmAware.equalsIgnoreCase("true")) {
            this.isRealmAware = true;
        }
        if ((allowNotDefineAttributes = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_ATTRIBUTES)) != null && allowNotDefineAttributes.equalsIgnoreCase("true")) {
            this.isAllowNotDefinedAttributes = true;
        }
        if ((allowNotDefinedIOT = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_IDENTITY_OBJECT_TYPES_OPTION)) != null && allowNotDefinedIOT.equalsIgnoreCase("true")) {
            this.isAllowNotDefinedIdentityObjectTypes = true;
        }
        if ((allowNotCaseSensitiveSearch = this.configurationMD.getOptionSingleValue(ALLOW_NOT_CASE_SENSITIVE_SEARCH)) != null && allowNotCaseSensitiveSearch.equalsIgnoreCase("true")) {
            this.isAllowNotCaseSensitiveSearch = true;
        }
        if ((lazyStartOfHibernateTransactionValue = this.configurationMD.getOptionSingleValue(LAZY_START_OF_HIBERNATE_TRANSACTION)) != null && lazyStartOfHibernateTransactionValue.equalsIgnoreCase("true")) {
            this.lazyStartOfHibernateTransaction = true;
        }
        if ((realm = this.getRealmByName(hibernateSession, DEFAULT_REALM_NAME)) == null) {
            this.addRealm(hibernateSession, DEFAULT_REALM_NAME);
        }
        if (this.isRealmAware()) {
            HashSet<String> realmNames = new HashSet<String>();
            for (RealmConfigurationMetaData realmMD : configurationContext.getConfigurationMetaData().getRealms()) {
                realmNames.add(realmMD.getId());
            }
            for (String rid : realmNames) {
                realm = this.getRealmByName(hibernateSession, rid);
                if (realm != null) continue;
                this.addRealm(hibernateSession, rid);
            }
        }
        if (this.isManageTransactionDuringBootstrap()) {
            hibernateSession.getTransaction().commit();
        }
        if (hibernateSession.getTransaction().isActive()) {
            hibernateSession.flush();
        }
        hibernateSession.close();
    }

    protected SessionFactory bootstrapHibernateSessionFactory(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        String sfJNDIName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_SESSION_FACTORY_JNDI_NAME);
        String sfRegistryName = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_SESSION_FACTORY_REGISTRY_NAME);
        String hibernateConfiguration = configurationContext.getStoreConfigurationMetaData().getOptionSingleValue(HIBERNATE_CONFIGURATION);
        if (sfJNDIName != null) {
            try {
                return (SessionFactory)new InitialContext().lookup(sfJNDIName);
            }
            catch (NamingException e) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided JNDI name: " + sfJNDIName, (Throwable)e);
            }
        }
        if (sfRegistryName != null) {
            Object registryObject = configurationContext.getConfigurationRegistry().getObject(sfRegistryName);
            if (registryObject == null) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided registry name: " + sfRegistryName);
            }
            if (!(registryObject instanceof SessionFactory)) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory from provided registry name: " + sfRegistryName + "; Registered object is not an instance of SessionFactory: " + registryObject.getClass().getName());
            }
            return (SessionFactory)registryObject;
        }
        if (hibernateConfiguration != null) {
            try {
                Configuration config = new Configuration().configure(hibernateConfiguration);
                return config.addAnnotatedClass(HibernateIdentityObject.class).addAnnotatedClass(HibernateIdentityObjectCredentialBinaryValue.class).addAnnotatedClass(HibernateIdentityObjectAttributeBinaryValue.class).addAnnotatedClass(HibernateIdentityObjectAttribute.class).addAnnotatedClass(HibernateIdentityObjectCredential.class).addAnnotatedClass(HibernateIdentityObjectCredentialType.class).addAnnotatedClass(HibernateIdentityObjectRelationship.class).addAnnotatedClass(HibernateIdentityObjectRelationshipName.class).addAnnotatedClass(HibernateIdentityObjectRelationshipType.class).addAnnotatedClass(HibernateIdentityObjectType.class).addAnnotatedClass(HibernateRealm.class).buildSessionFactory();
            }
            catch (Exception e) {
                throw new IdentityException("Cannot obtain hibernate SessionFactory using provided hibernate configuration: " + hibernateConfiguration, (Throwable)e);
            }
        }
        throw new IdentityException("Cannot obtain hibernate SessionFactory. None of supported options specified: hibernateSessionFactoryJNDIName, hibernateSessionFactoryRegistryName, hibernateConfiguration");
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        try {
            return new HibernateIdentityStoreSessionImpl(this.sessionFactory, this.lazyStartOfHibernateTransaction);
        }
        catch (Exception e) {
            throw new IdentityException("Failed to obtain Hibernate SessionFactory", (Throwable)e);
        }
    }

    public IdentityStoreSession createIdentityStoreSession(Map<String, Object> sessionOptions) throws IdentityException {
        return this.createIdentityStoreSession();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FeaturesMetaData getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.createIdentityObject(invocationCtx, name, identityObjectType, null);
    }

    public IdentityObject createIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException("IdentityObject name is null");
        }
        this.checkIOType(identityObjectType);
        Session session = this.getHibernateSession(ctx);
        HibernateRealm realm = this.getRealm(session, ctx);
        int size = this.countIdentityObjectByNameAndType(session, name, identityObjectType.getName(), realm.getName());
        if (size != 0) {
            throw new IdentityException("IdentityObject already present in this IdentityStore:name=" + name + "; type=" + identityObjectType.getName() + "; realm=" + String.valueOf(realm));
        }
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, identityObjectType);
        HibernateIdentityObject io = new HibernateIdentityObject(name, hibernateType, realm);
        if (attributes != null) {
            for (Map.Entry<String, String[]> entry : attributes.entrySet()) {
                io.addTextAttribute(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.getHibernateSession(ctx).persist((Object)io);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot persist new IdentityObject" + String.valueOf(io), (Throwable)e);
        }
        return io;
    }

    public void removeIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationship[] from = new HibernateIdentityObjectRelationship[hibernateObject.getFromRelationships().size()];
            for (HibernateIdentityObjectRelationship relationship : hibernateObject.getFromRelationships().toArray(from)) {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.remove((Object)relationship);
                hibernateSession.flush();
            }
            HibernateIdentityObjectRelationship[] to = new HibernateIdentityObjectRelationship[hibernateObject.getToRelationships().size()];
            for (HibernateIdentityObjectRelationship relationship : hibernateObject.getToRelationships().toArray(to)) {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                hibernateSession.remove((Object)relationship);
                hibernateSession.flush();
            }
            hibernateSession.remove((Object)hibernateObject);
            hibernateSession.flush();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot remove IdentityObject" + String.valueOf(identity), (Throwable)e);
        }
    }

    public int getIdentityObjectsCount(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        this.checkIOType(identityType);
        HibernateIdentityObjectType jpaType = this.getHibernateIdentityObjectType(ctx, identityType);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            return ((Long)hibernateSession.createNamedQuery("HibernateIdentityObject.countIdentityObjectsByType", Long.class).setParameter("typeName", (Object)jpaType.getName()).setParameter(REALM_NAME_PARAM, (Object)this.getRealmName(ctx)).setCacheable(true).uniqueResult()).intValue();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot count stored IdentityObjects with type: " + identityType.getName(), (Throwable)e);
        }
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String name, IdentityObjectType type) throws IdentityException {
        if (name == null) {
            throw new IllegalArgumentException("IdentityObject name is null");
        }
        this.checkIOType(type);
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, (IdentityObject)new SimpleIdentityObject(name, type));
        if (this.isAllowNotCaseSensitiveSearch()) {
            return hibernateObject;
        }
        if (hibernateObject != null && hibernateObject.getName().equals(name)) {
            return hibernateObject;
        }
        return null;
    }

    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String id) throws IdentityException {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        try {
            return (IdentityObject)this.getHibernateSession(ctx).get(HibernateIdentityObject.class, (Object)id);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot find IdentityObject with id: " + id, (Throwable)e);
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        this.checkIOType(identityType);
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, identityType);
        HibernateRealm realm = this.getRealm(this.getHibernateSession(ctx), ctx);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            StringBuilder hqlBuilderSelect = new StringBuilder("select distinct io from HibernateIdentityObject io");
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            StringBuilder hqlBuilderConditions = new StringBuilder(" where io.realm=:realm and io.identityType=:identityType");
            queryParams.put(REALM_PARAM, realm);
            queryParams.put("identityType", hibernateType);
            hqlBuilderConditions.append(" and io.name like :ioName");
            if (criteria != null && criteria.getFilter() != null) {
                queryParams.put("ioName", criteria.getFilter().replace("\\*", "%").replace("*", "%"));
            } else {
                queryParams.put("ioName", "%");
            }
            if (criteria != null && criteria.isFiltered() && criteria.getValues() != null) {
                int i = 0;
                for (Map.Entry entry : criteria.getValues().entrySet()) {
                    String mappedAttributeName = this.resolveAttributeStoreMapping(hibernateType, (String)entry.getKey());
                    List<String> given = Arrays.stream((String[])entry.getValue()).distinct().toList();
                    for (String attrValue : given) {
                        attrValue = attrValue.replace("\\*", "%").replace("*", "%");
                        String attrTableJoinName = "attrs" + ++i;
                        String textValuesTableJoinName = "textValues" + i;
                        String attrParamName = "attr" + i;
                        String textValueParamName = "textValue" + i;
                        hqlBuilderSelect.append(" join io.attributes as " + attrTableJoinName);
                        hqlBuilderSelect.append(" join " + attrTableJoinName + ".textValues as " + textValuesTableJoinName);
                        hqlBuilderConditions.append(" and " + attrTableJoinName + ".name like :" + attrParamName);
                        hqlBuilderConditions.append(" and " + textValuesTableJoinName + " like :" + textValueParamName);
                        queryParams.put(attrParamName, mappedAttributeName);
                        queryParams.put(textValueParamName, attrValue);
                    }
                }
            }
            if (criteria != null && criteria.isSorted()) {
                if (criteria.isAscending()) {
                    hqlBuilderConditions.append(" order by io.name asc");
                } else {
                    hqlBuilderConditions.append(" order by io.name desc");
                }
            }
            Query hibernateQuery = hibernateSession.createQuery(hqlBuilderSelect.toString() + hqlBuilderConditions.toString(), IdentityObject.class);
            if (criteria != null && criteria.isPaged()) {
                if (criteria.getMaxResults() > 0) {
                    hibernateQuery.setMaxResults(criteria.getMaxResults());
                }
                hibernateQuery.setFirstResult(criteria.getFirstResult());
            }
            this.applyQueryParameters(hibernateQuery, queryParams);
            hibernateQuery.setCacheable(true);
            List results = hibernateQuery.list();
            Hibernate.initialize((Object)results);
            return results;
        }
        catch (Exception e) {
            throw new IdentityException("Cannot find IdentityObjects with type '" + identityType.getName() + "'", (Throwable)e);
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        return this.findIdentityObject(ctx, identityType, null);
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getIdentityObjectCount(invocationCxt, identity, relationshipType, null, parent, criteria);
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.findIdentityObject(invocationCxt, identity, relationshipType, null, parent, criteria);
    }

    public int getIdentityObjectCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            Query q = this.prepareIdentityObjectQuery(ctx, identity, relationshipType, excludes, parent, criteria, false);
            return ((Number)q.uniqueResult()).intValue();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot get IdentityObject count", (Throwable)e);
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        try {
            Query q = this.prepareIdentityObjectQuery(ctx, identity, relationshipType, excludes, parent, criteria, false);
            List results = q.list();
            Hibernate.initialize((Object)results);
            if (criteria != null && criteria.isFiltered()) {
                this.filterByAttributesValues(results, criteria.getValues());
                if (criteria.isPaged()) {
                    return this.cutPageFromResults(results, criteria);
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new IdentityException("Cannot find IdentityObjects", (Throwable)e);
        }
    }

    public <T> Query<T> prepareIdentityObjectQuery(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, Collection<IdentityObjectType> excludes, boolean parent, IdentityObjectSearchCriteria criteria, boolean count) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        HibernateRealm realm = this.getRealm(this.getHibernateSession(ctx), ctx);
        boolean orderByName = false;
        boolean ascending = true;
        if (criteria != null && criteria.isSorted()) {
            orderByName = true;
            ascending = criteria.isAscending();
        }
        try {
            StringBuilder hqlString = new StringBuilder("");
            if (parent) {
                if (count) {
                    hqlString.append("select count(distinct toio) from HibernateIdentityObjectRelationship ior join ior.toIdentityObject toio where ");
                } else {
                    hqlString.append("select distinct toio from HibernateIdentityObjectRelationship ior join ior.toIdentityObject toio where ");
                }
                hqlString.append("toio.realm = :realm and ior.fromIdentityObject.realm = :realm and ");
                if (relationshipType != null) {
                    hqlString.append("toio.name like :nameFilter and ior.type.name = :relType and ior.fromIdentityObject = :identity");
                } else {
                    hqlString.append("toio.name like :nameFilter and ior.fromIdentityObject = :identity");
                }
                if (excludes != null && !excludes.isEmpty()) {
                    for (i = 0; i < excludes.size(); ++i) {
                        hqlString.append(" and toio.identityType.id <> ").append(":exclude" + i);
                    }
                }
                if (orderByName) {
                    hqlString.append(" order by toio.name");
                    if (ascending) {
                        hqlString.append(" asc");
                    }
                }
            } else {
                if (count) {
                    hqlString.append("select count(distinct fromio) from HibernateIdentityObjectRelationship ior join ior.fromIdentityObject fromio where ");
                } else {
                    hqlString.append("select distinct fromio from HibernateIdentityObjectRelationship ior join ior.fromIdentityObject fromio where ");
                }
                hqlString.append("ior.toIdentityObject.realm = :realm and fromio.realm = :realm and ");
                if (relationshipType != null) {
                    hqlString.append("fromio.name like :nameFilter and ior.type.name = :relType and ior.toIdentityObject = :identity");
                } else {
                    hqlString.append("fromio.name like :nameFilter and ior.toIdentityObject = :identity");
                }
                if (excludes != null && !excludes.isEmpty()) {
                    for (i = 0; i < excludes.size(); ++i) {
                        hqlString.append(" and fromio.identityType.id <> ").append(":exclude" + i);
                    }
                }
                if (orderByName) {
                    hqlString.append(" order by fromio.name");
                    if (ascending) {
                        hqlString.append(" asc");
                    }
                }
            }
            Query q = this.getHibernateSession(ctx).createQuery(hqlString.toString()).setParameter(IDENTITY_PARAM, (Object)hibernateObject).setParameter(REALM_PARAM, (Object)realm).setCacheable(true);
            if (relationshipType != null) {
                q.setParameter("relType", (Object)relationshipType.getName());
            }
            if (criteria != null && criteria.getFilter() != null) {
                q.setParameter("nameFilter", (Object)criteria.getFilter().replace("\\*", "%").replace("*", "%"));
            } else {
                q.setParameter("nameFilter", (Object)"%");
            }
            if (excludes != null && !excludes.isEmpty()) {
                int i = 0;
                for (IdentityObjectType exclude : excludes) {
                    HibernateIdentityObjectType exType = this.getHibernateIdentityObjectType(ctx, exclude);
                    q.setParameter("exclude" + i++, (Object)exType.getId());
                }
            }
            if (criteria != null && criteria.isPaged() && !criteria.isFiltered()) {
                q.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    q.setMaxResults(criteria.getMaxResults());
                }
            }
            return q;
        }
        catch (Exception e) {
            throw new IdentityException("Cannot prepare hibernate query", (Throwable)e);
        }
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent) throws IdentityException {
        return this.findIdentityObject(ctx, identity, relationshipType, parent, null);
    }

    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name, boolean createNames) throws IdentityException {
        if (relationshipType == null) {
            throw new IllegalArgumentException("RelationshipType is null");
        }
        HibernateIdentityObject fromIO = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject toIO = this.safeGet(ctx, toIdentity);
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationshipType);
        if (!this.getSupportedFeatures().isRelationshipTypeSupported((IdentityObjectType)fromIO.getIdentityType(), (IdentityObjectType)toIO.getIdentityType(), relationshipType) && !this.isAllowNotDefinedIdentityObjectTypes()) {
            throw new IdentityException("Relationship not supported. RelationshipType[ " + relationshipType.getName() + " ] beetween: [ " + fromIO.getIdentityType().getName() + " ] and [ " + toIO.getIdentityType().getName() + " ]");
        }
        HibernateIdentityObjectRelationship relationship = null;
        HibernateRealm realm = this.getRealm(this.getHibernateSession(ctx), ctx);
        if (name != null) {
            HibernateIdentityObjectRelationshipName relationshipName = this.findIdentityObjectRelationshipNameByName(this.getHibernateSession(ctx), name, realm.getName());
            if (relationshipName == null) {
                throw new IdentityException("Relationship name " + name + " not present in the store");
            }
            relationship = new HibernateIdentityObjectRelationship(type, fromIO, toIO, relationshipName);
        } else {
            relationship = new HibernateIdentityObjectRelationship(type, fromIO, toIO);
        }
        try {
            Session session = this.getHibernateSession(ctx);
            session.persist((Object)relationship);
            session.flush();
            return relationship;
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot create relationship: ", (Throwable)e);
        }
    }

    public void removeRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name) throws IdentityException {
        if (relationshipType == null) {
            throw new IllegalArgumentException("RelationshipType is null");
        }
        HibernateIdentityObject fromIO = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject toIO = this.safeGet(ctx, toIdentity);
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationshipType);
        HibernateIdentityObjectRelationship relationship = name == null ? this.findIdentityObjectRelationshipByIdentityByType(this.getHibernateSession(ctx), fromIO, toIO, type.getName()) : this.findIdentityObjectRelationshipByAttributes(this.getHibernateSession(ctx), fromIO, toIO, type.getId(), name);
        if (relationship == null) {
            throw new IdentityException("Relationship not present in the store");
        }
        try {
            fromIO.getFromRelationships().remove(relationship);
            toIO.getToRelationships().remove(relationship);
            this.getHibernateSession(ctx).remove((Object)relationship);
            this.getHibernateSession(ctx).flush();
        }
        catch (HibernateException e) {
            throw new IdentityException("Cannot remove relationship");
        }
    }

    public void removeRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        HibernateIdentityObject hio1 = this.safeGet(ctx, identity1);
        HibernateIdentityObject hio2 = this.safeGet(ctx, identity2);
        List<HibernateIdentityObjectRelationship> results = this.findIdentityObjectRelationshipsByIdentities(this.getHibernateSession(ctx), hio1, hio2);
        Hibernate.initialize(results);
        for (HibernateIdentityObjectRelationship relationship : results) {
            if ((!named || relationship.getName() == null) && (named || relationship.getName() != null)) continue;
            try {
                relationship.getFromIdentityObject().getFromRelationships().remove(relationship);
                relationship.getToIdentityObject().getToRelationships().remove(relationship);
                this.getHibernateSession(ctx).remove((Object)relationship);
                this.getHibernateSession(ctx).flush();
            }
            catch (HibernateException e) {
                throw new IdentityException("Cannot remove relationship");
            }
        }
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        HibernateIdentityObjectRelationship relationship;
        HibernateIdentityObject hio1 = this.safeGet(ctx, fromIdentity);
        HibernateIdentityObject hio2 = this.safeGet(ctx, toIdentity);
        List<Object> results = relationshipType != null ? ((relationship = this.findIdentityObjectRelationshipByIdentityByType(this.getHibernateSession(ctx), hio1, hio2, relationshipType.getName())) == null ? Collections.emptyList() : Collections.singletonList(relationship)) : this.findIdentityObjectRelationshipsByIdentities(this.getHibernateSession(ctx), hio1, hio2);
        Hibernate.initialize(results);
        return new HashSet<IdentityObjectRelationship>(results);
    }

    public int getRelationshipsCount(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria) throws IdentityException {
        Query query = this.prepareResolveRelationshipsCriteria(ctx, identity, type, parent, named, name, searchCriteria, true);
        Number count = (Number)query.uniqueResult();
        return count == null ? 0 : count.intValue();
    }

    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria) throws IdentityException {
        Query query = this.prepareResolveRelationshipsCriteria(ctx, identity, type, parent, named, name, searchCriteria, false);
        List results = query.list();
        Hibernate.initialize((Object)results);
        return new HashSet<IdentityObjectRelationship>(results);
    }

    public <T> Query<T> prepareResolveRelationshipsCriteria(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name, IdentityObjectSearchCriteria searchCriteria, boolean count) throws IdentityException {
        HibernateIdentityObject hio = this.safeGet(ctx, identity);
        StringBuilder queryString = new StringBuilder(count ? "SELECT COUNT(r) FROM HibernateIdentityObjectRelationship r" : "SELECT r FROM HibernateIdentityObjectRelationship r");
        queryString.append(" FETCH JOIN r.fromIdentityObject fromIo");
        queryString.append(" FETCH JOIN r.toIdentityObject toIo");
        queryString.append(" WHERE");
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        if (type != null) {
            HibernateIdentityObjectRelationshipType hibernateType = this.getHibernateIdentityObjectRelationshipType(ctx, type);
            paramNames.add("type");
            paramValues.add(hibernateType);
            queryString.append(" r.type = :type");
            queryString.append(" AND");
        }
        paramNames.add(IDENTITY_PARAM);
        paramValues.add(hio);
        if (parent) {
            queryString.append(" r.fromIdentityObject = :identity");
            queryString.append(" AND");
        } else {
            queryString.append(" r.toIdentityObject = :identity");
            queryString.append(" AND");
        }
        if (name != null) {
            paramNames.add(NAME_PARAM);
            paramValues.add(name);
            queryString.append(" r.name.name = :name");
        } else if (named) {
            queryString.append(" r.name IS NOT NULL");
        } else {
            queryString.append(" r.name.name IS NULL");
        }
        if (searchCriteria != null && searchCriteria.isSorted()) {
            if (parent) {
                if (searchCriteria.isAscending()) {
                    queryString.append(" ORDER BY toIo.name ASC");
                } else {
                    queryString.append(" ORDER BY toIo.name DESC");
                }
            } else if (searchCriteria.isAscending()) {
                queryString.append(" ORDER BY fromIo.name ASC");
            } else {
                queryString.append(" ORDER BY fromIo.name DESC");
            }
        }
        Query query = this.getHibernateSession(ctx).createQuery(queryString.toString());
        if (searchCriteria != null && searchCriteria.isPaged() && !searchCriteria.isFiltered()) {
            if (searchCriteria.getMaxResults() > 0) {
                query.setMaxResults(searchCriteria.getMaxResults());
            }
            query.setFirstResult(searchCriteria.getFirstResult());
        }
        for (int i = 0; i < paramNames.size(); ++i) {
            query.setParameter((String)paramNames.get(i), paramValues.get(i));
        }
        return query;
    }

    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException {
        this.checkName(name);
        Session hibernateSession = this.getHibernateSession(ctx);
        HibernateRealm realm = this.getRealm(hibernateSession, ctx);
        try {
            HibernateIdentityObjectRelationshipName hiorn = this.findIdentityObjectRelationshipNameByName(hibernateSession, name, realm.getName());
            if (hiorn != null) {
                throw new IdentityException("Relationship name already exists");
            }
            hiorn = new HibernateIdentityObjectRelationshipName(name, realm);
            this.getHibernateSession(ctx).persist((Object)hiorn);
            this.getHibernateSession(ctx).flush();
            return name;
        }
        catch (Exception e) {
            throw new IdentityException("Cannot create new relationship name: " + name, (Throwable)e);
        }
    }

    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException {
        this.checkName(name);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName relationshipName = this.getRelationshipName(ctx, name, hibernateSession);
            this.removeRelationshipsByName(ctx, relationshipName);
            hibernateSession.remove((Object)relationshipName);
            hibernateSession.flush();
            return name;
        }
        catch (Exception e) {
            throw new IdentityException("Cannot remove new relationship name: " + name, (Throwable)e);
        }
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException {
        return this.getRelationshipNames(ctx, criteria, null);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx) throws IdentityException {
        return this.getRelationshipNames(ctx, (IdentityObjectSearchCriteria)null);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException {
        if (identity == null) {
            throw new IllegalArgumentException("identity is mandatory");
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        return this.getRelationshipNames(ctx, hibernateObject, criteria);
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        return this.getRelationshipNames(ctx, identity, null);
    }

    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException {
        this.checkName(name);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName relationshipName = this.getRelationshipName(ctx, name, hibernateSession);
            Hibernate.initialize(relationshipName.getProperties());
            return new HashMap<String, String>(relationshipName.getProperties());
        }
        catch (Exception e) {
            throw new IdentityException("Cannot get relationship name properties: " + name, (Throwable)e);
        }
    }

    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException {
        this.checkName(name);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName relationshipName = this.getRelationshipName(ctx, name, hibernateSession);
            relationshipName.getProperties().putAll(properties);
            hibernateSession.persist((Object)relationshipName);
            hibernateSession.flush();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot set relationship name properties: " + name, (Throwable)e);
        }
    }

    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException {
        this.checkName(name);
        Session hibernateSession = this.getHibernateSession(ctx);
        try {
            HibernateIdentityObjectRelationshipName relationshipName = this.getRelationshipName(ctx, name, hibernateSession);
            Hibernate.initialize(relationshipName.getProperties());
            for (String property : properties) {
                relationshipName.getProperties().remove(property);
            }
            hibernateSession.persist((Object)relationshipName);
            hibernateSession.flush();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot remove relationship name properties: " + name, (Throwable)e);
        }
    }

    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        try {
            HibernateIdentityObjectRelationship hibernateRelationship = relationship.getName() != null ? this.findIdentityObjectRelationshipByAttributes(this.getHibernateSession(ctx), fromIO, toIO, type.getId(), relationship.getName()) : this.findIdentityObjectRelationshipByIdentityByType(this.getHibernateSession(ctx), fromIO, toIO, type.getName());
            Hibernate.initialize(hibernateRelationship.getProperties());
            return new HashMap<String, String>(hibernateRelationship.getProperties());
        }
        catch (HibernateException e) {
            throw new IdentityException(CANNOT_OBTAIN_RELATIONSHIP_PROPERTIES + String.valueOf(relationship), (Throwable)e);
        }
    }

    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        try {
            Session hibernateSession = this.getHibernateSession(ctx);
            HibernateIdentityObjectRelationship hibernateRelationship = relationship.getName() != null ? this.findIdentityObjectRelationshipByAttributes(hibernateSession, fromIO, toIO, type.getId(), relationship.getName()) : this.findIdentityObjectRelationshipByIdentityByType(hibernateSession, fromIO, toIO, type.getName());
            Hibernate.initialize(hibernateRelationship.getProperties());
            hibernateRelationship.getProperties().putAll(properties);
            hibernateSession.persist((Object)hibernateRelationship);
            hibernateSession.flush();
        }
        catch (HibernateException e) {
            throw new IdentityException(CANNOT_OBTAIN_RELATIONSHIP_PROPERTIES + String.valueOf(relationship), (Throwable)e);
        }
    }

    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException {
        HibernateIdentityObject fromIO = this.safeGet(ctx, relationship.getFromIdentityObject());
        HibernateIdentityObject toIO = this.safeGet(ctx, relationship.getToIdentityObject());
        HibernateIdentityObjectRelationshipType type = this.getHibernateIdentityObjectRelationshipType(ctx, relationship.getType());
        try {
            Session hibernateSession = this.getHibernateSession(ctx);
            HibernateIdentityObjectRelationship hibernateRelationship = relationship.getName() != null ? this.findIdentityObjectRelationshipByAttributes(hibernateSession, fromIO, toIO, type.getId(), relationship.getName()) : this.findIdentityObjectRelationshipByIdentityByType(hibernateSession, fromIO, toIO, type.getName());
            Hibernate.initialize(hibernateRelationship.getProperties());
            for (String property : properties) {
                hibernateRelationship.getProperties().remove(property);
            }
            hibernateSession.persist((Object)hibernateRelationship);
            hibernateSession.flush();
        }
        catch (HibernateException e) {
            throw new IdentityException(CANNOT_OBTAIN_RELATIONSHIP_PROPERTIES + String.valueOf(relationship), (Throwable)e);
        }
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        this.checkIOType(identityType);
        if (this.attributeMappings.containsKey(identityType.getName())) {
            return this.attributeMappings.get(identityType.getName());
        }
        return new HashSet<String>();
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext ctx, IdentityObject identity, String name) throws IdentityException {
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Set<HibernateIdentityObjectAttribute> storeAttributes = hibernateObject.getAttributes();
        Hibernate.initialize(storeAttributes);
        for (HibernateIdentityObjectAttribute attribute : storeAttributes) {
            String mappedName = this.resolveAttributeNameFromStoreMapping(identity.getIdentityType(), name);
            if (mappedName == null) continue;
            return attribute;
        }
        return null;
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        HibernateIdentityObject hibernateIdentityObject = this.getHibernateIdentityObject(ctx, identity);
        List<HibernateIdentityObjectAttribute> storeAttributes = this.findIdentityAttributes(this.getHibernateSession(ctx), hibernateIdentityObject);
        HashMap<String, IdentityObjectAttribute> result = new HashMap<String, IdentityObjectAttribute>();
        for (HibernateIdentityObjectAttribute attribute : storeAttributes) {
            String name = this.resolveAttributeNameFromStoreMapping(identity.getIdentityType(), attribute.getName());
            if (name == null) continue;
            result.put(name, attribute);
        }
        return result;
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return this.attributesMetaData.get(identityType.getName());
    }

    public void updateAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        this.checkAttributes(attributes);
        HashMap<String, IdentityObjectAttribute> mappedAttributes = new HashMap<String, IdentityObjectAttribute>();
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
        for (IdentityObjectAttribute attribute : attributes) {
            IdentityObject checkIdentity;
            String name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attribute.getName());
            mappedAttributes.put(name, attribute);
            if (!(mdMap != null && mdMap.containsKey(attribute.getName()) || this.isAllowNotDefinedAttributes)) {
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attribute.getName());
            }
            if (mdMap == null || !mdMap.containsKey(attribute.getName())) continue;
            IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
            if (!amd.isMultivalued() && attribute.getSize() > 1) {
                throw new IdentityException("Cannot assigned multiply values to single valued attribute: " + attribute.getName());
            }
            if (amd.isReadonly()) {
                mappedAttributes.remove(name);
                continue;
            }
            if (amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + String.valueOf(checkIdentity));
            }
            String type = amd.getType();
            for (HibernateIdentityObjectAttribute value : attribute.getValues()) {
                if (type.equals("text") && !(value instanceof String)) {
                    throw new IdentityException("Cannot update text type attribute with not String type value: " + attribute.getName() + " / " + String.valueOf(value));
                }
                if (!type.equals("binary") || value instanceof byte[]) continue;
                throw new IdentityException("Cannot update binary type attribute with not byte[] type value: " + attribute.getName() + " / " + String.valueOf(value));
            }
            if (!type.equals("binary") || attribute.getValues().size() <= 1) continue;
            throw new IdentityException("Cannot add binary type attribute with more than one value - this implementationsupport only single value binary attributes: " + attribute.getName());
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String name : mappedAttributes.keySet()) {
            IdentityObjectAttribute attribute;
            attribute = (IdentityObjectAttribute)mappedAttributes.get(name);
            IdentityObjectAttributeMetaData amd = null;
            if (mdMap != null) {
                amd = mdMap.get(attribute.getName());
            }
            String type = amd != null ? amd.getType() : "text";
            boolean present = false;
            for (HibernateIdentityObjectAttribute storeAttribute : hibernateObject.getAttributes()) {
                if (!storeAttribute.getName().equals(name)) continue;
                present = true;
                if (storeAttribute.getType().equals("text")) {
                    if (!type.equals("text")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as text is mapped with: " + type + ATTRIBUTE_NAME + name);
                    }
                    HashSet<String> v = new HashSet<String>();
                    for (Object value : attribute.getValues()) {
                        v.add(value.toString());
                    }
                    storeAttribute.setTextValues(v);
                    break;
                }
                if (storeAttribute.getType().equals("binary")) {
                    if (!type.equals("binary")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as binary is mapped with: " + type + ATTRIBUTE_NAME + name);
                    }
                    HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                    this.getHibernateSession(ctx).persist((Object)bv);
                    storeAttribute.setBinaryValue(bv);
                    break;
                }
                throw new IdentityException("Internal identity store error");
            }
            if (present || attribute.getValues() == null || attribute.getValues().isEmpty()) continue;
            HibernateIdentityObjectAttribute newAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, type);
            if (type.equals("text")) {
                newAttribute.setTextValues(attribute.getValues());
            } else if (type.equals("binary")) {
                HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                this.getHibernateSession(ctx).persist((Object)bv);
                newAttribute.setBinaryValue(bv);
            }
            hibernateObject.addAttribute(newAttribute);
        }
    }

    public void addAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        this.checkAttributes(attributes);
        HashMap<String, IdentityObjectAttribute> mappedAttributes = new HashMap<String, IdentityObjectAttribute>();
        Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
        for (IdentityObjectAttribute attribute : attributes) {
            IdentityObject checkIdentity;
            String name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attribute.getName());
            mappedAttributes.put(name, attribute);
            if (!(mdMap != null && mdMap.containsKey(attribute.getName()) || this.isAllowNotDefinedAttributes)) {
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attribute.getName());
            }
            IdentityObjectAttributeMetaData amd = null;
            if (mdMap != null) {
                amd = mdMap.get(attribute.getName());
            }
            if (amd == null) continue;
            if (!amd.isMultivalued() && attribute.getSize() > 1) {
                throw new IdentityException("Cannot add multiply values to single valued attribute: " + attribute.getName());
            }
            if (amd.isReadonly()) {
                mappedAttributes.remove(name);
                continue;
            }
            if (amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + String.valueOf(checkIdentity));
            }
            String type = amd.getType();
            for (HibernateIdentityObjectAttribute hibernateIdentityObjectAttribute : attribute.getValues()) {
                if (type.equals("text") && !(hibernateIdentityObjectAttribute instanceof String)) {
                    throw new IdentityException("Cannot add text type attribute with not String type value: " + attribute.getName() + " / " + String.valueOf(hibernateIdentityObjectAttribute));
                }
                if (!type.equals("binary") || hibernateIdentityObjectAttribute instanceof byte[]) continue;
                throw new IdentityException("Cannot add binary type attribute with not byte[] type value: " + attribute.getName() + " / " + String.valueOf(hibernateIdentityObjectAttribute));
            }
            if (!type.equals("binary") || attribute.getValues().size() <= 1) continue;
            throw new IdentityException("Cannot add binary type attribute with more than one value - this implementationsupport only single value binary attributes: " + attribute.getName());
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String name : mappedAttributes.keySet()) {
            IdentityObjectAttribute attribute;
            attribute = (IdentityObjectAttribute)mappedAttributes.get(name);
            IdentityObjectAttributeMetaData amd = mdMap != null ? mdMap.get(attribute.getName()) : null;
            String type = amd != null ? amd.getType() : "text";
            HibernateIdentityObjectAttribute hibernateAttribute = null;
            for (HibernateIdentityObjectAttribute hibernateIdentityObjectAttribute : hibernateObject.getAttributes()) {
                if (!hibernateIdentityObjectAttribute.getName().equals(name)) continue;
                hibernateAttribute = hibernateIdentityObjectAttribute;
                break;
            }
            if (hibernateAttribute != null) {
                if (hibernateAttribute.getType().equals("text")) {
                    if (!type.equals("text")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as text is mapped with: " + type + ATTRIBUTE_NAME + name);
                    }
                    HashSet<String> mergedValues = new HashSet<String>(hibernateAttribute.getValues());
                    for (Object value : attribute.getValues()) {
                        mergedValues.add(value.toString());
                    }
                    hibernateAttribute.setTextValues(mergedValues);
                    break;
                }
                if (hibernateAttribute.getType().equals("binary")) {
                    if (!type.equals("binary")) {
                        throw new IdentityException("Wrong attribute mapping. Attribute persisted as binary is mapped with: " + type + ATTRIBUTE_NAME + name);
                    }
                    HibernateIdentityObjectAttributeBinaryValue bv = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                    this.getHibernateSession(ctx).persist((Object)bv);
                    hibernateAttribute.setBinaryValue(bv);
                    break;
                }
                throw new IdentityException("Internal identity store error");
            }
            if (type.equals("text")) {
                values = new HashSet<String>();
                for (Object value : attribute.getValues()) {
                    values.add(value.toString());
                }
                hibernateAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, "text");
                hibernateAttribute.setTextValues(values);
            } else if (type.equals("binary")) {
                values = new HashSet();
                for (Object value : attribute.getValues()) {
                    values.add((String)((byte[])value));
                }
                hibernateAttribute = new HibernateIdentityObjectAttribute(hibernateObject, name, "binary");
                HibernateIdentityObjectAttributeBinaryValue hibernateIdentityObjectAttributeBinaryValue = new HibernateIdentityObjectAttributeBinaryValue((byte[])attribute.getValue());
                this.getHibernateSession(ctx).persist((Object)hibernateIdentityObjectAttributeBinaryValue);
                hibernateAttribute.setBinaryValue(hibernateIdentityObjectAttributeBinaryValue);
            }
            hibernateObject.addAttribute(hibernateAttribute);
        }
    }

    public void removeAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, String[] attributes) throws IdentityException {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes are null");
        }
        String[] mappedAttributes = new String[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            String name;
            mappedAttributes[i] = name = this.resolveAttributeStoreMapping(identity.getIdentityType(), attributes[i]);
            Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
            if (mdMap != null) {
                IdentityObjectAttributeMetaData amd = mdMap.get(attributes[i]);
                if (amd == null || !amd.isRequired()) continue;
                throw new IdentityException("Cannot remove required attribute: " + attributes[i]);
            }
            if (this.isAllowNotDefinedAttributes) continue;
            throw new IdentityException("Cannot remove not defined attribute. Use 'allowNotDefinedAttributes' option if needed. Attribute name: " + attributes[i]);
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identity);
        Hibernate.initialize(hibernateObject.getAttributes());
        for (String attr : mappedAttributes) {
            hibernateObject.removeAttribute(attr);
        }
    }

    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityObjectType, IdentityObjectAttribute attribute) throws IdentityException {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        this.checkIOType(identityObjectType);
        String attrMappedName = this.resolveAttributeStoreMapping(identityObjectType, attribute.getName());
        HibernateIdentityObjectType hiot = this.getHibernateIdentityObjectType(invocationCtx, identityObjectType);
        Session session = this.getHibernateSession(invocationCtx);
        HibernateRealm realm = this.getRealm(session, invocationCtx);
        if (attribute.getValues() == null || attribute.getValues().isEmpty()) {
            return null;
        }
        boolean attrDuctTypeText = true;
        if (attribute.getValue() instanceof byte[]) {
            attrDuctTypeText = false;
        }
        StringBuilder queryString = new StringBuilder("select a from HibernateIdentityObjectAttribute a where a.identityObject.identityType = :identityType and a.name = :attributeName and a.identityObject.realm = :realm");
        if (attrDuctTypeText) {
            for (int i = 0; i < attribute.getValues().size(); ++i) {
                String paramName = " :value" + i;
                queryString.append(" and").append(paramName).append(" = any elements(a.textValues)");
            }
        } else {
            queryString.append(" and :value = a.binaryValue");
        }
        Query q = session.createQuery(queryString.toString(), HibernateIdentityObjectAttribute.class);
        q.setParameter("identityType", (Object)hiot).setParameter("attributeName", (Object)attrMappedName).setParameter(REALM_PARAM, (Object)realm);
        if (attrDuctTypeText) {
            int i = 0;
            for (Object o : attribute.getValues()) {
                String value = o.toString();
                String paramName = "value" + i;
                q.setParameter(paramName, (Object)value);
                ++i;
            }
        } else {
            q.setParameter("value", attribute.getValue());
        }
        List attrs = q.list();
        if (attrs.isEmpty()) {
            return null;
        }
        if (attrs.size() > 1) {
            throw new IdentityException("Illegal state - more than one IdentityObject with the same unique attribute value: " + String.valueOf(attribute));
        }
        return ((HibernateIdentityObjectAttribute)attrs.get(0)).getIdentityObject();
    }

    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        if (this.supportedFeatures.isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), credential.getType())) {
            Object value;
            HibernateIdentityObjectCredential hibernateCredential = (HibernateIdentityObjectCredential)this.getHibernateSession(ctx).createNamedQuery("HibernateIdentityObjectCredential.findCredentialByTypeAndIdentity", HibernateIdentityObjectCredential.class).setParameter("cTypeName", (Object)credential.getType().getName()).setParameter("ioId", (Object)hibernateObject.getId()).uniqueResult();
            if (hibernateCredential == null) {
                return false;
            }
            Object tmpEncodedValue = credential.getEncodedValue();
            Object object = value = tmpEncodedValue == null ? credential.getValue() : tmpEncodedValue;
            if (value instanceof String) {
                String valueString = (String)value;
                if (hibernateCredential.getTextValue() != null) {
                    return valueString.equals(hibernateCredential.getTextValue());
                }
            }
            if (value instanceof byte[]) {
                byte[] valueBytes = (byte[])value;
                if (hibernateCredential.getBinaryValue() != null) {
                    return Arrays.equals(valueBytes, hibernateCredential.getBinaryValue().getValue());
                }
            }
            throw new IdentityException("Not supported credential value: " + String.valueOf(value.getClass()));
        }
        throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        Object tmpEncodedValue;
        Object value;
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        HibernateIdentityObject hibernateObject = this.safeGet(ctx, identityObject);
        Session hibernateSession = this.getHibernateSession(ctx);
        if (!this.supportedFeatures.isCredentialSupported((IdentityObjectType)hibernateObject.getIdentityType(), credential.getType())) throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
        HibernateIdentityObjectCredentialType hibernateCredentialType = this.getHibernateIdentityObjectCredentialType(ctx, credential.getType());
        if (hibernateCredentialType == null) {
            throw new IllegalStateException("Credential type not present in this store: " + credential.getType().getName());
        }
        HibernateIdentityObjectCredential hibernateCredential = hibernateObject.getCredential(credential.getType());
        if (hibernateCredential == null) {
            hibernateCredential = new HibernateIdentityObjectCredential();
            hibernateCredential.setType(hibernateCredentialType);
            hibernateObject.addCredential(hibernateCredential);
        }
        Object object = value = (tmpEncodedValue = credential.getEncodedValue()) == null ? credential.getValue() : tmpEncodedValue;
        if (value instanceof String) {
            String valueString = (String)value;
            hibernateCredential.setTextValue(valueString);
        } else {
            if (!(value instanceof byte[])) throw new IdentityException("Not supported credential value: " + String.valueOf(value.getClass()));
            byte[] valueBytes = (byte[])value;
            HibernateIdentityObjectCredentialBinaryValue bv = new HibernateIdentityObjectCredentialBinaryValue(valueBytes);
            this.getHibernateSession(ctx).persist((Object)bv);
            hibernateCredential.setBinaryValue(bv);
        }
        hibernateSession.persist((Object)hibernateCredential);
        hibernateObject.addCredential(hibernateCredential);
        hibernateSession.flush();
    }

    public void addIdentityObjectType(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        HibernateIdentityObjectType hibernateType = new HibernateIdentityObjectType(type);
        this.getHibernateSession(ctx).persist((Object)hibernateType);
        this.getHibernateSession(ctx).flush();
    }

    public void addIdentityObjectRelationshipType(IdentityStoreInvocationContext ctx, IdentityObjectRelationshipType type) throws IdentityException {
        HibernateIdentityObjectRelationshipType hibernateType = new HibernateIdentityObjectRelationshipType(type);
        this.getHibernateSession(ctx).persist((Object)hibernateType);
        this.getHibernateSession(ctx).flush();
    }

    protected Session getHibernateSession(IdentityStoreInvocationContext ctx) throws IdentityException {
        try {
            HibernateIdentityStoreSessionImpl hbIdentityStoreSession = (HibernateIdentityStoreSessionImpl)ctx.getIdentityStoreSession();
            if (this.lazyStartOfHibernateTransaction) {
                hbIdentityStoreSession.startHibernateTransactionIfNotStartedYet();
            }
            return (Session)hbIdentityStoreSession.getSessionContext();
        }
        catch (Exception e) {
            throw new IdentityException("Cannot obtain Hibernate Session", (Throwable)e);
        }
    }

    private void checkIOInstance(IdentityObject io) {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
    }

    private HibernateIdentityObject safeGet(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        this.checkIOInstance(io);
        if (io instanceof HibernateIdentityObject) {
            HibernateIdentityObject identityObject = (HibernateIdentityObject)io;
            return identityObject;
        }
        return this.getHibernateIdentityObject(ctx, io);
    }

    private void checkIOType(IdentityObjectType iot) throws IdentityException {
        if (iot == null) {
            throw new IllegalArgumentException("IdentityObjectType is null");
        }
        if (!this.getSupportedFeatures().isIdentityObjectTypeSupported(iot) && !this.isAllowNotDefinedIdentityObjectTypes()) {
            throw new IdentityException("IdentityType not supported by this IdentityStore implementation: " + String.valueOf(iot));
        }
    }

    private HibernateIdentityObjectType getHibernateIdentityObjectType(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        HibernateIdentityObjectType hibernateType;
        this.checkIOType(type);
        String typeName = type.getName();
        try {
            Session hibernateSession = this.getHibernateSession(ctx);
            hibernateType = this.findIdentityObjectTypeByName(hibernateSession, typeName);
            if (hibernateType == null) {
                if (this.isAllowNotDefinedIdentityObjectTypes()) {
                    this.populateObjectTypes(hibernateSession, new String[]{typeName});
                }
                hibernateType = this.findIdentityObjectTypeByName(hibernateSession, typeName);
            }
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObjectType[" + typeName + NOT_PRESENT_IN_THE_STORE, (Throwable)e);
        }
        if (hibernateType == null) {
            throw new IdentityException("IdentityObjectType[" + typeName + NOT_PRESENT_IN_THE_STORE);
        }
        return hibernateType;
    }

    private HibernateIdentityObject getHibernateIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        HibernateIdentityObject identity;
        Session hibernateSession = this.getHibernateSession(ctx);
        HibernateIdentityObjectType hibernateType = this.getHibernateIdentityObjectType(ctx, io.getIdentityType());
        HibernateRealm realm = this.getRealm(hibernateSession, ctx);
        try {
            identity = this.findIdentityObjectByNameAndType(hibernateSession, io.getName(), hibernateType.getName(), realm.getName());
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObject[ " + io.getName() + " | " + io.getIdentityType().getName() + NOT_PRESENT_IN_THE_STORE, (Throwable)e);
        }
        if (identity == null) {
            throw new IdentityException("IdentityObject[ " + io.getName() + " | " + io.getIdentityType().getName() + NOT_PRESENT_IN_THE_STORE);
        }
        return identity;
    }

    private HibernateIdentityObjectRelationshipType getHibernateIdentityObjectRelationshipType(IdentityStoreInvocationContext ctx, IdentityObjectRelationshipType iot) throws IdentityException {
        try {
            return this.findIdentityRelationshipTypeByName(this.getHibernateSession(ctx), iot.getName());
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObjectRelationshipType[ " + iot.getName() + NOT_PRESENT_IN_THE_STORE);
        }
    }

    private HibernateIdentityObjectCredentialType getHibernateIdentityObjectCredentialType(IdentityStoreInvocationContext ctx, IdentityObjectCredentialType credentialType) throws IdentityException {
        try {
            return this.findIdentityCredentialTypeByName(this.getHibernateSession(ctx), credentialType.getName());
        }
        catch (HibernateException e) {
            throw new IdentityException("IdentityObjectCredentialType[ " + credentialType.getName() + NOT_PRESENT_IN_THE_STORE);
        }
    }

    public void populateObjectTypes(Session hibernateSession, String[] typeNames) {
        for (String typeName : typeNames) {
            HibernateIdentityObjectType hibernateType = this.findIdentityObjectTypeByName(hibernateSession, typeName);
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectType(typeName);
            hibernateSession.persist((Object)hibernateType);
            hibernateSession.flush();
        }
    }

    public void populateRelationshipTypes(Session hibernateSession, String[] typeNames) {
        for (String typeName : typeNames) {
            HibernateIdentityObjectRelationshipType relationshipType = this.findIdentityRelationshipTypeByName(hibernateSession, typeName);
            if (relationshipType != null) continue;
            relationshipType = new HibernateIdentityObjectRelationshipType(typeName);
            hibernateSession.persist((Object)relationshipType);
            hibernateSession.flush();
        }
    }

    public void populateCredentialTypes(Session hibernateSession, String[] typeNames) {
        for (String typeName : typeNames) {
            HibernateIdentityObjectCredentialType hibernateType = this.findIdentityCredentialTypeByName(hibernateSession, typeName);
            if (hibernateType != null) continue;
            hibernateType = new HibernateIdentityObjectCredentialType(typeName);
            hibernateSession.persist((Object)hibernateType);
            hibernateSession.flush();
        }
    }

    public void addRealm(Session hibernateSession, String realmName) throws IdentityException {
        try {
            HibernateRealm realm = new HibernateRealm(realmName);
            hibernateSession.persist((Object)realm);
            hibernateSession.flush();
        }
        catch (Exception e) {
            throw new IdentityException("Failed to create store realm", (Throwable)e);
        }
    }

    private HibernateRealm getRealm(Session hibernateSession, IdentityStoreInvocationContext ctx) throws IdentityException {
        if (this.getRealmName(ctx) == null) {
            throw new IllegalStateException("Realm Id not present");
        }
        if (!this.isRealmAware()) {
            HibernateRealm realm = this.getRealmByName(hibernateSession, DEFAULT_REALM_NAME);
            if (realm == null) {
                throw new IdentityException("Default store realm is not present: " + DEFAULT_REALM_NAME);
            }
            return realm;
        }
        HibernateRealm realm = this.getRealmByName(hibernateSession, this.getRealmName(ctx));
        if (realm == null) {
            HibernateRealm newRealm = new HibernateRealm(this.getRealmName(ctx));
            hibernateSession.persist((Object)newRealm);
            hibernateSession.flush();
            return newRealm;
        }
        return realm;
    }

    private String getRealmName(IdentityStoreInvocationContext ctx) {
        if (this.isRealmAware()) {
            return ctx.getRealmId();
        }
        return DEFAULT_REALM_NAME;
    }

    private boolean isRealmAware() {
        return this.isRealmAware;
    }

    private boolean isAllowNotDefinedAttributes() {
        return this.isAllowNotDefinedAttributes;
    }

    private String resolveAttributeStoreMapping(IdentityObjectType type, String name) throws IdentityException {
        IdentityObjectAttributeMetaData amd;
        String mapping = null;
        if (this.attributesMetaData.containsKey(type.getName()) && (amd = this.attributesMetaData.get(type.getName()).get(name)) != null) {
            mapping = amd.getStoreMapping() != null ? amd.getStoreMapping() : amd.getName();
            return mapping;
        }
        if (this.isAllowNotDefinedAttributes()) {
            mapping = name;
            return mapping;
        }
        throw new IdentityException("Attribute name is not configured in this store");
    }

    private String resolveAttributeNameFromStoreMapping(IdentityObjectType type, String mapping) {
        Map<String, String> map;
        if (this.reverseAttributeMappings.containsKey(type.getName()) && (map = this.reverseAttributeMappings.get(type.getName())) != null) {
            return map.containsKey(mapping) ? map.get(mapping) : mapping;
        }
        if (this.isAllowNotDefinedAttributes()) {
            return mapping;
        }
        return null;
    }

    private void filterByAttributesValues(Collection<IdentityObject> objects, Map<String, String[]> attrs) {
        HashSet<IdentityObject> toRemove = new HashSet<IdentityObject>();
        block2: for (IdentityObject object : objects) {
            Map<String, Collection> presentAttrs = ((HibernateIdentityObject)object).getAttributesAsMap();
            block3: for (Map.Entry<String, String[]> entry : attrs.entrySet()) {
                String mappedAttributeName = null;
                try {
                    mappedAttributeName = this.resolveAttributeStoreMapping(object.getIdentityType(), entry.getKey());
                }
                catch (IdentityException identityException) {
                    // empty catch block
                }
                if (mappedAttributeName == null) {
                    toRemove.add(object);
                    continue block2;
                }
                if (presentAttrs.containsKey(mappedAttributeName)) {
                    HashSet<String> given = new HashSet<String>(Arrays.asList(entry.getValue()));
                    Collection present = presentAttrs.get(mappedAttributeName);
                    for (String s : given) {
                        String regex = Tools.wildcardToRegex((String)s);
                        boolean matches = false;
                        for (Object o : present) {
                            if (!o.toString().matches(regex)) continue;
                            matches = true;
                        }
                        if (matches) continue;
                        toRemove.add(object);
                        continue block3;
                    }
                    continue;
                }
                toRemove.add(object);
                continue block2;
            }
        }
        for (IdentityObject identityObject : toRemove) {
            objects.remove(identityObject);
        }
    }

    private <T> List<T> cutPageFromResults(List<T> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<T> results = new LinkedList<T>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    private void applyQueryParameters(Query<?> hibernateQuery, Map<String, Object> queryParams) {
        for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
            hibernateQuery.setParameter(entry.getKey(), entry.getValue());
        }
    }

    protected boolean isAllowNotDefinedIdentityObjectTypes() {
        return this.isAllowNotDefinedIdentityObjectTypes;
    }

    public boolean isManageTransactionDuringBootstrap() {
        return this.isManageTransactionDuringBootstrap;
    }

    public boolean isAllowNotCaseSensitiveSearch() {
        return this.isAllowNotCaseSensitiveSearch;
    }

    private void removeRelationshipsByName(IdentityStoreInvocationContext ctx, HibernateIdentityObjectRelationshipName hiorn) throws IdentityException {
        List relationships = this.getHibernateSession(ctx).createNamedQuery("HibernateIdentityObjectRelationship.getRelationshipsByName", HibernateIdentityObjectRelationship.class).setParameter("nameId", (Object)hiorn.getId()).list();
        Hibernate.initialize((Object)relationships);
        for (HibernateIdentityObjectRelationship rel : relationships) {
            this.removeRelationship(ctx, rel.getFromIdentityObject(), rel.getToIdentityObject(), rel.getType(), rel.getName());
        }
    }

    private void checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
    }

    private void checkAttributes(IdentityObjectAttribute[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attributes are null");
        }
    }

    private HibernateIdentityObjectRelationshipName getRelationshipName(IdentityStoreInvocationContext ctx, String name, Session hibernateSession) throws IdentityException {
        HibernateIdentityObjectRelationshipName relationshipName = this.findIdentityObjectRelationshipNameByName(hibernateSession, name, this.getRealmName(ctx));
        this.checkRelationshipName(name, relationshipName);
        return relationshipName;
    }

    private void checkRelationshipName(String name, HibernateIdentityObjectRelationshipName relationshipName) throws IdentityException {
        if (relationshipName == null) {
            throw new IdentityException("Relationship name " + name + " doesn't exist");
        }
    }

    private Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria, HibernateIdentityObject hibernateObject) throws IdentityException {
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Object> paramValues = new ArrayList<Object>();
        StringBuilder queryString = new StringBuilder();
        if (hibernateObject != null) {
            queryString.append("SELECT rn.name FROM HibernateIdentityObjectRelationshipName rn");
            queryString.append("INNER JOIN r.name rn");
            queryString.append(" WHERE");
        } else {
            queryString.append(" SELECT rn.name FROM HibernateIdentityObjectRelationship r");
            queryString.append(" INNER JOIN r.name rn");
            queryString.append(" WHERE (r.fromIdentityObject = :identity OR r.toIdentityObject = :identity)");
            queryString.append(" AND");
            paramNames.add(IDENTITY_PARAM);
            paramValues.add(hibernateObject);
        }
        try {
            paramNames.add(REALM_NAME_PARAM);
            paramValues.add(this.getRealmName(ctx));
            queryString.append(" rn.realm.name = :").append(REALM_NAME_PARAM);
            if (criteria != null && criteria.getFilter() != null) {
                paramNames.add(NAME_PARAM);
                paramValues.add(criteria.getFilter().replace("\\*", "%").replace("*", "%"));
                queryString.append(" AND rn.name LIKE :").append(NAME_PARAM);
            } else {
                queryString.append(" AND rn.name IS NOT NULL");
            }
            if (hibernateObject != null) {
                queryString.append(" AND (rn.name IS NOT NULL)");
            }
            if (criteria != null && criteria.isSorted()) {
                if (criteria.isAscending()) {
                    queryString.append(" ORDER BY rn.name ASC");
                } else {
                    queryString.append(" ORDER BY rn.name DESC");
                }
            }
            Query query = this.getHibernateSession(ctx).createQuery(queryString.toString(), String.class);
            if (criteria != null && criteria.isPaged() && !criteria.isFiltered()) {
                if (criteria.getMaxResults() > 0) {
                    query.setMaxResults(criteria.getMaxResults());
                }
                query.setFirstResult(criteria.getFirstResult());
            }
            for (int i = 0; i < paramNames.size(); ++i) {
                query.setParameter((String)paramNames.get(i), paramValues.get(i));
            }
            List results = query.list();
            Hibernate.initialize((Object)results);
            return new HashSet<String>(results);
        }
        catch (Exception e) {
            throw new IdentityException("Cannot get relationship names. ", (Throwable)e);
        }
    }

    private HibernateRealm getRealmByName(Session hibernateSession, String name) {
        return (HibernateRealm)hibernateSession.createNamedQuery("HibernateRealm.findRealmByName", HibernateRealm.class).setParameter(NAME_PARAM, (Object)name).uniqueResult();
    }

    private int countIdentityObjectByNameAndType(Session hibernateSession, String identityName, String identityType, String realmName) {
        Number result = (Number)hibernateSession.createNamedQuery("HibernateIdentityObject.countIdentityObjectByNameAndType", Number.class).setParameter(REALM_NAME_PARAM, (Object)realmName).setParameter(NAME_PARAM, (Object)identityName).setParameter("typeName", (Object)identityType).uniqueResult();
        return result == null ? 0 : result.intValue();
    }

    private HibernateIdentityObject findIdentityObjectByNameAndType(Session hibernateSession, String identityName, String identityType, String realmName) {
        return (HibernateIdentityObject)hibernateSession.createNamedQuery("HibernateIdentityObject.findIdentityObjectByNameAndType", HibernateIdentityObject.class).setParameter(REALM_NAME_PARAM, (Object)realmName).setParameter(NAME_PARAM, (Object)identityName).setParameter("typeName", (Object)identityType).uniqueResult();
    }

    private HibernateIdentityObjectRelationshipName findIdentityObjectRelationshipNameByName(Session hibernateSession, String relationshipName, String realmName) {
        return (HibernateIdentityObjectRelationshipName)hibernateSession.createNamedQuery("HibernateIdentityObjectRelationshipName.findIdentityObjectRelationshipNameByName", HibernateIdentityObjectRelationshipName.class).setParameter(REALM_NAME_PARAM, (Object)realmName).setParameter(NAME_PARAM, (Object)relationshipName).uniqueResult();
    }

    private HibernateIdentityObjectRelationship findIdentityObjectRelationshipByIdentityByType(Session hibernateSession, HibernateIdentityObject fromIdentityObject, HibernateIdentityObject toIdentityObject, String typeName) {
        return (HibernateIdentityObjectRelationship)hibernateSession.createNamedQuery("HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByIdentityByType", HibernateIdentityObjectRelationship.class).setParameter("fromIdentityObject", (Object)fromIdentityObject).setParameter("toIdentityObject", (Object)toIdentityObject).setParameter("typeName", (Object)typeName).uniqueResult();
    }

    private HibernateIdentityObjectRelationship findIdentityObjectRelationshipByAttributes(Session hibernateSession, HibernateIdentityObject fromIdentityObject, HibernateIdentityObject toIdentityObject, Long typeId, String relationName) {
        return (HibernateIdentityObjectRelationship)hibernateSession.createNamedQuery("HibernateIdentityObjectRelationship.findIdentityObjectRelationshipByAttributes", HibernateIdentityObjectRelationship.class).setParameter("fromIdentityObject", (Object)fromIdentityObject).setParameter("toIdentityObject", (Object)toIdentityObject).setParameter("typeId", (Object)typeId).setParameter(NAME_PARAM, (Object)relationName).uniqueResult();
    }

    private List<HibernateIdentityObjectRelationship> findIdentityObjectRelationshipsByIdentities(Session hibernateSession, HibernateIdentityObject hio1, HibernateIdentityObject hio2) {
        return hibernateSession.createNamedQuery("HibernateIdentityObjectRelationship.findIdentityObjectRelationshipsByIdentities", HibernateIdentityObjectRelationship.class).setParameter("hio1", (Object)hio1).setParameter("hio2", (Object)hio2).list();
    }

    private List<HibernateIdentityObjectAttribute> findIdentityAttributes(Session hibernateSession, HibernateIdentityObject identityObject) {
        return hibernateSession.createNamedQuery("HibernateIdentityObjectAttribute.findIdentityAttributes", HibernateIdentityObjectAttribute.class).setParameter("identityObject", (Object)identityObject).list();
    }

    private HibernateIdentityObjectRelationshipType findIdentityRelationshipTypeByName(Session hibernateSession, String name) {
        return (HibernateIdentityObjectRelationshipType)hibernateSession.createNamedQuery("HibernateIdentityObjectRelationshipType.findIdentityRelationshipTypeByName", HibernateIdentityObjectRelationshipType.class).setParameter(NAME_PARAM, (Object)name).uniqueResult();
    }

    private HibernateIdentityObjectCredentialType findIdentityCredentialTypeByName(Session hibernateSession, String name) {
        return (HibernateIdentityObjectCredentialType)hibernateSession.createNamedQuery("HibernateIdentityObjectCredentialType.findIdentityCredentialTypeByName", HibernateIdentityObjectCredentialType.class).setParameter(NAME_PARAM, (Object)name).uniqueResult();
    }

    private HibernateIdentityObjectType findIdentityObjectTypeByName(Session hibernateSession, String typeName) {
        return (HibernateIdentityObjectType)hibernateSession.createNamedQuery("HibernateIdentityObjectType.findIdentityObjectTypeByName", HibernateIdentityObjectType.class).setParameter(NAME_PARAM, (Object)typeName).uniqueResult();
    }

    static {
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.ATTRIBUTE_FILTER);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.NAME_FILTER);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.PAGE);
        supportedIdentityObjectSearchCriteria.add(IdentityObjectSearchCriteriaType.SORT);
        supportedCredentialTypes.add(CREDENTIAL_TYPE_PASSWORD);
        supportedCredentialTypes.add(CREDENTIAL_TYPE_BINARY);
    }
}

