/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.picketlink.idm.api.IdentitySession;

public class AbstractDAOImpl {
    protected final PicketLinkIDMService service_;
    protected final PicketLinkIDMOrganizationServiceImpl orgService;
    protected final Log log = ExoLogger.getLogger(this.getClass());

    public AbstractDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService idmService) {
        this.service_ = idmService;
        this.orgService = orgService;
    }

    public void handleException(String messageToLog, Exception e) {
        try {
            this.orgService.recoverFromIDMError();
            throw new IllegalStateException(messageToLog, e);
        }
        catch (IllegalStateException e1) {
            throw e1;
        }
        catch (Exception e1) {
            this.log.warn("Second Exception when rolling back original error {}/{}", new Object[]{messageToLog, e.getMessage(), e1});
            throw new IllegalStateException(messageToLog, e);
        }
    }

    protected IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }
}

