/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.idm.Config;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractTestOrganizationService {
    private static String Group1 = "Group1";
    private static String Group2 = "Group2";
    private static String Group3 = "Group3";
    private static String Benj = "Benj";
    private static String Tuan = "Tuan";
    private OrganizationService service_;
    private UserHandler userHandler_;
    private UserProfileHandler profileHandler_;
    private GroupHandler groupHandler_;
    private MembershipTypeHandler mtHandler_;
    private MembershipHandler membershipHandler_;
    boolean runtest = true;
    private static final String USER = "test";
    private static final List<String> USERS = new ArrayList<String>(15);
    private static final int USERS_LIST_SIZE = 15;
    private PortalContainer container;

    @Before
    public void setUp() throws Exception {
        if (!this.runtest) {
            return;
        }
        this.container = PortalContainer.getInstance();
        this.service_ = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
        this.userHandler_ = this.service_.getUserHandler();
        this.profileHandler_ = this.service_.getUserProfileHandler();
        this.groupHandler_ = this.service_.getGroupHandler();
        this.mtHandler_ = this.service_.getMembershipTypeHandler();
        this.membershipHandler_ = this.service_.getMembershipHandler();
        RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.service_));
    }

    @After
    public void tearDown() throws Exception {
        Query query = new Query();
        query.setUserName("test*");
        PageList users = this.userHandler_.findUsers(query);
        List allUsers = users.getAll();
        for (int i = allUsers.size() - 1; i >= 0; --i) {
            String userName = ((User)allUsers.get(i)).getUserName();
            this.userHandler_.removeUser(userName, true);
        }
        RequestLifeCycle.end();
    }

    @Test
    public void testSimple() throws Exception {
        Assert.assertTrue((boolean)true);
        Config config = ((PicketLinkIDMOrganizationServiceImpl)this.service_).getConfiguration();
        Assert.assertNotNull((Object)config);
        Assert.assertNotNull((Object)config.getGroupTypeMappings());
        Assert.assertNotNull(config.getGroupTypeMappings().keySet());
        Assert.assertTrue((config.getGroupTypeMappings().keySet().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals(config.getGroupTypeMappings().get("/"), (Object)"root_type");
        Assert.assertEquals((Object)config.getGroupType("/"), (Object)"root_type");
        Assert.assertEquals((Object)config.getGroupType(null), (Object)"root_type");
        Assert.assertEquals((Object)config.getGroupType("/platform"), (Object)"platform_type");
        Assert.assertEquals((Object)config.getGroupType("/platform/administrators"), (Object)"platform_type");
        Assert.assertEquals((Object)config.getGroupType("/platform/guests"), (Object)"platform_type");
        Assert.assertEquals((Object)config.getGroupType("/platform/users"), (Object)"users_type");
        Assert.assertEquals((Object)config.getGroupType("/platform/users/john"), (Object)"platform_type");
        Assert.assertEquals((Object)config.getGroupType("/organization/acme/france/offices"), (Object)".organization.acme.france.offices");
        Assert.assertEquals((Object)config.getGroupType("/organization/acme/france/offices/paris"), (Object)".organization.acme.france.offices.paris");
        Assert.assertEquals((Object)config.getGroupType("/organization/acme/france"), (Object)"france_type");
        Assert.assertEquals((Object)config.getGroupType("/organization/acme"), (Object)".organization.acme");
        Assert.assertEquals((Object)config.getGroupType("/foo/bar"), (Object)".foo.bar");
        Assert.assertEquals((Object)config.getGroupType("/foo"), (Object)".foo");
        Assert.assertEquals((Object)config.getGroupType("/toto"), (Object)"toto_type");
        Assert.assertEquals((Object)config.getGroupType("/toto/lolo"), (Object)"toto_type");
        Assert.assertEquals((Object)config.getGroupType("/toto/lolo/tutu"), (Object)"toto_type");
    }

    @Test
    public void testUserPageSize() throws Exception {
        for (String name : USERS) {
            this.createUser(name);
        }
        Query query = new Query();
        query.setUserName(USER);
        PageList users = this.userHandler_.findUsers(query);
        Assert.assertEquals((long)15L, (long)users.getAll().size());
        Assert.assertEquals((long)1L, (long)users.getAvailablePage());
        List usersList = users.getPage(1);
        for (String username : USERS) {
            Assert.assertTrue((String)username, (boolean)usersList.stream().anyMatch(user -> StringUtils.equals((CharSequence)username, (CharSequence)user.getUserName())));
        }
    }

    @Test
    public void testUser() throws Exception {
        int initialSize = this.userHandler_.findAllUsers().getSize();
        this.createUser(USER);
        User user = this.userHandler_.findUserByName(USER);
        Assert.assertTrue((String)"Found user instance ", (user != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"Expect user name is: ", (Object)USER, (Object)user.getUserName());
        UserProfile userProfile = this.profileHandler_.findUserProfileByName(USER);
        Assert.assertNull((Object)this.profileHandler_.removeUserProfile(USER, true));
        Assert.assertNull((Object)this.profileHandler_.findUserProfileByName(USER));
        userProfile = this.profileHandler_.createUserProfileInstance(USER);
        userProfile.getUserInfoMap().put("key", "value");
        this.profileHandler_.saveUserProfile(userProfile, true);
        userProfile = this.profileHandler_.findUserProfileByName(USER);
        Assert.assertTrue((String)"Expect user profile is found: ", (userProfile != null ? 1 : 0) != 0);
        Assert.assertEquals(userProfile.getUserInfoMap().get("key"), (Object)"value");
        PageList users = this.userHandler_.findUsers(new Query());
        Assert.assertTrue((String)"Expect 1 user found ", (users.getAvailable() >= 1 ? 1 : 0) != 0);
        user.setFirstName("Exo(Update)");
        this.userHandler_.saveUser(user, false);
        userProfile.getUserInfoMap().put("user.gender", "male");
        this.profileHandler_.saveUserProfile(userProfile, true);
        userProfile = this.profileHandler_.findUserProfileByName(USER);
        Assert.assertEquals((String)"expect first name is", (Object)"Exo(Update)", (Object)user.getFirstName());
        Assert.assertEquals((String)"Expect profile is updated: user.gender is ", (Object)"male", userProfile.getUserInfoMap().get("user.gender"));
        PageList piterator = this.userHandler_.getUserPageList(10);
        Assert.assertEquals((long)((long)initialSize + 1L), (long)piterator.currentPage().size());
        this.userHandler_.removeUser(USER, true);
        piterator = this.userHandler_.getUserPageList(10);
        Assert.assertEquals((long)initialSize, (long)piterator.currentPage().size());
        Assert.assertNull((String)"User: USER is removed: ", (Object)this.userHandler_.findUserByName(USER));
        Assert.assertNull((String)" user's profile of USER was removed:", (Object)this.profileHandler_.findUserProfileByName(USER));
    }

    @Test
    public void testFindUserWithIllegalArgument() throws Exception {
        String USER = USER;
        this.createUser(USER);
        User user = this.userHandler_.findUserByName(null);
        Assert.assertTrue((user == null ? 1 : 0) != 0);
        user = this.userHandler_.findUserByName("sdg*Ssd\"sd'sd%");
        Assert.assertTrue((user == null ? 1 : 0) != 0);
        user = this.userHandler_.removeUser(null, true);
        Assert.assertTrue((user == null ? 1 : 0) != 0);
        user = this.userHandler_.findUserByName(USER);
        Assert.assertTrue((String)"NOT found user instance ", (user != null ? 1 : 0) != 0);
        this.userHandler_.removeUser(USER, true);
    }

    @Test
    public void testUniqueAttribute() throws Exception {
        if (this.userHandler_ instanceof UserDAOImpl) {
            UserDAOImpl ud = (UserDAOImpl)this.userHandler_;
            User user = this.userHandler_.createUserInstance("toto");
            user.setEmail("toto@gatein.org");
            this.userHandler_.createUser(user, true);
            user = this.userHandler_.createUserInstance("lolo");
            user.setEmail("lolo@gatein.org");
            this.userHandler_.createUser(user, true);
            Assert.assertNull((Object)ud.findUserByEmail("foobar"));
            user = ud.findUserByEmail("toto@gatein.org");
            Assert.assertNotNull((Object)user);
            Assert.assertEquals((Object)"toto", (Object)user.getUserName());
            user = ud.findUserByEmail("lolo@gatein.org");
            Assert.assertNotNull((Object)user);
            Assert.assertEquals((Object)"lolo", (Object)user.getUserName());
            ud.removeUser("toto", false);
            ud.removeUser("lolo", false);
        }
    }

    @Test
    public void testFindUsers() throws Exception {
        UserHandler userHandler = this.userHandler_;
        if (userHandler instanceof UserDAOImpl) {
            UserDAOImpl ud = (UserDAOImpl)userHandler;
            int initialSize = this.userHandler_.findAllUsers().getSize();
            User user1 = ud.createUserInstance("foo");
            user1.setFirstName("foo");
            user1.setLastName("bar");
            user1.setEmail("foo@bar.com");
            ud.createUser(user1, true);
            User user2 = ud.createUserInstance("foobar");
            user2.setFirstName("foobar");
            user2.setLastName("foobar");
            user2.setEmail("foobar@foobar.com");
            ud.createUser(user2, true);
            Query query = new Query();
            List users = ud.findUsers(query).getAll();
            Assert.assertEquals((long)(initialSize + 2), (long)users.size());
            Assert.assertTrue((String)"foo", (boolean)users.stream().anyMatch(user -> StringUtils.equals((CharSequence)"foo", (CharSequence)user.getUserName())));
            Assert.assertTrue((String)"foobar", (boolean)users.stream().anyMatch(user -> StringUtils.equals((CharSequence)"foobar", (CharSequence)user.getUserName())));
            query.setEmail("*foo*");
            users = ud.findUsers(query).getAll();
            Assert.assertEquals((long)2L, (long)users.size());
            Assert.assertEquals((Object)"foo", (Object)((User)users.get(0)).getUserName());
            Assert.assertEquals((Object)"foobar", (Object)((User)users.get(1)).getUserName());
            query.setEmail("*bar*");
            users = ud.findUsers(query).getAll();
            Assert.assertEquals((long)2L, (long)users.size());
            Assert.assertEquals((Object)"foo", (Object)((User)users.get(0)).getUserName());
            Assert.assertEquals((Object)"foobar", (Object)((User)users.get(1)).getUserName());
            query.setEmail("*bar.com*");
            users = ud.findUsers(query).getAll();
            Assert.assertEquals((long)2L, (long)users.size());
            Assert.assertEquals((Object)"foo", (Object)((User)users.get(0)).getUserName());
            Assert.assertEquals((Object)"foobar", (Object)((User)users.get(1)).getUserName());
            query.setEmail("*foobar*");
            users = ud.findUsers(query).getAll();
            Assert.assertEquals((long)1L, (long)users.size());
            Assert.assertEquals((Object)"foobar", (Object)((User)users.get(0)).getUserName());
            ud.removeUser("foo", true);
            ud.removeUser("foobar", true);
        }
    }

    @Test
    public void testGroup() throws Exception {
        String parentName = "GroupParent";
        Group groupParent = this.groupHandler_.findGroupById("/" + parentName);
        if (groupParent != null) {
            this.groupHandler_.removeGroup(groupParent, true);
        }
        groupParent = this.groupHandler_.createGroupInstance();
        groupParent.setGroupName(parentName);
        groupParent.setDescription("This is description");
        this.groupHandler_.addChild(null, groupParent, true);
        groupParent = this.groupHandler_.findGroupById(groupParent.getId());
        Assert.assertEquals((Object)"GroupParent", (Object)groupParent.getGroupName());
        Group groupChild1 = this.groupHandler_.createGroupInstance();
        groupChild1.setGroupName(Group1);
        groupChild1.setLabel("Group1 Label");
        this.groupHandler_.addChild(groupParent, groupChild1, true);
        Assert.assertEquals((Object)this.groupHandler_.findGroupById(groupChild1.getId()).getLabel(), (Object)"Group1 Label");
        groupChild1 = this.groupHandler_.findGroupById(groupChild1.getId());
        Assert.assertEquals((Object)groupChild1.getParentId(), (Object)groupParent.getId());
        Assert.assertEquals((String)"Expect group child's name is: ", (Object)Group1, (Object)groupChild1.getGroupName());
        groupChild1.setLabel("Group1 Label renamed");
        groupChild1.setDescription("new description ");
        this.groupHandler_.saveGroup(groupChild1, true);
        Assert.assertEquals((Object)this.groupHandler_.findGroupById(groupChild1.getId()).getLabel(), (Object)"Group1 Label renamed");
        Group groupChild2 = this.groupHandler_.createGroupInstance();
        groupChild2.setGroupName(Group2);
        this.groupHandler_.addChild(groupParent, groupChild2, true);
        groupChild2 = this.groupHandler_.findGroupById(groupChild2.getId());
        Assert.assertEquals((Object)groupChild2.getParentId(), (Object)groupParent.getId());
        Assert.assertEquals((String)"Expect group child's name is: ", (Object)Group2, (Object)groupChild2.getGroupName());
        Assert.assertEquals((String)"Expect number of child group in parent group is: ", (long)2L, (long)this.groupHandler_.findGroups(groupParent).size());
        ListAccess groupChildrenListAccess = this.groupHandler_.findGroupChildren(groupParent, null);
        Assert.assertEquals((String)"Expect number of child group in parent group is: ", (long)2L, (long)groupChildrenListAccess.getSize());
        Group[] childrenGroup = (Group[])groupChildrenListAccess.load(0, 2);
        Assert.assertEquals((String)"Expect number of child group in parent group is: ", (long)2L, (long)childrenGroup.length);
        childrenGroup = (Group[])groupChildrenListAccess.load(1, 1);
        Assert.assertEquals((String)"Expect number of child group in parent group is: ", (long)1L, (long)childrenGroup.length);
        groupChildrenListAccess = this.groupHandler_.findGroupChildren(groupParent, "1");
        Assert.assertEquals((String)"Expect number of child group in parent group with search term '1' is: ", (long)1L, (long)groupChildrenListAccess.getSize());
        childrenGroup = (Group[])groupChildrenListAccess.load(0, 1);
        Assert.assertEquals((String)"Expect number of child group in parent group with search term '1' is: ", (long)1L, (long)childrenGroup.length);
        this.groupHandler_.removeGroup(this.groupHandler_.findGroupById(groupChild1.getId()), true);
        Assert.assertNull((String)"Expect child group has been removed: ", (Object)this.groupHandler_.findGroupById(groupChild1.getId()));
        Assert.assertEquals((String)"Expect only 1 child group in parent group", (long)1L, (long)this.groupHandler_.findGroups(groupParent).size());
        try {
            this.groupHandler_.removeGroup(groupParent, true);
            Assert.fail((String)"Exception should be thrown when try return parennt group");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((String)"Expect ParentGroup is not removed:", (Object)this.groupHandler_.findGroupById(groupParent.getId()));
        Assert.assertEquals((String)"Expect all child group is not removed: ", (long)1L, (long)this.groupHandler_.findGroups(groupParent).size());
        Collection groups = this.groupHandler_.findGroupByMembership("demo", "member");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)1L, (long)groups.size());
        groups = this.groupHandler_.resolveGroupByMembership("demo", "member");
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)1L, (long)groups.size());
        this.groupHandler_.removeGroup(groupChild2, true);
        this.groupHandler_.removeGroup(groupParent, true);
        Assert.assertNull((String)"Expect ParentGroup is removed", (Object)this.groupHandler_.findGroupById(groupParent.getId()));
    }

    @Test
    public void testMembershipType() throws Exception {
        int initialSize = this.mtHandler_.findMembershipTypes().size();
        String testType = "testType";
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName(testType);
        mt.setDescription("This is a test");
        mt.setOwner("exo");
        this.mtHandler_.createMembershipType(mt, true);
        Assert.assertEquals((String)"Expect mebershiptype is:", (Object)testType, (Object)this.mtHandler_.findMembershipType(testType).getName());
        String desc = "This is a test (update)";
        mt.setDescription(desc);
        this.mtHandler_.saveMembershipType(mt, true);
        Assert.assertEquals((String)"Expect membershiptype's description", (Object)desc, (Object)this.mtHandler_.findMembershipType(testType).getDescription());
        mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("anothertype");
        mt.setOwner("exo");
        this.mtHandler_.createMembershipType(mt, true);
        Assert.assertEquals((String)"Expect 2 memberships added in collection: ", (long)((long)initialSize + 2L), (long)this.mtHandler_.findMembershipTypes().size());
        Assert.assertEquals((String)"The * should be the first one in collection: ", (Object)"*", (Object)((MembershipType)this.mtHandler_.findMembershipTypes().iterator().next()).getName());
        this.mtHandler_.removeMembershipType(testType, true);
        Assert.assertEquals((String)"Membership type has been removed:", null, (Object)this.mtHandler_.findMembershipType(testType));
        Assert.assertEquals((String)"Expect 2 membership in collection(1 is default): ", (long)((long)initialSize + 1L), (long)this.mtHandler_.findMembershipTypes().size());
        this.mtHandler_.removeMembershipType("anothertype", true);
        Assert.assertEquals((String)"Membership type has been removed:", null, (Object)this.mtHandler_.findMembershipType("anothertype"));
        Assert.assertEquals((String)"Expect 1 membership in collection(default type): ", (long)initialSize, (long)this.mtHandler_.findMembershipTypes().size());
    }

    @Test
    public void testMembership() throws Exception {
        User userBenj = this.createUser(Benj);
        User userTuan = this.createUser(Tuan);
        Group group1 = this.groupHandler_.createGroupInstance();
        group1.setGroupName(Group1);
        this.groupHandler_.addChild(null, group1, true);
        Group group2 = this.groupHandler_.createGroupInstance();
        group2.setGroupName(Group2);
        this.groupHandler_.addChild(null, group2, true);
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("testmembership");
        this.mtHandler_.createMembershipType(mt, true);
        this.membershipHandler_.linkMembership(userBenj, group1, mt, true);
        this.membershipHandler_.linkMembership(userBenj, group2, mt, true);
        this.membershipHandler_.linkMembership(userTuan, group2, mt, true);
        mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("membershipType2");
        this.mtHandler_.createMembershipType(mt, true);
        this.membershipHandler_.linkMembership(userBenj, group2, mt, true);
        mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("membershipType3");
        this.mtHandler_.createMembershipType(mt, true);
        this.membershipHandler_.linkMembership(userBenj, group2, mt, true);
        Assert.assertEquals((String)"Expect number of membership in group 2 is: ", (long)4L, (long)this.membershipHandler_.findMembershipsByGroup(group2).size());
        Assert.assertEquals((String)("Expect number of membership in " + Group2 + " relate with benj is: "), (long)3L, (long)this.membershipHandler_.findMembershipsByUserAndGroup(Benj, group2.getId()).size());
        Assert.assertEquals((String)"expect membership is: ", (long)5L, (long)this.membershipHandler_.findMembershipsByUser(Benj).size());
        Membership membership = this.membershipHandler_.findMembershipByUserGroupAndType(Benj, group2.getId(), "testmembership");
        Assert.assertNotNull((String)"Expect membership is found:", (Object)membership);
        Assert.assertEquals((String)"Expect membership type is: ", (Object)"testmembership", (Object)membership.getMembershipType());
        Assert.assertEquals((String)"Expect groupId of this membership is: ", (Object)group2.getId(), (Object)membership.getGroupId());
        Assert.assertEquals((String)"Expect user of this membership is: ", (Object)Benj, (Object)membership.getUserName());
        Assert.assertEquals((String)"expect group is: ", (long)3L, (long)this.groupHandler_.findGroupsOfUser(Benj).size());
        Assert.assertEquals((String)"expect group is: ", (long)2L, (long)this.groupHandler_.findGroupByMembership(Benj, "testmembership").size());
        String memId = this.membershipHandler_.findMembershipByUserGroupAndType(Benj, group2.getId(), "membershipType3").getId();
        this.membershipHandler_.removeMembership(memId, true);
        Assert.assertNull((String)"Membership was removed: ", (Object)this.membershipHandler_.findMembershipByUserGroupAndType(Benj, "/" + Group2, "membershipType3"));
        this.userHandler_.removeUser(Tuan, true);
        Assert.assertNull((String)"This user was removed", (Object)this.userHandler_.findUserByName(Tuan));
        Assert.assertTrue((String)"All membership related with this user was removed: ", (boolean)this.membershipHandler_.findMembershipsByUser(Tuan).isEmpty());
        this.groupHandler_.removeGroup(group1, true);
        Assert.assertNull((String)"This group was removed ", (Object)this.groupHandler_.findGroupById(group1.getId()));
        Assert.assertTrue((boolean)this.membershipHandler_.findMembershipsByGroup(group1).isEmpty());
        this.mtHandler_.removeMembershipType("testmembership", true);
        Assert.assertNull((String)"This membershipType was removed: ", (Object)this.mtHandler_.findMembershipType("testmembership"));
        for (Object o : this.groupHandler_.findGroups(null)) {
            Group g = (Group)o;
            for (Object o1 : this.membershipHandler_.findMembershipsByGroup(g)) {
                Membership m = (Membership)o1;
                Assert.assertFalse((String)"MembershipType of this membership is not: \"testmembership\"", (boolean)m.getMembershipType().equalsIgnoreCase("testmembership"));
            }
        }
        RequestLifeCycle.end();
        RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)this.service_));
        this.membershipHandler_.removeMembershipByUser(Benj, true);
        this.userHandler_.removeUser(Benj, true);
        this.groupHandler_.removeGroup(group2, true);
        this.mtHandler_.removeMembershipType("membershipType2", true);
        this.mtHandler_.removeMembershipType("membershipType3", true);
    }

    @Test
    public void testRemoveMembershipByUser() throws Exception {
        String Benj = "B";
        String Tuan = "T";
        User userBenj = this.createUser(Benj);
        User userTuan = this.createUser(Tuan);
        String Group1 = "G1";
        String Group2 = "G2";
        String Group3 = "G3";
        Group group1 = this.groupHandler_.createGroupInstance();
        group1.setGroupName(Group1);
        this.groupHandler_.addChild(null, group1, true);
        Group group2 = this.groupHandler_.createGroupInstance();
        group2.setGroupName(Group2);
        this.groupHandler_.addChild(null, group2, true);
        Group group3 = this.groupHandler_.createGroupInstance();
        group3.setGroupName(Group3);
        this.groupHandler_.addChild(null, group3, true);
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName("testmembership_");
        this.mtHandler_.createMembershipType(mt, true);
        this.membershipHandler_.linkMembership(userBenj, group1, mt, true);
        this.membershipHandler_.linkMembership(userBenj, group2, mt, true);
        this.membershipHandler_.linkMembership(userBenj, group3, mt, true);
        this.membershipHandler_.linkMembership(userTuan, group1, mt, true);
        Assert.assertEquals((long)1L, (long)this.membershipHandler_.removeMembershipByUser(Tuan, true).size());
        Assert.assertEquals((long)3L, (long)this.membershipHandler_.removeMembershipByUser(Benj, true).size());
        this.mtHandler_.removeMembershipType("testmembership_", true);
        this.userHandler_.removeUser(Tuan, true);
        this.userHandler_.removeUser(Benj, true);
        this.groupHandler_.removeGroup(group1, true);
        this.groupHandler_.removeGroup(group2, true);
        this.groupHandler_.removeGroup(group3, true);
    }

    @Test
    public void testUserProfileListener() throws Exception {
        UserProfileListener l = new UserProfileListener();
        this.profileHandler_.addUserProfileEventListener((UserProfileEventListener)l);
        User user = this.createUser(USER);
        Assert.assertNotNull((Object)user);
        UserProfile profile = this.profileHandler_.createUserProfileInstance(user.getUserName());
        profile.setAttribute("blah", "blah");
        this.profileHandler_.saveUserProfile(profile, true);
        Assert.assertTrue((l.preSave && l.postSave ? 1 : 0) != 0);
        Assert.assertEquals((long)l.preSaveCreations, (long)1L);
        Assert.assertEquals((long)l.postSaveCreations, (long)1L);
        Assert.assertEquals((long)l.preSaveUpdates, (long)0L);
        Assert.assertEquals((long)l.postSaveUpdates, (long)0L);
        profile.setAttribute("blah", "blah2");
        this.profileHandler_.saveUserProfile(profile, true);
        Assert.assertEquals((long)l.preSaveCreations, (long)1L);
        Assert.assertEquals((long)l.postSaveCreations, (long)1L);
        Assert.assertEquals((long)l.preSaveUpdates, (long)1L);
        Assert.assertEquals((long)l.postSaveUpdates, (long)1L);
        profile.setAttribute("blah", "blah3");
        this.profileHandler_.saveUserProfile(profile, true);
        Assert.assertEquals((long)l.preSaveCreations, (long)1L);
        Assert.assertEquals((long)l.postSaveCreations, (long)1L);
        Assert.assertEquals((long)l.preSaveUpdates, (long)2L);
        Assert.assertEquals((long)l.postSaveUpdates, (long)2L);
        Assert.assertFalse((l.preDelete || l.postDelete ? 1 : 0) != 0);
        this.profileHandler_.removeUserProfile(user.getUserName(), true);
        Assert.assertTrue((l.preDelete && l.postDelete ? 1 : 0) != 0);
        this.userHandler_.removeUser(user.getUserName(), false);
    }

    @Test
    public void testLinkMembership() throws Exception {
        String g1 = "grp1";
        String usr1 = "usr1";
        String mstype1 = "mstype1";
        Group group1 = this.groupHandler_.createGroupInstance();
        group1.setGroupName(g1);
        this.groupHandler_.addChild(null, group1, true);
        User user = this.createUser(usr1);
        MembershipType mt = this.mtHandler_.createMembershipTypeInstance();
        mt.setName(mstype1);
        try {
            this.membershipHandler_.linkMembership(user, group1, mt, true);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)this.mtHandler_.findMembershipType(mstype1));
        this.userHandler_.removeUser(usr1, true);
        this.groupHandler_.removeGroup(group1, true);
    }

    @Test
    public void testFindUsersByGroupId() throws Exception {
        PageList users = this.userHandler_.findUsersByGroup("/platform/users");
        Assert.assertTrue((users.getAvailable() > 0 ? 1 : 0) != 0);
    }

    public User createUser(String userName) throws Exception {
        User user = this.userHandler_.createUserInstance(userName);
        user.setPassword("default");
        user.setFirstName("default");
        user.setLastName("default");
        user.setEmail("exo@exoportal.org");
        this.userHandler_.createUser(user, true);
        return user;
    }

    static {
        for (int i = 0; i < 15; ++i) {
            USERS.add("test_" + i);
        }
    }

    private static class UserProfileListener
    extends UserProfileEventListener {
        boolean preSave;
        boolean postSave;
        boolean preDelete;
        boolean postDelete;
        int preSaveCreations = 0;
        int preSaveUpdates = 0;
        int postSaveCreations = 0;
        int postSaveUpdates = 0;

        private UserProfileListener() {
        }

        public void postDelete(UserProfile profile) throws Exception {
            Assert.assertEquals((Object)AbstractTestOrganizationService.USER, (Object)profile.getUserName());
            this.postDelete = true;
        }

        public void postSave(UserProfile profile, boolean isNew) throws Exception {
            Assert.assertEquals((Object)AbstractTestOrganizationService.USER, (Object)profile.getUserName());
            this.postSave = true;
            if (isNew) {
                ++this.postSaveCreations;
            } else {
                ++this.postSaveUpdates;
            }
        }

        public void preDelete(UserProfile profile) throws Exception {
            Assert.assertEquals((Object)AbstractTestOrganizationService.USER, (Object)profile.getUserName());
            this.preDelete = true;
        }

        public void preSave(UserProfile profile, boolean isNew) throws Exception {
            Assert.assertEquals((Object)AbstractTestOrganizationService.USER, (Object)profile.getUserName());
            this.preSave = true;
            if (isNew) {
                ++this.preSaveCreations;
            } else {
                ++this.preSaveUpdates;
            }
        }
    }
}

