/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.navigation;

import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gatein.api.AbstractApiTest;
import org.gatein.api.EntityAlreadyExistsException;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.navigation.Nodes;
import org.gatein.api.navigation.PublicationDate;
import org.gatein.api.navigation.Visibility;
import org.gatein.api.page.PageId;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ApiNodeTest
extends AbstractApiTest {
    private Navigation navigation;
    private Node root;

    @Test
    public void addChild() {
        this.root.addChild("child");
    }

    @Test
    public void addChild_ChildToNewChild() {
        this.root.addChild("child").addChild("child");
    }

    @Test(expected=EntityAlreadyExistsException.class)
    public void addChild_Existing() {
        this.root.addChild("child");
        this.root.addChild("child");
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void addChild_IndexOutOfBoundsException() {
        this.root.addChild(1, "0");
    }

    @Test(expected=IllegalStateException.class)
    public void addChild_NotLoaded() {
        this.getRoot(false).addChild("child");
    }

    @Test(expected=IllegalArgumentException.class)
    public void addChild_NullName() {
        this.root.addChild(null);
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.createSite(this.defaultSiteId, new String[0]);
        this.navigation = this.portal.getNavigation(this.defaultSiteId);
        this.root = this.getRoot(true);
    }

    @Test(expected=IllegalStateException.class)
    public void getChild_NotLoaded() {
        this.getRoot(false).getChild("0");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getChild_NullName() {
        this.root.getChild(null);
    }

    @Test(expected=IllegalStateException.class)
    public void getChildCount_NotLoaded() {
        this.getRoot(false).getChildCount();
    }

    @Test
    public void getDescendant() {
        this.root.addChild("child0").addChild("child0-0");
        this.root.addChild("child1");
        Assert.assertTrue((boolean)this.root.getNode(NodePath.root()).isRoot());
        Assert.assertEquals((Object)"child0", (Object)this.root.getNode(NodePath.path((String[])new String[]{"child0"})).getName());
        Assert.assertEquals((Object)"child0-0", (Object)this.root.getNode(NodePath.path((String[])new String[]{"child0", "child0-0"})).getName());
        Assert.assertNull((Object)this.root.getNode(NodePath.path((String[])new String[]{"child1", "child0-0"})));
    }

    @Test(expected=IllegalStateException.class)
    public void getNode_NotLoaded() {
        this.getRoot(false).getNode(NodePath.path((String[])new String[]{"0"}));
    }

    @Test
    public void getNodePath() {
        this.root.addChild("child0").addChild("child0-0");
        Assert.assertEquals((Object)"/child0", (Object)this.root.getChild("child0").getNodePath().toString());
        Assert.assertEquals((Object)"/child0/child0-0", (Object)this.root.getChild("child0").getChild("child0-0").getNodePath().toString());
    }

    @Test
    public void getURI() {
        this.root.addChild("child0").addChild("child0-0");
        Assert.assertEquals((Object)("/portal/" + this.defaultSiteId.getName()), (Object)this.root.getURI());
        Assert.assertEquals((Object)("/portal/" + this.defaultSiteId.getName() + "/child0"), (Object)this.root.getChild("child0").getURI());
        Assert.assertEquals((Object)("/portal/" + this.defaultSiteId.getName() + "/child0/child0-0"), (Object)this.root.getChild("child0").getChild("child0-0").getURI());
    }

    @Test(expected=IllegalStateException.class)
    public void hasChild_NotLoaded() {
        this.getRoot(false).hasChild("0");
    }

    @Test
    public void iconName() {
        Node c = this.root.addChild("child");
        Assert.assertNull((Object)c.getIconName());
        c.setIconName("iconName");
        Assert.assertEquals((Object)"iconName", (Object)c.getIconName());
    }

    @Test(expected=IllegalStateException.class)
    public void indexOf_NotLoaded() {
        this.getRoot(false).indexOf("0");
    }

    @Test
    public void isRoot() {
        Assert.assertTrue((boolean)this.root.isRoot());
        Assert.assertFalse((boolean)this.root.addChild("child").isRoot());
    }

    @Test
    public void iterator() {
        this.root.addChild("child0");
        this.root.addChild("child1");
        this.root.addChild("child2");
        ApiNodeTest.assertIterator(this.root.iterator(), "child0", "child1", "child2");
    }

    @Test(expected=NoSuchElementException.class)
    public void iterator_NoSuchElement() {
        this.root.iterator().next();
    }

    @Test
    public void iterator_Remove() {
        this.root.addChild("child0");
        this.root.addChild("child1");
        this.root.addChild("child2");
        Iterator itr = this.root.iterator();
        itr.next();
        itr.next();
        itr.remove();
        ApiNodeTest.assertIterator(this.root.iterator(), "child0", "child2");
    }

    @Test(expected=IllegalStateException.class)
    public void iterator_RemoveIllegalState() {
        this.root.iterator().remove();
    }

    @Test
    public void moveTo() {
        this.root.addChild("0");
        this.root.addChild("1");
        this.root.addChild("2");
        this.root.getChild(0).moveTo(2);
        ApiNodeTest.assertIterator(this.root.iterator(), "1", "2", "0");
        this.root.getChild(2).moveTo(0);
        ApiNodeTest.assertIterator(this.root.iterator(), "0", "1", "2");
        this.root.getChild(0).moveTo(1);
        ApiNodeTest.assertIterator(this.root.iterator(), "1", "0", "2");
        this.root.getChild(1).moveTo(0);
        ApiNodeTest.assertIterator(this.root.iterator(), "0", "1", "2");
        this.root.getChild(1).moveTo(2);
        ApiNodeTest.assertIterator(this.root.iterator(), "0", "2", "1");
        this.root.getChild(1).moveTo(0);
        ApiNodeTest.assertIterator(this.root.iterator(), "2", "0", "1");
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveTo_Child() {
        Node parent0 = this.root.addChild("parent0");
        Node child = parent0.addChild("0");
        Node child2 = child.addChild("0-0");
        child.moveTo(child2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void moveTo_DifferentBranch() {
        Node parent0 = this.root.addChild("parent0");
        Node child = parent0.addChild("0");
        child.moveTo(this.getRoot(true));
    }

    @Test
    public void moveTo_Parent() {
        Node parent0 = this.root.addChild("parent0");
        Node child = parent0.addChild("0");
        Node parent1 = this.root.addChild("parent1");
        child.moveTo(parent1);
        Assert.assertEquals((long)0L, (long)parent0.getChildCount());
        Assert.assertEquals((long)1L, (long)parent1.getChildCount());
    }

    @Test
    public void moveTo_ParentAtIndex() {
        Node parent0 = this.root.addChild("parent0");
        Node child = parent0.addChild("1");
        Node parent1 = this.root.addChild("parent1");
        parent1.addChild("0");
        parent1.addChild("2");
        child.moveTo(1, parent1);
        Assert.assertEquals((long)0L, (long)parent0.getChildCount());
        Assert.assertEquals((long)3L, (long)parent1.getChildCount());
        Assert.assertEquals((Object)"1", (Object)parent1.getChild(1).getName());
    }

    @Test
    public void name() {
        Node c = this.root.addChild("child");
        Assert.assertEquals((Object)"child", (Object)c.getName());
    }

    @Test
    public void pageId() {
        Node c = this.root.addChild("child");
        Assert.assertNull((Object)c.getPageId());
        c.setPageId(new PageId("classic", "page"));
        Assert.assertEquals((Object)new PageId("classic", "page"), (Object)c.getPageId());
    }

    @Test(expected=IllegalStateException.class)
    public void removeChild_NotLoaded() {
        this.getRoot(false).removeChild("0");
    }

    @Test
    public void root_getName() {
        Assert.assertNull((Object)this.root.getName());
    }

    @Test
    public void root_getNodePath() {
        Assert.assertEquals((Object)"/", (Object)this.root.getNodePath().toString());
    }

    @Test
    public void root_getParent() {
        Assert.assertNull((Object)this.root.getParent());
    }

    @Test
    public void root_isRoot() {
        Assert.assertTrue((boolean)this.root.isRoot());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_moveTo() {
        this.root.moveTo(0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_moveToParent() {
        this.root.moveTo(this.getRoot(true));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_moveToParentIndex() {
        this.root.moveTo(0, this.getRoot(true));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_setDisplayName() {
        this.root.setDisplayName("label");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_setIconName() {
        this.root.setIconName("iconName");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_setPageId() {
        this.root.setPageId(new PageId("siteName", "pageName"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_setVisibility() {
        this.root.setVisibility(true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_setVisibilityPublicationDate() {
        this.root.setVisibility(PublicationDate.startingOn((Date)new Date()));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void root_setVisibilityVisibility() {
        this.root.setVisibility(new Visibility());
    }

    @Test
    public void setIconName_NullIconName() {
        this.root.addChild("0").setIconName(null);
    }

    @Test
    public void setIconName_NullPageId() {
        this.root.addChild("0").setPageId(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setName_NullName() {
        this.root.addChild("0").setName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setVisibility_NullPublicationDate() {
        this.root.addChild("0").setVisibility((Visibility)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setVisibility_NullVisibility() {
        this.root.addChild("0").setVisibility((Visibility)null);
    }

    @Test
    public void sort() {
        this.root.addChild("2");
        this.root.addChild("1");
        this.root.addChild("0");
        this.root.sort((Comparator)new Comparator<Node>(this){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Assert.assertEquals((long)3L, (long)this.root.getChildCount());
        Assert.assertEquals((Object)"0", (Object)this.root.getChild(0).getName());
        Assert.assertEquals((Object)"1", (Object)this.root.getChild(1).getName());
        Assert.assertEquals((Object)"2", (Object)this.root.getChild(2).getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void sort_NullComparator() {
        this.root.sort(null);
    }

    @Test
    public void visibility() {
        Node c = this.root.addChild("child");
        ApiNodeTest.assertVisibility(true, Visibility.Status.VISIBLE, null, c);
        c.setVisibility(false);
        ApiNodeTest.assertVisibility(false, Visibility.Status.HIDDEN, null, c);
        PublicationDate d = PublicationDate.between((Date)new Date(), (Date)new Date(System.currentTimeMillis() + 60000L));
        c.setVisibility(d);
        ApiNodeTest.assertVisibility(true, Visibility.Status.PUBLICATION, d, c);
        c.setVisibility(new Visibility(Visibility.Status.SYSTEM));
        ApiNodeTest.assertVisibility(false, Visibility.Status.SYSTEM, null, c);
    }

    public Node getRoot(boolean expanded) {
        return this.navigation.getRootNode(expanded ? Nodes.visitChildren() : Nodes.visitNone());
    }

    public static void assertIterator(Iterator<Node> itr, String ... expected) {
        for (String e : expected) {
            Assert.assertTrue((boolean)itr.hasNext());
            Assert.assertEquals((Object)e, (Object)itr.next().getName());
        }
        Assert.assertFalse((boolean)itr.hasNext());
    }

    public static void assertVisibility(boolean expectedVisible, Visibility.Status expectedFlag, PublicationDate expectedDate, Node actualNode) {
        Assert.assertEquals((Object)expectedVisible, (Object)actualNode.isVisible());
        Assert.assertEquals((Object)expectedFlag, (Object)actualNode.getVisibility().getStatus());
        Assert.assertEquals((Object)expectedDate, (Object)actualNode.getVisibility().getPublicationDate());
    }
}

