/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Arrays;
import java.util.Comparator;
import org.gatein.api.security.Membership;
import org.gatein.api.security.Permission;

public class Assert
extends org.junit.Assert {
    public static void assertEquals(Permission expected, Permission actual) {
        Membership[] e = expected.getMemberships().toArray(new Membership[expected.getMemberships().size()]);
        Membership[] a = actual.getMemberships().toArray(new Membership[expected.getMemberships().size()]);
        Comparator<Membership> m = new Comparator<Membership>(){

            @Override
            public int compare(Membership o1, Membership o2) {
                int i = o1.getGroup().getId().compareTo(o2.getGroup().getId());
                if (i != 0) {
                    return i;
                }
                return o1.getMembershipType().compareTo(o2.getMembershipType());
            }
        };
        Arrays.sort(e, m);
        Arrays.sort(a, m);
        Assert.assertArrayEquals(e, a, m);
    }

    public static <T> void assertArrayEquals(T[] expected, T[] actual, Comparator<T> comparator) {
        Assert.assertEquals((String)"Arrays length differ", (long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("Arrays differ at " + i), (long)0L, (long)comparator.compare(expected[i], actual[i]));
        }
    }
}

