/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.resources.AbstractResourceBundleTest;
import org.exoplatform.services.resources.IdentityResourceBundle;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.services.resources.impl.LocaleConfigServiceImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestLocaleConfigService
extends AbstractResourceBundleTest {
    private ListenerService listenerService;

    public void testParseLocaleConfigFile() throws Exception {
        PropertyManager.setProperty((String)"exo.product.developing", (String)"false");
        LocaleConfigService service = this.createService();
        Map<String, LocaleConfig> map = this.createMap(service);
        TestLocaleConfigService.assertEquals((int)4, (int)map.size());
        this.assertCommonConfigs(service);
    }

    public void testDevMode() throws Exception {
        PropertyManager.setProperty((String)"exo.product.developing", (String)"true");
        LocaleConfigService service = this.createService();
        Map<String, LocaleConfig> map = this.createMap(service);
        TestLocaleConfigService.assertEquals((int)5, (int)map.size());
        this.assertCommonConfigs(service);
        LocaleConfig ma = service.getLocaleConfig("ma");
        this.assertLocaleConfig(ma, "ma", "Default configuration for the debugging locale", "UTF-8", "UTF-8", Orientation.LT, IdentityResourceBundle.MAGIC_LOCALE);
    }

    public void testDefaultConfiguredLanguage() throws Exception {
        LocaleConfigService service = this.createService("fr");
        LocaleConfig defaultLocaleConfig = service.getDefaultLocaleConfig();
        TestLocaleConfigService.assertNotNull((Object)defaultLocaleConfig);
        TestLocaleConfigService.assertEquals((String)"fr", (String)defaultLocaleConfig.getLocaleName());
    }

    public void testDefaultStoredLanguage() throws Exception {
        LocaleConfigService service = this.createService("fr");
        service.saveDefaultLocaleConfig("en");
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("locale.config.default.modified", (Object)"fr", (Object)"en");
        LocaleConfig defaultLocaleConfig = service.getDefaultLocaleConfig();
        TestLocaleConfigService.assertNotNull((Object)defaultLocaleConfig);
        TestLocaleConfigService.assertEquals((String)"en", (String)defaultLocaleConfig.getLocaleName());
    }

    public void testRemoveDefaultStoredLanguage() throws Exception {
        LocaleConfigService service = this.createService("fr");
        service.saveDefaultLocaleConfig("en");
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("locale.config.default.modified", (Object)"fr", (Object)"en");
        service.saveDefaultLocaleConfig(null);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("locale.config.default.modified", (Object)"en", (Object)"fr");
        LocaleConfig defaultLocaleConfig = service.getDefaultLocaleConfig();
        TestLocaleConfigService.assertNotNull((Object)defaultLocaleConfig);
        TestLocaleConfigService.assertEquals((String)"fr", (String)defaultLocaleConfig.getLocaleName());
    }

    public void testLocaleConfig() {
        LocaleConfigImpl ma = new LocaleConfigImpl();
        ma.setLocale("ma");
        TestLocaleConfigService.assertEquals((String)"ma", (String)ma.getLocaleName());
        LocaleConfigImpl ma1 = new LocaleConfigImpl();
        ma1.setLocale(new Locale("ma"));
        TestLocaleConfigService.assertEquals((String)"ma", (String)ma1.getLocaleName());
    }

    private Map<String, LocaleConfig> createMap(LocaleConfigService service) {
        HashMap<String, LocaleConfig> map = new HashMap<String, LocaleConfig>();
        for (LocaleConfig config : service.getLocalConfigs()) {
            map.put(config.getLanguage(), config);
        }
        return map;
    }

    private LocaleConfigService createService() throws Exception {
        return this.createService(null);
    }

    private LocaleConfigService createService(String defaultLang) throws Exception {
        ConfigurationManagerImpl cm = new ConfigurationManagerImpl();
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("locale.config.file");
        param.setValue("classpath:/resources/locales-config.xml");
        params.addParameter((Parameter)param);
        if (StringUtils.isNotBlank((CharSequence)defaultLang)) {
            param = new ValueParam();
            param.setName("locale.config.default");
            param.setValue(defaultLang);
            params.addParameter((Parameter)param);
        }
        SettingService settingService = (SettingService)Mockito.mock(SettingService.class);
        this.listenerService = (ListenerService)Mockito.mock(ListenerService.class);
        ((SettingService)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)settingService.get((Context)invocation.getArgument(0), (Scope)invocation.getArgument(1), (String)invocation.getArgument(2))).thenReturn((Object)((SettingValue)invocation.getArgument(3)));
            return null;
        }).when((Object)settingService)).set((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (SettingValue)ArgumentMatchers.any());
        ((SettingService)Mockito.doAnswer(invocation -> {
            Mockito.reset((Object[])new SettingService[]{settingService});
            return null;
        }).when((Object)settingService)).remove((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        return new LocaleConfigServiceImpl(settingService, this.listenerService, (ConfigurationManager)cm, params);
    }

    private void assertCommonConfigs(LocaleConfigService service) {
        LocaleConfig en = service.getLocaleConfig("en");
        LocaleConfig fr = service.getLocaleConfig("fr");
        LocaleConfig ar = service.getLocaleConfig("ar");
        LocaleConfig vi = service.getLocaleConfig("vi");
        this.assertLocaleConfig(en, "en", "Default configuration for english locale", "UTF-8", "UTF-8", Orientation.LT, Locale.ENGLISH);
        this.assertLocaleConfig(fr, "fr", "Default configuration for the french locale", "UTF-8", "UTF-8", Orientation.LT, Locale.FRENCH);
        this.assertLocaleConfig(ar, "ar", "Default configuration for the arabic locale", "UTF-8", "UTF-8", Orientation.RT, new Locale("ar"));
        this.assertLocaleConfig(vi, "vi", "Default configuration for the vietnam locale", "UTF-8", "UTF-8", Orientation.LT, new Locale("vi"));
    }

    private void assertLocaleConfig(LocaleConfig config, String language, String description, String inputEncoding, String outputEncoding, Orientation orientation, Locale locale) {
        TestLocaleConfigService.assertNotNull((Object)config);
        TestLocaleConfigService.assertEquals((String)language, (String)config.getLanguage());
        TestLocaleConfigService.assertEquals((String)description, (String)config.getDescription());
        TestLocaleConfigService.assertEquals((String)inputEncoding, (String)config.getInputEncoding());
        TestLocaleConfigService.assertEquals((String)outputEncoding, (String)config.getOutputEncoding());
        TestLocaleConfigService.assertEquals((Object)orientation, (Object)config.getOrientation());
        TestLocaleConfigService.assertEquals((Object)locale, (Object)config.getLocale());
    }
}

